/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.kotlin;

import com.intellij.openapi.diagnostic.Logger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.metadata.KmClass;
import kotlin.metadata.KmDeclarationContainer;
import kotlin.metadata.KmTypeAlias;
import org.jetbrains.jps.dependency.Delta;
import org.jetbrains.jps.dependency.DifferentiateContext;
import org.jetbrains.jps.dependency.DifferentiateParameters;
import org.jetbrains.jps.dependency.DifferentiateStrategy;
import org.jetbrains.jps.dependency.Graph;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.java.ClassUsage;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmElementUsage;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.LookupNameUsage;
import org.jetbrains.jps.dependency.java.Utils;
import org.jetbrains.jps.dependency.kotlin.KJvmUtils;
import org.jetbrains.jps.javac.Iterators;

public final class KotlinSourceOnlyDifferentiateStrategy
implements DifferentiateStrategy {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.dependency.kotlin.KotlinSourceOnlyDifferentiateStrategy");

    @Override
    public boolean differentiate(DifferentiateContext context, Iterable<Node<?, ?>> nodesBefore, Iterable<Node<?, ?>> nodesAfter, Iterable<Node<?, ?>> nodesWithErrors) {
        Delta delta = context.getDelta();
        if (!delta.isSourceOnly()) {
            return true;
        }
        Graph graph = context.getGraph();
        Set<NodeSource> baseSources = delta.getBaseSources();
        Utils present = new Utils(context.getGraph(), DifferentiateParameters.affectableInCurrentChunk(context.getParams()));
        HashSet<JvmElementUsage> affectedUsages = new HashSet<JvmElementUsage>();
        HashSet<JvmNodeReferenceID> affectedSealedClasses = new HashSet<JvmNodeReferenceID>();
        HashSet<JvmNodeReferenceID> baseNodes = new HashSet<JvmNodeReferenceID>();
        for (JvmClass cls : Iterators.flat((Iterable)Iterators.map(baseSources, s -> graph.getNodes((NodeSource)s, JvmClass.class)))) {
            String ownerName;
            List typeAliases;
            KmDeclarationContainer container;
            if (!cls.isPrivate()) {
                for (ReferenceID id2 : present.withAllSubclasses(cls.getReferenceID())) {
                    if (!(id2 instanceof JvmNodeReferenceID)) continue;
                    affectedUsages.add(new ClassUsage((JvmNodeReferenceID)id2));
                }
            }
            if ((container = KJvmUtils.getDeclarationContainer(cls)) == null) continue;
            if (container instanceof KmClass) {
                baseNodes.add(cls.getReferenceID());
                KotlinSourceOnlyDifferentiateStrategy.appendSealedClasses(cls, present, affectedSealedClasses);
            }
            if ((typeAliases = container.getTypeAliases()).isEmpty() || (ownerName = KJvmUtils.getKotlinName(cls)) == null) continue;
            for (KmTypeAlias alias : typeAliases) {
                affectedUsages.add(new LookupNameUsage(ownerName, alias.getName()));
            }
        }
        HashSet<NodeSource> affectedSources = new HashSet<NodeSource>();
        if (!affectedUsages.isEmpty()) {
            Iterators.BooleanFunction unmodifiedKtSources = s -> !baseSources.contains(s) && !Iterators.isEmpty((Iterable)Iterators.filter(graph.getNodes((NodeSource)s, JvmClass.class), KJvmUtils::isKotlinNode));
            Iterable supertypeSources = Iterators.unique((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.unique((Iterable)Iterators.filter((Iterable)Iterators.flat((Iterable)Iterators.map(baseNodes, present::allSupertypes)), id -> !baseNodes.contains(id))), present::getNodeSources)));
            for (NodeSource src : Iterators.filter((Iterable)supertypeSources, (Iterators.BooleanFunction)unmodifiedKtSources)) {
                if (Iterators.isEmpty((Iterable)Iterators.filter((Iterable)Iterators.flat((Iterable)Iterators.map(graph.getNodes(src), Node::getUsages)), affectedUsages::contains))) continue;
                LOG.debug("Parent Kotlin class in a class hierarchy is not marked for compilation, while it may be using a potentially changed type alias or has compiler-inferred types based on potentially changed types. Affecting  " + src);
                affectedSources.add(src);
            }
        }
        for (JvmClass cls : Iterators.flat((Iterable)Iterators.map(affectedSources, s -> graph.getNodes((NodeSource)s, JvmClass.class)))) {
            KotlinSourceOnlyDifferentiateStrategy.appendSealedClasses(cls, present, affectedSealedClasses);
        }
        for (NodeSource src : affectedSources) {
            context.affectNodeSource(src);
        }
        if (!affectedSealedClasses.isEmpty()) {
            for (NodeSource src : Iterators.filter((Iterable)Iterators.unique((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.flat((Iterable)Iterators.map(affectedSealedClasses, id -> KJvmUtils.withAllSubclassesIfSealed(present, id))), present::getNodeSources))), s -> !baseSources.contains(s))) {
                LOG.debug("Sealed class or subclass of a sealed class is about to be recompiled => sealed classes should be always compiled together with all its subclasses. Affecting  " + src);
                context.affectNodeSource(src);
            }
        }
        return true;
    }

    private static void appendSealedClasses(JvmClass cls, Utils utils, Set<JvmNodeReferenceID> acc) {
        KmDeclarationContainer container = KJvmUtils.getDeclarationContainer(cls);
        if (container instanceof KmClass) {
            Iterable candidates = Iterators.unique((Iterable)Iterators.flat((Iterable)Iterators.map(KJvmUtils.withAllSubclassesIfSealed(utils, cls.getReferenceID()), utils::allDirectSupertypes)));
            for (JvmClass sealedCls : Iterators.filter((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)candidates, id -> utils.getNodes((ReferenceID)id, JvmClass.class))), KJvmUtils::isSealed)) {
                acc.add(sealedCls.getReferenceID());
            }
        }
    }
}

