/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.BuildDataVersionManager;
import org.jetbrains.jps.incremental.storage.BuildDataVersionManagerKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/jps/incremental/storage/BuildDataVersionManagerImpl;", "Lorg/jetbrains/jps/incremental/storage/BuildDataVersionManager;", "versionFile", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "versionDiffers", "", "Ljava/lang/Boolean;", "saveVersion", "", "intellij.platform.jps.build"})
@SourceDebugExtension(value={"SMAP\nBuildDataVersionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildDataVersionManager.kt\norg/jetbrains/jps/incremental/storage/BuildDataVersionManagerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,64:1\n15#2:65\n15#2:66\n*S KotlinDebug\n*F\n+ 1 BuildDataVersionManager.kt\norg/jetbrains/jps/incremental/storage/BuildDataVersionManagerImpl\n*L\n45#1:65\n61#1:66\n*E\n"})
public final class BuildDataVersionManagerImpl
implements BuildDataVersionManager {
    @NotNull
    private final Path versionFile;
    @Nullable
    private Boolean versionDiffers;

    public BuildDataVersionManagerImpl(@NotNull Path versionFile) {
        Intrinsics.checkNotNullParameter((Object)versionFile, (String)"versionFile");
        this.versionFile = versionFile;
    }

    @Override
    public boolean versionDiffers() {
        Boolean cached = this.versionDiffers;
        if (cached != null) {
            return cached;
        }
        try {
            ByteBuffer data = ByteBuffer.wrap(Files.readAllBytes(this.versionFile));
            boolean diff = data.getInt(0) != BuildDataVersionManagerKt.access$getVERSION$p();
            this.versionDiffers = diff;
            return diff;
        }
        catch (NoSuchFileException noSuchFileException) {
            return false;
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(BuildDataManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
            return true;
        }
    }

    @Override
    public void saveVersion() {
        Boolean differs = this.versionDiffers;
        if (differs != null && !differs.booleanValue()) {
            return;
        }
        try {
            Files.createDirectories(this.versionFile.getParent(), new FileAttribute[0]);
            Files.write(this.versionFile, ByteBuffer.allocate(4).putInt(BuildDataVersionManagerKt.access$getVERSION$p()).array(), new OpenOption[0]);
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(BuildDataManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
        }
    }
}

