/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.GradleBlockModelMap;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.SharedParserUtilsKt;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.ElementState;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslAnchor;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslBlockElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ElementSort;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.semantics.MethodSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyType;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.SemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class GradlePropertiesDslElement
extends GradleDslElementImpl {
    private static final Logger LOG = Logger.getInstance(GradlePropertiesDslElement.class);
    @NotNull
    private static final Predicate<ElementList.ElementItem> VARIABLE_FILTER = e -> e.myElement.getElementType() == PropertyType.VARIABLE;
    @NotNull
    private static final Predicate<ElementList.ElementItem> PROPERTY_FILTER = VARIABLE_FILTER.negate();
    @NotNull
    private static final Predicate<ElementList.ElementItem> ANY_FILTER = Predicates.alwaysTrue();
    @NotNull
    public final ElementList myProperties;
    @NotNull
    private static final ImmutableMap<String, PropertiesElementDescription<?>> NO_CHILD_PROPERTIES_ELEMENTS = ImmutableMap.of();

    protected GradlePropertiesDslElement(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull GradleNameElement name2) {
        if (name2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(0);
        }
        super(parent, psiElement, name2);
        this.myProperties = new ElementList();
    }

    private void addPropertyInternal(@NotNull GradleDslElement element, @NotNull ElementState state) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(1);
        }
        if (state == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(2);
        }
        if (this instanceof ExtDslElement && state == ElementState.TO_BE_ADDED) {
            int index = this.reorderAndMaybeGetNewIndex(element);
            this.myProperties.addElementAtIndex(element, state, index, false);
        } else {
            this.myProperties.addElement(element, state, state == ElementState.EXISTING);
        }
        if (state == ElementState.TO_BE_ADDED) {
            this.updateDependenciesOnAddElement(element);
            element.setModified();
        }
    }

    public void addParsedPropertyAsFirstElement(@NotNull GradleDslElement extElement) {
        if (extElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(3);
        }
        this.myProperties.addElementAtIndex(extElement, ElementState.EXISTING, 0, true);
    }

    private void addPropertyInternal(int index, @NotNull GradleDslElement element, @NotNull ElementState state) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(4);
        }
        if (state == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(5);
        }
        this.myProperties.addElementAtIndex(element, state, index, state == ElementState.EXISTING);
        if (state == ElementState.TO_BE_ADDED) {
            this.updateDependenciesOnAddElement(element);
            element.setModified();
        }
    }

    public void addAppliedProperty(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(6);
        }
        element.addHolder(this);
        this.addPropertyInternal(element, ElementState.APPLIED);
        this.markSubtreeApplied(element, new HashSet<GradleDslElement>());
    }

    private void markSubtreeApplied(@NotNull GradleDslElement element, HashSet<GradleDslElement> seen) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(7);
        }
        seen.add(element);
        if (element instanceof GradlePropertiesDslElement) {
            GradlePropertiesDslElement propertiesDslElement = (GradlePropertiesDslElement)element;
            for (ElementList.ElementItem item : propertiesDslElement.myProperties.myElements) {
                if (seen.contains(item.myElement)) continue;
                item.myElementState = ElementState.APPLIED;
                this.markSubtreeApplied(item.myElement, seen);
            }
        }
    }

    public void addDefaultProperty(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(8);
        }
        element.setElementType(PropertyType.REGULAR);
        this.addPropertyInternal(element, ElementState.DEFAULT);
    }

    public void addDefaultPropertyAt(@NotNull GradleDslElement element, int index) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(9);
        }
        element.setElementType(PropertyType.REGULAR);
        this.myProperties.addElementAtIndex(element, ElementState.DEFAULT, index, false);
    }

    private void removePropertyInternal(@NotNull String property) {
        if (property == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(10);
        }
        List<GradleDslElement> elements = this.myProperties.removeAll(e -> e.myElement.getName().equals(property));
        elements.forEach(e -> {
            e.setModified();
            this.updateDependenciesOnRemoveElement((GradleDslElement)e);
        });
        this.setModified();
    }

    private ElementState removePropertyInternal(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(11);
        }
        element.setModified();
        ElementState state = this.myProperties.remove(element);
        this.updateDependenciesOnRemoveElement(element);
        return state;
    }

    private ElementState replacePropertyInternal(@NotNull GradleDslElement element, @NotNull GradleDslElement newElement) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(12);
        }
        if (newElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(13);
        }
        element.setModified();
        this.updateDependenciesOnReplaceElement(element, newElement);
        newElement.setModified();
        ElementState oldState = this.myProperties.replaceElement(element, newElement);
        this.reorderAndMaybeGetNewIndex(newElement);
        return oldState;
    }

    private ElementState hidePropertyInternal(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(14);
        }
        return this.myProperties.hide(element);
    }

    public void addAppliedModelProperties(@NotNull GradleDslFile file) {
        if (file == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(15);
        }
        this.mergePropertiesFrom(file);
    }

    public void mergePropertiesFrom(@NotNull GradlePropertiesDslElement other) {
        if (other == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(16);
        }
        Map<String, GradleDslElement> ourProperties = this.getPropertyElements();
        for (Map.Entry<String, GradleDslElement> entry : other.getPropertyElements().entrySet()) {
            GradlePropertiesDslElement createdElement;
            GradleDslElement newProperty = entry.getValue();
            if (newProperty instanceof ApplyDslElement) continue;
            if (ourProperties.containsKey(entry.getKey())) {
                GradleDslElement existingProperty = this.getElementWhere(entry.getKey(), PROPERTY_FILTER);
                if (newProperty instanceof GradleDslBlockElement && existingProperty instanceof GradleDslBlockElement) {
                    ((GradlePropertiesDslElement)existingProperty).mergePropertiesFrom((GradlePropertiesDslElement)newProperty);
                    continue;
                }
            } else if (PropertyUtil.isPropertiesElementOrMap(newProperty) && (createdElement = this.getDslFile().getParser().getPropertiesElement(Arrays.asList(entry.getKey().split("\\.")), this, null)) != null) {
                createdElement.mergePropertiesFrom((GradlePropertiesDslElement)newProperty);
                continue;
            }
            this.addAppliedProperty(entry.getValue());
        }
    }

    public void setParsedElement(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(17);
        }
        element.setParent(this);
        this.addPropertyInternal(element, ElementState.EXISTING);
    }

    public void addParsedElement(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(18);
        }
        element.setParent(this);
        this.addPropertyInternal(element, ElementState.EXISTING);
    }

    public void augmentParsedElement(@NotNull GradleDslElement element) {
        ModelEffectDescription modelEffect;
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(19);
        }
        if ((modelEffect = element.getModelEffect()) == null) {
            this.addParsedElement(element);
            return;
        }
        ModelPropertyType type = modelEffect.property.type;
        if (type == ModelPropertyType.MUTABLE_LIST || type == ModelPropertyType.MUTABLE_SET) {
            this.addToParsedExpressionList(modelEffect, element);
            return;
        }
        if (type == ModelPropertyType.MUTABLE_MAP) {
            this.addToParsedExpressionMap(modelEffect, element);
            return;
        }
        this.addParsedElement(element);
    }

    protected void addAsParsedDslExpressionList(@NotNull ModelEffectDescription effect, @NotNull GradleDslSimpleExpression expression) {
        if (effect == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(20);
        }
        if (expression == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(21);
        }
        String property = effect.property.name;
        PsiElement psiElement = expression.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList literalList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(property), true);
        literalList.setModelEffect(effect);
        literalList.setElementType(PropertyType.REGULAR);
        if (expression instanceof GradleDslMethodCall) {
            literalList.setPsiElement(((GradleDslMethodCall)expression).getArgumentListPsiElement());
            for (GradleDslElement gradleDslElement : ((GradleDslMethodCall)expression).getArguments()) {
                if (!(gradleDslElement instanceof GradleDslSimpleExpression)) continue;
                literalList.addParsedExpression((GradleDslSimpleExpression)gradleDslElement);
            }
        } else {
            literalList.addParsedExpression(expression);
        }
        this.addPropertyInternal(literalList, ElementState.EXISTING);
    }

    @Nullable
    private static PsiElement mungeElementsForAddToParsedExpressionList(@NotNull GradleDslElement dslElement, @NotNull List<GradleDslElement> newDslElements) {
        PsiElement psiElement;
        if (dslElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(22);
        }
        if (newDslElements == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(23);
        }
        if ((psiElement = dslElement.getPsiElement()) == null) {
            return null;
        }
        if (dslElement instanceof GradleDslMethodCall) {
            List<GradleDslExpression> args = ((GradleDslMethodCall)dslElement).getArguments();
            if (!args.isEmpty()) {
                if (args.size() == 1 && args.get(0) instanceof GradleDslExpressionList) {
                    newDslElements.addAll(((GradleDslExpressionList)args.get(0)).getExpressions());
                    PsiElement newElement = args.get(0).getPsiElement();
                    return newElement != null ? newElement : psiElement;
                }
                newDslElements.addAll(args);
                return psiElement;
            }
            return psiElement;
        }
        if (dslElement instanceof GradleDslSimpleExpression) {
            newDslElements.add(dslElement);
            return psiElement;
        }
        if (dslElement instanceof GradleDslExpressionList) {
            newDslElements.addAll(((GradleDslExpressionList)dslElement).getExpressions());
            return psiElement;
        }
        return null;
    }

    public void addToParsedExpressionList(@NotNull String property, @NotNull GradleDslElement element) {
        ArrayList<GradleDslElement> newElements;
        PsiElement psiElement;
        if (property == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(24);
        }
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(25);
        }
        if ((psiElement = GradlePropertiesDslElement.mungeElementsForAddToParsedExpressionList(element, newElements = new ArrayList<GradleDslElement>())) == null) {
            return;
        }
        GradleDslExpressionList gradleDslExpressionList = this.getPropertyElement(property, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(property), false);
            this.addPropertyInternal(gradleDslExpressionList, ElementState.EXISTING);
        } else {
            gradleDslExpressionList.setPsiElement(psiElement);
        }
        newElements.forEach(gradleDslExpressionList::addParsedElement);
    }

    public void addToParsedExpressionList(@NotNull ModelEffectDescription effect, @NotNull GradleDslElement element) {
        ArrayList<GradleDslElement> newElements;
        PsiElement psiElement;
        if (effect == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(26);
        }
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(27);
        }
        if ((psiElement = GradlePropertiesDslElement.mungeElementsForAddToParsedExpressionList(element, newElements = new ArrayList<GradleDslElement>())) == null) {
            return;
        }
        GradleDslExpressionList gradleDslExpressionList = this.getPropertyElement(effect.property, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList((GradleDslElement)this, psiElement, GradleNameElement.create(effect.property.name), false);
            ModelEffectDescription createEffect = new ModelEffectDescription(effect.property, ModelSemanticsDescription.CREATE_WITH_VALUE, effect.versionConstraint);
            gradleDslExpressionList.setModelEffect(createEffect);
            gradleDslExpressionList.setElementType(PropertyType.REGULAR);
            this.addPropertyInternal(gradleDslExpressionList, ElementState.EXISTING);
        } else {
            gradleDslExpressionList.setPsiElement(psiElement);
        }
        newElements.forEach(gradleDslExpressionList::addParsedElement);
    }

    public void addToParsedExpressionMap(@NotNull ModelEffectDescription effect, @NotNull GradleDslElement element) {
        if (effect == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(28);
        }
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(29);
        }
        if (!((element = PropertyUtil.followElement(element)) instanceof GradleDslExpressionMap)) {
            return;
        }
        GradleDslExpressionMap map = this.getPropertyElement(effect.property, GradleDslExpressionMap.class);
        if (map == null) {
            map = new GradleDslExpressionMap(this, element.getPsiElement(), GradleNameElement.create(effect.property.name), true);
            ModelEffectDescription createEffect = new ModelEffectDescription(effect.property, ModelSemanticsDescription.CREATE_WITH_VALUE, effect.versionConstraint);
            map.setModelEffect(createEffect);
            map.setElementType(PropertyType.REGULAR);
            this.addPropertyInternal(map, ElementState.EXISTING);
        } else {
            map.setPsiElement(element.getPsiElement());
            SemanticsDescription semantics = ModelSemanticsDescription.CREATE_WITH_VALUE;
            ModelEffectDescription currentEffect = map.getModelEffect();
            if (currentEffect != null) {
                semantics = currentEffect.semantics;
            }
            ModelEffectDescription newEffect = new ModelEffectDescription(effect.property, semantics, effect.versionConstraint);
            map.setModelEffect(newEffect);
        }
        GradleDslExpressionMap newElements = (GradleDslExpressionMap)element;
        for (Map.Entry<String, GradleDslElement> entry : newElements.getPropertyElements().entrySet()) {
            map.setParsedElement(entry.getValue());
        }
    }

    @NotNull
    public Map<String, PropertiesElementDescription<?>> getChildPropertiesElementsDescriptionMap(GradleDslNameConverter.Kind kind) {
        ImmutableMap<String, PropertiesElementDescription<?>> immutableMap = GradleBlockModelMap.getElementMap(this.getClass(), kind);
        if (immutableMap == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(30);
        }
        return immutableMap;
    }

    @Nullable
    public PropertiesElementDescription getChildPropertiesElementDescription(GradleDslNameConverter converter, String name2) {
        return this.getChildPropertiesElementsDescriptionMap(converter.getKind()).get(name2);
    }

    @NotNull
    public Set<String> getProperties() {
        Set<String> set = this.getPropertyElements().keySet();
        if (set == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(31);
        }
        return set;
    }

    @NotNull
    public Map<String, GradleDslElement> getPropertyElements() {
        return this.getElementsWhere(PROPERTY_FILTER);
    }

    @NotNull
    public <T extends GradleDslElement> List<T> getPropertyElements(@NotNull String name2, @NotNull Class<T> clazz) {
        if (name2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(32);
        }
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(33);
        }
        List list = this.myProperties.getElementsWhere(PROPERTY_FILTER).stream().filter(e -> clazz.isAssignableFrom(e.getClass()) && e.getName().equals(name2)).map(e -> (GradleDslElement)clazz.cast(e)).collect(Collectors.toList());
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(34);
        }
        return list;
    }

    @NotNull
    public List<GradleDslElement> getAllPropertyElements() {
        List<GradleDslElement> list = this.myProperties.getElementsWhere(PROPERTY_FILTER);
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    public Map<String, GradleDslElement> getVariableElements() {
        return this.getElementsWhere(VARIABLE_FILTER);
    }

    @NotNull
    public Map<String, GradleDslElement> getElements() {
        return this.getElementsWhere(ANY_FILTER);
    }

    @NotNull
    public List<GradleDslElement> getAllElements() {
        List<GradleDslElement> list = this.myProperties.getElementsWhere(ANY_FILTER);
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(36);
        }
        return list;
    }

    @NotNull
    private Map<String, GradleDslElement> getElementsWhere(@NotNull Predicate<ElementList.ElementItem> predicate) {
        if (predicate == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(37);
        }
        LinkedHashMap<String, GradleDslElement> results = new LinkedHashMap<String, GradleDslElement>();
        List<GradleDslElement> elements = this.myProperties.getElementsWhere(predicate);
        for (GradleDslElement element : elements) {
            if (element == null) continue;
            results.put(element.getName(), element);
        }
        LinkedHashMap<String, GradleDslElement> linkedHashMap = results;
        if (linkedHashMap == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(38);
        }
        return linkedHashMap;
    }

    private GradleDslElement getElementWhere(@NotNull String name2, @NotNull Predicate<ElementList.ElementItem> predicate) {
        if (name2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(39);
        }
        if (predicate == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(40);
        }
        return this.getElementWhere(e -> predicate.test((ElementList.ElementItem)e) && e.myElement.getName().equals(name2));
    }

    private GradleDslElement getElementWhere(@NotNull ModelPropertyDescription property, @NotNull Predicate<ElementList.ElementItem> predicate) {
        if (property == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(41);
        }
        if (predicate == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(42);
        }
        return this.getElementWhere(e -> predicate.test((ElementList.ElementItem)e) && property.equals(e.myElement.getModelProperty()));
    }

    protected GradleDslElement getElementWhere(@NotNull Predicate<ElementList.ElementItem> predicate) {
        if (predicate == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(43);
        }
        return this.myProperties.getElementWhere(predicate);
    }

    private GradleDslElement getElementBeforeChildWhere(@NotNull String name2, Predicate<ElementList.ElementItem> predicate, @NotNull GradleDslElement element, boolean includeSelf) {
        if (name2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(44);
        }
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(45);
        }
        return this.getElementBeforeChildWhere(e -> predicate.test((ElementList.ElementItem)e) && e.myElement.getName().equals(name2), element, includeSelf);
    }

    protected GradleDslElement getElementBeforeChildWhere(Predicate<ElementList.ElementItem> predicate, @NotNull GradleDslElement element, boolean includeSelf) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(46);
        }
        return this.myProperties.getElementBeforeChildWhere(predicate, element, includeSelf);
    }

    @Nullable
    public GradleDslElement getVariableElement(@NotNull String property) {
        if (property == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(47);
        }
        return this.getElementWhere(property, VARIABLE_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElement(@NotNull String property) {
        if (property == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(48);
        }
        return this.getElementWhere(property, PROPERTY_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElement(@NotNull ModelPropertyDescription property) {
        if (property == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(49);
        }
        return this.getElementWhere(property, PROPERTY_FILTER);
    }

    @Nullable
    public GradleDslElement getElement(@NotNull String property) {
        if (property == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(50);
        }
        return this.getElementWhere(property, ANY_FILTER);
    }

    @Nullable
    public GradleDslElement getPropertyElementBefore(@Nullable GradleDslElement element, @NotNull String property, boolean includeSelf) {
        if (property == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(51);
        }
        if (element == null) {
            return this.getElementWhere(property, PROPERTY_FILTER);
        }
        return this.getElementBeforeChildWhere(property, PROPERTY_FILTER, element, includeSelf);
    }

    @Nullable
    GradleDslElement getElementBefore(@Nullable GradleDslElement element, @NotNull String property, boolean includeSelf) {
        if (property == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(52);
        }
        if (element == null) {
            return this.getElementWhere(property, ANY_FILTER);
        }
        return this.getElementBeforeChildWhere(property, ANY_FILTER, element, includeSelf);
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull String property, @NotNull Class<T> clazz) {
        GradleDslElement propertyElement;
        if (property == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(53);
        }
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(54);
        }
        return (T)(clazz.isInstance(propertyElement = this.getPropertyElement(property)) ? (GradleDslElement)clazz.cast(propertyElement) : null);
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull ModelPropertyDescription property, @NotNull Class<T> clazz) {
        GradleDslElement propertyElement;
        if (property == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(55);
        }
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(56);
        }
        return (T)(clazz.isInstance(propertyElement = this.getPropertyElement(property)) ? (GradleDslElement)clazz.cast(propertyElement) : null);
    }

    @Nullable
    public <T extends GradlePropertiesDslElement> T getPropertyElement(@NotNull PropertiesElementDescription<T> description) {
        if (description == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(57);
        }
        assert (description.name != null);
        return (T)((GradlePropertiesDslElement)this.getPropertyElement(description.name, description.clazz));
    }

    @NotNull
    public <T extends GradlePropertiesDslElement> T ensurePropertyElement(@NotNull PropertiesElementDescription<T> description) {
        if (description == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(58);
        }
        T t = this.ensurePropertyElementAt(description, null);
        if (t == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(59);
        }
        return t;
    }

    @NotNull
    public <T extends GradlePropertiesDslElement, U> T ensurePropertyElementBefore(@NotNull PropertiesElementDescription<T> description, Class<U> before) {
        if (description == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(60);
        }
        Integer at = null;
        List<GradleDslElement> elements = this.getCurrentElements();
        for (int i = 0; i < elements.size(); ++i) {
            if (!before.isInstance(elements.get(i))) continue;
            at = i;
            break;
        }
        T t = this.ensurePropertyElementAt(description, at);
        if (t == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(61);
        }
        return t;
    }

    @NotNull
    public <T extends GradlePropertiesDslElement> T ensureNamedPropertyElement(PropertiesElementDescription<T> description, GradleNameElement name2) {
        GradlePropertiesDslElement propertyElement = (GradlePropertiesDslElement)this.getPropertyElement(name2.name(), description.clazz);
        if (propertyElement != null) {
            GradlePropertiesDslElement gradlePropertiesDslElement = propertyElement;
            if (gradlePropertiesDslElement == null) {
                GradlePropertiesDslElement.$$$reportNull$$$0(62);
            }
            return (T)gradlePropertiesDslElement;
        }
        assert (description.name == null);
        Object newElement = description.constructor.construct(this, name2);
        this.setNewElement((GradleDslElement)newElement);
        Object t = newElement;
        if (t == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(63);
        }
        return t;
    }

    @NotNull
    public <T extends GradlePropertiesDslElement> T ensurePropertyElementAt(PropertiesElementDescription<T> description, Integer at) {
        T propertyElement = this.getPropertyElement(description);
        if (propertyElement != null) {
            T t = propertyElement;
            if (t == null) {
                GradlePropertiesDslElement.$$$reportNull$$$0(64);
            }
            return t;
        }
        assert (description.name != null);
        Object newElement = description.constructor.construct(this, GradleNameElement.create(description.name));
        if (at != null) {
            this.addNewElementAt(at, (GradleDslElement)newElement);
        } else {
            this.setNewElement((GradleDslElement)newElement);
        }
        Object t = newElement;
        if (t == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(65);
        }
        return t;
    }

    @Nullable
    public <T extends GradleDslElement> T getPropertyElement(@NotNull List<String> properties, @NotNull Class<T> clazz) {
        GradleDslElement propertyElement;
        if (properties == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(66);
        }
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(67);
        }
        return (T)(clazz.isInstance(propertyElement = this.myProperties.getElementWhere(e -> properties.contains(e.myElement.getName()))) ? (GradleDslElement)clazz.cast(propertyElement) : null);
    }

    @NotNull
    public <T extends GradleDslElement> List<T> getPropertyElements(@NotNull Class<T> clazz) {
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(68);
        }
        List list = this.myProperties.getElementsWhere(PROPERTY_FILTER).stream().filter(e -> clazz.isAssignableFrom(e.getClass())).map(e -> (GradleDslElement)clazz.cast(e)).collect(Collectors.toList());
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(69);
        }
        return list;
    }

    @NotNull
    public List<GradleDslElement> getPropertyElementsByName(@NotNull String propertyName) {
        if (propertyName == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(70);
        }
        List<GradleDslElement> list = this.myProperties.getElementsWhere(e -> e.myElement.getName().equals(propertyName) && PROPERTY_FILTER.test((ElementList.ElementItem)e));
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(71);
        }
        return list;
    }

    @NotNull
    public List<GradleDslElement> getOriginalElements() {
        List<GradleDslElement> list = this.myProperties.myElements.stream().filter(e -> e.myExistsOnFile).map(e -> e.myElement).collect(Collectors.toList());
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(72);
        }
        return list;
    }

    @Nullable
    public GradleDslElement getOriginalElementForNameAndType(@NotNull String name2, @NotNull PropertyType type) {
        if (name2 == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(73);
        }
        if (type == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(74);
        }
        return this.myProperties.myElements.stream().filter(e -> e.myElement.getName().equals(name2) && e.myExistsOnFile && e.myElement.getElementType() == type).map(e -> e.myElement).reduce((a, b) -> b).orElse(null);
    }

    @NotNull
    public List<GradleDslElement> getCurrentElements() {
        Predicate<ElementList.ElementItem> currentElementFilter = e -> e.myElementState == ElementState.TO_BE_ADDED || e.myElementState == ElementState.EXISTING || e.myElementState == ElementState.MOVED || e.myElementState == ElementState.DEFAULT && e.myElement instanceof GradlePropertiesDslElement && !((GradlePropertiesDslElement)e.myElement).getCurrentElements().isEmpty();
        List<GradleDslElement> list = this.myProperties.myElements.stream().filter(currentElementFilter).map(e -> e.myElement).collect(Collectors.toList());
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(75);
        }
        return list;
    }

    public void setNewElement(@NotNull GradleDslElement newElement) {
        if (newElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(76);
        }
        newElement.setParent(this);
        this.addPropertyInternal(newElement, ElementState.TO_BE_ADDED);
        this.setModified();
    }

    public void addNewElementAt(int index, @NotNull GradleDslElement newElement) {
        if (newElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(77);
        }
        newElement.setParent(this);
        this.addPropertyInternal(index, newElement, ElementState.TO_BE_ADDED);
        this.setModified();
    }

    @VisibleForTesting
    public void moveElementTo(int index, @NotNull GradleDslElement newElement) {
        if (newElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(78);
        }
        assert (newElement.getParent() == this);
        this.myProperties.moveElementToIndex(newElement, index);
    }

    public void replaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (oldElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(79);
        }
        if (newElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(80);
        }
        newElement.setParent(this);
        ArrayList<GradlePropertiesDslElement> holders = new ArrayList<GradlePropertiesDslElement>();
        holders.add(this);
        holders.addAll(oldElement.getHolders());
        for (GradlePropertiesDslElement holder : holders) {
            holder.replacePropertyInternal(oldElement, newElement);
        }
    }

    public void substituteElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (oldElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(81);
        }
        if (newElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(82);
        }
        assert (newElement.getParent() == this);
        this.myProperties.substituteElement(oldElement, newElement);
    }

    @Override
    public void childPsiUpdated(@NotNull GradleDslElement childElement) {
        if (childElement == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(83);
        }
        assert (childElement.getParent() == this);
        for (ElementList.ElementItem item : this.myProperties.myElements) {
            if (childElement != item.myElement) continue;
            if (childElement.getPsiElement() == null) {
                item.myElementState = ElementState.TO_BE_ADDED;
                item.myExistsOnFile = false;
            } else {
                item.myElementState = ElementState.EXISTING;
                item.myExistsOnFile = true;
            }
            return;
        }
    }

    @Nullable
    public <T> T getLiteral(@NotNull String property, @NotNull Class<T> clazz) {
        GradleDslSimpleExpression expression;
        if (property == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(84);
        }
        if (clazz == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(85);
        }
        if ((expression = this.getPropertyElement(property, GradleDslSimpleExpression.class)) == null) {
            return null;
        }
        return expression.getValue(clazz);
    }

    @NotNull
    public GradleDslLiteral setNewLiteral(@NotNull String property, @NotNull Object value) {
        if (property == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(86);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(87);
        }
        return this.setNewLiteralImpl(property, value);
    }

    @NotNull
    private GradleDslLiteral setNewLiteralImpl(@NotNull String property, @NotNull Object value) {
        GradleDslLiteral literalElement;
        if (property == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(88);
        }
        if (value == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(89);
        }
        if ((literalElement = this.getPropertyElement(property, GradleDslLiteral.class)) == null) {
            literalElement = new GradleDslLiteral(this, GradleNameElement.create(property));
            this.addPropertyInternal(literalElement, ElementState.TO_BE_ADDED);
        }
        literalElement.setValue(value);
        GradleDslLiteral gradleDslLiteral = literalElement;
        if (gradleDslLiteral == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(90);
        }
        return gradleDslLiteral;
    }

    public void removeProperty(@NotNull String property) {
        if (property == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(91);
        }
        this.removePropertyInternal(property);
    }

    public void removeProperty(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(92);
        }
        this.removePropertyInternal(element);
        for (GradlePropertiesDslElement holder : element.getHolders()) {
            if (this == holder) continue;
            holder.removePropertyInternal(element);
        }
        GradleDslElement parent = element.getParent();
        if (this != parent && parent instanceof GradlePropertiesDslElement) {
            ((GradlePropertiesDslElement)parent).removePropertyInternal(element);
        }
    }

    public void hideProperty(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(93);
        }
        this.hidePropertyInternal(element);
        for (GradlePropertiesDslElement holder : element.getHolders()) {
            if (this == holder) continue;
            holder.removePropertyInternal(element);
        }
        GradleDslElement parent = element.getParent();
        if (this != parent && parent instanceof GradlePropertiesDslElement) {
            ((GradlePropertiesDslElement)parent).hidePropertyInternal(element);
        }
    }

    @Override
    @NotNull
    public GradleDslAnchor requestAnchor(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(94);
        }
        GradleDslAnchor anchor = new GradleDslAnchor.Start(this);
        for (ElementList.ElementItem item : this.myProperties.myElements) {
            ProjectPropertiesDslElement projectProperties;
            GradleDslElement currentElement;
            if (item.myElement == element) {
                if (item.myElementState == ElementState.EXISTING && SharedParserUtilsKt.findLastPsiElementIn(item.myElement) != null) {
                    return new GradleDslAnchor.After(item.myElement);
                }
                GradleDslAnchor.Start start = anchor;
                if (start == null) {
                    GradlePropertiesDslElement.$$$reportNull$$$0(95);
                }
                return start;
            }
            if (!item.myElementState.isPhysicalInFile() || (currentElement = item.myElement) instanceof ProjectPropertiesDslElement && (projectProperties = (ProjectPropertiesDslElement)currentElement).getAllPropertyElements().stream().allMatch(it -> it.getPsiElement() == null)) continue;
            if (currentElement instanceof ApplyDslElement) {
                anchor = currentElement.requestAnchor(element);
                continue;
            }
            anchor = new GradleDslAnchor.After(currentElement);
        }
        GradleDslAnchor.Start start = anchor;
        if (start == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(96);
        }
        return start;
    }

    @Override
    @NotNull
    public Collection<GradleDslElement> getChildren() {
        List<GradleDslElement> list = this.getAllElements();
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(97);
        }
        return list;
    }

    @Override
    @NotNull
    public List<GradleDslElement> getContainedElements(boolean includeProperties) {
        ArrayList<GradleDslElement> result = new ArrayList<GradleDslElement>();
        if (includeProperties) {
            result.addAll(this.getElementsWhere(e -> e.myElementState != ElementState.APPLIED && !e.isDefaultElement()).values());
        } else {
            result.addAll(this.getVariableElements().values());
        }
        List<GradlePropertiesDslElement> holders = this.getPropertyElements(GradlePropertiesDslElement.class).stream().filter(e -> !(e instanceof GradleDslExpression)).collect(Collectors.toList());
        holders.forEach(e -> result.addAll(e.getContainedElements(includeProperties)));
        ArrayList<GradleDslElement> arrayList = result;
        if (arrayList == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(98);
        }
        return arrayList;
    }

    @Override
    public void delete() {
        this.myProperties.forEach(e -> e.myElement.delete());
        super.delete();
    }

    protected void deleteAndRecreate() {
        this.myProperties.removeElements(GradleDslElement::delete);
        if (!this.myProperties.isEmpty()) {
            this.myProperties.forEach(item -> {
                GradleDslElement element;
                GradleDslElement copy = element = item.myElement;
                if (element instanceof GradleDslExpression) {
                    copy = ((GradleDslExpression)element).copy();
                }
                element.getDslFile().getWriter().deleteDslElement(element);
                item.myElement = copy;
            });
            this.getDslFile().getWriter().deleteDslElement(this);
            this.create();
            this.myProperties.forEach(item -> {
                GradleDslElement element = item.myElement;
                element.create();
                item.myElementState = ElementState.EXISTING;
            });
        }
    }

    protected boolean isStructurallyModified() {
        Predicate<ElementList.ElementItem> predicate = e -> e.myElementState.isStructuralChange();
        return this.myProperties.myElements.stream().anyMatch(predicate);
    }

    @Override
    protected void apply() {
        this.getDslFile().getWriter().applyDslPropertiesElement(this);
        this.myProperties.removeElements(GradleDslElement::delete);
        this.maybeCreateNewElementsFromApplied();
        this.myProperties.createElements(e -> e.create() != null);
        this.myProperties.applyElements(e -> {
            if (e.isModified()) {
                e.applyChanges();
            }
        });
        this.myProperties.forEach(item -> {
            if (item.myElementState == ElementState.MOVED) {
                item.myElement.move();
            }
        });
    }

    private void maybeCreateNewElementsFromApplied() {
        ArrayList<GradleDslSimpleExpression> additionalElements = new ArrayList<GradleDslSimpleExpression>();
        for (ElementList.ElementItem elementItem : this.myProperties.myElements) {
            GradleDslElement element = elementItem.myElement;
            if (elementItem.myElementState != ElementState.APPLIED || !element.isModified() || this.isNativeElementForFile(element) || !(element instanceof GradleDslSimpleExpression)) continue;
            GradleDslSimpleExpression expression = (GradleDslSimpleExpression)element;
            additionalElements.add(expression.copy());
            element.resetState();
        }
        for (GradleDslElement gradleDslElement : additionalElements) {
            this.myProperties.addElement(gradleDslElement, ElementState.TO_BE_ADDED, false);
        }
    }

    private boolean isNativeElementForFile(GradleDslElement dslElement) {
        return this.isNativeElementForFile(dslElement, dslElement.getDslFile().getFile());
    }

    private boolean isNativeElementForFile(GradleDslElement dslElement, VirtualFile file) {
        if (dslElement instanceof GradleDslFile) {
            GradleDslFile dslFile = (GradleDslFile)dslElement;
            return dslFile.getFile().equals(file);
        }
        if (this.myParent != null) {
            return this.isNativeElementForFile(dslElement.getParent(), file);
        }
        return false;
    }

    @Override
    protected void reset() {
        this.myProperties.reset();
    }

    protected void clear() {
        this.myProperties.clear();
    }

    public int reorderAndMaybeGetNewIndex(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(99);
        }
        int result = this.sortElementsAndMaybeGetNewIndex(element);
        element.resolve();
        return result;
    }

    private int sortElementsAndMaybeGetNewIndex(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(100);
        }
        List<GradleDslElement> currentElements = this.myProperties.getElementsWhere(e -> e.myElementState == ElementState.EXISTING || e.myElementState == ElementState.TO_BE_ADDED);
        ArrayList<GradleDslElement> sortedElements = new ArrayList<GradleDslElement>();
        boolean result = ElementSort.create(this, element).sort(currentElements, sortedElements);
        int resultIndex = this.myProperties.myElements.size();
        if (!result) {
            this.notification(NotificationTypeReference.PROPERTY_PLACEMENT);
            return resultIndex;
        }
        int i = 0;
        int j = 0;
        while (i < currentElements.size() && j < sortedElements.size()) {
            if (currentElements.get(i) == sortedElements.get(i)) {
                ++i;
                ++j;
                continue;
            }
            if (sortedElements.get(i) == element && !currentElements.contains(element)) {
                resultIndex = i;
                ++j;
                continue;
            }
            this.moveElementTo(i, (GradleDslElement)sortedElements.get(j));
            ++i;
            ++j;
        }
        return resultIndex;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependencies() {
        List<GradleReferenceInjection> list = this.getAllElements().stream().map(GradleDslElement::getDependencies).flatMap(Collection::stream).collect(Collectors.toList());
        if (list == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(101);
        }
        return list;
    }

    @VisibleForTesting
    public boolean isApplied(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(102);
        }
        for (ElementList.ElementItem item : this.myProperties.myElements) {
            if (item.myElement != element) continue;
            return item.myElementState == ElementState.APPLIED;
        }
        throw new IllegalStateException("Element not found in parent");
    }

    void updateAppliedState(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertiesDslElement.$$$reportNull$$$0(103);
        }
        for (ElementList.ElementItem item : this.myProperties.myElements) {
            if (item.myElement != element) continue;
            if (item.myElementState == ElementState.APPLIED) {
                item.myElementState = ElementState.TO_BE_ADDED;
            }
            return;
        }
        LOG.warn((Throwable)new IllegalStateException("Element " + element + " not found in parent " + this));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 30, 31, 34, 35, 36, 38, 59, 61, 62, 63, 64, 65, 69, 71, 72, 75, 90, 95, 96, 97, 98, 101 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 25: 
            case 27: 
            case 29: 
            case 45: 
            case 46: 
            case 92: 
            case 93: 
            case 94: 
            case 99: 
            case 100: 
            case 102: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extElement";
                break;
            }
            case 10: 
            case 24: 
            case 41: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 84: 
            case 86: 
            case 88: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 13: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 20: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effect";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDslElements";
                break;
            }
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 71: 
            case 72: 
            case 75: 
            case 90: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement";
                break;
            }
            case 33: 
            case 54: 
            case 56: 
            case 67: 
            case 68: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 37: 
            case 40: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 57: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 79: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childElement";
                break;
            }
            case 87: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildPropertiesElementsDescriptionMap";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 34: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyElements";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPropertyElements";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllElements";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsWhere";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "ensurePropertyElement";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "ensurePropertyElementBefore";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureNamedPropertyElement";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "ensurePropertyElementAt";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyElementsByName";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalElements";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentElements";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "setNewLiteralImpl";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "requestAnchor";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainedElements";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyInternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addParsedPropertyAsFirstElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAppliedProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markSubtreeApplied";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultProperty";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultPropertyAt";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyInternal";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replacePropertyInternal";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hidePropertyInternal";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addAppliedModelProperties";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mergePropertiesFrom";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setParsedElement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addParsedElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "augmentParsedElement";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addAsParsedDslExpressionList";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "mungeElementsForAddToParsedExpressionList";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addToParsedExpressionList";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addToParsedExpressionMap";
                break;
            }
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 71: 
            case 72: 
            case 75: 
            case 90: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 101: {
                break;
            }
            case 32: 
            case 33: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyElements";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getElementsWhere";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getElementWhere";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getElementBeforeChildWhere";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getVariableElement";
                break;
            }
            case 48: 
            case 49: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyElement";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyElementBefore";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getElementBefore";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "ensurePropertyElement";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "ensurePropertyElementBefore";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyElementsByName";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElementForNameAndType";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "setNewElement";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addNewElementAt";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "moveElementTo";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "replaceElement";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "substituteElement";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "childPsiUpdated";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getLiteral";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "setNewLiteral";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "setNewLiteralImpl";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "removeProperty";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "hideProperty";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "requestAnchor";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "reorderAndMaybeGetNewIndex";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "sortElementsAndMaybeGetNewIndex";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "isApplied";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "updateAppliedState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 30, 31, 34, 35, 36, 38, 59, 61, 62, 63, 64, 65, 69, 71, 72, 75, 90, 95, 96, 97, 98, 101 -> new IllegalStateException(string);
        };
    }

    protected static class ElementList {
        @NotNull
        private final List<ElementItem> myElements = new ArrayList<ElementItem>();

        private void forEach(@NotNull Consumer<ElementItem> func) {
            if (func == null) {
                ElementList.$$$reportNull$$$0(0);
            }
            this.myElements.forEach(func);
        }

        @NotNull
        private List<GradleDslElement> getElementsWhere(@NotNull Predicate<ElementItem> predicate) {
            if (predicate == null) {
                ElementList.$$$reportNull$$$0(1);
            }
            List<GradleDslElement> list = this.myElements.stream().filter(e -> e.myElementState.isSemanticallyRelevant()).filter(predicate).map(e -> e.myElement).collect(Collectors.toList());
            if (list == null) {
                ElementList.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Nullable
        public GradleDslElement getElementWhere(@NotNull Predicate<ElementItem> predicate) {
            ModelEffectDescription effect;
            GradleDslElement last;
            if (predicate == null) {
                ElementList.$$$reportNull$$$0(3);
            }
            if ((last = (GradleDslElement)this.myElements.stream().filter(e -> e.myElementState.isSemanticallyRelevant()).filter(predicate).map(e -> e.myElement).reduce((first, second) -> second).orElse(null)) != null && (effect = last.getModelEffect()) != null && effect.semantics == MethodSemanticsDescription.RESET) {
                return null;
            }
            return last;
        }

        @Nullable
        public GradleDslElement getElementBeforeChildWhere(@NotNull Predicate<ElementItem> predicate, @NotNull GradleDslElement child, boolean includeSelf) {
            if (predicate == null) {
                ElementList.$$$reportNull$$$0(4);
            }
            if (child == null) {
                ElementList.$$$reportNull$$$0(5);
            }
            GradleDslElement lastElement = null;
            for (ElementItem i : this.myElements) {
                if (!i.myElementState.isSemanticallyRelevant()) continue;
                if (predicate.test(i) && (includeSelf || child != i.myElement)) {
                    lastElement = i.myElement;
                }
                if (i.myElement != child) continue;
                return lastElement;
            }
            return lastElement;
        }

        public void addElement(@NotNull GradleDslElement newElement, @NotNull ElementState state, boolean onFile) {
            if (newElement == null) {
                ElementList.$$$reportNull$$$0(6);
            }
            if (state == null) {
                ElementList.$$$reportNull$$$0(7);
            }
            this.myElements.add(new ElementItem(newElement, state, onFile));
        }

        private void addElementAtIndex(@NotNull GradleDslElement newElement, @NotNull ElementState state, int index, boolean onFile) {
            if (newElement == null) {
                ElementList.$$$reportNull$$$0(8);
            }
            if (state == null) {
                ElementList.$$$reportNull$$$0(9);
            }
            this.myElements.add(this.getRealIndex(index, newElement), new ElementItem(newElement, state, onFile));
        }

        private void moveElementToIndex(@NotNull GradleDslElement element, int index) {
            ElementItem item;
            if (element == null) {
                ElementList.$$$reportNull$$$0(10);
            }
            if ((item = (ElementItem)this.myElements.stream().filter(e -> e.myElement == element).findFirst().orElse(null)) == null) {
                return;
            }
            this.myElements.remove(item);
            ElementList.moveElementTree(item);
            this.myElements.add(this.getRealIndex(index, element), item);
        }

        private int getRealIndex(int index, @NotNull GradleDslElement element) {
            if (element == null) {
                ElementList.$$$reportNull$$$0(11);
            }
            if (index <= 0) {
                return 0;
            }
            for (int i = 0; i < this.myElements.size(); ++i) {
                if (index == 0) {
                    return i;
                }
                ElementItem item = this.myElements.get(i);
                if (!item.myElementState.isPhysicalInFile()) continue;
                --index;
            }
            return this.myElements.size();
        }

        @Nullable
        private ElementState remove(@NotNull GradleDslElement element) {
            ElementItem item;
            if (element == null) {
                ElementList.$$$reportNull$$$0(12);
            }
            if ((item = (ElementItem)this.myElements.stream().filter(e -> element == e.myElement).findFirst().orElse(null)) == null) {
                return null;
            }
            ElementState oldState = item.myElementState;
            item.myElementState = ElementState.TO_BE_REMOVED;
            return oldState;
        }

        @Nullable
        private ElementState hide(@NotNull GradleDslElement element) {
            ElementItem item;
            if (element == null) {
                ElementList.$$$reportNull$$$0(13);
            }
            if ((item = (ElementItem)this.myElements.stream().filter(e -> element == e.myElement).findFirst().orElse(null)) == null) {
                return null;
            }
            ElementState oldState = item.myElementState;
            item.myElementState = ElementState.HIDDEN;
            return oldState;
        }

        @Nullable
        private ElementState replaceElement(@Nullable GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
            if (newElement == null) {
                ElementList.$$$reportNull$$$0(14);
            }
            for (int i = 0; i < this.myElements.size(); ++i) {
                ElementItem item = this.myElements.get(i);
                if (oldElement != item.myElement) continue;
                ElementState oldState = item.myElementState;
                item.myElementState = ElementState.TO_BE_REMOVED;
                ElementState newState = ElementState.TO_BE_ADDED;
                if (Arrays.asList(ElementState.APPLIED, ElementState.HIDDEN).contains((Object)oldState)) {
                    newState = oldState;
                }
                this.myElements.add(i, new ElementItem(newElement, newState, false));
                return oldState;
            }
            return null;
        }

        @Nullable
        private ElementState substituteElement(@Nullable GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
            if (newElement == null) {
                ElementList.$$$reportNull$$$0(15);
            }
            for (ElementItem item : this.myElements) {
                if (oldElement != item.myElement) continue;
                item.myElement = newElement;
                if (newElement.getPsiElement() == null) {
                    item.myElementState = ElementState.TO_BE_ADDED;
                    item.myExistsOnFile = false;
                } else {
                    item.myElementState = ElementState.EXISTING;
                    item.myExistsOnFile = true;
                }
                return item.myElementState;
            }
            return null;
        }

        @NotNull
        private @Unmodifiable List<GradleDslElement> removeAll(@NotNull Predicate<ElementItem> filter) {
            if (filter == null) {
                ElementList.$$$reportNull$$$0(16);
            }
            List<ElementItem> toBeRemoved = this.myElements.stream().filter(filter).collect(Collectors.toList());
            toBeRemoved.forEach((? super T e) -> {
                e.myElementState = ElementState.TO_BE_REMOVED;
            });
            List list = ContainerUtil.map(toBeRemoved, e -> e.myElement);
            if (list == null) {
                ElementList.$$$reportNull$$$0(17);
            }
            return list;
        }

        private boolean isEmpty() {
            return this.myElements.isEmpty();
        }

        private void reset() {
            LinkedHashSet<String> seen = new LinkedHashSet<String>();
            Iterator<ElementItem> i = this.myElements.iterator();
            while (i.hasNext()) {
                ElementItem item = i.next();
                item.myElement.resetState();
                if (item.myElementState == ElementState.TO_BE_REMOVED) {
                    item.myElementState = ElementState.EXISTING;
                }
                if (item.myElementState == ElementState.EXISTING) {
                    seen.add(item.myElement.getName());
                }
                if (item.myElementState == ElementState.TO_BE_ADDED) {
                    i.remove();
                }
                if (item.myElementState != ElementState.DEFAULT || !seen.contains(item.myElement.getName())) continue;
                i.remove();
            }
        }

        private void removeElements(@NotNull Consumer<GradleDslElement> removeFunc) {
            if (removeFunc == null) {
                ElementList.$$$reportNull$$$0(18);
            }
            Iterator<ElementItem> i = this.myElements.iterator();
            while (i.hasNext()) {
                ElementItem item = i.next();
                if (item.myElementState != ElementState.TO_BE_REMOVED) continue;
                removeFunc.accept(item.myElement);
                i.remove();
            }
        }

        private void createElements(@NotNull Predicate<GradleDslElement> addFunc) {
            if (addFunc == null) {
                ElementList.$$$reportNull$$$0(19);
            }
            Iterator<ElementItem> i = this.myElements.iterator();
            while (i.hasNext()) {
                ElementItem item = i.next();
                if (item.myElementState == ElementState.DEFAULT && !item.isDefaultElement()) {
                    item.myElementState = ElementState.TO_BE_ADDED;
                }
                if (item.myElementState != ElementState.TO_BE_ADDED) continue;
                if (addFunc.test(item.myElement)) {
                    item.myElementState = ElementState.EXISTING;
                    continue;
                }
                i.remove();
            }
        }

        private void applyElements(@NotNull Consumer<GradleDslElement> func) {
            if (func == null) {
                ElementList.$$$reportNull$$$0(20);
            }
            this.myElements.stream().map(e -> e.myElement).forEach(func);
        }

        private void clear() {
            this.myElements.clear();
        }

        private static void moveElementTree(@NotNull ElementItem item) {
            if (item == null) {
                ElementList.$$$reportNull$$$0(21);
            }
            if (item.myElementState != ElementState.TO_BE_ADDED) {
                item.myElementState = ElementState.MOVED;
            }
            item.myElement.setModified();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 17 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "func";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 2: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement$ElementList";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 6: 
                case 8: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "removeFunc";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "addFunc";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement$ElementList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsWhere";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "removeAll";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "forEach";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementsWhere";
                    break;
                }
                case 2: 
                case 17: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementWhere";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementBeforeChildWhere";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addElement";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addElementAtIndex";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "moveElementToIndex";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getRealIndex";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "hide";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceElement";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "substituteElement";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "removeAll";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "removeElements";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "createElements";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "applyElements";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "moveElementTree";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 17 -> new IllegalStateException(string);
            };
        }

        public static class ElementItem {
            @NotNull
            private GradleDslElement myElement;
            @NotNull
            private ElementState myElementState;
            private boolean myExistsOnFile;

            private ElementItem(@NotNull GradleDslElement element, @NotNull ElementState state, boolean existsOnFile) {
                if (element == null) {
                    ElementItem.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    ElementItem.$$$reportNull$$$0(1);
                }
                this.myElement = element;
                this.myElementState = state;
                this.myExistsOnFile = existsOnFile;
            }

            private boolean isDefaultElement() {
                return this.myElementState == ElementState.DEFAULT && this.myElement.isInsignificantIfEmpty() && this.myElement instanceof GradlePropertiesDslElement && ((GradlePropertiesDslElement)this.myElement).getCurrentElements().isEmpty();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement$ElementList$ElementItem";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

