/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import git4idea.commands.GitHandler;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class GitLogRecord {
    private static final Logger LOG = Logger.getInstance(GitLogRecord.class);
    @NotNull
    protected final Map<GitLogParser.GitLogOption, String> myOptions;
    protected final boolean mySupportsRawBody;
    protected GitHandler myHandler;

    GitLogRecord(@NotNull Map<GitLogParser.GitLogOption, String> options, boolean supportsRawBody) {
        if (options == null) {
            GitLogRecord.$$$reportNull$$$0(0);
        }
        this.myOptions = options;
        this.mySupportsRawBody = supportsRawBody;
    }

    @NotNull
    private String lookup(@NotNull GitLogParser.GitLogOption key) {
        String value;
        if (key == null) {
            GitLogRecord.$$$reportNull$$$0(1);
        }
        if ((value = this.myOptions.get((Object)key)) == null) {
            LOG.error("Missing value for option " + key + ", while executing " + this.myHandler);
            return "";
        }
        String string = value;
        if (string == null) {
            GitLogRecord.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    String getHash() {
        return this.lookup(GitLogParser.GitLogOption.HASH);
    }

    @NotNull
    String getTreeHash() {
        return this.lookup(GitLogParser.GitLogOption.TREE);
    }

    @NotNull
    String getAuthorName() {
        return this.lookup(GitLogParser.GitLogOption.AUTHOR_NAME);
    }

    @NotNull
    String getAuthorEmail() {
        return this.lookup(GitLogParser.GitLogOption.AUTHOR_EMAIL);
    }

    @NotNull
    String getCommitterName() {
        return this.lookup(GitLogParser.GitLogOption.COMMITTER_NAME);
    }

    @NotNull
    String getCommitterEmail() {
        return this.lookup(GitLogParser.GitLogOption.COMMITTER_EMAIL);
    }

    @NotNull
    String getSubject() {
        return this.lookup(GitLogParser.GitLogOption.SUBJECT);
    }

    @NotNull
    String getBody() {
        return this.lookup(GitLogParser.GitLogOption.BODY);
    }

    @NotNull
    String getRawBody() {
        return this.lookup(GitLogParser.GitLogOption.RAW_BODY);
    }

    @NotNull
    String getShortenedRefLog() {
        return this.lookup(GitLogParser.GitLogOption.SHORT_REF_LOG_SELECTOR);
    }

    @NotNull
    Date getDate() {
        return new Date(this.getCommitTime());
    }

    long getCommitTime() {
        try {
            return GitLogUtil.parseTime(this.myOptions.get((Object)GitLogParser.GitLogOption.COMMIT_TIME));
        }
        catch (NumberFormatException e) {
            LOG.error("Couldn't get commit time from " + this + ", while executing " + this.myHandler, (Throwable)e);
            return 0L;
        }
    }

    long getAuthorTimeStamp() {
        try {
            return GitLogUtil.parseTime(this.myOptions.get((Object)GitLogParser.GitLogOption.AUTHOR_TIME));
        }
        catch (NumberFormatException e) {
            LOG.error("Couldn't get author time from " + this + ", while executing " + this.myHandler, (Throwable)e);
            return 0L;
        }
    }

    String getFullMessage() {
        return ((String)(this.mySupportsRawBody ? this.getRawBody() : this.getSubject() + "\n\n" + this.getBody())).stripTrailing();
    }

    String @NotNull [] getParentsHashes() {
        String parents = this.lookup(GitLogParser.GitLogOption.PARENTS);
        if (parents.trim().isEmpty()) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                GitLogRecord.$$$reportNull$$$0(3);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = parents.split(" ");
        if (stringArray == null) {
            GitLogRecord.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    @NotNull
    public Collection<String> getRefs() {
        String decorate = this.myOptions.get((Object)GitLogParser.GitLogOption.REF_NAMES);
        return GitLogRecord.parseRefNames(decorate);
    }

    @NotNull
    public Map<GitLogParser.GitLogOption, String> getOptions() {
        Map<GitLogParser.GitLogOption, String> map2 = this.myOptions;
        if (map2 == null) {
            GitLogRecord.$$$reportNull$$$0(5);
        }
        return map2;
    }

    public boolean isSupportsRawBody() {
        return this.mySupportsRawBody;
    }

    @NotNull
    private static List<String> parseRefNames(@Nullable String decoration) {
        if (decoration == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GitLogRecord.$$$reportNull$$$0(6);
            }
            return list;
        }
        int startParentheses = decoration.indexOf("(");
        int endParentheses = decoration.lastIndexOf(")");
        if (startParentheses == -1 || endParentheses == -1) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GitLogRecord.$$$reportNull$$$0(7);
            }
            return list;
        }
        String refs = decoration.substring(startParentheses + 1, endParentheses);
        String[] names = refs.split(", ");
        ArrayList<String> result2 = new ArrayList<String>();
        for (String item : names) {
            String POINTER = " -> ";
            if (item.contains(" -> ")) {
                List parts = StringUtil.split((String)item, (String)" -> ");
                result2.addAll(ContainerUtil.map((Collection)parts, String::trim));
                continue;
            }
            int colon = item.indexOf(58);
            String raw = colon > 0 ? item.substring(colon + 1).trim() : item;
            result2.add(raw);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            GitLogRecord.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public void setUsedHandler(GitHandler handler) {
        this.myHandler = handler;
    }

    @NonNls
    public String toString() {
        return String.format("GitLogRecord{myOptions=%s, mySupportsRawBody=%s, myHandler=%s}", this.myOptions, this.mySupportsRawBody, this.myHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitLogRecord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitLogRecord";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "lookup";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentsHashes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRefNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "lookup";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

