/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.ResolvedDependencies;
import org.jetbrains.kotlin.utils.ResolvedDependency;
import org.jetbrains.kotlin.utils.ResolvedDependencyArtifactPath;
import org.jetbrains.kotlin.utils.ResolvedDependencyId;
import org.jetbrains.kotlin.utils.ResolvedDependencyVersion;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007JF\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u000526\u0010\n\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\u000bR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/utils/ResolvedDependenciesSupport;", "", "<init>", "()V", "serialize", "", "dependencies", "Lorg/jetbrains/kotlin/utils/ResolvedDependencies;", "deserialize", "source", "onMalformedLine", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "lineNo", "line", "", "SOURCE_CODE_MODULE_REGEX", "Lkotlin/text/Regex;", "DEPENDENCY_MODULE_REGEX", "REQUESTED_VERSION_BY_INCOMING_DEPENDENCY_REGEX", "util"})
@SourceDebugExtension(value={"SMAP\nResolvedDependencies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolvedDependencies.kt\norg/jetbrains/kotlin/utils/ResolvedDependenciesSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,207:1\n1878#2,3:208\n1869#2,2:211\n1878#2,2:213\n1193#2,2:221\n1267#2,4:223\n1880#2:227\n1869#2:228\n1870#2:231\n125#3:215\n114#3,5:216\n216#4,2:229\n*S KotlinDebug\n*F\n+ 1 ResolvedDependencies.kt\norg/jetbrains/kotlin/utils/ResolvedDependenciesSupport\n*L\n90#1:208,3\n98#1:211,2\n124#1:213,2\n155#1:221,2\n155#1:223,4\n124#1:227\n177#1:228\n177#1:231\n134#1:215\n134#1:216,5\n178#1:229,2\n*E\n"})
public final class ResolvedDependenciesSupport {
    @NotNull
    public static final ResolvedDependenciesSupport INSTANCE = new ResolvedDependenciesSupport();
    @NotNull
    private static final Regex SOURCE_CODE_MODULE_REGEX = new Regex("^0 ([^\\[]+)$");
    @NotNull
    private static final Regex DEPENDENCY_MODULE_REGEX = new Regex("^(\\d+) ([^\\[]+)\\[([^]]+)](.*)?$");
    @NotNull
    private static final Regex REQUESTED_VERSION_BY_INCOMING_DEPENDENCY_REGEX = new Regex("^#(\\d+)\\[(.*)]$");

    private ResolvedDependenciesSupport() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String serialize(@NotNull ResolvedDependencies dependencies2) {
        Intrinsics.checkNotNullParameter((Object)dependencies2, (String)"dependencies");
        Object object = new Pair[]{TuplesKt.to((Object)dependencies2.getSourceCodeModuleId(), (Object)0)};
        Object $this$serialize_u24lambda_u241 = object = MapsKt.mutableMapOf((Pair[])object);
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = dependencies2.getModules();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void module;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ResolvedDependency resolvedDependency = (ResolvedDependency)item$iv;
            int index = n;
            boolean bl2 = false;
            $this$serialize_u24lambda_u241.put(module.getId(), index + 1);
        }
        Object moduleIdToIndex = object;
        Object $this$serialize_u24lambda_u245 = object = new StringBuilder();
        boolean bl3 = false;
        ((StringBuilder)$this$serialize_u24lambda_u245).append("0 ");
        CollectionsKt.joinTo$default((Iterable)dependencies2.getSourceCodeModuleId().getUniqueNames(), (Appendable)((Appendable)$this$serialize_u24lambda_u245), (CharSequence)",", null, null, (int)0, null, null, (int)124, null);
        ((StringBuilder)$this$serialize_u24lambda_u245).append('\n');
        Iterable $this$forEach$iv = dependencies2.getModules();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolvedDependency module = (ResolvedDependency)element$iv;
            boolean bl4 = false;
            int moduleIndex = ((Number)MapsKt.getValue((Map)moduleIdToIndex, (Object)module.getId())).intValue();
            ((StringBuilder)$this$serialize_u24lambda_u245).append(String.valueOf(moduleIndex)).append(' ');
            CollectionsKt.joinTo$default((Iterable)module.getId().getUniqueNames(), (Appendable)((Appendable)$this$serialize_u24lambda_u245), (CharSequence)",", null, null, (int)0, null, null, (int)124, null);
            ((StringBuilder)$this$serialize_u24lambda_u245).append('[').append(module.getSelectedVersion()).append(']');
            CollectionsKt.joinTo$default((Iterable)module.getRequestedVersionsByIncomingDependencies().entrySet(), (Appendable)((Appendable)$this$serialize_u24lambda_u245), (CharSequence)"", null, null, (int)0, null, arg_0 -> ResolvedDependenciesSupport.serialize$lambda$5$lambda$4$lambda$2((Map)moduleIdToIndex, arg_0), (int)60, null);
            ((StringBuilder)$this$serialize_u24lambda_u245).append('\n');
            CollectionsKt.joinTo$default((Iterable)module.getArtifactPaths(), (Appendable)((Appendable)$this$serialize_u24lambda_u245), (CharSequence)"", null, null, (int)0, null, ResolvedDependenciesSupport::serialize$lambda$5$lambda$4$lambda$3, (int)60, null);
        }
        return ((StringBuilder)object).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ResolvedDependencies deserialize(@NotNull String source, @NotNull Function2<? super Integer, ? super String, Unit> onMalformedLine) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(onMalformedLine, (String)"onMalformedLine");
        Map moduleIndexToId = new LinkedHashMap();
        Map requestedVersionsByIncomingDependenciesIndices = new LinkedHashMap();
        ResolvedDependencyId sourceCodeModuleId = null;
        List modules2 = new ArrayList();
        Iterable $this$forEachIndexed$iv = StringsKt.lines((CharSequence)source);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            MatchResult result2;
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv;
            int lineNo = n;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)((CharSequence)line))) continue;
            if (CharsKt.isWhitespace((char)line.charAt(0))) {
                CharSequence charSequence;
                ResolvedDependency currentModule;
                block16: {
                    currentModule = (ResolvedDependency)CollectionsKt.lastOrNull((List)modules2);
                    void $this$trimStart$iv = line;
                    boolean $i$f$trimStart = false;
                    CharSequence $this$trimStart$iv$iv = (CharSequence)$this$trimStart$iv;
                    boolean $i$f$trimStart2 = false;
                    int n2 = $this$trimStart$iv$iv.length();
                    for (int index$iv$iv = 0; index$iv$iv < n2; ++index$iv$iv) {
                        char it = $this$trimStart$iv$iv.charAt(index$iv$iv);
                        boolean bl2 = false;
                        if (CharsKt.isWhitespace((char)it)) continue;
                        charSequence = $this$trimStart$iv$iv.subSequence(index$iv$iv, $this$trimStart$iv$iv.length());
                        break block16;
                    }
                    charSequence = "";
                }
                String artifactPath = ((Object)charSequence).toString();
                if (currentModule != null && !StringsKt.isBlank((CharSequence)artifactPath)) {
                    ((Collection)currentModule.getArtifactPaths()).add(new ResolvedDependencyArtifactPath(artifactPath));
                    continue;
                }
                return ResolvedDependenciesSupport.deserialize$lambda$8$malformedLine(onMalformedLine, lineNo, (String)line);
            }
            if (line.charAt(0) == '0') {
                if (SOURCE_CODE_MODULE_REGEX.matchEntire((CharSequence)line) == null) {
                    return ResolvedDependenciesSupport.deserialize$lambda$8$malformedLine(onMalformedLine, lineNo, (String)line);
                }
                char[] artifactPath = new char[]{','};
                sourceCodeModuleId = new ResolvedDependencyId(StringsKt.split$default((CharSequence)((CharSequence)result2.getGroupValues().get(1)), (char[])artifactPath, (boolean)false, (int)0, (int)6, null));
                continue;
            }
            if (sourceCodeModuleId == null) {
                return ResolvedDependenciesSupport.deserialize$lambda$8$malformedLine(onMalformedLine, lineNo, (String)line);
            }
            if (DEPENDENCY_MODULE_REGEX.matchEntire((CharSequence)line) == null) {
                return ResolvedDependenciesSupport.deserialize$lambda$8$malformedLine(onMalformedLine, lineNo, (String)line);
            }
            int moduleIndex = Integer.parseInt((String)result2.getGroupValues().get(1));
            char[] $i$f$trimStart = new char[]{','};
            ResolvedDependencyId moduleId = new ResolvedDependencyId(StringsKt.split$default((CharSequence)((CharSequence)result2.getGroupValues().get(2)), (char[])$i$f$trimStart, (boolean)false, (int)0, (int)6, null));
            ResolvedDependencyVersion selectedVersion = new ResolvedDependencyVersion((String)result2.getGroupValues().get(3));
            if (result2.getGroupValues().size() > 4) {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                Object $i$f$trimStart2 = new char[]{' '};
                $i$f$trimStart2 = StringsKt.split$default((CharSequence)((Object)StringsKt.trimStart((CharSequence)((String)result2.getGroupValues().get(4)))).toString(), (char[])$i$f$trimStart2, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void it = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    MatchResult tokenResult;
                    Map map = destination$iv$iv;
                    String token = (String)element$iv$iv;
                    boolean bl3 = false;
                    if (REQUESTED_VERSION_BY_INCOMING_DEPENDENCY_REGEX.matchEntire((CharSequence)token) == null) {
                        return ResolvedDependenciesSupport.deserialize$lambda$8$malformedLine(onMalformedLine, lineNo, (String)line);
                    }
                    int incomingDependencyIndex = Integer.parseInt((String)tokenResult.getGroupValues().get(1));
                    ResolvedDependencyVersion requestedVersion = new ResolvedDependencyVersion((String)tokenResult.getGroupValues().get(2));
                    Pair pair = TuplesKt.to((Object)incomingDependencyIndex, (Object)requestedVersion);
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map requestedVersions = destination$iv$iv;
                requestedVersionsByIncomingDependenciesIndices.put(moduleId, requestedVersions);
            }
            Integer $this$associate$iv = moduleIndex;
            moduleIndexToId.put($this$associate$iv, moduleId);
            ((Collection)modules2).add(new ResolvedDependency(moduleId, false, selectedVersion, new LinkedHashMap(), new LinkedHashSet(), 2, null));
        }
        Iterable $this$forEach$iv = modules2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map $this$forEach$iv2;
            ResolvedDependency module = (ResolvedDependency)element$iv;
            boolean bl = false;
            if ((Map)requestedVersionsByIncomingDependenciesIndices.get(module.getId()) == null) continue;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                ResolvedDependencyId resolvedDependencyId;
                Map.Entry element$iv2;
                Map.Entry entry = element$iv2 = iterator2.next();
                boolean bl4 = false;
                int incomingDependencyIndex = ((Number)entry.getKey()).intValue();
                ResolvedDependencyVersion requestedVersion = (ResolvedDependencyVersion)entry.getValue();
                if (incomingDependencyIndex == 0) {
                    ResolvedDependencyId resolvedDependencyId2 = sourceCodeModuleId;
                    resolvedDependencyId = resolvedDependencyId2;
                    Intrinsics.checkNotNull(resolvedDependencyId2);
                } else {
                    resolvedDependencyId = (ResolvedDependencyId)MapsKt.getValue((Map)moduleIndexToId, (Object)incomingDependencyIndex);
                }
                ResolvedDependencyId incomingDependencyId = resolvedDependencyId;
                module.getRequestedVersionsByIncomingDependencies().put(incomingDependencyId, requestedVersion);
            }
        }
        Collection collection = modules2;
        ResolvedDependencyId resolvedDependencyId = sourceCodeModuleId;
        Intrinsics.checkNotNull(resolvedDependencyId);
        return new ResolvedDependencies(collection, resolvedDependencyId);
    }

    private static final CharSequence serialize$lambda$5$lambda$4$lambda$2(Map $moduleIdToIndex, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        ResolvedDependencyId incomingDependencyId = (ResolvedDependencyId)entry.getKey();
        ResolvedDependencyVersion requestedVersion = (ResolvedDependencyVersion)entry.getValue();
        int incomingDependencyIndex = ((Number)MapsKt.getValue((Map)$moduleIdToIndex, (Object)incomingDependencyId)).intValue();
        return " #" + incomingDependencyIndex + '[' + requestedVersion + ']';
    }

    private static final CharSequence serialize$lambda$5$lambda$4$lambda$3(ResolvedDependencyArtifactPath artifactPath) {
        Intrinsics.checkNotNullParameter((Object)artifactPath, (String)"artifactPath");
        return "" + '\t' + artifactPath + '\n';
    }

    private static final ResolvedDependencies deserialize$lambda$8$malformedLine(Function2<? super Integer, ? super String, Unit> $onMalformedLine, int $lineNo, String $line) {
        $onMalformedLine.invoke((Object)$lineNo, (Object)$line);
        return ResolvedDependencies.Companion.getEMPTY();
    }
}

