/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.psi.imports;

import com.intellij.psi.PsiFile;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.imports.KotlinImportPathComparatorKt;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntry;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntryTable;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00132\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0001\u0013B\u0011\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/base/psi/imports/KotlinImportPathComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "Lkotlin/Comparator;", "packageTable", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable;", "<init>", "(Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable;)V", "importAliasesSeparately", "", "getImportAliasesSeparately", "()Z", "compare", "", "import1", "import2", "bestEntryMatchIndex", "path", "ignoreAlias", "Companion", "kotlin.base.analysis-api.utils"})
@ApiStatus.Internal
public final class KotlinImportPathComparator
implements Comparator<ImportPath> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinPackageEntryTable packageTable;

    private KotlinImportPathComparator(KotlinPackageEntryTable packageTable) {
        this.packageTable = packageTable;
    }

    private final boolean getImportAliasesSeparately() {
        return ArraysKt.contains((Object[])this.packageTable.getEntries(), (Object)KotlinPackageEntry.ALL_OTHER_ALIAS_IMPORTS_ENTRY);
    }

    @Override
    public int compare(@NotNull ImportPath import1, @NotNull ImportPath import2) {
        Intrinsics.checkNotNullParameter((Object)import1, (String)"import1");
        Intrinsics.checkNotNullParameter((Object)import2, (String)"import2");
        boolean ignoreAlias = this.getImportAliasesSeparately() ? import1.hasAlias() && import2.hasAlias() : true;
        Function1[] function1Array = new Function1[]{arg_0 -> KotlinImportPathComparator.compare$lambda$0(this, ignoreAlias, arg_0), KotlinImportPathComparator::compare$lambda$1};
        return ComparisonsKt.compareValuesBy((Object)import1, (Object)import2, (Function1[])function1Array);
    }

    private final int bestEntryMatchIndex(ImportPath path2, boolean ignoreAlias) {
        KotlinPackageEntry bestEntryMatch = null;
        int bestIndex = -1;
        KotlinPackageEntry[] kotlinPackageEntryArray = this.packageTable.getEntries();
        int n = kotlinPackageEntryArray.length;
        for (int j = 0; j < n; ++j) {
            int index2 = j;
            KotlinPackageEntry entry = kotlinPackageEntryArray[j];
            if (!KotlinImportPathComparatorKt.access$isBetterMatchForPackageThan(entry, bestEntryMatch, path2, ignoreAlias)) continue;
            bestEntryMatch = entry;
            bestIndex = index2;
        }
        return bestIndex;
    }

    private static final Comparable compare$lambda$0(KotlinImportPathComparator this$0, boolean $ignoreAlias, ImportPath importPath) {
        Intrinsics.checkNotNullParameter((Object)importPath, (String)"import");
        return Integer.valueOf(this$0.bestEntryMatchIndex(importPath, $ignoreAlias));
    }

    private static final Comparable compare$lambda$1(ImportPath importPath) {
        Intrinsics.checkNotNullParameter((Object)importPath, (String)"import");
        return (Comparable)((Object)StringsKt.replace$default((String)importPath.toString(), (String)"`", (String)"", (boolean)false, (int)4, null));
    }

    public /* synthetic */ KotlinImportPathComparator(KotlinPackageEntryTable packageTable, DefaultConstructorMarker $constructor_marker) {
        this(packageTable);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/base/psi/imports/KotlinImportPathComparator$Companion;", "", "<init>", "()V", "create", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "Lkotlin/Comparator;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.base.analysis-api.utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<ImportPath> create(@NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            KotlinPackageEntryTable kotlinPackageEntryTable = CodeStyleUtilsKt.getKotlinCustomSettings((PsiFile)((PsiFile)file)).PACKAGES_IMPORT_LAYOUT;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinPackageEntryTable, (String)"PACKAGES_IMPORT_LAYOUT");
            KotlinPackageEntryTable packagesImportLayout = kotlinPackageEntryTable;
            return new KotlinImportPathComparator(packagesImportLayout, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

