/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.dependencies;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsFieldImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.util.MethodSignatureUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptDependencyAware;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/dependencies/ScriptDependencySourceNavigationPolicyForJavaClasses;", "Lcom/intellij/psi/impl/compiled/ClsCustomNavigationPolicy;", "<init>", "()V", "getNavigationElement", "Lcom/intellij/psi/PsiClass;", "clsClass", "Lcom/intellij/psi/impl/compiled/ClsClassImpl;", "Lcom/intellij/psi/PsiElement;", "clsMethod", "Lcom/intellij/psi/impl/compiled/ClsMethodImpl;", "clsField", "Lcom/intellij/psi/impl/compiled/ClsFieldImpl;", "file", "Lcom/intellij/psi/impl/compiled/ClsFileImpl;", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nScriptDependencySourceNavigationPolicyForJavaClasses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptDependencySourceNavigationPolicyForJavaClasses.kt\norg/jetbrains/kotlin/idea/core/script/dependencies/ScriptDependencySourceNavigationPolicyForJavaClasses\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,57:1\n1310#2,2:58\n125#3:60\n*S KotlinDebug\n*F\n+ 1 ScriptDependencySourceNavigationPolicyForJavaClasses.kt\norg/jetbrains/kotlin/idea/core/script/dependencies/ScriptDependencySourceNavigationPolicyForJavaClasses\n*L\n27#1:58,2\n38#1:60\n*E\n"})
public final class ScriptDependencySourceNavigationPolicyForJavaClasses
implements ClsCustomNavigationPolicy {
    @Nullable
    public PsiClass getNavigationElement(@NotNull ClsClassImpl clsClass) {
        ClsClassImpl containingClass;
        Intrinsics.checkNotNullParameter((Object)clsClass, (String)"clsClass");
        PsiClass psiClass = clsClass.getContainingClass();
        ClsClassImpl clsClassImpl = containingClass = psiClass instanceof ClsClassImpl ? (ClsClassImpl)psiClass : null;
        if (containingClass != null) {
            PsiClass psiClass2 = this.getNavigationElement(containingClass);
            return psiClass2 != null ? psiClass2.findInnerClassByName(clsClass.getName(), false) : null;
        }
        PsiFile psiFile = clsClass.getContainingFile();
        ClsFileImpl clsFileImpl = psiFile instanceof ClsFileImpl ? (ClsFileImpl)psiFile : null;
        if (clsFileImpl == null) {
            return null;
        }
        ClsFileImpl clsFileImpl2 = clsFileImpl;
        psiFile = this.getNavigationElement(clsFileImpl2);
        Object[] objectArray = psiFile instanceof PsiClassOwner ? (Object[])psiFile : null;
        return objectArray != null && (objectArray = objectArray.getClasses()) != null ? (PsiClass)ArraysKt.singleOrNull((Object[])objectArray) : null;
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull ClsMethodImpl clsMethod) {
        Object object;
        block2: {
            Intrinsics.checkNotNullParameter((Object)clsMethod, (String)"clsMethod");
            PsiClass psiClass = clsMethod.getContainingClass();
            Intrinsics.checkNotNull((Object)psiClass, (String)"null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
            PsiClass psiClass2 = this.getNavigationElement((ClsClassImpl)psiClass);
            if (psiClass2 == null) {
                return null;
            }
            PsiClass clsClass = psiClass2;
            PsiMethod[] psiMethodArray = clsClass.findMethodsByName(clsMethod.getName(), false);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
            Object[] $this$firstOrNull$iv = psiMethodArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiMethod it = (PsiMethod)element$iv;
                boolean bl = false;
                if (!MethodSignatureUtil.areParametersErasureEqual((PsiMethod)it, (PsiMethod)((PsiMethod)clsMethod))) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        return (PsiElement)object;
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull ClsFieldImpl clsField) {
        Intrinsics.checkNotNullParameter((Object)clsField, (String)"clsField");
        PsiClass psiClass = clsField.getContainingClass();
        Intrinsics.checkNotNull((Object)psiClass, (String)"null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
        PsiClass psiClass2 = this.getNavigationElement((ClsClassImpl)psiClass);
        if (psiClass2 == null) {
            return null;
        }
        PsiClass srcClass = psiClass2;
        return (PsiElement)srcClass.findFieldByName(clsField.getName(), false);
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull ClsFileImpl file) {
        Object object;
        Project project;
        VirtualFile virtualFile;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                VirtualFile virtualFile2 = file.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
                virtualFile = virtualFile2;
                Project project2 = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                project = project2;
                PsiClass[] psiClassArray = file.getClasses();
                Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
                object = (PsiClass)ArraysKt.firstOrNull((Object[])psiClassArray);
                if (object == null) break block6;
                PsiClass $this$safeAs$iv = object;
                boolean $i$f$safeAs = false;
                PsiClass psiClass = $this$safeAs$iv;
                if (!(psiClass instanceof ClsClassImpl)) {
                    psiClass = null;
                }
                if ((object = (ClsClassImpl)psiClass) != null && (object = object.getSourceFileName()) != null) break block7;
            }
            return null;
        }
        Object sourceFileName = object;
        if (!ScriptDependencyAware.Companion.getInstance(project).getAllScriptsDependenciesClassFilesScope().contains(virtualFile)) {
            return null;
        }
        String string = file.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
        String packageName = string;
        Object relativePath = ((CharSequence)packageName).length() == 0 ? sourceFileName : StringsKt.replace$default((String)packageName, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + (String)sourceFileName;
        for (VirtualFile root : ScriptDependencyAware.Companion.getInstance(project).getAllScriptDependenciesSources()) {
            PsiFile sourcePsi;
            VirtualFile sourceFile;
            if (!root.isValid() || (sourceFile = root.findFileByRelativePath((String)relativePath)) == null || !sourceFile.isValid() || !((sourcePsi = file.getManager().findFile(sourceFile)) instanceof PsiClassOwner)) continue;
            return (PsiElement)sourcePsi;
        }
        return null;
    }
}

