/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.applicators.ApplicabilityRanges;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.RedundantRequireNotNullCallInspectionKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.RemoveRedundantNotNullCallFix;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0003*\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001d\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0003H\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/RedundantRequireNotNullCallInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/RedundantRequireNotNullCallInspection$Context;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isApplicableByPsi", "element", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "getProblemDescription", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "context", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "Context", "kotlin.code-insight.inspections.k2"})
public final class RedundantRequireNotNullCallInspection
extends KotlinApplicableInspectionBase.Simple<KtCallExpression, Context> {
    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)VisitorWrappersKt.callExpressionVisitor(arg_0 -> RedundantRequireNotNullCallInspection.buildVisitor$lambda$0(this, holder2, isOnTheFly, arg_0));
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = RedundantRequireNotNullCallInspectionKt.access$getFunctionName(element);
        if (string == null) {
            return false;
        }
        String functionName = string;
        return Intrinsics.areEqual((Object)functionName, (Object)"requireNotNull") || Intrinsics.areEqual((Object)functionName, (Object)"checkNotNull");
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!RedundantRequireNotNullCallInspectionKt.access$validateFunctionCall($this$prepareContext, element)) {
            return null;
        }
        String string = RedundantRequireNotNullCallInspectionKt.access$getFunctionName(element);
        if (string == null) {
            return null;
        }
        String functionName = string;
        KtReferenceExpression ktReferenceExpression = RedundantRequireNotNullCallInspectionKt.access$extractArgument(element);
        if (ktReferenceExpression == null) {
            return null;
        }
        KtReferenceExpression argument2 = ktReferenceExpression;
        KaType kaType = $this$prepareContext.getExpressionType((KtExpression)argument2);
        if (kaType == null) {
            return null;
        }
        KaType argumentType = kaType;
        if ($this$prepareContext.getCanBeNull(argumentType)) {
            return null;
        }
        return new Context(functionName, $this$prepareContext.isUsedAsExpression((KtExpression)element));
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return ApplicabilityRanges.INSTANCE.calleeExpression(element);
    }

    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtCallExpression element, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object[] objectArray = new Object[]{context.getFunctionName()};
        return KotlinBundle.message((String)"redundant.0.call", (Object[])objectArray);
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtCallExpression> createQuickFix(@NotNull KtCallExpression element, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new RemoveRedundantNotNullCallFix(context);
    }

    private static final Unit buildVisitor$lambda$0(RedundantRequireNotNullCallInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtCallExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.visitTargetElement((KtElement)it, $holder, $isOnTheFly);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/RedundantRequireNotNullCallInspection$Context;", "", "functionName", "", "isUsedAsExpression", "", "<init>", "(Ljava/lang/String;Z)V", "getFunctionName", "()Ljava/lang/String;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "kotlin.code-insight.inspections.k2"})
    public static final class Context {
        @NotNull
        private final String functionName;
        private final boolean isUsedAsExpression;

        public Context(@NotNull String functionName, boolean isUsedAsExpression) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            this.functionName = functionName;
            this.isUsedAsExpression = isUsedAsExpression;
        }

        @NotNull
        public final String getFunctionName() {
            return this.functionName;
        }

        public final boolean isUsedAsExpression() {
            return this.isUsedAsExpression;
        }

        @NotNull
        public final String component1() {
            return this.functionName;
        }

        public final boolean component2() {
            return this.isUsedAsExpression;
        }

        @NotNull
        public final Context copy(@NotNull String functionName, boolean isUsedAsExpression) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            return new Context(functionName, isUsedAsExpression);
        }

        public static /* synthetic */ Context copy$default(Context context, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = context.functionName;
            }
            if ((n & 2) != 0) {
                bl = context.isUsedAsExpression;
            }
            return context.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "Context(functionName=" + this.functionName + ", isUsedAsExpression=" + this.isUsedAsExpression + ")";
        }

        public int hashCode() {
            int result2 = this.functionName.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isUsedAsExpression);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.functionName, (Object)context.functionName)) {
                return false;
            }
            return this.isUsedAsExpression == context.isUsedAsExpression;
        }
    }
}

