/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions.contexts;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.k2.refactoring.UtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.changeSignature.KotlinChangeInfo;
import org.jetbrains.kotlin.idea.k2.refactoring.changeSignature.KotlinChangeSignatureProcessor;
import org.jetbrains.kotlin.idea.k2.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\rJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000eJ\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000eJ\u0012\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0014*\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u0015\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/contexts/ContextParameterUtils;", "", "<init>", "()V", "isConvertibleContextParameter", "", "ktParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "isValueParameterConvertibleToContext", "runChangeSignatureForParameter", "", "element", "configureChangeInfo", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/changeSignature/KotlinChangeInfo;", "findContextParameterInChangeInfo", "Lorg/jetbrains/kotlin/idea/k2/refactoring/changeSignature/KotlinParameterInfo;", "changeInfo", "findValueParameterInChangeInfo", "getContextParameters", "", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "createChangeInfo", "ktCallable", "kotlin.code-insight.k2"})
@SourceDebugExtension(value={"SMAP\nContextParameterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextParameterUtils.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/contexts/ContextParameterUtils\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,92:1\n213#2:93\n59#3,11:94\n23#3,2:105\n*S KotlinDebug\n*F\n+ 1 ContextParameterUtils.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/contexts/ContextParameterUtils\n*L\n42#1:93\n87#1:94,11\n87#1:105,2\n*E\n"})
public final class ContextParameterUtils {
    @NotNull
    public static final ContextParameterUtils INSTANCE = new ContextParameterUtils();

    private ContextParameterUtils() {
    }

    public final boolean isConvertibleContextParameter(@NotNull KtParameter ktParameter) {
        Intrinsics.checkNotNullParameter((Object)ktParameter, (String)"ktParameter");
        if (!LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)ktParameter).supportsFeature(LanguageFeature.ContextParameters)) {
            return false;
        }
        PsiElement psiElement = ktParameter.getParent();
        KtContextReceiverList ktContextReceiverList = psiElement instanceof KtContextReceiverList ? (KtContextReceiverList)psiElement : null;
        if (ktContextReceiverList == null) {
            return false;
        }
        KtContextReceiverList contextParameterList = ktContextReceiverList;
        KtDeclaration contextParameterListOwner = contextParameterList.getOwnerDeclaration();
        return contextParameterListOwner instanceof KtCallableDeclaration;
    }

    public final boolean isValueParameterConvertibleToContext(@NotNull KtParameter ktParameter) {
        Intrinsics.checkNotNullParameter((Object)ktParameter, (String)"ktParameter");
        if (!LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)ktParameter).supportsFeature(LanguageFeature.ContextParameters)) {
            return false;
        }
        PsiElement psiElement = ktParameter.getParent();
        KtParameterList ktParameterList = psiElement instanceof KtParameterList ? (KtParameterList)psiElement : null;
        if (ktParameterList == null) {
            return false;
        }
        KtParameterList valueParameterList = ktParameterList;
        return valueParameterList.getOwnerFunction() != null;
    }

    public final void runChangeSignatureForParameter(@NotNull KtParameter element, @NotNull Function1<? super KotlinChangeInfo, Boolean> configureChangeInfo) {
        KotlinChangeSignatureProcessor kotlinChangeSignatureProcessor;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(configureChangeInfo, (String)"configureChangeInfo");
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
        boolean $i$f$getStrictParentOfType = false;
        KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallableDeclaration.class, (boolean)true);
        if (ktCallableDeclaration == null) {
            return;
        }
        KtCallableDeclaration ktCallable = ktCallableDeclaration;
        KotlinChangeInfo kotlinChangeInfo = this.createChangeInfo(ktCallable);
        if (kotlinChangeInfo == null) {
            return;
        }
        KotlinChangeInfo changeInfo = kotlinChangeInfo;
        if (!((Boolean)configureChangeInfo.invoke((Object)changeInfo)).booleanValue()) {
            return;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KotlinChangeSignatureProcessor it = kotlinChangeSignatureProcessor = new KotlinChangeSignatureProcessor(project, changeInfo);
        boolean bl = false;
        it.setPrepareSuccessfulSwingThreadCallback(ContextParameterUtils::runChangeSignatureForParameter$lambda$1$lambda$0);
        kotlinChangeSignatureProcessor.run();
    }

    @Nullable
    public final KotlinParameterInfo findContextParameterInChangeInfo(@NotNull KtParameter ktParameter, @NotNull KotlinChangeInfo changeInfo) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)ktParameter, (String)"ktParameter");
            Intrinsics.checkNotNullParameter((Object)changeInfo, (String)"changeInfo");
            Iterable iterable = changeInfo.getNonReceiverParameters();
            for (Object t : iterable) {
                KotlinParameterInfo it = (KotlinParameterInfo)t;
                boolean bl = false;
                if (!(it.isContextParameter() && Intrinsics.areEqual((Object)it.getOldName(), (Object)ktParameter.getName()))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final KotlinParameterInfo findValueParameterInChangeInfo(@NotNull KtParameter ktParameter, @NotNull KotlinChangeInfo changeInfo) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)ktParameter, (String)"ktParameter");
            Intrinsics.checkNotNullParameter((Object)changeInfo, (String)"changeInfo");
            Iterable iterable = changeInfo.getNonReceiverParameters();
            for (Object t : iterable) {
                KotlinParameterInfo it = (KotlinParameterInfo)t;
                boolean bl = false;
                if (!(!it.isContextParameter() && Intrinsics.areEqual((Object)it.getOldName(), (Object)ktParameter.getName()))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final List<KtParameter> getContextParameters(@NotNull KtCallableDeclaration $this$getContextParameters) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$getContextParameters, (String)"<this>");
        KtCallableDeclaration ktCallableDeclaration = $this$getContextParameters;
        if (ktCallableDeclaration instanceof KtNamedFunction) {
            KtContextReceiverList ktContextReceiverList = ((KtNamedFunction)$this$getContextParameters).getContextReceiverList();
            list2 = ktContextReceiverList != null ? ktContextReceiverList.contextParameters() : null;
        } else if (ktCallableDeclaration instanceof KtProperty) {
            KtContextReceiverList ktContextReceiverList = ((KtProperty)$this$getContextParameters).getContextReceiverList();
            list2 = ktContextReceiverList != null ? ktContextReceiverList.contextParameters() : null;
        } else {
            list2 = null;
        }
        return list2;
    }

    @Nullable
    public final KotlinChangeInfo createChangeInfo(@NotNull KtCallableDeclaration ktCallable) {
        Object v3;
        block6: {
            Intrinsics.checkNotNullParameter((Object)ktCallable, (String)"ktCallable");
            KtDeclaration ktDeclaration = (KtDeclaration)ktCallable;
            Collection collection = CollectionsKt.emptyList();
            String string = RefactoringBundle.message((String)"to.refactor");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            List<PsiElement> callableWithOverridden = UtilsKt.checkSuperMethods(ktDeclaration, collection, string);
            Iterable $this$lastIsInstanceOrNull$iv = callableWithOverridden;
            boolean $i$f$lastIsInstanceOrNull = false;
            if ($this$lastIsInstanceOrNull$iv instanceof List) {
                int n = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                if (0 <= n) {
                    do {
                        int i$iv;
                        Object element$iv;
                        if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n--)) instanceof KtCallableDeclaration)) continue;
                        v3 = element$iv;
                        break block6;
                    } while (0 <= n);
                }
                v3 = null;
            } else {
                Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                    if (!(element$iv$iv instanceof KtCallableDeclaration)) continue;
                    v3 = element$iv$iv;
                    break block6;
                }
                v3 = null;
            }
        }
        KtCallableDeclaration ktCallableDeclaration = v3;
        if (ktCallableDeclaration == null) {
            return null;
        }
        KtCallableDeclaration rootOverriddenOrSelf = ktCallableDeclaration;
        KotlinMethodDescriptor methodDescriptor = new KotlinMethodDescriptor((KtNamedDeclaration)rootOverriddenOrSelf);
        return new KotlinChangeInfo(methodDescriptor, null, null, null, null, null, false, 126, null);
    }

    private static final void runChangeSignatureForParameter$lambda$1$lambda$0() {
    }
}

