/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.onboarding.k2;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginMode;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.base.plugin.PluginsSupportingK2ModeKt;
import org.jetbrains.kotlin.idea.base.util.DumbModeUtils;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.idea.configuration.ui.KotlinPluginKindSwitcherController;
import org.jetbrains.kotlin.onboarding.FeedbackBundle;
import org.jetbrains.kotlin.onboarding.k2.satisfaction.survey.K2UserTracker;
import org.jetbrains.kotlin.onboarding.k2.satisfaction.survey.K2UserTrackerState;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/onboarding/k2/EnableK2NotificationService;", "", "<init>", "()V", "productName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getProductName", "()Ljava/lang/String;", "applicableVersions", "", "showEnableK2Notification", "", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTrackerState;", "hasIncompatibleWithK2ModeThirdPartyPluginsEnabled", "", "showNotification", "Companion", "kotlin.onboarding"})
@SourceDebugExtension(value={"SMAP\nEnableK2NotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnableK2NotificationService.kt\norg/jetbrains/kotlin/onboarding/k2/EnableK2NotificationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1761#2,3:114\n*S KotlinDebug\n*F\n+ 1 EnableK2NotificationService.kt\norg/jetbrains/kotlin/onboarding/k2/EnableK2NotificationService\n*L\n73#1:114,3\n*E\n"})
public final class EnableK2NotificationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> applicableVersions;

    public EnableK2NotificationService() {
        Object[] objectArray = new String[]{"2024.2", "2024.3"};
        this.applicableVersions = SetsKt.setOf((Object[])objectArray);
    }

    private final String getProductName() {
        String string = ApplicationNamesInfo.getInstance().getFullProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullProductName(...)");
        return string;
    }

    public final void showEnableK2Notification(@NotNull Project project, @NotNull K2UserTrackerState state) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        if (KotlinPluginModeProvider.Companion.getCurrentPluginMode() == KotlinPluginMode.K2) {
            return;
        }
        if (!Registry.Companion.is("test.enable.k2.notification", false)) {
            if (state.getUserSawEnableK2Notification()) {
                return;
            }
            if (state.getK2UserSince() != -1L) {
                return;
            }
        }
        if (!StringsKt.startsWith$default((String)KotlinJpsPluginSettings.Companion.jpsVersion(project), (String)"2.0", (boolean)false, (int)2, null)) {
            return;
        }
        String ideShortVersion = ApplicationInfo.getInstance().getShortVersion();
        if (!this.applicableVersions.contains(ideShortVersion) || ideShortVersion.equals("2024.3") && (!ApplicationInfo.getInstance().isEAP() || !ApplicationManager.getApplication().isInternal())) {
            return;
        }
        boolean projectContainsNonScriptKotlinFile = (Boolean)DumbModeUtils.runReadActionInSmartMode(project, () -> EnableK2NotificationService.showEnableK2Notification$lambda$0(project));
        if (!projectContainsNonScriptKotlinFile) {
            return;
        }
        if (this.hasIncompatibleWithK2ModeThirdPartyPluginsEnabled()) {
            return;
        }
        this.showNotification(project, state);
    }

    private final boolean hasIncompatibleWithK2ModeThirdPartyPluginsEnabled() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = PluginsSupportingK2ModeKt.getPluginsDependingOnKotlinPluginInK2ModeAndIncompatibleWithIt();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IdeaPluginDescriptorImpl it = (IdeaPluginDescriptorImpl)element$iv;
                    boolean bl2 = false;
                    if (!(!it.isBundled() && it.isEnabled())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void showNotification(Project project, K2UserTrackerState state) {
        Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("Configure K2").createNotification(FeedbackBundle.INSTANCE.message("enable.k2.mode", new Object[0]), FeedbackBundle.INSTANCE.message("enable.k2.mode.notification.text", new Object[0]), NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createExpiring((String)FeedbackBundle.INSTANCE.message("enable.action.name", new Object[0]), (arg_0, arg_1) -> EnableK2NotificationService.showNotification$lambda$3((arg_0, arg_1) -> EnableK2NotificationService.showNotification$lambda$2(this, arg_0, arg_1), arg_0, arg_1))).setIcon(KotlinIcons.SMALL_LOGO);
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setIcon(...)");
        Notification notification2 = notification;
        notification2.notify(project);
        state.setUserSawEnableK2Notification(true);
    }

    private static final boolean showEnableK2Notification$lambda$0(Project $project) {
        return ProjectStructureUtils.containsNonScriptKotlinFile($project);
    }

    private static final Unit showNotification$lambda$2(EnableK2NotificationService this$0, AnActionEvent anActionEvent, Notification notification) {
        VMOptions.setOption((String)"-Didea.kotlin.plugin.use.k2=", (String)"true");
        KotlinPluginKindSwitcherController.Companion.suggestRestart(this$0.getProductName());
        return Unit.INSTANCE;
    }

    private static final void showNotification$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/onboarding/k2/EnableK2NotificationService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTracker;", "kotlin.onboarding"})
    @SourceDebugExtension(value={"SMAP\nEnableK2NotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnableK2NotificationService.kt\norg/jetbrains/kotlin/onboarding/k2/EnableK2NotificationService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,113:1\n40#2,3:114\n*S KotlinDebug\n*F\n+ 1 EnableK2NotificationService.kt\norg/jetbrains/kotlin/onboarding/k2/EnableK2NotificationService$Companion\n*L\n110#1:114,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final K2UserTracker getInstance() {
            boolean $i$f$service = false;
            Class<K2UserTracker> serviceClass$iv = K2UserTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (K2UserTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

