/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.onboarding.k2.satisfaction.survey;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.feedback.impl.OnDemandFeedbackResolver;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginMode;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.base.util.DumbModeUtils;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.onboarding.k2.satisfaction.survey.K2FeedbackSurvey;
import org.jetbrains.kotlin.onboarding.k2.satisfaction.survey.K2UserTrackerState;
import org.jetbrains.kotlin.onboarding.k2.satisfaction.survey.PluginModes;

@State(name="K2NewUserTracker", storages={@Storage(value="k2-feedback.xml")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0018\b\u0007\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\u001b\u001a\u00020\u0002H\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\u0006\u0010\u001e\u001a\u00020\u0006J\u0015\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\u0002X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTracker;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTrackerState;", "<init>", "()V", "forceShowFeedbackForm", "", "project", "Lcom/intellij/openapi/project/Project;", "forced", "", "switchedToK1", "getSwitchedToK1$kotlin_onboarding", "()Z", "setSwitchedToK1$kotlin_onboarding", "(Z)V", "forUnitTests", "getForUnitTests$kotlin_onboarding", "setForUnitTests$kotlin_onboarding", "k2PluginModeForTests", "getK2PluginModeForTests$kotlin_onboarding", "setK2PluginModeForTests$kotlin_onboarding", "currentState", "getCurrentState$kotlin_onboarding", "()Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTrackerState;", "setCurrentState$kotlin_onboarding", "(Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTrackerState;)V", "getState", "loadState", "state", "checkIfKotlinPluginModeWasSwitchedOnRestart", "shouldShowK2FeedbackDialog", "shouldShowK2FeedbackDialog$kotlin_onboarding", "Companion", "kotlin.onboarding"})
public final class K2UserTracker
implements PersistentStateComponent<K2UserTrackerState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean forced;
    private boolean switchedToK1;
    private boolean forUnitTests;
    private boolean k2PluginModeForTests;
    @NotNull
    private K2UserTrackerState currentState = new K2UserTrackerState();
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Internal
    public final void forceShowFeedbackForm(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.forced = true;
        OnDemandFeedbackResolver.Companion.getInstance().showFeedbackNotification(Reflection.getOrCreateKotlinClass(K2FeedbackSurvey.class), project, arg_0 -> K2UserTracker.forceShowFeedbackForm$lambda$0(this, arg_0));
    }

    public final boolean getSwitchedToK1$kotlin_onboarding() {
        return this.switchedToK1;
    }

    public final void setSwitchedToK1$kotlin_onboarding(boolean bl) {
        this.switchedToK1 = bl;
    }

    public final boolean getForUnitTests$kotlin_onboarding() {
        return this.forUnitTests;
    }

    public final void setForUnitTests$kotlin_onboarding(boolean bl) {
        this.forUnitTests = bl;
    }

    public final boolean getK2PluginModeForTests$kotlin_onboarding() {
        return this.k2PluginModeForTests;
    }

    public final void setK2PluginModeForTests$kotlin_onboarding(boolean bl) {
        this.k2PluginModeForTests = bl;
    }

    @NotNull
    public final K2UserTrackerState getCurrentState$kotlin_onboarding() {
        return this.currentState;
    }

    public final void setCurrentState$kotlin_onboarding(@NotNull K2UserTrackerState k2UserTrackerState) {
        Intrinsics.checkNotNullParameter((Object)((Object)k2UserTrackerState), (String)"<set-?>");
        this.currentState = k2UserTrackerState;
    }

    @NotNull
    public K2UserTrackerState getState() {
        return this.currentState;
    }

    public void loadState(@NotNull K2UserTrackerState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.currentState = state;
    }

    public final void checkIfKotlinPluginModeWasSwitchedOnRestart() {
        if (KotlinPluginModeProvider.Companion.getCurrentPluginMode() == KotlinPluginMode.K1 && Intrinsics.areEqual((Object)this.getState().getLastSavedPluginMode(), (Object)PluginModes.K2.getValue())) {
            LOG.debug("Switched to K1");
            this.switchedToK1 = true;
        }
        if (KotlinPluginModeProvider.Companion.getCurrentPluginMode() == KotlinPluginMode.K2 && Intrinsics.areEqual((Object)this.getState().getLastSavedPluginMode(), (Object)PluginModes.K1.getValue())) {
            LOG.debug("Switched to K2");
            this.getState().setK2UserSince(Instant.now().getEpochSecond());
        }
        this.getState().setLastSavedPluginMode(KotlinPluginModeProvider.Companion.getCurrentPluginMode().name());
    }

    public final boolean shouldShowK2FeedbackDialog$kotlin_onboarding(@NotNull Project project) {
        boolean projectContainsNonScriptKotlinFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.forced) {
            return true;
        }
        LOG.debug("State: " + this.getState());
        if (!Registry.Companion.is("test.k2.feedback.survey", false)) {
            if (!this.forUnitTests && ApplicationManager.getApplication().isInternal()) {
                return false;
            }
            if (this.getState().getUserSawSurvey()) {
                return false;
            }
        } else {
            this.getState().setUserSawSurvey(false);
        }
        boolean bl = projectContainsNonScriptKotlinFile = this.forUnitTests || (Boolean)DumbModeUtils.runReadActionInSmartMode(project, () -> K2UserTracker.shouldShowK2FeedbackDialog$lambda$1(project)) != false;
        if (!projectContainsNonScriptKotlinFile) {
            return false;
        }
        return this.switchedToK1;
    }

    private static final Unit forceShowFeedbackForm$lambda$0(K2UserTracker this$0, boolean it) {
        this$0.forced = false;
        return Unit.INSTANCE;
    }

    private static final boolean shouldShowK2FeedbackDialog$lambda$1(Project $project) {
        return ProjectStructureUtils.containsNonScriptKotlinFile($project);
    }

    static {
        Logger logger = Logger.getInstance(K2UserTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTracker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTracker;", "kotlin.onboarding"})
    @SourceDebugExtension(value={"SMAP\nK2UserTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2UserTracker.kt\norg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTracker$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,103:1\n40#2,3:104\n*S KotlinDebug\n*F\n+ 1 K2UserTracker.kt\norg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTracker$Companion\n*L\n42#1:104,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final K2UserTracker getInstance() {
            boolean $i$f$service = false;
            Class<K2UserTracker> serviceClass$iv = K2UserTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (K2UserTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

