/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeWithSubgraphs;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CfgInternals;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowNodeMapper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00014B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-H\u0007J\b\u0010.\u001a\u00020*H\u0007J\u001a\u0010/\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u00172\u0006\u00100\u001a\u00020%H\u0007J\u000e\u00101\u001a\u00020*2\u0006\u00102\u001a\u000203R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u00020\u0011@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R2\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u00172\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0017@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0018@\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R \u0010!\u001a\u0006\u0012\u0002\b\u00030\u0018@\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00000\u00178F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001b\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "name", "", "kind", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$Kind;", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Ljava/lang/String;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$Kind;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getName", "()Ljava/lang/String;", "getKind", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$Kind;", "nodeCount", "", "getNodeCount", "()I", "setNodeCount", "(I)V", "value", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "nodes", "getNodes", "()Ljava/util/List;", "enterNode", "getEnterNode", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "setEnterNode", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;)V", "exitNode", "getExitNode", "setExitNode", "isSubGraph", "", "()Z", "subGraphs", "getSubGraphs", "copyData", "", "from", "mapper", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowNodeMapper;", "complete", "orderNodes", "isComplete", "traverse", "visitor", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "Kind", "semantics"})
@SourceDebugExtension(value={"SMAP\nControlFlowGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowGraph.kt\norg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,225:1\n1374#2:226\n1460#2,5:227\n1563#2:232\n1634#2,3:233\n1869#2,2:239\n1#3:236\n12476#4,2:237\n*S KotlinDebug\n*F\n+ 1 ControlFlowGraph.kt\norg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph\n*L\n27#1:226\n27#1:227,5\n38#1:232\n38#1:233,3\n121#1:239,2\n91#1:237,2\n*E\n"})
public final class ControlFlowGraph {
    @Nullable
    private final FirDeclaration declaration;
    @NotNull
    private final String name;
    @NotNull
    private final Kind kind;
    private int nodeCount;
    private List<? extends CFGNode<?>> nodes;
    public CFGNode<?> enterNode;
    public CFGNode<?> exitNode;

    public ControlFlowGraph(@Nullable FirDeclaration declaration, @NotNull String name2, @NotNull Kind kind) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        this.declaration = declaration;
        this.name = name2;
        this.kind = kind;
    }

    @Nullable
    public final FirDeclaration getDeclaration() {
        return this.declaration;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    public final int getNodeCount() {
        return this.nodeCount;
    }

    @CfgInternals
    public final void setNodeCount(int n2) {
        this.nodeCount = n2;
    }

    @NotNull
    public final List<CFGNode<?>> getNodes() {
        List<CFGNode<?>> list = this.nodes;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException("nodes");
        return null;
    }

    @NotNull
    public final CFGNode<?> getEnterNode() {
        CFGNode<?> cFGNode = this.enterNode;
        if (cFGNode != null) {
            return cFGNode;
        }
        Intrinsics.throwUninitializedPropertyAccessException("enterNode");
        return null;
    }

    @CfgInternals
    public final void setEnterNode(@NotNull CFGNode<?> cFGNode) {
        Intrinsics.checkNotNullParameter(cFGNode, "<set-?>");
        this.enterNode = cFGNode;
    }

    @NotNull
    public final CFGNode<?> getExitNode() {
        CFGNode<?> cFGNode = this.exitNode;
        if (cFGNode != null) {
            return cFGNode;
        }
        Intrinsics.throwUninitializedPropertyAccessException("exitNode");
        return null;
    }

    @CfgInternals
    public final void setExitNode(@NotNull CFGNode<?> cFGNode) {
        Intrinsics.checkNotNullParameter(cFGNode, "<set-?>");
        this.exitNode = cFGNode;
    }

    public final boolean isSubGraph() {
        return !((Collection)this.getEnterNode().getPreviousNodes()).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ControlFlowGraph> getSubGraphs() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getNodes();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CFGNode it = (CFGNode)element$iv$iv;
            boolean bl = false;
            Object object = it instanceof CFGNodeWithSubgraphs ? (CFGNodeWithSubgraphs)it : null;
            if (object == null || (object = ((CFGNodeWithSubgraphs)object).getSubGraphs()) == null) {
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @CfgInternals
    public final void copyData(@NotNull ControlFlowGraph from2, @NotNull ControlFlowNodeMapper mapper) {
        Intrinsics.checkNotNullParameter(from2, "from");
        Intrinsics.checkNotNullParameter(mapper, "mapper");
        if (from2.nodes != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = from2.getNodes();
            ControlFlowGraph controlFlowGraph = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                CFGNode cFGNode = (CFGNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(mapper.get(p0));
            }
            controlFlowGraph.nodes = (List)destination$iv$iv;
        }
        if (from2.enterNode != null) {
            this.setEnterNode(mapper.get(from2.getEnterNode()));
        }
        if (from2.exitNode != null) {
            this.setExitNode(mapper.get(from2.getExitNode()));
        }
    }

    @CfgInternals
    public final void complete() {
        this.nodes = this.orderNodes(true);
    }

    /*
     * WARNING - void declaration
     */
    @CfgInternals
    @NotNull
    public final List<CFGNode<?>> orderNodes(boolean isComplete) {
        ArrayList<Object> arrayList;
        ArrayList<Object> $this$orderNodes_u24lambda_u241 = arrayList = new ArrayList<Object>(this.nodeCount);
        boolean bl = false;
        $this$orderNodes_u24lambda_u241.add(this.getEnterNode());
        ArrayList<Object> result2 = arrayList;
        int[] countdowns = new int[this.nodeCount];
        int i2 = 0;
        while (i2 < result2.size()) {
            Object e2 = result2.get(i2++);
            Intrinsics.checkNotNullExpressionValue(e2, "get(...)");
            CFGNode node = (CFGNode)e2;
            for (CFGNode<?> next : node.getFollowingNodes()) {
                if (!Intrinsics.areEqual(next.getOwner(), this)) continue;
                if (next.getPreviousNodes().size() == 1) {
                    result2.add(next);
                    continue;
                }
                if (node.edgeTo(next).getKind().isBack()) continue;
                int it = countdowns[next.getId()];
                boolean bl2 = false;
                int remaining = (it == 0 ? ControlFlowGraphKt.access$getPreviousNodeCount(next) : it) - 1;
                if (remaining == 0) {
                    result2.add(next);
                }
                countdowns[next.getId()] = remaining;
            }
        }
        if (isComplete) {
            boolean bl3;
            boolean bl4 = bl3 = result2.size() == this.nodeCount;
            if (_Assertions.ENABLED && !bl3) {
                boolean bl5;
                StringBuilder stringBuilder;
                block7: {
                    void $this$all$iv;
                    CFGNode<?> next;
                    boolean bl6 = false;
                    next = (CFGNode<?>)countdowns;
                    stringBuilder = new StringBuilder().append("some nodes ");
                    boolean $i$f$all = false;
                    int n2 = ((void)$this$all$iv).length;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        void element$iv;
                        void it = element$iv = $this$all$iv[i3];
                        boolean bl7 = false;
                        if (it == false) continue;
                        bl5 = false;
                        break block7;
                    }
                    bl5 = true;
                }
                boolean bl8 = bl5;
                String string = stringBuilder.append(bl8 ? "are not reachable" : "form loops").append(" in control flow graph ").append(this.name).toString();
                throw new AssertionError((Object)string);
            }
        }
        return result2;
    }

    public final void traverse(@NotNull ControlFlowGraphVisitorVoid visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        for (CFGNode<?> node : this.getNodes()) {
            node.accept(visitor2);
            Object object = node instanceof CFGNodeWithSubgraphs ? (CFGNodeWithSubgraphs)node : null;
            if (object == null || (object = ((CFGNodeWithSubgraphs)object).getSubGraphs()) == null) continue;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ControlFlowGraph it = (ControlFlowGraph)element$iv;
                boolean bl = false;
                it.traverse(visitor2);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0010\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$Kind;", "", "<init>", "(Ljava/lang/String;I)V", "File", "Class", "Constructor", "Function", "Script", "LocalFunction", "AnonymousFunction", "AnonymousFunctionCalledInPlace", "PropertyInitializer", "ClassInitializer", "FieldInitializer", "FakeCall", "DefaultArgument", "semantics"})
    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind File = new Kind();
        public static final /* enum */ Kind Class = new Kind();
        public static final /* enum */ Kind Constructor = new Kind();
        public static final /* enum */ Kind Function = new Kind();
        public static final /* enum */ Kind Script = new Kind();
        public static final /* enum */ Kind LocalFunction = new Kind();
        public static final /* enum */ Kind AnonymousFunction = new Kind();
        public static final /* enum */ Kind AnonymousFunctionCalledInPlace = new Kind();
        public static final /* enum */ Kind PropertyInitializer = new Kind();
        public static final /* enum */ Kind ClassInitializer = new Kind();
        public static final /* enum */ Kind FieldInitializer = new Kind();
        public static final /* enum */ Kind FakeCall = new Kind();
        public static final /* enum */ Kind DefaultArgument = new Kind();
        private static final /* synthetic */ Kind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value2) {
            return Enum.valueOf(Kind.class, value2);
        }

        @NotNull
        public static EnumEntries<Kind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = kindArray = new Kind[]{Kind.File, Kind.Class, Kind.Constructor, Kind.Function, Kind.Script, Kind.LocalFunction, Kind.AnonymousFunction, Kind.AnonymousFunctionCalledInPlace, Kind.PropertyInitializer, Kind.ClassInitializer, Kind.FieldInitializer, Kind.FakeCall, Kind.DefaultArgument};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

