/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.KlibLoaderExtensionsKt;
import org.jetbrains.kotlin.backend.common.LoadedKlibs;
import org.jetbrains.kotlin.backend.common.diagnostics.StandardLibrarySpecialCompatibilityChecker;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsStandardLibrarySpecialCompatibilityChecker;
import org.jetbrains.kotlin.ir.backend.js.checkers.WasmStandardLibrarySpecialCompatibilityChecker;
import org.jetbrains.kotlin.js.config.JSConfigurationKeysKt;
import org.jetbrains.kotlin.konan.file.ZipFileSystemAccessor;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.loader.KlibLoader;
import org.jetbrains.kotlin.library.loader.KlibLoaderResult;
import org.jetbrains.kotlin.library.loader.KlibLoaderSpec;
import org.jetbrains.kotlin.library.loader.KlibPlatformChecker;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a@\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0004\u001a\u00020\u0005\u001aF\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"loadWebKlibsInProductionPipeline", "Lorg/jetbrains/kotlin/backend/common/LoadedKlibs;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "platformChecker", "Lorg/jetbrains/kotlin/library/loader/KlibPlatformChecker;", "loadWebKlibsInTestPipeline", "libraryPaths", "", "", "friendPaths", "includedPath", "loadWebKlibs", "useStricterChecks", "", "ir.serialization.js"})
@SourceDebugExtension(value={"SMAP\nloadWebKlibs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 loadWebKlibs.kt\norg/jetbrains/kotlin/ir/backend/js/LoadWebKlibsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class LoadWebKlibsKt {
    @NotNull
    public static final LoadedKlibs loadWebKlibsInProductionPipeline(@NotNull CompilerConfiguration configuration2, @NotNull KlibPlatformChecker platformChecker) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(platformChecker, "platformChecker");
        LoadedKlibs klibs = LoadWebKlibsKt.loadWebKlibs(configuration2, JSConfigurationKeysKt.getLibraries(configuration2), JSConfigurationKeysKt.getFriendLibraries(configuration2), JSConfigurationKeysKt.getIncludes(configuration2), platformChecker, false);
        boolean isWasm = platformChecker instanceof KlibPlatformChecker.Wasm;
        StandardLibrarySpecialCompatibilityChecker stdlibChecker = isWasm ? (StandardLibrarySpecialCompatibilityChecker)WasmStandardLibrarySpecialCompatibilityChecker.INSTANCE : (StandardLibrarySpecialCompatibilityChecker)JsStandardLibrarySpecialCompatibilityChecker.INSTANCE;
        stdlibChecker.check((Collection<? extends KotlinLibrary>)klibs.getAll(), CommonConfigurationKeysKt.getMessageCollector(configuration2));
        return klibs;
    }

    @NotNull
    public static final LoadedKlibs loadWebKlibsInTestPipeline(@NotNull CompilerConfiguration configuration2, @NotNull List<String> libraryPaths2, @NotNull List<String> friendPaths, @Nullable String includedPath, @NotNull KlibPlatformChecker platformChecker) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(libraryPaths2, "libraryPaths");
        Intrinsics.checkNotNullParameter(friendPaths, "friendPaths");
        Intrinsics.checkNotNullParameter(platformChecker, "platformChecker");
        return LoadWebKlibsKt.loadWebKlibs(configuration2, libraryPaths2, friendPaths, includedPath, platformChecker, true);
    }

    public static /* synthetic */ LoadedKlibs loadWebKlibsInTestPipeline$default(CompilerConfiguration compilerConfiguration, List list, List list2, String string, KlibPlatformChecker klibPlatformChecker, int n2, Object object) {
        if ((n2 & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n2 & 8) != 0) {
            string = null;
        }
        return LoadWebKlibsKt.loadWebKlibsInTestPipeline(compilerConfiguration, list, list2, string, klibPlatformChecker);
    }

    private static final LoadedKlibs loadWebKlibs(CompilerConfiguration configuration2, List<String> libraryPaths2, List<String> friendPaths, String includedPath, KlibPlatformChecker platformChecker, boolean useStricterChecks) {
        KlibLoaderResult klibLoaderResult;
        KlibLoaderResult $this$loadWebKlibs_u24lambda_u242 = klibLoaderResult = new KlibLoader(arg_0 -> LoadWebKlibsKt.loadWebKlibs$lambda$1(libraryPaths2, platformChecker, configuration2, arg_0)).load();
        boolean bl = false;
        KlibLoaderExtensionsKt.reportLoadingProblemsIfAny($this$loadWebKlibs_u24lambda_u242, configuration2, useStricterChecks);
        KlibLoaderResult result2 = KlibLoaderExtensionsKt.eliminateLibrariesWithDuplicatedUniqueNames(klibLoaderResult, configuration2);
        return new LoadedKlibs(result2.getLibrariesStdlibFirst(), KlibLoaderExtensionsKt.loadFriendLibraries(result2, friendPaths), CollectionsKt.firstOrNull(KlibLoaderExtensionsKt.loadFriendLibraries(result2, CollectionsKt.listOfNotNull(includedPath))));
    }

    private static final Unit loadWebKlibs$lambda$1(List $libraryPaths, KlibPlatformChecker $platformChecker, CompilerConfiguration $configuration, KlibLoaderSpec $this$KlibLoader) {
        block0: {
            Intrinsics.checkNotNullParameter($this$KlibLoader, "$this$KlibLoader");
            $this$KlibLoader.libraryPaths($libraryPaths);
            $this$KlibLoader.platformChecker($platformChecker);
            $this$KlibLoader.maxPermittedAbiVersion(KotlinAbiVersion.Companion.getCURRENT());
            ZipFileSystemAccessor zipFileSystemAccessor = JSConfigurationKeysKt.getZipFileSystemAccessor($configuration);
            if (zipFileSystemAccessor == null) break block0;
            ZipFileSystemAccessor it = zipFileSystemAccessor;
            boolean bl = false;
            $this$KlibLoader.zipFileSystemAccessor(it);
        }
        return Unit.INSTANCE;
    }
}

