/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLogger
extends Logger {
    private static boolean ourMirrorToStderr = true;
    private final String myCategory;
    private LogLevel myLevel = LogLevel.WARNING;

    public DefaultLogger(String category) {
        this.myCategory = category;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.myLevel.compareTo(LogLevel.DEBUG) >= 0;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.myLevel.compareTo(LogLevel.TRACE) >= 0;
    }

    @Override
    public void trace(String message2) {
        if (this.isTraceEnabled()) {
            System.out.println("TRACE[" + this.myCategory + "]: " + message2);
        }
    }

    @Override
    public void trace(@Nullable Throwable t) {
        if (t != null && this.isTraceEnabled()) {
            System.out.print("TRACE[" + this.myCategory + "]: ");
            t.printStackTrace(System.out);
        }
    }

    @Override
    public void debug(String message2, @Nullable Throwable t) {
        if (this.isDebugEnabled()) {
            System.out.println("DEBUG[" + this.myCategory + "]: " + message2);
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }

    @Override
    public void info(String message2, Throwable t) {
        if (this.myLevel.compareTo(LogLevel.INFO) >= 0) {
            System.out.println("INFO[" + this.myCategory + "]: " + message2);
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }

    @Override
    public void warn(String message2, @Nullable Throwable t) {
        t = DefaultLogger.ensureNotControlFlow(t);
        System.err.println("WARN: " + message2);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    @Override
    public void error(String message2, @Nullable Throwable t, String ... details) {
        if (details == null) {
            DefaultLogger.$$$reportNull$$$0(0);
        }
        t = DefaultLogger.ensureNotControlFlow(t);
        if (DefaultLogger.shouldDumpExceptionToStderr()) {
            System.err.println("ERROR: " + message2 + DefaultLogger.detailsToString(details) + DefaultLogger.attachmentsToString(t));
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
        throw new AssertionError(message2, t);
    }

    @Override
    public void setLevel(@NotNull Level level) {
        if (level == null) {
            DefaultLogger.$$$reportNull$$$0(1);
        }
    }

    @Override
    public void setLevel(@NotNull LogLevel level) {
        if (level == null) {
            DefaultLogger.$$$reportNull$$$0(2);
        }
        this.myLevel = level;
    }

    @NotNull
    public static String detailsToString(String ... details) {
        if (details == null) {
            DefaultLogger.$$$reportNull$$$0(3);
        }
        return details.length > 0 ? "\nDetails:\n" + String.join((CharSequence)"\n", details) : "";
    }

    @NotNull
    public static String attachmentsToString(@Nullable Throwable t) {
        if (t != null) {
            String prefix = "\n\nAttachments:\n";
            String attachments = ExceptionUtil.findCauseAndSuppressed(t, ExceptionWithAttachments.class).stream().flatMap(e -> Stream.of(e.getAttachments())).map(ATTACHMENT_TO_STRING).collect(Collectors.joining("\n----\n", prefix, ""));
            if (!attachments.equals(prefix)) {
                String string2 = attachments;
                if (string2 == null) {
                    DefaultLogger.$$$reportNull$$$0(4);
                }
                return string2;
            }
        }
        return "";
    }

    public static boolean shouldDumpExceptionToStderr() {
        return ourMirrorToStderr;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/DefaultLogger";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/DefaultLogger";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "attachmentsToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLevel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "detailsToString";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "disableStderrDumping";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

