/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class ClassFileViewProvider
extends SingleRootFileViewProvider {
    private static final Key<Boolean> IS_INNER_CLASS = Key.create("java.is.inner.class.key");

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file2) {
        if (manager == null) {
            ClassFileViewProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ClassFileViewProvider.$$$reportNull$$$0(1);
        }
        this(manager, file2, true);
    }

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file2, boolean eventSystemEnabled) {
        if (manager == null) {
            ClassFileViewProvider.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ClassFileViewProvider.$$$reportNull$$$0(3);
        }
        super(manager, file2, eventSystemEnabled, JavaLanguage.INSTANCE);
    }

    @Override
    protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile file2, @NotNull FileType fileType) {
        FileIndexFacade fileIndex;
        if (project == null) {
            ClassFileViewProvider.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            ClassFileViewProvider.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            ClassFileViewProvider.$$$reportNull$$$0(6);
        }
        if (!(fileIndex = FileIndexFacade.getInstance(project)).isInLibraryClasses(file2) && fileIndex.isInSource(file2)) {
            return new PsiBinaryFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        try {
            if (!ClassFileViewProvider.isInnerClass(file2)) {
                return new ClsFileImpl(this);
            }
        }
        catch (Exception e) {
            Logger.getInstance(ClassFileViewProvider.class).debug(file2.getPath(), e);
        }
        return null;
    }

    public static boolean isInnerClass(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ClassFileViewProvider.$$$reportNull$$$0(7);
        }
        return ClassFileViewProvider.detectInnerClass(file2, null);
    }

    public static boolean isInnerClass(@NotNull VirtualFile file2, byte @NotNull [] content) {
        if (file2 == null) {
            ClassFileViewProvider.$$$reportNull$$$0(8);
        }
        if (content == null) {
            ClassFileViewProvider.$$$reportNull$$$0(9);
        }
        return ClassFileViewProvider.detectInnerClass(file2, content);
    }

    private static boolean detectInnerClass(VirtualFile file2, byte @Nullable [] content) {
        String name2 = file2.getNameWithoutExtension();
        int p = name2.lastIndexOf(36, name2.length() - 2);
        if (p <= 0) {
            return false;
        }
        Boolean isInner = IS_INNER_CLASS.get(file2);
        if (isInner != null) {
            return isInner;
        }
        if (content == null) {
            try {
                content = file2.contentsToByteArray(false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ClassReader reader = new ClassReader(content);
        final Ref<Boolean> ref = Ref.create(Boolean.FALSE);
        final String className = reader.getClassName();
        reader.accept(new ClassVisitor(589824){

            @Override
            public void visitOuterClass(String owner, String name2, String desc) {
                ref.set(Boolean.TRUE);
            }

            @Override
            public void visitInnerClass(String name2, String outer, String inner, int access) {
                if (className.equals(name2)) {
                    ref.set(Boolean.TRUE);
                }
            }
        }, ClsFileImpl.EMPTY_ATTRIBUTES, 7);
        isInner = ref.get();
        IS_INNER_CLASS.set(file2, isInner);
        return isInner;
    }

    @Override
    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy) {
        if (copy == null) {
            ClassFileViewProvider.$$$reportNull$$$0(10);
        }
        return new ClassFileViewProvider(this.getManager(), copy, false);
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return this.findElementAt(offset, this.getBaseLanguage());
    }

    @Override
    public PsiElement findElementAt(int offset, @NotNull Language language2) {
        PsiFile file2;
        if (language2 == null) {
            ClassFileViewProvider.$$$reportNull$$$0(11);
        }
        if ((file2 = this.getPsi(language2)) instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        return ClassFileViewProvider.findElementAt(file2, offset);
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        return this.findReferenceAt(offset, this.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiReference findReferenceAt(int offset, @NotNull Language language2) {
        PsiFile file2;
        if (language2 == null) {
            ClassFileViewProvider.$$$reportNull$$$0(12);
        }
        if ((file2 = this.getPsi(language2)) instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        return ClassFileViewProvider.findReferenceAt(file2, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/ClassFileViewProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isInnerClass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createCopy";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementAt";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferenceAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

