/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0006H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0013\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataIntegerArray;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataElement;", "value", "", "", "integerSize", "", "<init>", "(Ljava/util/List;I)V", "getValue", "()Ljava/util/List;", "getIntegerSize", "()I", "toBytes", "", "dump", "", "indent", "startAddress", "sizeInBytes", "getSizeInBytes", "backend.wasm"})
public final class ConstantDataIntegerArray
extends ConstantDataElement {
    @NotNull
    private final List<Long> value;
    private final int integerSize;
    private final int sizeInBytes;

    public ConstantDataIntegerArray(@NotNull List<Long> value, int integerSize) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        super(null);
        this.value = value;
        this.integerSize = integerSize;
        this.sizeInBytes = this.value.size() * this.integerSize;
    }

    @NotNull
    public final List<Long> getValue() {
        return this.value;
    }

    public final int getIntegerSize() {
        return this.integerSize;
    }

    @Override
    @NotNull
    public byte[] toBytes() {
        byte[] array = new byte[this.value.size() * this.integerSize];
        int n = this.value.size();
        int n2 = 0;
        while (n2 < n) {
            int i = n2++;
            boolean bl = false;
            ConstantDataKt.toLittleEndianBytesTo(((Number)this.value.get(i)).longValue(), array, i * this.integerSize, this.integerSize);
        }
        return array;
    }

    @Override
    @NotNull
    public String dump(@NotNull String indent, int startAddress) {
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        if (this.value.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder().append(ConstantDataKt.access$addressToString(startAddress)).append(": ").append(indent).append(" i").append(this.integerSize * 8).append("[] : ");
        String string = Arrays.toString(this.toBytes());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return stringBuilder.append(string).append("   ;;\n").toString();
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }
}

