/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.build.events.MessageEvent;
import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.ExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NullUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.gradle.DefaultExternalDependencyId;
import org.jetbrains.plugins.gradle.ExternalDependencyId;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencySyncIssue;
import org.jetbrains.plugins.gradle.model.DefaultExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.GradleBuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.GradleLightProject;
import org.jetbrains.plugins.gradle.model.UnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.cache.GradleLocalCacheHelper;
import org.jetbrains.plugins.gradle.service.project.ArtifactMappingService;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.ModuleMappingInfo;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.GradleExecutionWorkspace;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleDataKt;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public final class GradleProjectResolverUtil {
    private static final Logger LOG = Logger.getInstance(GradleProjectResolverUtil.class);
    @NonNls
    private static final String SOURCE_JAR_SUFFIX = "-sources.jar";
    @NonNls
    private static final String JAVADOC_JAR_SUFFIX = "-javadoc.jar";
    private static final Key<Boolean> IS_INCLUDED_BUILD_TASK_RUN_SUPPORTED = Key.create((String)"is included build task running supported");
    private static final Key<Set<LibraryData>> LIBRARIES_CACHE = Key.create((String)"GradleProjectResolverUtil.LIBRARIES_CACHE");
    private static final Key<Map<String, Map<LibraryPathType, List<String>>>> PATHS_CACHE = Key.create((String)"GradleProjectResolverUtil.PATHS_CACHE");
    private static final Key<Map<String, DataNode<LibraryData>>> LIBRARIES_BY_NAME_CACHE = Key.create((String)"GradleProjectResolverUtil.FOUND_LIBRARIES");

    @NotNull
    public static DataNode<ModuleData> createMainModule(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        String mainModuleFileDirectoryPath;
        String moduleName;
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(0);
        }
        if (gradleModule == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(1);
        }
        if (projectDataNode == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(2);
        }
        GradleProject gradleProject = gradleModule.getGradleProject();
        String string = moduleName = resolverCtx.isUseQualifiedModuleNames() ? gradleProject.getName() : gradleModule.getName();
        if (moduleName == null) {
            throw new IllegalStateException("Module with undefined name detected: " + String.valueOf(gradleModule));
        }
        ProjectData projectData = (ProjectData)projectDataNode.getData();
        String mainModuleConfigPath = GradleProjectResolverUtil.getModuleConfigPath(resolverCtx, gradleModule, projectData.getLinkedExternalProjectPath());
        String ideProjectPath = resolverCtx.getIdeProjectPath();
        boolean isUnderProjectRoot = FileUtil.isAncestor((String)projectData.getLinkedExternalProjectPath(), (String)mainModuleConfigPath, (boolean)false);
        String relativePath = isUnderProjectRoot ? FileUtil.getRelativePath((String)projectData.getLinkedExternalProjectPath(), (String)mainModuleConfigPath, (char)'/') : String.valueOf(FileUtil.pathHashCode((String)mainModuleConfigPath));
        String string2 = ideProjectPath == null ? mainModuleConfigPath : (mainModuleFileDirectoryPath = ideProjectPath + "/" + (relativePath == null || relativePath.equals(".") ? "" : relativePath));
        if (GradleProjectResolver.DEBUG_ORPHAN_MODULES_PROCESSING) {
            LOG.info(String.format("Creating module data ('%s') with the external config path: '%s'", gradleProject.getPath(), mainModuleConfigPath));
        }
        String mainModuleId = GradleProjectResolverUtil.getModuleId(resolverCtx, gradleModule);
        ModuleData moduleData = new ModuleData(mainModuleId, GradleConstants.SYSTEM_ID, GradleProjectResolverUtil.getDefaultModuleTypeId(), moduleName, mainModuleFileDirectoryPath, mainModuleConfigPath);
        ExternalProject externalProject = resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject != null) {
            GradleModuleDataKt.setGradlePath(moduleData, externalProject.getPath());
            GradleModuleDataKt.setGradleIdentityPath(moduleData, GradleProjectResolverUtil.getIdentityPath(resolverCtx, externalProject, projectData.getExternalName()));
            moduleData.setInternalName(GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, resolverCtx));
            moduleData.setGroup(externalProject.getGroup());
            moduleData.setVersion(externalProject.getVersion());
            moduleData.setDescription(externalProject.getDescription());
            moduleData.setModuleName(moduleName);
            if (!resolverCtx.isResolveModulePerSourceSet()) {
                moduleData.setArtifacts(externalProject.getArtifacts());
                moduleData.setPublication((ProjectCoordinate)new ProjectId(externalProject.getGroup(), externalProject.getName(), externalProject.getVersion()));
            }
        }
        File rootDir = gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir();
        String rootProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)rootDir.getPath());
        boolean isComposite = !resolverCtx.getNestedBuilds().isEmpty();
        boolean isIncludedBuildTaskRunningSupported = isComposite && GradleProjectResolverUtil.isIncludedBuildTaskRunningSupported(projectDataNode, resolverCtx);
        File mainBuildRootDir = resolverCtx.getRootBuild().getBuildIdentifier().getRootDir();
        String mainBuildRootPath = ExternalSystemApiUtil.toCanonicalPath((String)mainBuildRootDir.getPath());
        boolean isFromIncludedBuild = !rootProjectPath.equals(mainBuildRootPath);
        boolean useIncludedBuildPathPrefix = isFromIncludedBuild && isIncludedBuildTaskRunningSupported;
        String compositeBuildGradlePath = useIncludedBuildPathPrefix ? ":" + GradleProjectResolverUtil.getRootProject(gradleProject).getName() : "";
        GradleModuleDataKt.setIncludedBuild(moduleData, isFromIncludedBuild);
        String directoryToRunTask = compositeBuildGradlePath.isEmpty() ? rootProjectPath : mainBuildRootPath;
        GradleModuleDataKt.setDirectoryToRunTask(moduleData, directoryToRunTask);
        DataNode dataNode = projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
        if (dataNode == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(3);
        }
        return dataNode;
    }

    @NotNull
    private static String getIdentityPath(@NotNull ProjectResolverContext resolverCtx, @NotNull ExternalProject externalProject, @NotNull @NlsSafe String rootProjectName) {
        String buildSrcPrefix;
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(4);
        }
        if (externalProject == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(5);
        }
        if (rootProjectName == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(6);
        }
        if (!StringUtil.isEmpty((String)(buildSrcPrefix = GradleProjectResolverUtil.getBuildSrcPrefix(resolverCtx, rootProjectName)))) {
            String string = GradleProjectResolverUtil.patchBuildSrcIdentity(buildSrcPrefix, externalProject.getIdentityPath());
            if (string == null) {
                GradleProjectResolverUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = externalProject.getIdentityPath();
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    private static String getBuildSrcPrefix(@NotNull ProjectResolverContext ctx, @NotNull String rootProjectName) {
        if (ctx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(9);
        }
        if (rootProjectName == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(10);
        }
        if (ctx.getBuildSrcGroup() == null) {
            return null;
        }
        return ":" + ctx.getBuildSrcGroup() + ":buildSrc";
    }

    private static String patchBuildSrcIdentity(@NotNull String prefix, @NotNull String path) {
        if (prefix == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(11);
        }
        if (path == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(12);
        }
        return path.isEmpty() || path.equals(":") ? prefix : prefix + path;
    }

    @NotNull
    private static GradleProject getRootProject(@NotNull GradleProject project) {
        if (project == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(13);
        }
        GradleProject result = project;
        while (result.getParent() != null) {
            result = result.getParent();
        }
        GradleProject gradleProject = result;
        if (gradleProject == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(14);
        }
        return gradleProject;
    }

    private static boolean isIncludedBuildTaskRunningSupported(@NotNull DataNode<ProjectData> project, @NotNull ProjectResolverContext resolverCtx) {
        Boolean isSupported;
        if (project == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(15);
        }
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(16);
        }
        if ((isSupported = (Boolean)IS_INCLUDED_BUILD_TASK_RUN_SUPPORTED.get(project)) == null) {
            isSupported = GradleVersionUtil.isGradleAtLeast((GradleVersion)resolverCtx.getGradleVersion(), (String)"6.8");
            IS_INCLUDED_BUILD_TASK_RUN_SUPPORTED.set(project, (Object)isSupported);
        }
        return isSupported;
    }

    public static String getDefaultModuleTypeId() {
        ModuleType moduleType = ModuleTypeManager.getInstance().getDefaultModuleType();
        return moduleType.getId();
    }

    @NotNull
    static String getInternalModuleName(@NotNull IdeaModule gradleModule, @NotNull ExternalProject externalProject, @NotNull ProjectResolverContext resolverCtx) {
        if (gradleModule == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(17);
        }
        if (externalProject == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(18);
        }
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(19);
        }
        return GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, null, resolverCtx);
    }

    @NotNull
    static String getInternalModuleName(@NotNull IdeaModule gradleModule, @NotNull ExternalProject externalProject, @Nullable String sourceSetName, @NotNull ProjectResolverContext resolverCtx) {
        String delimiter;
        if (gradleModule == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(20);
        }
        if (externalProject == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(21);
        }
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(22);
        }
        StringBuilder moduleName = new StringBuilder();
        String rootName = gradleModule.getProject().getName();
        BuildIdentifier buildIdentifier = gradleModule.getGradleProject().getProjectIdentifier().getBuildIdentifier();
        String buildSrcGroup = resolverCtx.getBuildSrcGroup(rootName, buildIdentifier);
        if (resolverCtx.isUseQualifiedModuleNames()) {
            delimiter = ".";
            if (StringUtil.isNotEmpty((String)buildSrcGroup)) {
                moduleName.append(buildSrcGroup).append(delimiter);
            }
            moduleName.append(GradleProjectResolverUtil.gradlePathToQualifiedName(rootName, externalProject.getQName()));
        } else {
            delimiter = "_";
            if (StringUtil.isNotEmpty((String)buildSrcGroup)) {
                moduleName.append(buildSrcGroup).append(delimiter);
            }
            moduleName.append(gradleModule.getName());
        }
        if (sourceSetName != null) {
            assert (!sourceSetName.isEmpty());
            moduleName.append(delimiter);
            moduleName.append(sourceSetName);
        }
        String string = PathUtilRt.suggestFileName((String)moduleName.toString(), (boolean)true, (boolean)false);
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @ApiStatus.Internal
    @NotNull
    public static String getHolderModuleName(@NotNull ProjectResolverContext context, @NotNull GradleLightProject projectModel, @NotNull ExternalProject externalProject) {
        boolean isBuildSrcOfRootBuild;
        if (context == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(24);
        }
        if (projectModel == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(25);
        }
        if (externalProject == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(26);
        }
        Path rootBuildPath = context.getRootBuild().getBuildIdentifier().getRootDir().toPath();
        String rootBuildName = context.getRootBuild().getName();
        Path buildPath = projectModel.getBuild().getBuildIdentifier().getRootDir().toPath();
        String buildName = projectModel.getBuild().getName();
        String identityPath = externalProject.getIdentityPath();
        Object moduleName = Strings.trimStart((String)identityPath, (String)":");
        boolean isRootBuild = rootBuildPath.equals(buildPath);
        boolean bl = isBuildSrcOfRootBuild = rootBuildPath.equals(buildPath.getParent()) && buildName.equals("buildSrc");
        if (isRootBuild || isBuildSrcOfRootBuild) {
            moduleName = rootBuildName + ":" + (String)moduleName;
        }
        if (context.getBuildSrcGroup() != null) {
            moduleName = context.getBuildSrcGroup() + ":" + (String)moduleName;
        }
        moduleName = Strings.trimEnd((String)moduleName, (String)":");
        String string = Arrays.stream(((String)moduleName).split(":")).map(it -> GradleProjectResolverUtil.escapeModuleNameElement(it)).collect(Collectors.joining("."));
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @ApiStatus.Internal
    @NotNull
    public static String resolveSourceSetModuleName(@NotNull ProjectResolverContext context, @NotNull EntityStorage storage, @NotNull GradleLightProject projectModel, @NotNull ExternalProject externalProject, @NotNull String sourceSetName) {
        String holderModuleName;
        String sourceSetModuleName;
        if (context == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(28);
        }
        if (storage == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(29);
        }
        if (projectModel == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(30);
        }
        if (externalProject == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(31);
        }
        if (sourceSetName == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(32);
        }
        if (storage.contains((SymbolicEntityId)new ModuleId(sourceSetModuleName = (holderModuleName = GradleProjectResolverUtil.getHolderModuleName(context, projectModel, externalProject)) + "." + GradleProjectResolverUtil.escapeModuleNameElement(sourceSetName)))) {
            String string = sourceSetModuleName + "~1";
            if (string == null) {
                GradleProjectResolverUtil.$$$reportNull$$$0(33);
            }
            return string;
        }
        String string = sourceSetModuleName;
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private static String escapeModuleNameElement(@NotNull String moduleNameElement) {
        if (moduleNameElement == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(35);
        }
        String string = moduleNameElement.replace(" ", "_").replace("/", "_").replace("\\\\", "_").replace(".", "_");
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    private static String gradlePathToQualifiedName(@NotNull String rootName, @NotNull String gradlePath2) {
        if (rootName == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(37);
        }
        if (gradlePath2 == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(38);
        }
        String string = (String)(gradlePath2.startsWith(":") ? rootName + "." : "") + Arrays.stream(gradlePath2.split(":")).filter(s -> !s.isEmpty()).collect(Collectors.joining("."));
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    public static String getModuleConfigPath(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull String rootProjectPath) {
        ExternalProject externalProject;
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(40);
        }
        if (gradleModule == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(41);
        }
        if (rootProjectPath == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(42);
        }
        if ((externalProject = resolverCtx.getExtraProject(gradleModule, ExternalProject.class)) != null) {
            File projectDir = externalProject.getProjectDir();
            String string = ExternalSystemApiUtil.toCanonicalPath((String)projectDir.getPath());
            if (string == null) {
                GradleProjectResolverUtil.$$$reportNull$$$0(43);
            }
            return string;
        }
        String string = GradleUtil.getConfigPath(gradleModule.getGradleProject(), rootProjectPath);
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(44);
        }
        return string;
    }

    @NotNull
    public static String getModuleId(@NotNull ProjectResolverContext context, @NotNull IdeaModule gradleModule) {
        if (context == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(45);
        }
        if (gradleModule == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(46);
        }
        ExternalProject externalProject = GradleProjectResolverUtil.getExternalProject(context, gradleModule);
        return GradleProjectResolverUtil.getModuleId(context, externalProject);
    }

    @NotNull
    public static String getModuleId(@NotNull ProjectResolverContext context, @NotNull IdeaModule gradleModule, @NotNull ExternalSourceSet sourceSet) {
        if (context == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(47);
        }
        if (gradleModule == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(48);
        }
        if (sourceSet == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(49);
        }
        ExternalProject externalProject = GradleProjectResolverUtil.getExternalProject(context, gradleModule);
        return GradleProjectResolverUtil.getModuleId(context, externalProject, sourceSet);
    }

    @NotNull
    private static ExternalProject getExternalProject(@NotNull ProjectResolverContext context, @NotNull IdeaModule gradleModule) {
        ExternalProject externalProject;
        if (context == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(50);
        }
        if (gradleModule == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(51);
        }
        if ((externalProject = context.getProjectModel((ProjectModel)gradleModule, ExternalProject.class)) == null) {
            throw new IllegalStateException("Missing " + ExternalProject.class.getSimpleName() + " for " + gradleModule.getProjectIdentifier().getProjectPath());
        }
        ExternalProject externalProject2 = externalProject;
        if (externalProject2 == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(52);
        }
        return externalProject2;
    }

    @NotNull
    public static String getModuleId(@NotNull ProjectResolverContext context, @NotNull ExternalProject externalProject, @NotNull ExternalSourceSet sourceSet) {
        if (context == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(53);
        }
        if (externalProject == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(54);
        }
        if (sourceSet == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(55);
        }
        String mainModuleId = GradleProjectResolverUtil.getModuleId(context, externalProject);
        String string = mainModuleId + ":" + sourceSet.getName();
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(56);
        }
        return string;
    }

    @NotNull
    public static String getModuleId(@NotNull ProjectResolverContext context, @NotNull ExternalProject externalProject) {
        if (context == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(57);
        }
        if (externalProject == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(58);
        }
        if (!StringUtil.isEmpty((String)context.getBuildSrcGroup())) {
            String string = context.getBuildSrcGroup() + ":" + GradleProjectResolverUtil.getModuleId(externalProject);
            if (string == null) {
                GradleProjectResolverUtil.$$$reportNull$$$0(59);
            }
            return string;
        }
        return GradleProjectResolverUtil.getModuleId(externalProject);
    }

    @NotNull
    private static String getModuleId(@NotNull ExternalProject externalProject) {
        if (externalProject == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(60);
        }
        String moduleName = externalProject.getName();
        String gradlePath2 = externalProject.getIdentityPath();
        if (StringUtil.isEmpty((String)gradlePath2)) {
            String string = moduleName;
            if (string == null) {
                GradleProjectResolverUtil.$$$reportNull$$$0(61);
            }
            return string;
        }
        if (":".equals(gradlePath2)) {
            String string = moduleName;
            if (string == null) {
                GradleProjectResolverUtil.$$$reportNull$$$0(62);
            }
            return string;
        }
        String string = gradlePath2;
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(63);
        }
        return string;
    }

    @TestOnly
    @NotNull
    public static String getModuleId(@NotNull ExternalProject externalProject, @NotNull ExternalSourceSet sourceSet) {
        if (externalProject == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(64);
        }
        if (sourceSet == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(65);
        }
        String mainModuleId = GradleProjectResolverUtil.getModuleId(externalProject);
        String string = mainModuleId + ":" + sourceSet.getName();
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(66);
        }
        return string;
    }

    @NotNull
    public static String getModuleId(@NotNull ExternalProjectDependency projectDependency) {
        Object moduleId;
        if (projectDependency == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(67);
        }
        DependencyScope dependencyScope = GradleProjectResolverUtil.getDependencyScope(projectDependency.getScope());
        String projectPath = projectDependency.getProjectPath();
        Object object = moduleId = StringUtil.isEmpty((String)projectPath) || ":".equals(projectPath) ? projectDependency.getName() : projectPath;
        moduleId = "default".equals(projectDependency.getConfigurationName()) ? (String)moduleId + (dependencyScope == DependencyScope.TEST ? ":test" : ":main") : (String)moduleId + ":" + projectDependency.getConfigurationName();
        Object object2 = moduleId;
        if (object2 == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(68);
        }
        return object2;
    }

    @NotNull
    public static String getModuleId(@NotNull ProjectResolverContext context, @NotNull GradleLightProject projectModel) {
        if (context == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(69);
        }
        if (projectModel == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(70);
        }
        if (!StringUtil.isEmpty((String)context.getBuildSrcGroup())) {
            String string = context.getBuildSrcGroup() + ":" + GradleProjectResolverUtil.getModuleId(projectModel);
            if (string == null) {
                GradleProjectResolverUtil.$$$reportNull$$$0(71);
            }
            return string;
        }
        return GradleProjectResolverUtil.getModuleId(projectModel);
    }

    @NotNull
    private static String getModuleId(@NotNull GradleLightProject projectModel) {
        String identityPath;
        if (projectModel == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(72);
        }
        if (":".equals(identityPath = projectModel.getIdentityPath())) {
            String string = projectModel.getName();
            if (string == null) {
                GradleProjectResolverUtil.$$$reportNull$$$0(73);
            }
            return string;
        }
        String string = identityPath;
        if (string == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(74);
        }
        return string;
    }

    @Nullable
    public static String getSourceSetName(Module module) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        if (!"sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module))) {
            return null;
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (externalProjectId == null) {
            return null;
        }
        int i = externalProjectId.lastIndexOf(58);
        if (i == -1 || externalProjectId.length() < i + 1) {
            return null;
        }
        return externalProjectId.substring(i + 1);
    }

    @Nullable
    public static String getGradleIdentityPathOrNull(Module module) {
        String join;
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (externalProjectId == null) {
            return null;
        }
        String moduleType = ExternalSystemApiUtil.getExternalModuleType((Module)module);
        boolean trimSourceSet = "sourceSet".equals(moduleType);
        List pathParts = StringUtil.split((String)externalProjectId, (String)":");
        if (!externalProjectId.startsWith(":") && !pathParts.isEmpty()) {
            pathParts = pathParts.subList(1, pathParts.size());
        }
        if (trimSourceSet && !pathParts.isEmpty()) {
            pathParts = pathParts.subList(0, pathParts.size() - 1);
        }
        return (join = StringUtil.join((Collection)pathParts, (String)":")).isEmpty() ? ":" : ":" + join;
    }

    @NotNull
    public static DependencyScope getDependencyScope(@Nullable String scope) {
        DependencyScope dependencyScope = scope != null ? DependencyScope.valueOf((String)scope) : DependencyScope.COMPILE;
        if (dependencyScope == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(75);
        }
        return dependencyScope;
    }

    @NotNull
    private static DependencyScope getMergedDependencyScope(@Nullable String scope1, @Nullable String scope2) {
        DependencyScope dependencyScope = DependencyScope.coveringUseCasesOf((DependencyScope)GradleProjectResolverUtil.getDependencyScope(scope1), (DependencyScope)GradleProjectResolverUtil.getDependencyScope(scope2));
        if (dependencyScope == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(76);
        }
        return dependencyScope;
    }

    public static void attachGradleSdkSources(@NotNull IdeaModule gradleModule, @Nullable File libFile, @NotNull LibraryData library, @NotNull ProjectResolverContext resolverCtx) {
        if (gradleModule == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(77);
        }
        if (library == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(78);
        }
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(79);
        }
        if (libFile == null || !libFile.getName().startsWith("gradle-")) {
            return;
        }
        GradleBuildScriptClasspathModel buildScriptClasspathModel = resolverCtx.getExtraProject(gradleModule, GradleBuildScriptClasspathModel.class);
        if (buildScriptClasspathModel == null) {
            return;
        }
        File gradleHomeDir = buildScriptClasspathModel.getGradleHomeDir();
        if (gradleHomeDir == null) {
            return;
        }
        String gradleVersion = buildScriptClasspathModel.getGradleVersion();
        GradleProjectResolverUtil.attachGradleSdkSources(libFile, library, gradleHomeDir, gradleVersion);
    }

    public static void attachGradleSdkSources(@Nullable File libFile, @NotNull LibraryData library, @NotNull File gradleHomeDir, @NotNull String gradleVersion) {
        if (library == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(80);
        }
        if (gradleHomeDir == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(81);
        }
        if (gradleVersion == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(82);
        }
        if (libFile == null || !libFile.getName().startsWith("gradle-")) {
            return;
        }
        if (!FileUtil.isAncestor((File)gradleHomeDir, (File)libFile, (boolean)true)) {
            File libFileParent = libFile.getParentFile();
            if (libFileParent == null || !StringUtil.equals((CharSequence)"generated-gradle-jars", (CharSequence)libFileParent.getName())) {
                return;
            }
            if (("gradle-api-" + gradleVersion + ".jar").equals(libFile.getName())) {
                File gradleSrc = new File(gradleHomeDir, "src");
                File[] gradleSrcRoots = gradleSrc.listFiles();
                if (gradleSrcRoots == null) {
                    return;
                }
                for (File srcRoot : gradleSrcRoots) {
                    library.addPath(LibraryPathType.SOURCE, srcRoot.getPath());
                }
            }
            return;
        }
        File libOrPluginsFile = libFile.getParentFile();
        if (libOrPluginsFile != null && "plugins".equals(libOrPluginsFile.getName())) {
            libOrPluginsFile = libOrPluginsFile.getParentFile();
        }
        if (libOrPluginsFile != null && "lib".equals(libOrPluginsFile.getName()) && libOrPluginsFile.getParentFile() != null) {
            File srcDir = new File(libOrPluginsFile.getParentFile(), "src");
            int endIndex = libFile.getName().indexOf(gradleVersion);
            if (endIndex != -1) {
                String srcDirChild = libFile.getName().substring("gradle-".length(), endIndex - 1);
                srcDir = new File(srcDir, srcDirChild);
            }
            if (srcDir.isDirectory()) {
                library.addPath(LibraryPathType.SOURCE, srcDir.getPath());
            }
        }
    }

    public static void attachSourcesAndJavadocFromGradleCacheIfNeeded(File gradleUserHomeDir2, LibraryData libraryData) {
        GradleProjectResolverUtil.attachSourcesAndJavadocFromGradleCacheIfNeeded(null, gradleUserHomeDir2, libraryData);
    }

    public static void attachSourcesAndJavadocFromGradleCacheIfNeeded(ProjectResolverContext context, File gradleUserHomeDir2, LibraryData libraryData) {
        boolean docResolved;
        boolean sourceResolved = !libraryData.getPaths(LibraryPathType.SOURCE).isEmpty();
        boolean bl = docResolved = !libraryData.getPaths(LibraryPathType.DOC).isEmpty();
        if (sourceResolved && docResolved) {
            return;
        }
        Map pathsCache = null;
        if (context != null) {
            Set libsCache = (Set)ConcurrencyUtil.computeIfAbsent((UserDataHolder)context, LIBRARIES_CACHE, () -> Collections.newSetFromMap(new IdentityHashMap()));
            if (!libsCache.add(libraryData)) {
                return;
            }
            pathsCache = (Map)ConcurrencyUtil.computeIfAbsent((UserDataHolder)context, PATHS_CACHE, () -> new HashMap());
        }
        for (String path : libraryData.getPaths(LibraryPathType.BINARY)) {
            HashMap<LibraryPathType, List<String>> collectedPaths;
            if (!FileUtil.isAncestor((String)gradleUserHomeDir2.getPath(), (String)path, (boolean)true)) continue;
            HashMap<LibraryPathType, List<String>> hashMap = collectedPaths = pathsCache == null ? null : (HashMap<LibraryPathType, List<String>>)pathsCache.get(path);
            if (collectedPaths == null) {
                collectedPaths = new HashMap<LibraryPathType, List<String>>();
                if (pathsCache != null) {
                    pathsCache.put(path, collectedPaths);
                }
                if (path.contains("/caches/modules-2/files-2.1") || path.contains("/caches/transforms-")) {
                    UnifiedCoordinates coordinates = GradleProjectResolverUtil.getLibraryCoordinates(libraryData);
                    Set<LibraryPathType> requiredComponentTypes = GradleProjectResolverUtil.getRequiredComponentTypes(sourceResolved, docResolved);
                    Map<LibraryPathType, List<Path>> cachedComponents = coordinates != null ? GradleLocalCacheHelper.findArtifactComponents(coordinates, gradleUserHomeDir2.toPath(), requiredComponentTypes) : GradleProjectResolverUtil.findAdjacentComponents(Paths.get(path, new String[0]), requiredComponentTypes);
                    GradleProjectResolverUtil.mergeCollectedArtifacts(collectedPaths, cachedComponents);
                } else {
                    GradleProjectResolverUtil.collectSourcesAndJavadocsFromTheSameFolder(path, collectedPaths, sourceResolved, docResolved);
                }
            }
            for (Map.Entry each : collectedPaths.entrySet()) {
                for (String cachedPath : (List)each.getValue()) {
                    libraryData.addPath((LibraryPathType)each.getKey(), cachedPath);
                }
            }
        }
    }

    private static void mergeCollectedArtifacts(@NotNull Map<LibraryPathType, List<String>> target, @NotNull Map<LibraryPathType, List<Path>> collected) {
        if (target == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(83);
        }
        if (collected == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(84);
        }
        for (Map.Entry<LibraryPathType, List<Path>> entry : collected.entrySet()) {
            Set pathStrings = entry.getValue().stream().map(v -> v.toString()).collect(Collectors.toSet());
            target.computeIfAbsent(entry.getKey(), ignore -> new SmartList()).addAll(pathStrings);
        }
    }

    @NotNull
    private static Set<LibraryPathType> getRequiredComponentTypes(boolean sourceResolved, boolean docResolved) {
        EnumSet<LibraryPathType> requiredComponentTypes = EnumSet.noneOf(LibraryPathType.class);
        if (!sourceResolved) {
            requiredComponentTypes.add(LibraryPathType.SOURCE);
        }
        if (!docResolved) {
            requiredComponentTypes.add(LibraryPathType.DOC);
        }
        EnumSet<LibraryPathType> enumSet = requiredComponentTypes;
        if (enumSet == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(85);
        }
        return enumSet;
    }

    private static void collectSourcesAndJavadocsFromTheSameFolder(@NotNull String binaryPath, @NotNull Map<LibraryPathType, List<String>> collect, boolean sourceResolved, boolean docResolved) {
        Path file;
        Path binaryFileParent;
        if (binaryPath == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(86);
        }
        if (collect == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(87);
        }
        if (!Files.isDirectory(binaryFileParent = (file = Paths.get(binaryPath, new String[0])).getParent(), new LinkOption[0])) {
            return;
        }
        try (Stream<Path> list = Files.list(binaryFileParent);){
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Path p = (Path)it.next();
                if (!Files.isRegularFile(p, new LinkOption[0])) continue;
                String name = p.getFileName().toString();
                if (!sourceResolved && name.endsWith(SOURCE_JAR_SUFFIX)) {
                    collect.computeIfAbsent(LibraryPathType.SOURCE, type -> new SmartList()).add(p.toFile().getPath());
                    sourceResolved = true;
                } else if (!docResolved && name.endsWith(JAVADOC_JAR_SUFFIX)) {
                    collect.computeIfAbsent(LibraryPathType.DOC, type -> new SmartList()).add(p.toFile().getPath());
                    docResolved = true;
                }
                if (!sourceResolved || !docResolved) continue;
                return;
            }
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    @Nullable
    private static UnifiedCoordinates getLibraryCoordinates(@NotNull LibraryData libraryData) {
        if (libraryData == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(88);
        }
        String group = libraryData.getGroupId();
        String artifact = libraryData.getArtifactId();
        String version = libraryData.getVersion();
        if (NullUtils.hasNull((Object[])new Object[]{group, artifact, version})) {
            String externalName = libraryData.getExternalName();
            if (StringUtil.isEmpty((String)externalName)) {
                return null;
            }
            String[] externalNameParticles = externalName.split(":");
            if (externalNameParticles.length == 3) {
                group = externalNameParticles[0];
                artifact = externalNameParticles[1];
                version = externalNameParticles[2];
            }
        }
        if (NullUtils.hasNull((Object[])new Object[]{group, artifact, version})) {
            return null;
        }
        version = version.replace("@aar", "");
        return new UnifiedCoordinates(group, artifact, version);
    }

    public static void buildDependencies(@NotNull ProjectResolverContext resolverCtx, @NotNull Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetMap, @NotNull ArtifactMappingService artifactsMap, @NotNull DataNode<? extends ExternalEntityData> ownerDataNode, @NotNull Collection<ExternalDependency> dependencies, @Nullable DataNode<ProjectData> ideProject) throws IllegalStateException {
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(89);
        }
        if (sourceSetMap == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(90);
        }
        if (artifactsMap == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(91);
        }
        if (ownerDataNode == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(92);
        }
        if (dependencies == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(93);
        }
        HashMap<ExternalDependencyId, ExternalDependency> dependencyMap = new HashMap<ExternalDependencyId, ExternalDependency>();
        ArrayDeque<ExternalDependency> queue = new ArrayDeque<ExternalDependency>(dependencies);
        while (!queue.isEmpty()) {
            ExternalDependency dependency = (ExternalDependency)queue.remove();
            DefaultExternalDependencyId key = new DefaultExternalDependencyId(dependency.getId());
            ExternalDependency seenDependency = (ExternalDependency)dependencyMap.get(key);
            if (seenDependency != null) {
                if (dependency instanceof ExternalLibraryDependency) {
                    ExternalLibraryDependency seenLibDependency;
                    ExternalLibraryDependency libDependency = (ExternalLibraryDependency)dependency;
                    if (seenDependency instanceof ExternalLibraryDependency && !FileUtil.filesEqual((File)(seenLibDependency = (ExternalLibraryDependency)seenDependency).getFile(), (File)libDependency.getFile())) {
                        DefaultExternalMultiLibraryDependency mergedDependency = new DefaultExternalMultiLibraryDependency(seenLibDependency);
                        mergedDependency.setScope(GradleProjectResolverUtil.getMergedDependencyScope(mergedDependency.getScope(), libDependency.getScope()).name());
                        mergedDependency.addArtifactsFrom(libDependency);
                        dependencyMap.put((ExternalDependencyId)key, (ExternalDependency)mergedDependency);
                        continue;
                    }
                    if (seenDependency instanceof DefaultExternalMultiLibraryDependency) {
                        DefaultExternalMultiLibraryDependency mergedDependency = (DefaultExternalMultiLibraryDependency)seenDependency;
                        mergedDependency.setScope(GradleProjectResolverUtil.getMergedDependencyScope(mergedDependency.getScope(), libDependency.getScope()).name());
                        mergedDependency.addArtifactsFrom(libDependency);
                        continue;
                    }
                }
                DependencyScope prevScope = GradleProjectResolverUtil.getDependencyScope(seenDependency.getScope());
                DependencyScope currentScope = GradleProjectResolverUtil.getDependencyScope(dependency.getScope());
                if (prevScope.isForProductionCompile() || prevScope.isForProductionRuntime() && currentScope.isForProductionRuntime()) continue;
            }
            dependencyMap.put((ExternalDependencyId)key, dependency);
            queue.addAll(dependency.getDependencies());
        }
        GradleProjectResolverUtil.doBuildDependencies(resolverCtx, sourceSetMap, artifactsMap, dependencyMap, ownerDataNode, dependencies, ideProject);
    }

    private static void doBuildDependencies(@NotNull ProjectResolverContext resolverCtx, @NotNull Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetMap, @NotNull ArtifactMappingService artifactsMap, @NotNull Map<ExternalDependencyId, ExternalDependency> mergedDependencyMap, @NotNull DataNode<? extends ExternalEntityData> ownerDataNode, @NotNull Collection<ExternalDependency> dependencies, @Nullable DataNode<ProjectData> ideProject) throws IllegalStateException {
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(94);
        }
        if (sourceSetMap == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(95);
        }
        if (artifactsMap == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(96);
        }
        if (mergedDependencyMap == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(97);
        }
        if (ownerDataNode == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(98);
        }
        if (dependencies == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(99);
        }
        AtomicInteger classpathOrderShift = new AtomicInteger(0);
        HashSet<ExternalDependencyId> processedDependencies = new HashSet<ExternalDependencyId>();
        Map<ExternalDependencyId, Collection<ExternalDependency>> transitiveDependenciesMap = GradleProjectResolverUtil.groupTransitiveDependenciesById(dependencies);
        for (ExternalDependency dependency : dependencies) {
            if (!processedDependencies.add(dependency.getId())) continue;
            Collection transitiveDependencies = transitiveDependenciesMap.getOrDefault(dependency.getId(), Collections.emptySet());
            ExternalDependency mergedDependency = mergedDependencyMap.getOrDefault(dependency.getId(), dependency);
            DataNode<? extends ExternalEntityData> depOwnerDataNode = null;
            if (mergedDependency instanceof ExternalProjectDependency) {
                ExternalProjectDependency projectDependency = (ExternalProjectDependency)mergedDependency;
                depOwnerDataNode = GradleProjectResolverUtil.createDependencyDataNode(projectDependency, resolverCtx, ownerDataNode, transitiveDependencies.isEmpty(), sourceSetMap, artifactsMap, classpathOrderShift);
            } else if (mergedDependency instanceof ExternalLibraryDependency) {
                ExternalLibraryDependency libraryDependency = (ExternalLibraryDependency)mergedDependency;
                depOwnerDataNode = GradleProjectResolverUtil.createDependencyDataNode(libraryDependency, ownerDataNode, ideProject, classpathOrderShift);
            } else if (mergedDependency instanceof ExternalMultiLibraryDependency) {
                ExternalMultiLibraryDependency multiDep = (ExternalMultiLibraryDependency)mergedDependency;
                depOwnerDataNode = GradleProjectResolverUtil.createDependencyDataNode(multiDep, ownerDataNode, classpathOrderShift);
            } else if (mergedDependency instanceof FileCollectionDependency) {
                FileCollectionDependency fileCollectionDependency = (FileCollectionDependency)mergedDependency;
                depOwnerDataNode = GradleProjectResolverUtil.createDependencyDataNode(fileCollectionDependency, ownerDataNode, classpathOrderShift);
            } else if (mergedDependency instanceof UnresolvedExternalDependency) {
                UnresolvedExternalDependency unresolvedDep = (UnresolvedExternalDependency)mergedDependency;
                depOwnerDataNode = GradleProjectResolverUtil.createDependencyDataNode(unresolvedDep, resolverCtx, ownerDataNode, ideProject, classpathOrderShift);
            }
            if (depOwnerDataNode == null || transitiveDependencies.isEmpty()) continue;
            GradleProjectResolverUtil.doBuildDependencies(resolverCtx, sourceSetMap, artifactsMap, mergedDependencyMap, depOwnerDataNode, transitiveDependencies, ideProject);
        }
    }

    private static DataNode<? extends ExternalEntityData> createDependencyDataNode(ExternalProjectDependency projectDependency, @NotNull ProjectResolverContext resolverCtx, @NotNull DataNode<? extends ExternalEntityData> ownerDataNode, boolean isTransitiveDepsEmpty, @NotNull Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetMap, @NotNull ArtifactMappingService artifactMap, AtomicInteger classpathOrderShift) {
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(100);
        }
        if (ownerDataNode == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(101);
        }
        if (sourceSetMap == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(102);
        }
        if (artifactMap == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(103);
        }
        DataNode resultDataNode = null;
        ModuleData ownerModule = GradleProjectResolverUtil.getOwnerModule(ownerDataNode);
        DependencyScope dependencyScope = GradleProjectResolverUtil.getDependencyScope(projectDependency.getScope());
        ArrayList<ProjectDependencyInfo> projectDependencyInfos = new ArrayList<ProjectDependencyInfo>();
        ArrayList<File> artifactsToKeepAsLibraries = new ArrayList<File>();
        GradleExecutionWorkspace executionWorkspace = resolverCtx.getSettings().getExecutionWorkspace();
        ModuleData moduleData = executionWorkspace.findModuleDataByArtifacts(projectDependency.getProjectDependencyArtifacts());
        if (moduleData != null) {
            projectDependencyInfos.add(new ProjectDependencyInfo(moduleData, null, projectDependency.getProjectDependencyArtifacts()));
        }
        if (projectDependencyInfos.isEmpty()) {
            MultiMap projectPairs = new MultiMap((Map)new Reference2ObjectLinkedOpenHashMap());
            for (File file2 : projectDependency.getProjectDependencyArtifacts()) {
                ModuleMappingInfo mapping = artifactMap.getModuleMapping(ExternalSystemApiUtil.toCanonicalPath((String)file2.getPath()));
                if (mapping == null) continue;
                for (String moduleId : mapping.getModuleIds()) {
                    Pair<DataNode<GradleSourceSetData>, ExternalSourceSet> projectPair = sourceSetMap.get(moduleId);
                    if (projectPair == null) continue;
                    projectPairs.putValue(projectPair, (Object)file2);
                }
                if (!mapping.getHasNonModulesContent()) continue;
                artifactsToKeepAsLibraries.add(file2);
            }
            for (Map.Entry entry : projectPairs.entrySet()) {
                projectDependencyInfos.add(new ProjectDependencyInfo((ModuleData)((DataNode)((Pair)entry.getKey()).first).getData(), (ExternalSourceSet)((Pair)entry.getKey()).second, (Collection)entry.getValue()));
            }
            String moduleIdFromDependency = GradleProjectResolverUtil.getModuleId(projectDependency);
            Pair<DataNode<GradleSourceSetData>, ExternalSourceSet> projectPairFromMap = sourceSetMap.get(moduleIdFromDependency);
            if (projectPairFromMap != null && GradleProjectResolverUtil.doesNotContainDependencyOn(projectDependencyInfos, (GradleSourceSetData)((Object)((DataNode)projectPairFromMap.first).getData()))) {
                Collection artifacts = projectDependency.getProjectDependencyArtifacts();
                artifacts.removeAll(GradleProjectResolverUtil.collectProcessedArtifacts(projectDependencyInfos));
                projectDependencyInfos.add(new ProjectDependencyInfo((ModuleData)((DataNode)projectPairFromMap.first).getData(), (ExternalSourceSet)projectPairFromMap.second, artifacts));
            }
        }
        if (projectDependencyInfos.isEmpty()) {
            LibraryDependencyData libraryDependencyData = GradleProjectResolverUtil.createLibraryDependencyData(projectDependency, classpathOrderShift.get(), ownerModule, dependencyScope);
            if (!projectDependency.getProjectDependencyArtifacts().isEmpty()) {
                for (File artifact : projectDependency.getProjectDependencyArtifacts()) {
                    ((LibraryData)libraryDependencyData.getTarget()).addPath(LibraryPathType.BINARY, artifact.getPath());
                }
                if (projectDependency.getProjectDependencyArtifacts().size() == 1) {
                    projectDependency.getProjectDependencyArtifacts().stream().findFirst().filter(file -> file.getName().endsWith(".jar")).ifPresent(file -> {
                        String fileName = file.getName();
                        ((LibraryData)libraryDependencyData.getTarget()).setInternalName("Gradle: " + fileName);
                        ((LibraryData)libraryDependencyData.getTarget()).setExternalName(fileName);
                    });
                }
                resultDataNode = ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
            } else {
                resultDataNode = ownerDataNode;
            }
        } else {
            int i = 0;
            for (ProjectDependencyInfo projectDependencyInfo : projectDependencyInfos) {
                if (i++ > 0 && isTransitiveDepsEmpty) {
                    classpathOrderShift.incrementAndGet();
                }
                ModuleDependencyData moduleDependencyData = new ModuleDependencyData(ownerModule, projectDependencyInfo.myModuleData);
                moduleDependencyData.setScope(dependencyScope);
                if (projectDependencyInfo.mySourceSet != null && GradleProjectResolverUtil.isTestSourceSet(projectDependencyInfo.mySourceSet)) {
                    moduleDependencyData.setProductionOnTestDependency(true);
                }
                moduleDependencyData.setOrder(projectDependency.getClasspathOrder() + classpathOrderShift.get());
                moduleDependencyData.setExported(projectDependency.getExported());
                moduleDependencyData.setModuleDependencyArtifacts((Collection)ContainerUtil.map(projectDependencyInfo.dependencyArtifacts, File::getPath));
                resultDataNode = ownerDataNode.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)moduleDependencyData);
            }
            for (File artifact : artifactsToKeepAsLibraries) {
                LibraryDependencyData data = GradleProjectResolverUtil.createLibraryDependencyData(projectDependency, classpathOrderShift.incrementAndGet(), ownerModule, dependencyScope);
                ((LibraryData)data.getTarget()).addPath(LibraryPathType.BINARY, artifact.getPath());
                ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)data);
            }
            if (projectDependencyInfos.size() > 1) {
                resultDataNode = ownerDataNode;
            }
        }
        return resultDataNode;
    }

    @NotNull
    private static LibraryDependencyData createLibraryDependencyData(ExternalProjectDependency projectDependency, int classpathOrderShift, ModuleData ownerModule, DependencyScope dependencyScope) {
        LibraryLevel level = LibraryLevel.MODULE;
        LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, "");
        LibraryDependencyData libraryDependencyData = new LibraryDependencyData(ownerModule, library, level);
        libraryDependencyData.setScope(dependencyScope);
        libraryDependencyData.setOrder(projectDependency.getClasspathOrder() + classpathOrderShift);
        libraryDependencyData.setExported(projectDependency.getExported());
        LibraryDependencyData libraryDependencyData2 = libraryDependencyData;
        if (libraryDependencyData2 == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(104);
        }
        return libraryDependencyData2;
    }

    private static DataNode<? extends ExternalEntityData> createDependencyDataNode(ExternalLibraryDependency libraryDependency, @NotNull DataNode<? extends ExternalEntityData> ownerDataNode, @Nullable DataNode<ProjectData> ideProject, AtomicInteger classpathOrderShift) {
        LibraryLevel level;
        File javaDocPath;
        if (ownerDataNode == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(105);
        }
        DependencyScope dependencyScope = GradleProjectResolverUtil.getDependencyScope(libraryDependency.getScope());
        ModuleData ownerModule = GradleProjectResolverUtil.getOwnerModule(ownerDataNode);
        String libraryName = libraryDependency.getId().getPresentableName();
        LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName);
        library.setArtifactId(libraryDependency.getId().getName());
        library.setGroup(libraryDependency.getId().getGroup());
        library.setVersion(libraryDependency.getId().getVersion());
        library.addPath(LibraryPathType.BINARY, libraryDependency.getFile().getPath());
        File sourcePath = libraryDependency.getSource();
        if (sourcePath != null) {
            library.addPath(LibraryPathType.SOURCE, sourcePath.getPath());
        }
        if ((javaDocPath = libraryDependency.getJavadoc()) != null) {
            library.addPath(LibraryPathType.DOC, javaDocPath.getPath());
        }
        LibraryLevel libraryLevel = level = StringUtil.isNotEmpty((String)libraryName) ? LibraryLevel.PROJECT : LibraryLevel.MODULE;
        if (StringUtil.isEmpty((String)libraryName) || !GradleProjectResolverUtil.linkProjectLibrary(ideProject, library)) {
            level = LibraryLevel.MODULE;
        }
        LibraryDependencyData libraryDependencyData = new LibraryDependencyData(ownerModule, library, level);
        libraryDependencyData.setScope(dependencyScope);
        libraryDependencyData.setOrder(libraryDependency.getClasspathOrder() + classpathOrderShift.get());
        libraryDependencyData.setExported(libraryDependency.getExported());
        return ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
    }

    private static DataNode<? extends ExternalEntityData> createDependencyDataNode(ExternalMultiLibraryDependency multiDep, @NotNull DataNode<? extends ExternalEntityData> ownerDataNode, AtomicInteger classpathOrderShift) {
        if (ownerDataNode == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(106);
        }
        ModuleData ownerModule = GradleProjectResolverUtil.getOwnerModule(ownerDataNode);
        DependencyScope dependencyScope = GradleProjectResolverUtil.getDependencyScope(multiDep.getScope());
        LibraryLevel level = LibraryLevel.MODULE;
        String libraryName = multiDep.getId().getPresentableName();
        LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName);
        library.setArtifactId(multiDep.getId().getName());
        library.setGroup(multiDep.getId().getGroup());
        library.setVersion(multiDep.getId().getVersion());
        LibraryDependencyData libraryDependencyData = new LibraryDependencyData(ownerModule, library, level);
        libraryDependencyData.setScope(dependencyScope);
        libraryDependencyData.setOrder(multiDep.getClasspathOrder() + classpathOrderShift.get());
        libraryDependencyData.setExported(multiDep.getExported());
        for (File file : multiDep.getFiles()) {
            library.addPath(LibraryPathType.BINARY, file.getPath());
        }
        for (File file : multiDep.getSources()) {
            library.addPath(LibraryPathType.SOURCE, file.getPath());
        }
        for (File file : multiDep.getJavadoc()) {
            library.addPath(LibraryPathType.DOC, file.getPath());
        }
        return ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
    }

    @Nullable
    private static DataNode<? extends ExternalEntityData> createDependencyDataNode(FileCollectionDependency fileCollectionDependency, @NotNull DataNode<? extends ExternalEntityData> ownerDataNode, AtomicInteger classpathOrderShift) {
        if (ownerDataNode == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(107);
        }
        ModuleData ownerModule = GradleProjectResolverUtil.getOwnerModule(ownerDataNode);
        DependencyScope dependencyScope = GradleProjectResolverUtil.getDependencyScope(fileCollectionDependency.getScope());
        LibraryLevel level = LibraryLevel.MODULE;
        String libraryName = "";
        LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName);
        LibraryDependencyData libraryDependencyData = new LibraryDependencyData(ownerModule, library, level);
        libraryDependencyData.setScope(dependencyScope);
        libraryDependencyData.setOrder(fileCollectionDependency.getClasspathOrder() + classpathOrderShift.get());
        libraryDependencyData.setExported(fileCollectionDependency.getExported());
        for (File file2 : fileCollectionDependency.getFiles()) {
            DefaultFileCollectionDependency defaultFCDep;
            library.addPath(LibraryPathType.BINARY, file2.getPath());
            if (!(fileCollectionDependency instanceof DefaultFileCollectionDependency) || !(defaultFCDep = (DefaultFileCollectionDependency)fileCollectionDependency).isExcludedFromIndexing()) continue;
            library.addPath(LibraryPathType.EXCLUDED, file2.getPath());
        }
        if (fileCollectionDependency.getFiles().size() == 1) {
            fileCollectionDependency.getFiles().stream().findFirst().filter(file -> file.getName().endsWith(".jar")).ifPresent(file -> {
                String fileName = file.getName();
                library.setInternalName("Gradle: " + fileName);
                library.setExternalName(fileName);
            });
        }
        ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
        return null;
    }

    @Nullable
    private static DataNode<? extends ExternalEntityData> createDependencyDataNode(UnresolvedExternalDependency unresolvedDep, @NotNull ProjectResolverContext resolverCtx, @NotNull DataNode<? extends ExternalEntityData> ownerDataNode, @Nullable DataNode<ProjectData> ideProject, AtomicInteger classpathOrderShift) {
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(108);
        }
        if (ownerDataNode == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(109);
        }
        ModuleData ownerModule = GradleProjectResolverUtil.getOwnerModule(ownerDataNode);
        GradleProjectResolverUtil.reportUnresolvedDependencyError(resolverCtx, unresolvedDep, ownerModule.getId());
        String libraryName = unresolvedDep.getId().getPresentableName();
        DependencyScope dependencyScope = GradleProjectResolverUtil.getDependencyScope(unresolvedDep.getScope());
        LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName, true);
        LibraryLevel level = GradleProjectResolverUtil.linkProjectLibrary(ideProject, library) ? LibraryLevel.PROJECT : LibraryLevel.MODULE;
        LibraryDependencyData libraryDependencyData = new LibraryDependencyData(ownerModule, library, level);
        libraryDependencyData.setScope(dependencyScope);
        libraryDependencyData.setOrder(unresolvedDep.getClasspathOrder() + classpathOrderShift.get());
        ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
        return null;
    }

    private static void reportUnresolvedDependencyError(@NotNull ProjectResolverContext resolverCtx, UnresolvedExternalDependency unresolvedDep, String ownerModuleId) {
        if (resolverCtx == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(110);
        }
        String libraryName = unresolvedDep.getId().getPresentableName();
        String failureMessage = unresolvedDep.getFailureMessage();
        boolean isOfflineWork = resolverCtx.getSettings().isOfflineWork();
        UnresolvedDependencySyncIssue buildIssue = new UnresolvedDependencySyncIssue(libraryName, failureMessage, resolverCtx.getProjectPath(), isOfflineWork, ownerModuleId);
        resolverCtx.report(MessageEvent.Kind.ERROR, buildIssue);
    }

    @NotNull
    private static ModuleData getOwnerModule(@NotNull DataNode<? extends ExternalEntityData> ownerDataNode) {
        if (ownerDataNode == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(111);
        }
        ModuleData result = null;
        ExternalEntityData ownerData = (ExternalEntityData)ownerDataNode.getData();
        if (ownerData instanceof ModuleData) {
            ModuleData moduleData;
            result = moduleData = (ModuleData)ownerData;
        } else if (ownerData instanceof DependencyData) {
            DependencyData dependencyData = (DependencyData)ownerData;
            result = dependencyData.getOwnerModule();
        }
        assert (result != null);
        ModuleData moduleData = result;
        if (moduleData == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(112);
        }
        return moduleData;
    }

    @NotNull
    private static Map<ExternalDependencyId, Collection<ExternalDependency>> groupTransitiveDependenciesById(@NotNull Collection<ExternalDependency> dependencies) {
        if (dependencies == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(113);
        }
        LinkedHashMap<ExternalDependencyId, Collection<ExternalDependency>> dependencyMap = new LinkedHashMap<ExternalDependencyId, Collection<ExternalDependency>>();
        for (ExternalDependency dependency : dependencies) {
            Collection transitiveDependencies = dependencyMap.computeIfAbsent(dependency.getId(), __ -> new LinkedHashSet());
            transitiveDependencies.addAll(dependency.getDependencies());
        }
        LinkedHashMap<ExternalDependencyId, Collection<ExternalDependency>> linkedHashMap = dependencyMap;
        if (linkedHashMap == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(114);
        }
        return linkedHashMap;
    }

    @NotNull
    private static Map<LibraryPathType, List<Path>> findAdjacentComponents(@NotNull Path binaryPath, @NotNull Set<LibraryPathType> requestedComponents) {
        if (binaryPath == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(115);
        }
        if (requestedComponents == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(116);
        }
        Path parent = binaryPath.getParent();
        Path cachedArtifactRoot = parent.getParent();
        Map<LibraryPathType, List<Path>> map = GradleLocalCacheHelper.findAdjacentComponents(cachedArtifactRoot, requestedComponents);
        if (map == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(117);
        }
        return map;
    }

    public static boolean isTestSourceSet(@NotNull ExternalSourceSet sourceSet) {
        if (sourceSet == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(118);
        }
        if (sourceSet.getSources().isEmpty()) {
            return false;
        }
        return sourceSet.getSources().keySet().stream().allMatch(IExternalSystemSourceType::isTest);
    }

    private static Collection<File> collectProcessedArtifacts(Collection<ProjectDependencyInfo> infos) {
        return infos.stream().flatMap(info -> info.dependencyArtifacts.stream()).collect(Collectors.toSet());
    }

    private static boolean doesNotContainDependencyOn(Collection<ProjectDependencyInfo> infos, GradleSourceSetData data) {
        return infos.stream().noneMatch(info -> info.myModuleData.equals((Object)data));
    }

    public static boolean linkProjectLibrary(@Nullable DataNode<ProjectData> ideProject, @NotNull LibraryData library) {
        if (library == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(119);
        }
        if (ideProject == null) {
            return false;
        }
        HashMap<String, DataNode> cache2 = (HashMap<String, DataNode>)ideProject.getUserData(LIBRARIES_BY_NAME_CACHE);
        if (cache2 == null) {
            cache2 = new HashMap<String, DataNode>();
            ideProject.putUserData(LIBRARIES_BY_NAME_CACHE, cache2);
        }
        String libraryName = library.getExternalName();
        DataNode libraryData = cache2.computeIfAbsent(libraryName, name -> {
            DataNode newValueToCache = ExternalSystemApiUtil.find((DataNode)ideProject, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY, node -> libraryName.equals(((LibraryData)node.getData()).getExternalName()));
            if (newValueToCache == null) {
                newValueToCache = ideProject.createChild(ProjectKeys.LIBRARY, (Object)library);
            }
            return newValueToCache;
        });
        return ((LibraryData)libraryData.getData()).equals((Object)library);
    }

    public static boolean isIdeaTask(String taskName, @Nullable String group) {
        if ((group == null || "ide".equalsIgnoreCase(group)) && StringUtil.containsIgnoreCase((String)taskName, (String)"idea")) {
            return true;
        }
        return "other".equalsIgnoreCase(group) && StringUtil.containsIgnoreCase((String)taskName, (String)"idea");
    }

    @Nullable
    public static DataNode<ModuleData> findModule(@Nullable DataNode<ProjectData> projectNode, @NotNull String modulePath) {
        if (modulePath == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(120);
        }
        if (projectNode == null) {
            return null;
        }
        return ExternalSystemApiUtil.find(projectNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.MODULE, node -> ((ModuleData)node.getData()).getLinkedExternalProjectPath().equals(modulePath));
    }

    @Nullable
    public static DataNode<ModuleData> findModuleById(@Nullable DataNode<ProjectData> projectNode, @NotNull String path) {
        if (path == null) {
            GradleProjectResolverUtil.$$$reportNull$$$0(121);
        }
        if (projectNode == null) {
            return null;
        }
        return ExternalSystemApiUtil.find(projectNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.MODULE, node -> ((ModuleData)node.getData()).getId().equals(path));
    }

    @ApiStatus.Internal
    public static Stream<GradleProjectResolverExtension> createProjectResolvers(@Nullable ProjectResolverContext projectResolverContext) {
        return GradleProjectResolverExtension.EP_NAME.getExtensionList().stream().map(extension -> {
            try {
                Constructor<?> constructor = extension.getClass().getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                GradleProjectResolverExtension resolverExtension = (GradleProjectResolverExtension)constructor.newInstance(new Object[0]);
                if (projectResolverContext != null) {
                    resolverExtension.setProjectResolverContext(projectResolverContext);
                }
                return resolverExtension;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return null;
            }
        }).sorted(ExternalSystemApiUtil.ORDER_AWARE_COMPARATOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8, 14, 23, 27, 33, 34, 36, 39, 43, 44, 52, 56, 59, 61, 62, 63, 66, 68, 71, 73, 74, 75, 76, 85, 104, 112, 114, 117 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverCtx";
                break;
            }
            case 1: 
            case 17: 
            case 20: 
            case 41: 
            case 46: 
            case 48: 
            case 51: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 14: 
            case 23: 
            case 27: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 43: 
            case 44: 
            case 52: 
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 85: 
            case 104: 
            case 112: 
            case 114: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil";
                break;
            }
            case 5: 
            case 18: 
            case 21: 
            case 26: 
            case 31: 
            case 54: 
            case 58: 
            case 60: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProject";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProjectName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 12: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: 
            case 28: 
            case 45: 
            case 47: 
            case 50: 
            case 53: 
            case 57: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 25: 
            case 30: 
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModel";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetName";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNameElement";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProjectPath";
                break;
            }
            case 49: 
            case 55: 
            case 65: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSet";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDependency";
                break;
            }
            case 78: 
            case 80: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleHomeDir";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collected";
                break;
            }
            case 86: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collect";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryData";
                break;
            }
            case 90: 
            case 95: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetMap";
                break;
            }
            case 91: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactsMap";
                break;
            }
            case 92: 
            case 98: 
            case 101: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerDataNode";
                break;
            }
            case 93: 
            case 99: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedDependencyMap";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactMap";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedComponents";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainModule";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentityPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProject";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalModuleName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getHolderModuleName";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSourceSetModuleName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeModuleNameElement";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "gradlePathToQualifiedName";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleConfigPath";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProject";
                break;
            }
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleId";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyScope";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedDependencyScope";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredComponentTypes";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryDependencyData";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnerModule";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "groupTransitiveDependenciesById";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "findAdjacentComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createMainModule";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 14: 
            case 23: 
            case 27: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 43: 
            case 44: 
            case 52: 
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 85: 
            case 104: 
            case 112: 
            case 114: 
            case 117: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIdentityPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBuildSrcPrefix";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "patchBuildSrcIdentity";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRootProject";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isIncludedBuildTaskRunningSupported";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getInternalModuleName";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getHolderModuleName";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveSourceSetModuleName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "escapeModuleNameElement";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "gradlePathToQualifiedName";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getModuleConfigPath";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 64: 
            case 65: 
            case 67: 
            case 69: 
            case 70: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getModuleId";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProject";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "attachGradleSdkSources";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "mergeCollectedArtifacts";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "collectSourcesAndJavadocsFromTheSameFolder";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryCoordinates";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "buildDependencies";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "doBuildDependencies";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "createDependencyDataNode";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "reportUnresolvedDependencyError";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getOwnerModule";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "groupTransitiveDependenciesById";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "findAdjacentComponents";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "isTestSourceSet";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "linkProjectLibrary";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "findModuleById";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8, 14, 23, 27, 33, 34, 36, 39, 43, 44, 52, 56, 59, 61, 62, 63, 66, 68, 71, 73, 74, 75, 76, 85, 104, 112, 114, 117 -> new IllegalStateException(string);
        };
    }

    static class ProjectDependencyInfo {
        @NotNull
        final ModuleData myModuleData;
        @Nullable
        final ExternalSourceSet mySourceSet;
        final Collection<File> dependencyArtifacts;

        ProjectDependencyInfo(@NotNull ModuleData moduleData, @Nullable ExternalSourceSet sourceSet, Collection<File> dependencyArtifacts) {
            if (moduleData == null) {
                ProjectDependencyInfo.$$$reportNull$$$0(0);
            }
            this.myModuleData = moduleData;
            this.mySourceSet = sourceSet;
            this.dependencyArtifacts = dependencyArtifacts;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil$ProjectDependencyInfo", "<init>"));
        }
    }
}

