/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.Vibration;

public class FSGOutputReader
extends AtomSetCollectionReader {
    private String[] elementSymbols;

    @Override
    protected void initializeReader() throws Exception {
        super.initializeReader();
        String symbols = this.getFilterWithCase("elements=");
        if (symbols != null) {
            this.elementSymbols = PT.split(symbols.replace(',', ' '), " ");
        }
        SB sb = new SB();
        try {
            while (this.rd() != null) {
                sb.append(this.line);
            }
            this.processJSON(this.vwr.parseJSONMap(sb.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.continuing = false;
    }

    private void setElementsFromFileName(String fname) {
        int i;
        if (fname == null) {
            return;
        }
        int pt = fname.lastIndexOf(".");
        if (pt >= 0) {
            fname = fname.substring(0, pt);
        }
        fname = fname.substring(fname.lastIndexOf("/") + 1);
        fname = fname.substring(fname.lastIndexOf("\\") + 1);
        int i2 = fname.length();
        while (--i2 >= 1) {
            if (fname.charAt(i2) > 'a') continue;
            fname = fname.substring(0, i2) + " " + fname.substring(i2);
        }
        Lst<String> list = new Lst<String>();
        String[] tokens = PT.split(PT.rep(PT.replaceAllCharacters(fname, "0123456789-._", " "), "  ", " "), " ");
        int nt = 0;
        block5: for (i = 0; i < tokens.length; ++i) {
            String e = tokens[i];
            switch (e.length()) {
                case 2: {
                    if (e.charAt(1) < 'a') continue block5;
                }
                case 1: {
                    int n;
                    if (e.charAt(0) < 'A' || (n = JmolAdapter.getElementNumber(e)) <= 0) continue block5;
                    list.addLast(e);
                    ++nt;
                }
            }
        }
        if (nt > 0) {
            this.elementSymbols = new String[nt];
            i = nt;
            while (--i >= 0) {
                this.elementSymbols[i] = (String)list.get(i);
            }
        }
    }

    private void processJSON(Map<String, Object> json) {
        this.getHeaderInfo(json);
        Lst<Object> info = FSGOutputReader.getList(json, "G0_std_Cell");
        this.getCellInfo(this.getListItem(info, 0));
        this.readAllOperators(FSGOutputReader.getList(json, "G0_std_operations"));
        this.readAtomsAndMoments(info);
    }

    private Lst<Object> getListItem(Lst<Object> info, int i) {
        return (Lst)info.get(i);
    }

    private static Lst<Object> getList(Map<String, Object> json, String key) {
        return (Lst)json.get(key);
    }

    private void getHeaderInfo(Map<String, Object> json) {
        this.setSpaceGroupName((String)json.get("FPG_symbol"));
        this.appendUnitCellInfo("SSG_international_symbol=" + json.get("SSG_international_symbol"));
    }

    private void getCellInfo(Lst<Object> list) {
        this.setFractionalCoordinates(true);
        for (int i = 0; i < 3; ++i) {
            P3 v = FSGOutputReader.getPoint(this.getListItem(list, i));
            this.addExplicitLatticeVector(i, new float[]{v.x, v.y, v.z}, 0);
        }
    }

    private static P3 getPoint(Lst<Object> item) {
        return P3.new3(FSGOutputReader.getValue(item, 0), FSGOutputReader.getValue(item, 1), FSGOutputReader.getValue(item, 2));
    }

    private static float getValue(Lst<Object> item, int i) {
        return ((Number)item.get(i)).floatValue();
    }

    private void readAllOperators(Lst<Object> info) {
        int n = info.size();
        for (int i = 0; i < n; ++i) {
            Lst op = (Lst)info.get(i);
            M4 mspin = this.readMatrix(this.getListItem(op, 0), null);
            M4 mop = this.readMatrix(this.getListItem(op, 1), this.getListItem(op, 2));
            String s = SymmetryOperation.getXYZFromMatrixFrac(mop, false, false, false, true, true, "xyz") + SymmetryOperation.getSpinString(mspin, true);
            System.out.println("FSGOutput op[" + (i + 1) + "]=" + s);
            this.setSymmetryOperator(s);
        }
    }

    private M4 readMatrix(Lst<Object> rot, Lst<Object> trans) {
        M3 r = new M3();
        for (int i = 0; i < 3; ++i) {
            r.setRowV(i, FSGOutputReader.getPoint(this.getListItem(rot, i)));
        }
        P3 t = trans == null ? new P3() : FSGOutputReader.getPoint(trans);
        return M4.newMV(r, t);
    }

    private void readAtomsAndMoments(Lst<Object> info) {
        Lst<Object> atoms = this.getListItem(info, 1);
        Lst<Object> ids = this.getListItem(info, 2);
        Lst<Object> moments = this.getListItem(info, 3);
        int n = atoms.size();
        for (int i = 0; i < n; ++i) {
            P3 xyz = FSGOutputReader.getPoint(this.getListItem(atoms, i));
            int id = (int)FSGOutputReader.getValue(ids, i);
            P3 moment = FSGOutputReader.getPoint(this.getListItem(moments, i));
            Atom a = this.asc.addNewAtom();
            a.setT(xyz);
            this.setAtomCoord(a);
            if (this.elementSymbols != null && id <= this.elementSymbols.length) {
                a.elementSymbol = this.elementSymbols[id - 1];
            } else {
                a.elementNumber = (short)(id + 2);
            }
            Vibration v = new Vibration().setType(-2);
            v.set(moment.x, moment.y, moment.z);
            v.magMoment = v.length();
            if (v.magMoment > 0.0f) {
                System.out.println("FGSOutput moment " + i + " " + v.magMoment + " " + v);
            }
            a.vib = v;
        }
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.asc.setNoAutoBond();
        this.applySymmetryAndSetTrajectory();
        this.addJmolScript("vectors on;vectors 0.15;");
    }
}

