/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.UnifiedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.SkimpyOffsetMap;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\r\u0015e\u0001\u0002)R\u0001YC\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\tq\u0002\u0011)\u0019!C\u0001s\"I\u0011\u0011\u0003\u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\u000b\u0003'\u0001!Q1A\u0005\u0002\u0005U\u0001BCA\u0019\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u00111\u0007\u0001\u0003\u0006\u0004%\t!!\u000e\t\u0015\u0005u\u0002A!A!\u0002\u0013\t9\u0004\u0003\u0006\u0002@\u0001\u0011\t\u0011)A\u0005\u0003\u0003Bq!a\u0013\u0001\t\u0003\ti\u0005\u0003\u0006\u0002\\\u0001\u0011\r\u0011\"\u0001R\u0003;B\u0001\"!\u001c\u0001A\u0003%\u0011q\f\u0005\n\u0003_\u0002\u0001\u0019!C\u0005\u0003cB\u0011\"a\u001d\u0001\u0001\u0004%I!!\u001e\t\u000f\u0005\u0005\u0005\u0001)Q\u0005U\"Q\u00111\u0012\u0001C\u0002\u0013\u0005\u0011+!$\t\u0011\u0005U\u0005\u0001)A\u0005\u0003\u001fC!\"a&\u0001\u0005\u0004%\t!UAM\u0011!\t)\u000b\u0001Q\u0001\n\u0005m\u0005BCAT\u0001\t\u0007I\u0011A)\u0002*\"A!\u0011\u0010\u0001!\u0002\u0013\tY\u000b\u0003\u0005\u0003|\u0001!\t!\u0015B?\u0011!\u0011y\t\u0001C\u0001#\nE\u0005b\u0002BJ\u0001\u0011\u0005!q\u0006\u0005\t\u0005+\u0003\u0001\u0015\"\u0003\u00030!9!q\u0013\u0001\u0005\u0002\t=\u0002b\u0002BM\u0001\u0011\u0005!q\u0006\u0005\b\u00057\u0003A\u0011\tBO\u0011\u001d\u0011)\u000b\u0001C!\u0005OCqAa-\u0001\t\u0003\u0012)\fC\u0004\u0003>\u0002!\tAa0\t\u000f\t\r\u0007\u0001\"\u0001\u0003F\"I!Q\u001b\u0001\u0012\u0002\u0013\u0005!q\u001b\u0005\b\u0005[\u0004A\u0011\u0001Bx\u0011\u001d\u0011Y\u0010\u0001C\u0001\u0005{Dqaa\u0001\u0001\t\u0003\u0019)\u0001C\u0004\u0004\u0010\u0001!\ta!\u0005\t\u000f\rU\u0001\u0001\"\u0001\u0004\u0018!911\u0005\u0001\u0005\u0002\r\u0015\u0002\"CB\u0018\u0001E\u0005I\u0011AB\u0019\u0011\u001d\u0019)\u0004\u0001C\u0001\u0007oA\u0001b!\u0011\u0001\t\u0003\u0019\u0016\u0011\u000f\u0005\t\u0007\u0007\u0002A\u0011A)\u0003\u0012\u001a9\u00111\u0018\u0001\u0001#\u0006u\u0006BCAfW\t\u0005\t\u0015!\u0003\u0002N\"9\u00111J\u0016\u0005\u0002\u0005M\u0007bBAlW\u0011E\u0013\u0011\u001c\u0005\n\u0003c\\#\u0019!C\u0001\u0003gD\u0001\"a?,A\u0003%\u0011Q\u001f\u0005\n\u0003{\\\u0003\u0019!C\u0001\u0003\u007fD\u0011Ba\u0002,\u0001\u0004%\tA!\u0003\t\u0011\t51\u0006)Q\u0005\u0005\u0003A\u0011B!\u0005,\u0001\u0004%\tAa\u0005\t\u0013\tm1\u00061A\u0005\u0002\tu\u0001\u0002\u0003B\u0011W\u0001\u0006KA!\u0006\t\u000f\t\u00152\u0006\"\u0003\u0003(!9!QF\u0016\u0005B\t=\u0002b\u0002B\u0019W\u0011%!1\u0007\u0005\b\u0005wYC\u0011\u0002B\u001a\u0011\u001d\u0011ie\u000bC\u0005\u0005\u001fBqAa\u0017,\t\u0013\u0011ifB\u0004\u0004FEC\taa\u0012\u0007\rA\u000b\u0006\u0012AB%\u0011\u001d\tYE\u0010C\u0001\u0007\u0017B\u0011b!\u0014?\u0005\u0004%\tA!(\t\u0011\r=c\b)A\u0005\u0005?Cqa!\u0015?\t\u0003\u0019\u0019\u0006C\u0005\u0004Xy\u0012\r\u0011\"\u0003\u0004Z!A1Q\r !\u0002\u0013\u0019Y\u0006C\u0005\u0004hy\u0012\r\u0011\"\u0003\u0004Z!A1\u0011\u000e !\u0002\u0013\u0019Y\u0006C\u0005\u0004ly\u0012\r\u0011\"\u0003\u0004Z!A1Q\u000e !\u0002\u0013\u0019Y\u0006C\u0005\u0004py\u0012\r\u0011\"\u0003\u0004Z!A1\u0011\u000f !\u0002\u0013\u0019Y\u0006C\u0005\u0004ty\u0012\r\u0011\"\u0003\u0004Z!A1Q\u000f !\u0002\u0013\u0019Y\u0006\u0003\u0006\u0004xy\u0012\r\u0011\"\u0001R\u0007sB\u0001b! ?A\u0003%11\u0010\u0005\n\u0007\u007fr\u0014\u0013!C\u0001\u0007\u0003\u0013!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u00116+A\u0002m_\u001eT\u0011\u0001V\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001q+X2\u0011\u0005a[V\"A-\u000b\u0003i\u000bQa]2bY\u0006L!\u0001X-\u0003\r\u0005s\u0017PU3g!\tq\u0016-D\u0001`\u0015\t\u00017+A\u0003vi&d7/\u0003\u0002c?\n9Aj\\4hS:<\u0007C\u00013h\u001b\u0005)'B\u00014T\u0003\u0019\u0019XM\u001d<fe&\u0011\u0001.\u001a\u0002\u0015\u0005J|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0002\u001b%t\u0017\u000e^5bY\u000e{gNZ5h!\tYg/D\u0001m\u0015\t\u0011VN\u0003\u0002o_\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003aF\fqa\u001d;pe\u0006<WM\u0003\u0002Ue*\u00111\u000f^\u0001\u0007CB\f7\r[3\u000b\u0003U\f1a\u001c:h\u0013\t9HNA\u0007DY\u0016\fg.\u001a:D_:4\u0017nZ\u0001\bY><G)\u001b:t+\u0005Q\b\u0003B>\u007f\u0003\u0003i\u0011\u0001 \u0006\u0003{f\u000b!bY8mY\u0016\u001cG/[8o\u0013\tyHPA\u0002TKF\u0004B!a\u0001\u0002\u000e5\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0002j_*\u0011\u00111B\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0010\u0005\u0015!\u0001\u0002$jY\u0016\f\u0001\u0002\\8h\t&\u00148\u000fI\u0001\u0005Y><7/\u0006\u0002\u0002\u0018A9a,!\u0007\u0002\u001e\u0005%\u0012bAA\u000e?\n!\u0001k\\8m!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012c\u000611m\\7n_:LA!a\n\u0002\"\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BA\u0016\u0003[i\u0011!U\u0005\u0004\u0003_\t&AC+oS\u001aLW\r\u001a'pO\u0006)An\\4tA\u0005!Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2,\"!a\u000e\u0011\u0007-\fI$C\u0002\u0002<1\u0014A\u0003T8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0017!\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000eI\u0001\u0005i&lW\r\u0005\u0003\u0002D\u0005\u001dSBAA#\u0015\r\u0001\u0017\u0011E\u0005\u0005\u0003\u0013\n)E\u0001\u0003US6,\u0017A\u0002\u001fj]&$h\b\u0006\u0007\u0002P\u0005E\u00131KA+\u0003/\nI\u0006E\u0002\u0002,\u0001AQ![\u0005A\u0002)DQ\u0001_\u0005A\u0002iDq!a\u0005\n\u0001\u0004\t9\u0002C\u0004\u00024%\u0001\r!a\u000e\t\u0013\u0005}\u0012\u0002%AA\u0002\u0005\u0005\u0013\u0001D7fiJL7m]$s_V\u0004XCAA0!\u0011\t\t'!\u001b\u000e\u0005\u0005\r$\u0002BA3\u0003O\nq!\\3ue&\u001c7O\u0003\u0002gc&!\u00111NA2\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u000e[\u0016$(/[2t\u000fJ|W\u000f\u001d\u0011\u0002\r\r|gNZ5h+\u0005Q\u0017AC2p]\u001aLwm\u0018\u0013fcR!\u0011qOA?!\rA\u0016\u0011P\u0005\u0004\u0003wJ&\u0001B+oSRD\u0001\"a \u000e\u0003\u0003\u0005\rA[\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\r\t\u0015\u0004\u001d\u0005\u0015\u0005c\u0001-\u0002\b&\u0019\u0011\u0011R-\u0003\u0011Y|G.\u0019;jY\u0016\fab\u00197fC:,'/T1oC\u001e,'/\u0006\u0002\u0002\u0010B!\u00111FAI\u0013\r\t\u0019*\u0015\u0002\u0012\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\u0018aD2mK\u0006tWM]'b]\u0006<WM\u001d\u0011\u0002\u0013QD'o\u001c;uY\u0016\u0014XCAAN!\u0011\ti*!)\u000e\u0005\u0005}%B\u00011n\u0013\u0011\t\u0019+a(\u0003\u0013QC'o\u001c;uY\u0016\u0014\u0018A\u0003;ie>$H\u000f\\3sA\u0005A1\r\\3b]\u0016\u00148/\u0006\u0002\u0002,B1\u0011QVAZ\u0003ok!!a,\u000b\u0007\u0005EF0A\u0004nkR\f'\r\\3\n\t\u0005U\u0016q\u0016\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0002\u0002:.j\u0011\u0001\u0001\u0002\u000e\u00072,\u0017M\\3s)\"\u0014X-\u00193\u0014\t-\ny,\u0018\t\u0005\u0003\u0003\f9-\u0004\u0002\u0002D*!\u0011QYA4\u0003\u0011)H/\u001b7\n\t\u0005%\u00171\u0019\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG-\u0001\u0005uQJ,\u0017\rZ%e!\rA\u0016qZ\u0005\u0004\u0003#L&aA%oiR!\u0011qWAk\u0011\u001d\tY-\fa\u0001\u0003\u001b\f!\u0002\\8hO\u0016\u0014h*Y7f+\t\tY\u000e\u0005\u0003\u0002^\u0006-h\u0002BAp\u0003O\u00042!!9Z\u001b\t\t\u0019OC\u0002\u0002fV\u000ba\u0001\u0010:p_Rt\u0014bAAu3\u00061\u0001K]3eK\u001aLA!!<\u0002p\n11\u000b\u001e:j]\u001eT1!!;Z\u0003\u001d\u0019G.Z1oKJ,\"!!>\u0011\t\u0005-\u0012q_\u0005\u0004\u0003s\f&aB\"mK\u0006tWM]\u0001\tG2,\u0017M\\3sA\u0005IA.Y:u'R\fGo]\u000b\u0003\u0005\u0003\u0001B!a\u000b\u0003\u0004%\u0019!QA)\u0003\u0019\rcW-\u00198feN#\u0018\r^:\u0002\u001b1\f7\u000f^*uCR\u001cx\fJ3r)\u0011\t9Ha\u0003\t\u0013\u0005}$'!AA\u0002\t\u0005\u0011A\u00037bgR\u001cF/\u0019;tA!\u001a1'!\"\u0002#1\f7\u000f\u001e)sK\u000ecW-\u00198Ti\u0006$8/\u0006\u0002\u0003\u0016A!\u00111\u0006B\f\u0013\r\u0011I\"\u0015\u0002\u000e!J,7\t\\3b]N#\u0018\r^:\u0002+1\f7\u000f\u001e)sK\u000ecW-\u00198Ti\u0006$8o\u0018\u0013fcR!\u0011q\u000fB\u0010\u0011%\ty(NA\u0001\u0002\u0004\u0011)\"\u0001\nmCN$\bK]3DY\u0016\fgn\u0015;biN\u0004\u0003f\u0001\u001c\u0002\u0006\u0006I1\r[3dW\u0012{g.\u001a\u000b\u0005\u0003o\u0012I\u0003C\u0004\u0003,]\u0002\r!!\b\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\u00061Am\\,pe.$\"!a\u001e\u0002)Q\u0014\u0018p\u00117fC:4\u0015\u000e\u001c;iS\u0016\u001cH\u000fT8h)\t\u0011)\u0004E\u0002Y\u0005oI1A!\u000fZ\u0005\u001d\u0011un\u001c7fC:\f\u0011c\u00197fC:4\u0015\u000e\u001c;iS\u0016\u001cH\u000fT8hQ\u0015Q$q\bB&!\u0015A&\u0011\tB#\u0013\r\u0011\u0019%\u0017\u0002\u0007i\"\u0014xn^:\u0011\t\u0005-\"qI\u0005\u0004\u0005\u0013\n&\u0001\u0006'pO\u000ecW-\u00198j]\u001e,\u0005pY3qi&|gn\t\u0002\u0003F\u0005A1\r\\3b]2{w\r\u0006\u0003\u0002x\tE\u0003b\u0002B*w\u0001\u0007!QK\u0001\nG2,\u0017M\\1cY\u0016\u0004B!a\u000b\u0003X%\u0019!\u0011L)\u0003\u00151{w\rV8DY\u0016\fg.A\u0006sK\u000e|'\u000fZ*uCR\u001cH\u0003DA<\u0005?\u0012\u0019Ga\u001a\u0003r\tU\u0004b\u0002B1y\u0001\u0007\u0011QZ\u0001\u0003S\u0012DqA!\u001a=\u0001\u0004\tY.\u0001\u0003oC6,\u0007b\u0002B5y\u0001\u0007!1N\u0001\u0005MJ|W\u000eE\u0002Y\u0005[J1Aa\u001cZ\u0005\u0011auN\\4\t\u000f\tMD\b1\u0001\u0003l\u0005\u0011Ao\u001c\u0005\b\u0005ob\u0004\u0019\u0001B\u0001\u0003\u0015\u0019H/\u0019;t\u0003%\u0019G.Z1oKJ\u001c\b%A\u000bnCb|e/\u001a:DY\u0016\fg.\u001a:UQJ,\u0017\rZ:\u0015\t\u00055'q\u0010\u0005\b\u0005\u0003+\u0002\u0019\u0001BB\u0003\u00051\u0007c\u0002-\u0003\u0006\u0006]&\u0011R\u0005\u0004\u0005\u000fK&!\u0003$v]\u000e$\u0018n\u001c82!\rA&1R\u0005\u0004\u0005\u001bK&A\u0002#pk\ndW-A\beK\u0006$G\u000b\u001b:fC\u0012\u001cu.\u001e8u+\t\ti-A\u0004ti\u0006\u0014H/\u001e9\u0002!MDW\u000f\u001e3po:\u001cE.Z1oKJ\u001c\u0018\u0001C:ikR$wn\u001e8\u0002\u001bI,Wn\u001c<f\u001b\u0016$(/[2t\u0003U\u0011XmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON,\"Aa(\u0011\u000bm\u0014\t+a7\n\u0007\t\rFPA\u0002TKR\fqC^1mS\u0012\fG/\u001a*fG>tg-[4ve\u0006$\u0018n\u001c8\u0015\t\u0005]$\u0011\u0016\u0005\b\u0005Wc\u0002\u0019\u0001BW\u0003%qWm^\"p]\u001aLw\rE\u0002e\u0005_K1A!-f\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u000b\u0007\u0003o\u00129La/\t\u000f\teV\u00041\u0001\u0003.\u0006Iq\u000e\u001c3D_:4\u0017n\u001a\u0005\b\u0005Wk\u0002\u0019\u0001BW\u00035\t'm\u001c:u\u00072,\u0017M\\5oOR!\u0011q\u000fBa\u0011\u001d\u0011YC\ba\u0001\u0003;\t\u0011#\u001e9eCR,7\t[3dWB|\u0017N\u001c;t)\u0019\t9Ha2\u0003L\"9!\u0011Z\u0010A\u0002\u0005\u0005\u0011a\u00023bi\u0006$\u0015N\u001d\u0005\n\u0005\u001b|\u0002\u0013!a\u0001\u0005\u001f\f\u0011\u0003]1si&$\u0018n\u001c8U_J+Wn\u001c<f!\u0015A&\u0011[A\u000f\u0013\r\u0011\u0019.\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u00027U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IN\u000b\u0003\u0003P\nm7F\u0001Bo!\u0011\u0011yN!;\u000e\u0005\t\u0005(\u0002\u0002Br\u0005K\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u001d\u0018,\u0001\u0006b]:|G/\u0019;j_:LAAa;\u0003b\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%\u0005dG/\u001a:DQ\u0016\u001c7\u000e]8j]R$\u0015N\u001d\u000b\t\u0003o\u0012\tPa=\u0003x\"9!1F\u0011A\u0002\u0005u\u0001b\u0002B{C\u0001\u0007\u0011\u0011A\u0001\rg>,(oY3M_\u001e$\u0015N\u001d\u0005\b\u0005s\f\u0003\u0019AA\u0001\u0003)!Wm\u001d;M_\u001e$\u0015N]\u0001\u0014Q\u0006tG\r\\3M_\u001e$\u0015N\u001d$bS2,(/\u001a\u000b\u0005\u0003o\u0012y\u0010C\u0004\u0004\u0002\t\u0002\r!a7\u0002\u0007\u0011L'/A\fnCf\u0014W\r\u0016:v]\u000e\fG/Z\"iK\u000e\\\u0007o\\5oiRA\u0011qOB\u0004\u0007\u0013\u0019Y\u0001C\u0004\u0003J\u000e\u0002\r!!\u0001\t\u000f\t-2\u00051\u0001\u0002\u001e!91QB\u0012A\u0002\t-\u0014AB8gMN,G/A\u000bbE>\u0014H/\u00118e!\u0006,8/Z\"mK\u0006t\u0017N\\4\u0015\t\u0005]41\u0003\u0005\b\u0005W!\u0003\u0019AA\u000f\u00039\u0011Xm];nK\u000ecW-\u00198j]\u001e$B!a\u001e\u0004\u001a!911D\u0013A\u0002\ru\u0011a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\u000bm\u001cy\"!\b\n\u0007\r\u0005BP\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u00031\tw/Y5u\u00072,\u0017M\\3e)!\u0011)da\n\u0004*\r-\u0002b\u0002B\u0016M\u0001\u0007\u0011Q\u0004\u0005\b\u0007\u001b1\u0003\u0019\u0001B6\u0011%\u0019iC\nI\u0001\u0002\u0004\u0011Y'A\u0005nCb<\u0016-\u001b;Ng\u00061\u0012m^1ji\u000ecW-\u00198fI\u0012\"WMZ1vYR$3'\u0006\u0002\u00044)\"!1\u000eBn\u0003\u0019\u0002\u0018-^:f\u00072,\u0017M\\5oO\u001a{'OT8o\u0007>l\u0007/Y2uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003\u0007s\u0001Ra_B\u0010\u0007w\u0001r\u0001WB\u001f\u0003;\tI#C\u0002\u0004@e\u0013a\u0001V;qY\u0016\u0014\u0014!D2veJ,g\u000e^\"p]\u001aLw-\u0001\u0007dY\u0016\fg.\u001a:D_VtG/\u0001\u0006M_\u001e\u001cE.Z1oKJ\u00042!a\u000b?'\tqt\u000b\u0006\u0002\u0004H\u0005)\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\u0018A\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm\u001d\u0011\u0002\u001b\rdW-\u00198fe\u000e{gNZ5h)\rQ7Q\u000b\u0005\b\u0003_\u0012\u0005\u0019\u0001BW\u0003\u0015j\u0015\r\u001f\"vM\u001a,'/\u0016;jY&T\u0018\r^5p]B+'oY3oi6+GO]5d\u001d\u0006lW-\u0006\u0002\u0004\\A!1QLB2\u001b\t\u0019yF\u0003\u0003\u0004b\u0005%\u0011\u0001\u00027b]\u001eLA!!<\u0004`\u00051S*\u0019=Ck\u001a4WM]+uS2L'0\u0019;j_:\u0004VM]2f]RlU\r\u001e:jG:\u000bW.\u001a\u0011\u0002=\rcW-\u00198feJ+7m\u001c9z!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,\u0017aH\"mK\u0006tWM\u001d*fG>\u0004\u0018\u0010U3sG\u0016tG/T3ue&\u001cg*Y7fA\u00051R*\u0019=DY\u0016\fg\u000eV5nK6+GO]5d\u001d\u0006lW-A\fNCb\u001cE.Z1o)&lW-T3ue&\u001cg*Y7fA\u0005iR*\u0019=D_6\u0004\u0018m\u0019;j_:$U\r\\1z\u001b\u0016$(/[2t\u001d\u0006lW-\u0001\u0010NCb\u001cu.\u001c9bGRLwN\u001c#fY\u0006LX*\u001a;sS\u000e\u001ch*Y7fA\u0005IB)Z1e)\"\u0014X-\u00193D_VtG/T3ue&\u001cg*Y7f\u0003i!U-\u00193UQJ,\u0017\rZ\"pk:$X*\u001a;sS\u000et\u0015-\\3!\u0003-iU\r\u001e:jG:\u000bW.Z:\u0016\u0005\rm\u0004#B>\u0003\"\u000em\u0013\u0001D'fiJL7MT1nKN\u0004\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0004\u0004*\"\u0011\u0011\tBn\u0001")
public class LogCleaner
implements Logging,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, UnifiedLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private final KafkaMetricsGroup metricsGroup;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return Time.SYSTEM;
    }

    public static CleanerConfig cleanerConfig(KafkaConfig config) {
        return LogCleaner$.MODULE$.cleanerConfig(config);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, UnifiedLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    public int maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return (int)BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)this.cleaners().map(f)).maxOption((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
    }

    private void shutdownCleaners() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down the log cleaner.");
        this.cleaners().foreach((Function1 & Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        this.cleaners().clear();
    }

    public void shutdown() {
        try {
            this.shutdownCleaners();
        }
        finally {
            this.removeMetrics();
        }
    }

    public void removeMetrics() {
        LogCleaner$.MODULE$.MetricNames().foreach((Function1 & Serializable)x$1 -> {
            LogCleaner.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.cleanerManager().removeMetrics();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig((KafkaConfig)newConfig).numThreads;
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads;
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException("Log cleaner threads cannot be reduced to less than half the current value " + currentThreads);
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException("Log cleaner threads cannot be increased to more than double the current value " + currentThreads);
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        double maxIoBytesPerSecond = this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond;
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToDouble((double)maxIoBytesPerSecond), (Object)oldConfig.logCleanerIoMaxBytesPerSecond())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Updating logCleanerIoMaxBytesPerSecond: " + maxIoBytesPerSecond);
            this.throttler().updateDesiredRatePerSec(maxIoBytesPerSecond);
        }
        this.shutdownCleaners();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Long>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, Predef$.MODULE$.long2Long(offset));
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, UnifiedLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastStats().bufferUtilization();
    }

    public static final /* synthetic */ int $anonfun$new$1(LogCleaner $this) {
        return $this.maxOverCleanerThreads((Function1<CleanerThread, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1))) * 100;
    }

    public static final /* synthetic */ int $anonfun$new$3(LogCleaner $this) {
        ArrayBuffer stats = (ArrayBuffer)$this.cleaners().map((Function1 & Serializable)x$2 -> x$2.lastStats());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$5) {
        return x$5.lastStats().elapsedSecs();
    }

    public static final /* synthetic */ double $anonfun$new$10(CleanerThread x$6) {
        return x$6.lastPreCleanStats().maxCompactionDelayMs();
    }

    public static final /* synthetic */ int $anonfun$new$9(LogCleaner $this) {
        return $this.maxOverCleanerThreads((Function1<CleanerThread, Object>)(Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$10(x$6))) / 1000;
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(LogCleaner $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable)x$9 -> x$9 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond, 300L, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxBufferUtilizationPercentMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$1(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$CleanerRecopyPercentMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$3(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxCleanTimeMetricName(), () -> BoxesRunTime.boxToInteger((int)this.maxOverCleanerThreads((Function1<CleanerThread, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$5)))));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxCompactionDelayMetricsName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$9(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$DeadThreadCountMetricName(), () -> BoxesRunTime.boxToInteger((int)this.deadThreadCount()));
    }

    public class CleanerThread
    extends ShutdownableThread
    implements Logging {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backoffMs, TimeUnit.MILLISECONDS);
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().maintainUncleanablePartitions();
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception thrown when cleaning log " + e.log() + ". Marking its partition (" + e.log().topicPartition() + ") as uncleanable", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> ltc = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(ltc)) {
                bl = false;
            } else if (ltc instanceof Some) {
                LogToClean cleanable = (LogToClean)((Some)ltc).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(ltc);
            }
            boolean cleaned = bl;
            Iterable<Tuple2<TopicPartition, UnifiedLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                deletable.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(x0$1)));
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable)x$10 -> (TopicPartition)x$10._1())));
            }
            return cleaned;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = "Failed to clean up log for " + cleanable.topicPartition() + " in dir " + logDirectory + " due to IOException";
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        private void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / stats.elapsedSecs() / (double)0x100000))})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000 / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000 / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesRead())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesWritten() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesWritten())})) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}));
            this.info((Function0<String>)(Function0 & Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
                return;
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                UnifiedLog log = (UnifiedLog)x0$1._2();
                try {
                    return log.deleteOldSegments();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super("kafka-log-cleaner-thread-" + threadId, false);
            this.logIdent_$eq(this.logPrefix);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, (OffsetMap)new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads, Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize, LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor, LogCleaner.this.throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(Time.SYSTEM);
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

