/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Future;
import kafka.log.LogCleaner$;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.KafkaConfig;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class LogManager$ {
    public static final LogManager$ MODULE$ = new LogManager$();
    private static final String LockFileName = ".lock";
    private static final String RecoveryPointCheckpointFile = "recovery-point-offset-checkpoint";
    private static final String LogStartOffsetCheckpointFile = "log-start-offset-checkpoint";

    public String LockFileName() {
        return LockFileName;
    }

    public boolean waitForAllToComplete(Seq<Future<?>> jobs, Function1<Throwable, BoxedUnit> callback) {
        return jobs.count((Function1 & Serializable)future -> BoxesRunTime.boxToBoolean((boolean)LogManager$.$anonfun$waitForAllToComplete$1(callback, future))) == 0;
    }

    public String RecoveryPointCheckpointFile() {
        return RecoveryPointCheckpointFile;
    }

    public String LogStartOffsetCheckpointFile() {
        return LogStartOffsetCheckpointFile;
    }

    public LogManager apply(KafkaConfig config, Seq<String> initialOfflineDirs, ConfigRepository configRepository, Scheduler kafkaScheduler, Time time, BrokerTopicStats brokerTopicStats, LogDirFailureChannel logDirFailureChannel, boolean keepPartitionMetadataFile) {
        Map<String, Object> defaultProps = config.extractLogConfigMap();
        LogConfig.validateBrokerLogConfigValues(defaultProps, (boolean)config.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
        LogConfig defaultLogConfig = new LogConfig(defaultProps);
        CleanerConfig cleanerConfig = LogCleaner$.MODULE$.cleanerConfig(config);
        return new LogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable)x$30 -> new File((String)x$30).getAbsoluteFile())), (Seq<File>)((Seq)initialOfflineDirs.map((Function1 & Serializable)x$31 -> new File((String)x$31).getAbsoluteFile())), configRepository, defaultLogConfig, cleanerConfig, Predef$.MODULE$.Integer2int(config.numRecoveryThreadsPerDataDir()), Predef$.MODULE$.Long2long(config.logFlushSchedulerIntervalMs()), config.logFlushOffsetCheckpointIntervalMs(), config.logFlushStartOffsetCheckpointIntervalMs(), Predef$.MODULE$.Long2long(config.logCleanupIntervalMs()), config.transactionStateManagerConfig().transactionMaxTimeoutMs(), new ProducerStateManagerConfig(config.transactionLogConfig().producerIdExpirationMs(), config.transactionLogConfig().transactionPartitionVerificationEnable()), config.transactionLogConfig().producerIdExpirationCheckIntervalMs(), kafkaScheduler, brokerTopicStats, logDirFailureChannel, time, keepPartitionMetadataFile, config.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), Predef$.MODULE$.Long2long(config.logInitialTaskDelayMs()));
    }

    public boolean isStrayKraftReplica(int brokerId, TopicsImage newTopicsImage, UnifiedLog log) {
        int partitionId;
        if (log.topicId().isEmpty()) {
            BrokerMetadataPublisher$ info_this = BrokerMetadataPublisher$.MODULE$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = LogManager$.$anonfun$isStrayKraftReplica$1(log);
                Object var11_5 = null;
                info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
            }
            return true;
        }
        Uuid topicId = (Uuid)log.topicId().get();
        Option option = Option$.MODULE$.apply((Object)newTopicsImage.getPartition(topicId, partitionId = log.topicPartition().partition()));
        if (option instanceof Some) {
            PartitionRegistration partition = (PartitionRegistration)((Some)option).value();
            if (!ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Object)BoxesRunTime.boxToInteger((int)brokerId))) {
                BrokerMetadataPublisher$ info_this = BrokerMetadataPublisher$.MODULE$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = LogManager$.$anonfun$isStrayKraftReplica$2(log, partition, brokerId);
                    Object var12_11 = null;
                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                }
                return true;
            }
            return false;
        }
        if (None$.MODULE$.equals(option)) {
            BrokerMetadataPublisher$ info_this = BrokerMetadataPublisher$.MODULE$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = LogManager$.$anonfun$isStrayKraftReplica$3(log, topicId);
                Object var13_13 = null;
                info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
            }
            return true;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$waitForAllToComplete$1(Function1 callback$1, Future future) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> future.get());
        if (try_ instanceof Success) {
            return false;
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            callback$1.apply((Object)e);
            return true;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ String $anonfun$isStrayKraftReplica$1(UnifiedLog log$6) {
        return "The topicId does not exist in " + log$6 + ", treat it as a stray log";
    }

    public static final /* synthetic */ String $anonfun$isStrayKraftReplica$2(UnifiedLog log$6, PartitionRegistration partition$1, int brokerId$2) {
        return "Found stray log dir " + log$6 + ": the current replica assignment " + Predef$.MODULE$.wrapIntArray(partition$1.replicas).mkString("[", ", ", "]") + " does not contain the local brokerId " + brokerId$2 + ".";
    }

    public static final /* synthetic */ String $anonfun$isStrayKraftReplica$3(UnifiedLog log$6, Uuid topicId$4) {
        return "Found stray log dir " + log$6 + ": the topicId " + topicId$4 + " does not exist in the metadata image";
    }

    private LogManager$() {
    }
}

