/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.ForwardingManager$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.coordinator.share.ShareCoordinator;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001\u0002\t\u0012\u0001YA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!I\u0005A!A!\u0002\u0013Q\u0005\"B*\u0001\t\u0003!\u0006bB.\u0001\u0005\u0004%I\u0001\u0018\u0005\u0007a\u0002\u0001\u000b\u0011B/\t\u000bE\u0004A\u0011\t:\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B!9\u0011Q\f\u0001\u0005\n\u0005}\u0003bBA5\u0001\u0011%\u00111\u000e\u0005\b\u0003c\u0002A\u0011BA:\u0011\u001d\t\u0019\t\u0001C\u0005\u0003\u000bCq!a$\u0001\t\u0013\t\tJA\u0010EK\u001a\fW\u000f\u001c;BkR|Gk\u001c9jG\u000e\u0013X-\u0019;j_:l\u0015M\\1hKJT!AE\n\u0002\rM,'O^3s\u0015\u0005!\u0012!B6bM.\f7\u0001A\n\u0005\u0001]i\u0012\u0005\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=}i\u0011!E\u0005\u0003AE\u0011\u0001$Q;u_R{\u0007/[2De\u0016\fG/[8o\u001b\u0006t\u0017mZ3s!\t\u0011S%D\u0001$\u0015\t!3#A\u0003vi&d7/\u0003\u0002'G\t9Aj\\4hS:<\u0017AB2p]\u001aLw\r\u0005\u0002\u001fS%\u0011!&\u0005\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\bdQ\u0006tg.\u001a7NC:\fw-\u001a:\u0011\u000552T\"\u0001\u0018\u000b\u0005=\u0002\u0014AB2p[6|gN\u0003\u0002\u0013c)\u0011AC\r\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014x-\u0003\u00028]\tqbj\u001c3f)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u0001\u0011OJ|W\u000f]\"p_J$\u0017N\\1u_J\u0004\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0005y\n\u0014aC2p_J$\u0017N\\1u_JL!\u0001Q\u001e\u0003!\u001d\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014\u0018A\u0004;y]\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0003\u0007\u001ek\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b1\u0002\u001e:b]N\f7\r^5p]*\u0011ahE\u0005\u0003\u0011\u0012\u0013a\u0003\u0016:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]\u0001\u0011g\"\f'/Z\"p_J$\u0017N\\1u_J\u00042\u0001G&N\u0013\ta\u0015D\u0001\u0004PaRLwN\u001c\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!v\nQa\u001d5be\u0016L!AU(\u0003!MC\u0017M]3D_>\u0014H-\u001b8bi>\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0004V-^C\u0016L\u0017\t\u0003=\u0001AQa\n\u0004A\u0002!BQa\u000b\u0004A\u00021BQ\u0001\u000f\u0004A\u0002eBQ!\u0011\u0004A\u0002\tCQ!\u0013\u0004A\u0002)\u000ba\"\u001b8gY&<\u0007\u000e\u001e+pa&\u001c7/F\u0001^!\rq6-Z\u0007\u0002?*\u0011\u0001-Y\u0001\u0005kRLGNC\u0001c\u0003\u0011Q\u0017M^1\n\u0005\u0011|&aA*fiB\u0011a-\u001c\b\u0003O.\u0004\"\u0001[\r\u000e\u0003%T!A[\u000b\u0002\rq\u0012xn\u001c;?\u0013\ta\u0017$\u0001\u0004Qe\u0016$WMZ\u0005\u0003]>\u0014aa\u0015;sS:<'B\u00017\u001a\u0003=IgN\u001a7jO\"$Hk\u001c9jGN\u0004\u0013\u0001D2sK\u0006$X\rV8qS\u000e\u001cHcB:\u0002\u001c\u0005\r\u0012Q\u0006\t\u0004i^LX\"A;\u000b\u0005YL\u0012AC2pY2,7\r^5p]&\u0011\u00010\u001e\u0002\u0004'\u0016\f\bc\u0001>\u0002\u00169\u001910a\u0004\u000f\u0007q\fIAD\u0002~\u0003\u000fq1A`A\u0003\u001d\ry\u00181\u0001\b\u0004Q\u0006\u0005\u0011\"A\u001b\n\u0005M\"\u0014B\u0001\u000b3\u0013\ty\u0013'\u0003\u0003\u0002\f\u00055\u0011aB7fgN\fw-\u001a\u0006\u0003_EJA!!\u0005\u0002\u0014\u0005!R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a#bi\u0006TA!a\u0003\u0002\u000e%!\u0011qCA\r\u0005UiU\r^1eCR\f'+Z:q_:\u001cX\rV8qS\u000eTA!!\u0005\u0002\u0014!9\u0011QD\u0005A\u0002\u0005}\u0011A\u0002;pa&\u001c7\u000f\u0005\u0003u\u0003C)\u0017B\u00013v\u0011\u001d\t)#\u0003a\u0001\u0003O\tqcY8oiJ|G\u000e\\3s\u001bV$\u0018\r^5p]F+x\u000e^1\u0011\u0007y\tI#C\u0002\u0002,E\u0011qcQ8oiJ|G\u000e\\3s\u001bV$\u0018\r^5p]F+x\u000e^1\t\u000f\u0005=\u0012\u00021\u0001\u00022\u00051R.\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0005\u0003\u0019\u0017\u0006M\u0002\u0003BA\u001b\u0003wi!!a\u000e\u000b\t\u0005e\u0012QB\u0001\te\u0016\fX/Z:ug&!\u0011QHA\u001c\u00059\u0011V-];fgR\u001cuN\u001c;fqR\fac]3oI\u000e\u0013X-\u0019;f)>\u0004\u0018n\u0019*fcV,7\u000f\u001e\u000b\u0006g\u0006\r\u00131\f\u0005\b\u0003\u000bR\u0001\u0019AA$\u0003=\u0019'/Z1uC\ndW\rV8qS\u000e\u001c\bC\u0002;\u0002J\u0015\fi%C\u0002\u0002LU\u00141!T1q!\u0011\ty%!\u0016\u000f\u0007m\f\t&\u0003\u0003\u0002T\u0005M\u0011aF\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$H)\u0019;b\u0013\u0011\t9&!\u0017\u0003\u001d\r\u0013X-\u0019;bE2,Gk\u001c9jG*!\u00111KA\n\u0011\u001d\tyC\u0003a\u0001\u0003c\tQc\u00197fCJLeN\u001a7jO\"$(+Z9vKN$8\u000f\u0006\u0003\u0002b\u0005\u001d\u0004c\u0001\r\u0002d%\u0019\u0011QM\r\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u000bZ\u0001\u0019AA$\u00039\u0019'/Z1uC\ndW\rV8qS\u000e$B!!\u0014\u0002n!1\u0011q\u000e\u0007A\u0002\u0015\fQ\u0001^8qS\u000e\fqdY8om\u0016\u0014H\u000fV8U_BL7mQ8oM&<7i\u001c7mK\u000e$\u0018n\u001c8t)\u0011\t)(a\u001f\u0011\t\u0005=\u0013qO\u0005\u0005\u0003s\nIF\u0001\u0010De\u0016\fG/\u00192mKR{\u0007/[2D_:4\u0017nZ\"pY2,7\r^5p]\"1q%\u0004a\u0001\u0003{\u00022AXA@\u0013\r\t\ti\u0018\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001E5t-\u0006d\u0017\u000e\u001a+pa&\u001cg*Y7f)\u0011\t9)!$\u0011\u0007a\tI)C\u0002\u0002\ff\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002p9\u0001\r!Z\u0001\u0016M&dG/\u001a:De\u0016\fG/\u00192mKR{\u0007/[2t)\u0011\t\u0019*!'\u0011\ra\t)*a\u0012t\u0013\r\t9*\u0007\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005uq\u00021\u0001\u0002 \u0001")
public class DefaultAutoTopicCreationManager
implements AutoTopicCreationManager,
Logging {
    private final KafkaConfig config;
    private final NodeToControllerChannelManager channelManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final Option<ShareCoordinator> shareCoordinator;
    private final java.util.Set<String> inflightTopics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private java.util.Set<String> inflightTopics() {
        return this.inflightTopics;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> createTopics(Set<String> topics, ControllerMutationQuota controllerMutationQuota, Option<RequestContext> metadataRequestContext) {
        void var6_6;
        void var5_5;
        Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> tuple2 = this.filterCreatableTopics(topics);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map creatableTopics = (Map)tuple2._1();
        Seq uncreatableTopicResponses = (Seq)tuple2._2();
        Seq<MetadataResponseData.MetadataResponseTopic> creatableTopicResponses = var5_5.isEmpty() ? (Seq<MetadataResponseData.MetadataResponseTopic>)Seq$.MODULE$.empty() : this.sendCreateTopicRequest((Map<String, CreateTopicsRequestData.CreatableTopic>)var5_5, metadataRequestContext);
        return (Seq)var6_6.$plus$plus(creatableTopicResponses);
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> sendCreateTopicRequest(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, Option<RequestContext> metadataRequestContext) {
        CreateTopicsRequestData.CreatableTopicCollection topicsToCreate = new CreateTopicsRequestData.CreatableTopicCollection(creatableTopics.size());
        topicsToCreate.addAll(CollectionConverters$.MODULE$.IterableHasAsJava(creatableTopics.values()).asJavaCollection());
        CreateTopicsRequest.Builder createTopicsRequest = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTimeoutMs(Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs())).setTopics(topicsToCreate));
        ControllerRequestCompletionHandler requestCompletionHandler = new ControllerRequestCompletionHandler(this, creatableTopics){
            private final /* synthetic */ DefaultAutoTopicCreationManager $outer;
            private final Map creatableTopics$1;

            public void onTimeout() {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation timed out for " + $this.creatableTopics$1.keys() + ".");
            }

            public void onComplete(ClientResponse response) {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                if (response.authenticationException() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation failed for " + $this.creatableTopics$1.keys() + " with authentication exception");
                    return;
                }
                if (response.versionMismatch() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation failed for " + $this.creatableTopics$1.keys() + " with invalid version exception");
                    return;
                }
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation completed for " + $this.creatableTopics$1.keys() + " with response " + response.responseBody() + ".");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.creatableTopics$1 = creatableTopics$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$2(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$3(kafka.server.DefaultAutoTopicCreationManager$$anon$1 org.apache.kafka.clients.ClientResponse ), $anonfun$onTimeout$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 )}, serializedLambda);
            }
        };
        AbstractRequest.Builder request = (AbstractRequest.Builder)metadataRequestContext.map((Function1 & Serializable)context -> {
            short s;
            Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.channelManager.controllerApiVersions()));
            if (None$.MODULE$.equals(option)) {
                s = ApiKeys.CREATE_TOPICS.latestVersion();
            } else if (option instanceof Some) {
                s = ((NodeApiVersions)((Some)option).value()).latestUsableVersion(ApiKeys.CREATE_TOPICS);
            } else {
                throw new MatchError((Object)option);
            }
            short requestVersion = s;
            RequestHeader requestHeader = new RequestHeader(ApiKeys.CREATE_TOPICS, requestVersion, context.clientId(), context.correlationId());
            return ForwardingManager$.MODULE$.buildEnvelopeRequest((RequestContext)context, createTopicsRequest.build(requestVersion).serializeWithHeader(requestHeader));
        }).getOrElse((Function0 & Serializable)() -> createTopicsRequest);
        this.channelManager.sendRequest(request, requestCompletionHandler);
        scala.collection.immutable.Seq creatableTopicResponses = (scala.collection.immutable.Seq)creatableTopics.keySet().toSeq().map((Function1 & Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
        this.info((Function0<String>)(Function0 & Serializable)() -> "Sent auto-creation request for " + creatableTopics.keys() + " to the active controller.");
        return creatableTopicResponses;
    }

    public void kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics) {
        creatableTopics.keySet().foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultAutoTopicCreationManager.$anonfun$clearInflightRequests$1(this, x$1)));
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Cleared inflight topic creation state for " + creatableTopics);
    }

    private CreateTopicsRequestData.CreatableTopic creatableTopic(String topic) {
        switch (topic == null ? 0 : topic.hashCode()) {
            case -970371369: {
                if (!"__consumer_offsets".equals(topic)) break;
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(this.config.groupCoordinatorConfig().offsetsTopicPartitions()).setReplicationFactor(this.config.groupCoordinatorConfig().offsetsTopicReplicationFactor()).setConfigs(this.convertToTopicConfigCollections(this.groupCoordinator.groupMetadataTopicConfigs()));
            }
            case -253293552: {
                if (!"__transaction_state".equals(topic)) break;
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(this.config.transactionLogConfig().transactionTopicPartitions()).setReplicationFactor(this.config.transactionLogConfig().transactionTopicReplicationFactor()).setConfigs(this.convertToTopicConfigCollections(this.txnCoordinator.transactionTopicConfigs()));
            }
            case -81655151: {
                Properties properties;
                if (!"__share_group_state".equals(topic)) break;
                Option<ShareCoordinator> option = this.shareCoordinator;
                if (option instanceof Some) {
                    properties = ((ShareCoordinator)((Some)option).value()).shareGroupStateTopicConfigs();
                } else if (None$.MODULE$.equals(option)) {
                    properties = new Properties();
                } else {
                    throw new MatchError(option);
                }
                Properties props = properties;
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(this.config.shareCoordinatorConfig().shareCoordinatorStateTopicNumPartitions()).setReplicationFactor(this.config.shareCoordinatorConfig().shareCoordinatorStateTopicReplicationFactor()).setConfigs(this.convertToTopicConfigCollections(props));
            }
        }
        return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.numPartitions())).setReplicationFactor((short)this.config.defaultReplicationFactor());
    }

    private CreateTopicsRequestData.CreatableTopicConfigCollection convertToTopicConfigCollections(Properties config) {
        CreateTopicsRequestData.CreatableTopicConfigCollection topicConfigs = new CreateTopicsRequestData.CreatableTopicConfigCollection();
        config.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x0$1, x1$1) -> topicConfigs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopicConfig().setName(x0$1.toString()).setValue(x1$1.toString()))));
        return topicConfigs;
    }

    private boolean isValidTopicName(String topic) {
        try {
            Topic.validate((String)topic);
            return true;
        }
        catch (InvalidTopicException invalidTopicException) {
            return false;
        }
    }

    private Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> filterCreatableTopics(Set<String> topics) {
        scala.collection.mutable.Map creatableTopics = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Buffer uncreatableTopics = (Buffer)Buffer$.MODULE$.empty();
        topics.foreach((Function1 & Serializable)topic -> {
            Some validationError;
            Object object = !this.isValidTopicName((String)topic) ? new Some((Object)Errors.INVALID_TOPIC_EXCEPTION) : (validationError = !this.inflightTopics().add((String)topic) ? new Some((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION) : None$.MODULE$);
            if (validationError instanceof Some) {
                Errors error = (Errors)validationError.value();
                return uncreatableTopics.$plus$eq((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
            }
            if (None$.MODULE$.equals(validationError)) {
                return creatableTopics.put(topic, (Object)this.creatableTopic((String)topic));
            }
            throw new MatchError((Object)validationError);
        });
        return new Tuple2((Object)creatableTopics, (Object)uncreatableTopics);
    }

    public static final /* synthetic */ boolean $anonfun$clearInflightRequests$1(DefaultAutoTopicCreationManager $this, Object x$1) {
        return $this.inflightTopics().remove(x$1);
    }

    public DefaultAutoTopicCreationManager(KafkaConfig config, NodeToControllerChannelManager channelManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, Option<ShareCoordinator> shareCoordinator) {
        this.config = config;
        this.channelManager = channelManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.shareCoordinator = shareCoordinator;
        this.inflightTopics = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

