/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.BrokerDynamicThreadPool;
import kafka.server.BrokerReconfigurable;
import kafka.server.ControllerDynamicThreadPool;
import kafka.server.ControllerServer;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicClientQuotaCallback;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicProducerStateManagerConfig;
import kafka.server.DynamicRemoteLogConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Logging;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.security.PasswordEncoder;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.metrics.ClientMetricsReceiverPlugin;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0011Eq!\u0002-Z\u0011\u0003qf!\u00021Z\u0011\u0003\t\u0007\"\u00025\u0002\t\u0003I\u0007\u0002\u00036\u0002\u0005\u0004%\t!W6\t\rq\f\u0001\u0015!\u0003m\u0011!i\u0018A1A\u0005\u0002es\bbBA\u0003\u0003\u0001\u0006Ia \u0005\t\u0003\u000f\t!\u0019!C\u0001W\"9\u0011\u0011B\u0001!\u0002\u0013a\u0007\u0002CA\u0006\u0003\t\u0007I\u0011\u0002@\t\u000f\u00055\u0011\u0001)A\u0005\u007f\"A\u0011qB\u0001C\u0002\u0013%1\u000eC\u0004\u0002\u0012\u0005\u0001\u000b\u0011\u00027\t\u0011\u0005M\u0011A1A\u0005\nyDq!!\u0006\u0002A\u0003%q\u0010\u0003\u0005\u0002\u0018\u0005\u0011\r\u0011\"\u0003\u007f\u0011\u001d\tI\"\u0001Q\u0001\n}D\u0011\"a\u0007\u0002\u0005\u0004%I!!\b\t\u0011\u0005=\u0012\u0001)A\u0005\u0003?A\u0001\"!\r\u0002\u0005\u0004%Ia\u001b\u0005\b\u0003g\t\u0001\u0015!\u0003m\u0011\u001d\t)$\u0001C\u0001\u0003oAq!a\u0016\u0002\t\u0003\tI\u0006C\u0004\u0002t\u0005!\t!!\u001e\t\u000f\u0005=\u0015\u0001\"\u0003\u0002\u0012\"9\u0011qS\u0001\u0005\n\u0005e\u0005bBAO\u0003\u0011%\u0011q\u0014\u0005\b\u0003G\u000bA\u0011BAS\u0011!\tI+\u0001C\u00013\u0006-\u0006\u0002CAZ\u0003\u0011\u0005\u0011,!.\u0007\u000b\u0001L\u0006!a/\t\u0015\u0005%gD!b\u0001\n\u0013\tY\r\u0003\u0006\u0002Tz\u0011\t\u0011)A\u0005\u0003\u001bDa\u0001\u001b\u0010\u0005\u0002\u0005U\u0007BCAn=\t\u0007I\u0011A-\u0002^\"A\u00111\u001d\u0010!\u0002\u0013\ty\u000e\u0003\u0006\u0002fz\u0011\r\u0011\"\u0001Z\u0003;D\u0001\"a:\u001fA\u0003%\u0011q\u001c\u0005\n\u0003St\"\u0019!C\u0005\u0003WD\u0001\"a<\u001fA\u0003%\u0011Q\u001e\u0005\n\u0003ct\"\u0019!C\u0005\u0003WD\u0001\"a=\u001fA\u0003%\u0011Q\u001e\u0005\u000b\u0003kt\"\u0019!C\u00013\u0006]\b\u0002\u0003B\u000e=\u0001\u0006I!!?\t\u0013\tuaD1A\u0005\n\t}\u0001\u0002\u0003B\u0015=\u0001\u0006IA!\t\t\u0013\t-bD1A\u0005\n\t5\u0002\u0002\u0003B\u001e=\u0001\u0006IAa\f\t\u0017\tub\u00041AA\u0002\u0013%!q\b\u0005\f\u0005+r\u0002\u0019!a\u0001\n\u0013\u00119\u0006C\u0006\u0003^y\u0001\r\u0011!Q!\n\t\u0005\u0003b\u0003B0=\u0001\u0007\t\u0019!C\u0005\u0003\u0017D1B!\u0019\u001f\u0001\u0004\u0005\r\u0011\"\u0003\u0003d!Y!q\r\u0010A\u0002\u0003\u0005\u000b\u0015BAg\u0011%\u0011IG\bb\u0001\n\u0013\u0011Y\u0007\u0003\u0005\u0003\u0000y\u0001\u000b\u0011\u0002B7\u0011!\u0011\tI\bC\u00013\n\r\u0005\u0002\u0003BE=\u0011\u0005\u0011La#\t\u000f\t5e\u0004\"\u0001\u0003\u0010\"9!Q\u0012\u0010\u0005\u0002\tm\u0005b\u0002BT=\u0011\u0005!\u0011\u0016\u0005\b\u0005_sB\u0011\u0001BY\u0011\u001d\u0011)L\bC\u0001\u0005oCqAa/\u001f\t\u0013\u0011i\f\u0003\u0005\u0003Dz!\t!WAf\u0011!\u0011)M\bC\u00013\n\u001d\u0007\u0002\u0003Bg=\u0011\u0005\u0011La2\t\u0011\t=g\u0004\"\u0001Z\u0005\u007fA\u0001B!5\u001f\t\u0003I&1\u001b\u0005\u000b\u0005Ot\u0012\u0013!C\u00013\n%\b\u0002\u0003B\u0000=\u0011\u0005\u0011l!\u0001\t\u0015\r\u001da$%A\u0005\u0002e\u0013I\u000f\u0003\u0005\u0004\ny!\t!WB\u0006\u0011\u001d\u0019\tB\bC\u0005\u0007'A\u0001b!\u0006\u001f\t\u0003I6q\u0003\u0005\t\u0007?qB\u0011A-\u0004\"!91q\u0005\u0010\u0005\n\r%\u0002\u0002CB\u0019=\u0011\u0005\u0011la\r\t\u000f\reb\u0004\"\u0003\u0004<!A1\u0011\t\u0010\u0005\u0002e\u001b\u0019\u0005C\u0004\u0004jy!Iaa\u001b\t\u000f\r]e\u0004\"\u0003\u0004\u001a\"91q\u0014\u0010\u0005\n\r\u0005\u0006bBBS=\u0011%1q\u0015\u0005\n\u0007ks\u0012\u0013!C\u0005\u0005SDqaa.\u001f\t\u0013\u0019I\fC\u0004\u0004Lz!Ia!4\t\u000f\rMh\u0004\"\u0003\u0004v\u0006\u0019B)\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jO*\u0011!lW\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003q\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002`\u00035\t\u0011LA\nEs:\fW.[2Ce>\\WM]\"p]\u001aLwm\u0005\u0002\u0002EB\u00111MZ\u0007\u0002I*\tQ-A\u0003tG\u0006d\u0017-\u0003\u0002hI\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u00010\u0002-\u0011Kh.Y7jGN+7-\u001e:jif\u001cuN\u001c4jON,\u0012\u0001\u001c\t\u0004[J$X\"\u00018\u000b\u0005=\u0004\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0003c\u0012\f!bY8mY\u0016\u001cG/[8o\u0013\t\u0019hNA\u0002TKR\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\t1\fgn\u001a\u0006\u0002s\u0006!!.\u0019<b\u0013\tYhO\u0001\u0004TiJLgnZ\u0001\u0018\tft\u0017-\\5d'\u0016\u001cWO]5us\u000e{gNZ5hg\u0002\n\u0011\u0005R=oC6L7\r\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u00148i\u001c8gS\u001e,\u0012a \t\u0006\u0003\u0003\t\u0019\u0001^\u0007\u0002a&\u00111\u000f]\u0001#\tft\u0017-\\5d!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:D_:4\u0017n\u001a\u0011\u0002#\u0005cG\u000eR=oC6L7mQ8oM&<7/\u0001\nBY2$\u0015P\\1nS\u000e\u001cuN\u001c4jON\u0004\u0013aG\"mkN$XM\u001d'fm\u0016dG*[:uK:,'oQ8oM&<7/\u0001\u000fDYV\u001cH/\u001a:MKZ,G\u000eT5ti\u0016tWM]\"p]\u001aLwm\u001d\u0011\u0002!A+'O\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\u0018!\u0005)fe\n\u0013xn[3s\u0007>tg-[4tA\u0005AB*[:uK:,'/T3dQ\u0006t\u0017n]7D_:4\u0017nZ:\u000231K7\u000f^3oKJlUm\u00195b]&\u001cXnQ8oM&<7\u000fI\u0001\u0016%\u0016dw.\u00193bE2,g)\u001b7f\u0007>tg-[4t\u0003Y\u0011V\r\\8bI\u0006\u0014G.\u001a$jY\u0016\u001cuN\u001c4jON\u0004\u0013a\u0005'jgR,g.\u001a:D_:4\u0017n\u001a*fO\u0016DXCAA\u0010!\u0011\t\t#a\u000b\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t\u0001\"\\1uG\"Lgn\u001a\u0006\u0004\u0003S!\u0017\u0001B;uS2LA!!\f\u0002$\t)!+Z4fq\u0006!B*[:uK:,'oQ8oM&<'+Z4fq\u0002\na\u0003R=oC6L7\rU1tg^|'\u000fZ\"p]\u001aLwm]\u0001\u0018\tft\u0017-\\5d!\u0006\u001c8o^8sI\u000e{gNZ5hg\u0002\n\u0001#[:QCN\u001cxo\u001c:e\u0007>tg-[4\u0015\t\u0005e\u0012q\b\t\u0004G\u0006m\u0012bAA\u001fI\n9!i\\8mK\u0006t\u0007bBA!+\u0001\u0007\u00111I\u0001\u0005]\u0006lW\r\u0005\u0003\u0002F\u0005Mc\u0002BA$\u0003\u001f\u00022!!\u0013e\u001b\t\tYEC\u0002\u0002Nu\u000ba\u0001\u0010:p_Rt\u0014bAA)I\u00061\u0001K]3eK\u001aL1a_A+\u0015\r\t\t\u0006Z\u0001\u0015EJ|7.\u001a:D_:4\u0017nZ*z]>t\u00170\\:\u0015\r\u0005m\u0013QNA8!\u0019\ti&a\u001a\u0002D9!\u0011qLA2\u001d\u0011\tI%!\u0019\n\u0003\u0015L1!!\u001ae\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001b\u0002l\t!A*[:u\u0015\r\t)\u0007\u001a\u0005\b\u0003\u00032\u0002\u0019AA\"\u0011\u001d\t\tH\u0006a\u0001\u0003s\tQ#\\1uG\"d\u0015n\u001d;f]\u0016\u0014xJ^3se&$W-A\bwC2LG-\u0019;f\u0007>tg-[4t)\u0019\t9(! \u0002\fB\u00191-!\u001f\n\u0007\u0005mDM\u0001\u0003V]&$\bbBA@/\u0001\u0007\u0011\u0011Q\u0001\u0006aJ|\u0007o\u001d\t\u0005\u0003\u0007\u000b9)\u0004\u0002\u0002\u0006*\u0019\u0011\u0011\u0006=\n\t\u0005%\u0015Q\u0011\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBAG/\u0001\u0007\u0011\u0011H\u0001\u0010a\u0016\u0014(I]8lKJ\u001cuN\u001c4jO\u0006\u0001\u0002/\u001a:Ce>\\WM]\"p]\u001aLwm\u001d\u000b\u0005\u0003'\u000b)\n\u0005\u0004\u0002\u0002\u0005\r\u00111\t\u0005\b\u0003\u007fB\u0002\u0019AAA\u0003EqwN\u001c#z]\u0006l\u0017nY\"p]\u001aLwm\u001d\u000b\u0005\u0003'\u000bY\nC\u0004\u0002\u0000e\u0001\r!!!\u0002IM,7-\u001e:jif\u001cuN\u001c4jON<\u0016\u000e\u001e5pkRd\u0015n\u001d;f]\u0016\u0014\bK]3gSb$B!a%\u0002\"\"9\u0011q\u0010\u000eA\u0002\u0005\u0005\u0015a\u0005<bY&$\u0017\r^3D_:4\u0017n\u001a+za\u0016\u001cH\u0003BA<\u0003OCq!a \u001c\u0001\u0004\t\t)\u0001\res:\fW.[2D_:4\u0017nZ+qI\u0006$X-T8eKN,\"!!,\u0011\u0011\u0005\r\u0015qVA\"\u0003\u0007JA!!-\u0002\u0006\n\u0019Q*\u00199\u0002-I,7o\u001c7wKZ\u000b'/[1cY\u0016\u001cuN\u001c4jON$B!!!\u00028\"9\u0011\u0011X\u000fA\u0002\u0005\u0005\u0015!\u00049s_B\u001cxJ]5hS:\fGn\u0005\u0003\u001fE\u0006u\u0006\u0003BA`\u0003\u000bl!!!1\u000b\u0007\u0005\r7,A\u0003vi&d7/\u0003\u0003\u0002H\u0006\u0005'a\u0002'pO\u001eLgnZ\u0001\fW\u000647.Y\"p]\u001aLw-\u0006\u0002\u0002NB\u0019q,a4\n\u0007\u0005E\u0017LA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001D6bM.\f7i\u001c8gS\u001e\u0004C\u0003BAl\u00033\u0004\"a\u0018\u0010\t\u000f\u0005%\u0017\u00051\u0001\u0002N\u0006\u00192\u000f^1uS\u000e\u0014%o\\6fe\u000e{gNZ5hgV\u0011\u0011q\u001c\t\u0006[\u0006\u0005H\u000f^\u0005\u0004\u0003cs\u0017\u0001F:uCRL7M\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\b%\u0001\u000bti\u0006$\u0018n\u0019#fM\u0006,H\u000e^\"p]\u001aLwm]\u0001\u0016gR\fG/[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:!\u0003Q!\u0017P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5hgV\u0011\u0011Q\u001e\t\b[\u0006\u0005\u00181IA\"\u0003U!\u0017P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5hg\u0002\nQ\u0003Z=oC6L7\rR3gCVdGoQ8oM&<7/\u0001\fes:\fW.[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:!\u0003=\u0011XmY8oM&<WO]1cY\u0016\u001cXCAA}!\u0019\tYP!\u0001\u0003\u00065\u0011\u0011Q \u0006\u0005\u0003\u007f\f))\u0001\u0006d_:\u001cWO\u001d:f]RLAAa\u0001\u0002~\n!2i\u001c9z\u001f:<&/\u001b;f\u0003J\u0014\u0018-\u001f'jgR\u0004BAa\u0002\u0003\u00185\u0011!\u0011\u0002\u0006\u0005\u0005\u0017\u0011i!\u0001\u0004d_6lwN\u001c\u0006\u00049\n=!\u0002\u0002B\t\u0005'\ta!\u00199bG\",'B\u0001B\u000b\u0003\ry'oZ\u0005\u0005\u00053\u0011IA\u0001\bSK\u000e|gNZ5hkJ\f'\r\\3\u0002!I,7m\u001c8gS\u001e,(/\u00192mKN\u0004\u0013!\u00062s_.,'OU3d_:4\u0017nZ;sC\ndWm]\u000b\u0003\u0005C\u0001b!a?\u0003\u0002\t\r\u0002cA0\u0003&%\u0019!qE-\u0003)\t\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0003Y\u0011'o\\6feJ+7m\u001c8gS\u001e,(/\u00192mKN\u0004\u0013\u0001\u00027pG.,\"Aa\f\u0011\t\tE\"qG\u0007\u0003\u0005gQAA!\u000e\u0002~\u0006)An\\2lg&!!\u0011\bB\u001a\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0017!\u00027pG.\u0004\u0013\u0001G7fiJL7m\u001d*fG\u0016Lg/\u001a:QYV<\u0017N\\(qiV\u0011!\u0011\t\t\u0006G\n\r#qI\u0005\u0004\u0005\u000b\"'AB(qi&|g\u000e\u0005\u0003\u0003J\tESB\u0001B&\u0015\u0011\u0011iEa\u0014\u0002\u000f5,GO]5dg*\u0019!L!\u0004\n\t\tM#1\n\u0002\u001c\u00072LWM\u001c;NKR\u0014\u0018nY:SK\u000e,\u0017N^3s!2,x-\u001b8\u000295,GO]5dgJ+7-Z5wKJ\u0004F.^4j]>\u0003Ho\u0018\u0013fcR!\u0011q\u000fB-\u0011%\u0011Y&MA\u0001\u0002\u0004\u0011\t%A\u0002yIE\n\u0011$\\3ue&\u001c7OU3dK&4XM\u001d)mk\u001eLgn\u00149uA\u0005i1-\u001e:sK:$8i\u001c8gS\u001e\f\u0011cY;se\u0016tGoQ8oM&<w\fJ3r)\u0011\t9H!\u001a\t\u0013\tmC'!AA\u0002\u00055\u0017AD2veJ,g\u000e^\"p]\u001aLw\rI\u0001\u001dIft\u0017-\\5d\u0007>tg-[4QCN\u001cxo\u001c:e\u000b:\u001cw\u000eZ3s+\t\u0011i\u0007E\u0003d\u0005_\u0012\u0019(C\u0002\u0003r\u0011\u0014AaU8nKB!!Q\u000fB>\u001b\t\u00119H\u0003\u0003\u0003z\t5\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\t\tu$q\u000f\u0002\u0010!\u0006\u001c8o^8sI\u0016s7m\u001c3fe\u0006iB-\u001f8b[&\u001c7i\u001c8gS\u001e\u0004\u0016m]:x_J$WI\\2pI\u0016\u0014\b%\u0001\u0006j]&$\u0018.\u00197ju\u0016$B!a\u001e\u0003\u0006\"9!q\u0011\u001dA\u0002\t\u0005\u0013AH2mS\u0016tG/T3ue&\u001c7OU3dK&4XM\u001d)mk\u001eLgn\u00149u\u0003\u0015\u0019G.Z1s)\t\t9(\u0001\nbI\u0012\u0014VmY8oM&<WO]1cY\u0016\u001cH\u0003BA<\u0005#CqAa%;\u0001\u0004\u0011)*A\u0006lC\u001a\\\u0017mU3sm\u0016\u0014\bcA0\u0003\u0018&\u0019!\u0011T-\u0003\u0017-\u000bgm[1Ce>\\WM\u001d\u000b\u0005\u0003o\u0012i\nC\u0004\u0003 n\u0002\rA!)\u0002\u0015\r|g\u000e\u001e:pY2,'\u000fE\u0002`\u0005GK1A!*Z\u0005A\u0019uN\u001c;s_2dWM]*feZ,'/A\tbI\u0012\u0014VmY8oM&<WO]1cY\u0016$B!a\u001e\u0003,\"9!Q\u0016\u001fA\u0002\t\u0015\u0011A\u0004:fG>tg-[4ve\u0006\u0014G.Z\u0001\u0018C\u0012$'I]8lKJ\u0014VmY8oM&<WO]1cY\u0016$B!a\u001e\u00034\"9!QV\u001fA\u0002\t\r\u0012\u0001\u0006:f[>4XMU3d_:4\u0017nZ;sC\ndW\r\u0006\u0003\u0002x\te\u0006b\u0002BW}\u0001\u0007!QA\u0001\u001cm\u0016\u0014\u0018NZ=SK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0015\t\u0005]$q\u0018\u0005\b\u0005\u0003|\u0004\u0019AAJ\u0003-\u0019wN\u001c4jO:\u000bW.Z:\u0002%\r,(O]3oi.\u000bgm[1D_:4\u0017nZ\u0001\u001cGV\u0014(/\u001a8u\tft\u0017-\\5d\u0005J|7.\u001a:D_:4\u0017nZ:\u0016\u0005\t%\u0007\u0003CA\u0001\u0005\u0017\f\u0019%a\u0011\n\u0007\u0005E\u0006/\u0001\u000fdkJ\u0014XM\u001c;Es:\fW.[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:\u00027\rd\u0017.\u001a8u\u001b\u0016$(/[2t%\u0016\u001cW-\u001b<feBcWoZ5o\u0003I)\b\u000fZ1uK\n\u0013xn[3s\u0007>tg-[4\u0015\u0011\u0005]$Q\u001bBp\u0005GDqAa6E\u0001\u0004\u0011I.\u0001\u0005ce>\\WM]%e!\r\u0019'1\\\u0005\u0004\u0005;$'aA%oi\"9!\u0011\u001d#A\u0002\u0005\u0005\u0015a\u00049feNL7\u000f^3oiB\u0013x\u000e]:\t\u0013\t\u0015H\t%AA\u0002\u0005e\u0012!\u00023p\u0019><\u0017\u0001H;qI\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e$C-\u001a4bk2$HeM\u000b\u0003\u0005WTC!!\u000f\u0003n.\u0012!q\u001e\t\u0005\u0005c\u0014Y0\u0004\u0002\u0003t*!!Q\u001fB|\u0003%)hn\u00195fG.,GMC\u0002\u0003z\u0012\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011iPa=\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\nva\u0012\fG/\u001a#fM\u0006,H\u000e^\"p]\u001aLw\r\u0006\u0004\u0002x\r\r1Q\u0001\u0005\b\u0005C4\u0005\u0019AAA\u0011%\u0011)O\u0012I\u0001\u0002\u0004\tI$A\u000fva\u0012\fG/\u001a#fM\u0006,H\u000e^\"p]\u001aLw\r\n3fM\u0006,H\u000e\u001e\u00133\u0003\u0015\u0012X\r\\8bIV\u0003H-\u0019;fI\u001aKG.Z:XSRDw.\u001e;D_:4\u0017nZ\"iC:<W\r\u0006\u0003\u0002x\r5\u0001bBB\b\u0011\u0002\u0007\u0011\u0011Q\u0001\t]\u0016<\bK]8qg\u0006y\u0001/Y:to>\u0014H-\u00128d_\u0012,'/\u0006\u0002\u0003t\u0005\tBo\u001c)feNL7\u000f^3oiB\u0013x\u000e]:\u0015\r\u0005\u00055\u0011DB\u000f\u0011\u001d\u0019YB\u0013a\u0001\u0003\u0003\u000b1bY8oM&<\u0007K]8qg\"9\u0011Q\u0012&A\u0002\u0005e\u0012a\u00054s_6\u0004VM]:jgR,g\u000e\u001e)s_B\u001cHCBAA\u0007G\u0019)\u0003C\u0004\u0003b.\u0003\r!!!\t\u000f\u000555\n1\u0001\u0002:\u0005\u0019b/\u00197jI\u0006$X\rZ&bM.\f\u0007K]8qgR1!\u0011ZB\u0016\u0007_Aqa!\fM\u0001\u0004\t\t)A\u0007qe>\u00048o\u0014<feJLG-\u001a\u0005\b\u0003\u001bc\u0005\u0019AA\u001d\u0003!1\u0018\r\\5eCR,GCBA<\u0007k\u00199\u0004C\u0004\u0002\u00005\u0003\r!!!\t\u000f\u00055U\n1\u0001\u0002:\u0005!\"/Z7pm\u0016LeN^1mS\u0012\u001cuN\u001c4jON$b!a\u001e\u0004>\r}\u0002bBA@\u001d\u0002\u0007\u0011\u0011\u0011\u0005\b\u0003\u001bs\u0005\u0019AA\u001d\u0003Ai\u0017-\u001f2f%\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0005\u0002x\r\u00153qIB&\u0011\u001d\u0011ik\u0014a\u0001\u0005\u000bAqa!\u0013P\u0001\u0004\ti-A\u0005pY\u0012\u001cuN\u001c4jO\"91QJ(A\u0002\r=\u0013!\u00038fo\u000e{gNZ5ha\u0011\u0019\tfa\u0016\u0011\u0011\u0005\r\u0015qVA\"\u0007'\u0002Ba!\u0016\u0004X1\u0001A\u0001DB-\u0007\u0017\n\t\u0011!A\u0003\u0002\rm#aA0%cE!1QLB2!\r\u00197qL\u0005\u0004\u0007C\"'a\u0002(pi\"Lgn\u001a\t\u0004G\u000e\u0015\u0014bAB4I\n\u0019\u0011I\\=\u0002\u001dU\u0004H-\u0019;fI\u000e{gNZ5hgR11QNB?\u0007\u0013\u0003raYB8\u0007g\n\u0019*C\u0002\u0004r\u0011\u0014a\u0001V;qY\u0016\u0014\u0004\u0007BB;\u0007s\u0002r!\\Aq\u0003\u0007\u001a9\b\u0005\u0003\u0004V\reDaCB>!\u0006\u0005\t\u0011!B\u0001\u00077\u00121a\u0018\u00135\u0011\u001d\u0019y\u0001\u0015a\u0001\u0007\u007f\u0002Da!!\u0004\u0006BA\u00111QAX\u0003\u0007\u001a\u0019\t\u0005\u0003\u0004V\r\u0015E\u0001DBD\u0007{\n\t\u0011!A\u0003\u0002\rm#aA0%e!911\u0012)A\u0002\r5\u0015\u0001D2veJ,g\u000e\u001e)s_B\u001c\b\u0007BBH\u0007'\u0003\u0002\"a!\u00020\u0006\r3\u0011\u0013\t\u0005\u0007+\u001a\u0019\n\u0002\u0007\u0004\u0016\u000e%\u0015\u0011!A\u0001\u0006\u0003\u0019YFA\u0002`IM\nQb\u001c<feJLG-\u001a)s_B\u001cHCBA<\u00077\u001bi\nC\u0004\u0002\u0000E\u0003\r!!<\t\u000f\r5\u0012\u000b1\u0001\u0002n\u0006\u0019R\u000f\u001d3bi\u0016\u001cUO\u001d:f]R\u001cuN\u001c4jOR!\u0011qOBR\u0011\u001d\u0011)O\u0015a\u0001\u0003s\ta\u0003\u001d:pG\u0016\u001c8OU3d_:4\u0017nZ;sCRLwN\u001c\u000b\t\u0007S\u001bika,\u00044B91ma\u001c\u0002N\u000e-\u0006CBA/\u0003O\u0012\u0019\u0003C\u0004\u0004\u0010M\u0003\rA!3\t\u000f\rE6\u000b1\u0001\u0002:\u0005aa/\u00197jI\u0006$Xm\u00148ms\"I!Q]*\u0011\u0002\u0003\u0007\u0011\u0011H\u0001!aJ|7-Z:t%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]\u0012\"WMZ1vYR$3'\u0001\u000boK\u0016$7OU3d_:4\u0017nZ;sCRLwN\u001c\u000b\t\u0003s\u0019Yla1\u0004H\"91QX+A\u0002\r}\u0016!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm\u001d\t\u0007\u0003\u0007\u001b\t-a\u0011\n\u0007M\f)\tC\u0004\u0004FV\u0003\r!a%\u0002\u0017U\u0004H-\u0019;fI.+\u0017p\u001d\u0005\b\u0007\u0013,\u0006\u0019AAJ\u0003-!W\r\\3uK\u0012\\U-_:\u0002;A\u0014xnY3tg2K7\u000f^3oKJ\u0014VmY8oM&<WO]1cY\u0016$B\"a\u001e\u0004P\u000e}7\u0011]Bw\u0007_Dqa!5W\u0001\u0004\u0019\u0019.\u0001\fmSN$XM\\3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f!\u0011\u0019)na7\u000e\u0005\r]'\u0002BBm\u0005\u0013\tqA\\3uo>\u00148.\u0003\u0003\u0004^\u000e]'A\u0006'jgR,g.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\t\u000f\r5c\u000b1\u0001\u0002N\"911\u001d,A\u0002\r\u0015\u0018!D2vgR|WnQ8oM&<7\u000f\u0005\u0005\u0002\u0004\u0006=\u00161IBt!\r)8\u0011^\u0005\u0004\u0007W4(AB(cU\u0016\u001cG\u000fC\u0004\u00042Z\u0003\r!!\u000f\t\u000f\rEh\u000b1\u0001\u0002:\u0005Q!/\u001a7pC\u0012|e\u000e\\=\u0002+A\u0014xnY3tgJ+7m\u001c8gS\u001e,(/\u00192mKRa\u0011qOB|\u0007s\u001ci\u0010b\u0003\u0005\u0010!9!QV,A\u0002\t\u0015\u0001bBB~/\u0002\u0007\u00111S\u0001\u0013kB$\u0017\r^3e\u0007>tg-[4OC6,7\u000fC\u0004\u0004\u0000^\u0003\r\u0001\"\u0001\u0002\u001b\u0005dGNT3x\u0007>tg-[4ta\u0011!\u0019\u0001b\u0002\u0011\u0011\u0005\r\u0015qVA\"\t\u000b\u0001Ba!\u0016\u0005\b\u0011aA\u0011BB\u007f\u0003\u0003\u0005\tQ!\u0001\u0004\\\t\u0019q\fJ\u001b\t\u000f\u00115q\u000b1\u0001\u0004f\u0006\u0001b.Z<DkN$x.\\\"p]\u001aLwm\u001d\u0005\b\u0007c;\u0006\u0019AA\u001d\u0001")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private final CopyOnWriteArrayList<Reconfigurable> reconfigurables;
    private final CopyOnWriteArrayList<BrokerReconfigurable> brokerReconfigurables;
    private final ReentrantReadWriteLock lock;
    private Option<ClientMetricsReceiverPlugin> metricsReceiverPluginOpt;
    private KafkaConfig currentConfig;
    private final Some<PasswordEncoder> dynamicConfigPasswordEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateConfigs(Properties props, boolean perBrokerConfig) {
        DynamicBrokerConfig$.MODULE$.validateConfigs(props, perBrokerConfig);
    }

    public static List<String> brokerConfigSynonyms(String name, boolean matchListenerOverride) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, matchListenerOverride);
    }

    public static boolean isPasswordConfig(String name) {
        return DynamicBrokerConfig$.MODULE$.isPasswordConfig(name);
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    public CopyOnWriteArrayList<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private CopyOnWriteArrayList<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private Option<ClientMetricsReceiverPlugin> metricsReceiverPluginOpt() {
        return this.metricsReceiverPluginOpt;
    }

    private void metricsReceiverPluginOpt_$eq(Option<ClientMetricsReceiverPlugin> x$1) {
        this.metricsReceiverPluginOpt = x$1;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    private Some<PasswordEncoder> dynamicConfigPasswordEncoder() {
        return this.dynamicConfigPasswordEncoder;
    }

    public void initialize(Option<ClientMetricsReceiverPlugin> clientMetricsReceiverPluginOpt) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false));
        this.metricsReceiverPluginOpt_$eq(clientMetricsReceiverPluginOpt);
    }

    public void clear() {
        this.dynamicBrokerConfigs().clear();
        this.dynamicDefaultConfigs().clear();
        this.reconfigurables().clear();
        this.brokerReconfigurables().clear();
    }

    public void addReconfigurables(KafkaBroker kafkaServer) {
        Authorizer authz;
        Option<Authorizer> option = kafkaServer.authorizer();
        if (option instanceof Some && (authz = (Authorizer)((Some)option).value()) instanceof Reconfigurable) {
            this.addReconfigurable((Reconfigurable)authz);
        }
        this.addReconfigurable((Reconfigurable)kafkaServer.kafkaYammerMetrics());
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer.config(), kafkaServer.metrics(), kafkaServer.clusterId()));
        this.addReconfigurable(new DynamicClientQuotaCallback(kafkaServer.quotaManagers(), kafkaServer.config()));
        this.addBrokerReconfigurable(new BrokerDynamicThreadPool(kafkaServer));
        this.addBrokerReconfigurable(new DynamicLogConfig(kafkaServer.logManager()));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
        this.addBrokerReconfigurable(kafkaServer.socketServer());
        this.addBrokerReconfigurable(new DynamicProducerStateManagerConfig(kafkaServer.logManager().producerStateManagerConfig()));
        this.addBrokerReconfigurable(new DynamicRemoteLogConfig(kafkaServer));
    }

    public void addReconfigurables(ControllerServer controller) {
        Authorizer authz;
        Option<Authorizer> option = controller.authorizer();
        if (option instanceof Some && (authz = (Authorizer)((Some)option).value()) instanceof Reconfigurable) {
            this.addReconfigurable((Reconfigurable)authz);
        }
        if (!this.kafkaConfig().processRoles().contains((Object)ProcessRole.BrokerRole)) {
            this.addReconfigurable((Reconfigurable)controller.kafkaYammerMetrics());
            this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().nodeId(), controller.config(), controller.metrics(), controller.clusterId()));
        }
        this.addReconfigurable(new DynamicClientQuotaCallback(controller.quotaManagers(), controller.config()));
        this.addBrokerReconfigurable(new ControllerDynamicThreadPool(controller));
        this.addBrokerReconfigurable(controller.socketServer());
    }

    public void addReconfigurable(Reconfigurable reconfigurable) {
        this.verifyReconfigurableConfigs((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(reconfigurable.reconfigurableConfigs()).asScala());
        this.reconfigurables().add(reconfigurable);
    }

    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        this.verifyReconfigurableConfigs(reconfigurable.reconfigurableConfigs());
        this.brokerReconfigurables().add(reconfigurable);
    }

    public void removeReconfigurable(Reconfigurable reconfigurable) {
        this.reconfigurables().remove(reconfigurable);
    }

    private void verifyReconfigurableConfigs(Set<String> configNames) {
        Set nonDynamic = (Set)configNames.intersect(DynamicConfig$Broker$.MODULE$.nonDynamicProps());
        Predef$.MODULE$.require(nonDynamic.isEmpty(), (Function0 & Serializable)() -> "Reconfigurable contains non-dynamic configs " + nonDynamic);
    }

    public KafkaConfig currentKafkaConfig() {
        KafkaConfig kafkaConfig;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            kafkaConfig = this.currentConfig();
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return kafkaConfig;
    }

    public Map<String, String> currentDynamicBrokerConfigs() {
        scala.collection.mutable.Map map;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicBrokerConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    public Map<String, String> currentDynamicDefaultConfigs() {
        scala.collection.mutable.Map map;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicDefaultConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    public Option<ClientMetricsReceiverPlugin> clientMetricsReceiverPlugin() {
        Option option;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = this.metricsReceiverPluginOpt();
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    public void updateBrokerConfig(int brokerId, Properties persistentProps, boolean doLog) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateBrokerConfig$1(this, persistentProps, doLog, brokerId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean updateBrokerConfig$default$3() {
        return true;
    }

    public void updateDefaultConfig(Properties persistentProps, boolean doLog) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateDefaultConfig$1(this, persistentProps, doLog);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean updateDefaultConfig$default$2() {
        return true;
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties newProps) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$1(this, newProps);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)this.dynamicConfigPasswordEncoder().getOrElse((Function0 & Serializable)() -> {
            throw new ConfigException("Password encoder secret not configured");
        });
    }

    public Properties toPersistentProps(Properties configProps, boolean perBrokerConfig) {
        Properties props = (Properties)configProps.clone();
        CollectionConverters$.MODULE$.PropertiesHasAsScala(configProps).asScala().foreachEntry((Function2 & Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$toPersistentProps$1(this, perBrokerConfig, props, name, value);
            return BoxedUnit.UNIT;
        });
        return props;
    }

    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Non-dynamic configs will be ignored", props);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreachEntry((Function2 & Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$fromPersistentProps$5(this, props, name, value);
            return BoxedUnit.UNIT;
        });
        return props;
    }

    private Map<String, String> validatedKafkaProps(Properties propsOverride, boolean perBrokerConfig) {
        Properties propsResolved = DynamicBrokerConfig$.MODULE$.resolveVariableConfigs(propsOverride);
        DynamicBrokerConfig$.MODULE$.validateConfigs(propsResolved, perBrokerConfig);
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        if (perBrokerConfig) {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(propsResolved).asScala());
        } else {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(propsResolved).asScala());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        }
        return newProps;
    }

    public void validate(Properties props, boolean perBrokerConfig) {
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$validate$1(this, props, perBrokerConfig);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala();
            return;
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(x0$1)));
            invalidProps.keys().foreach((Function1 & Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable)() -> "Dynamic " + configSource + " config contains invalid values in: " + invalidProps.keys() + ", these configs will be ignored", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        if (CollectionConverters$.MODULE$.SetHasAsScala(reconfigurable.reconfigurableConfigs()).asScala().exists((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) {
            reconfigurable.reconfigure(newConfig);
            return;
        }
    }

    private Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<String, ?> currentProps) {
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(newProps).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$1)));
        Set deletedKeySet = ((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(currentProps).asScala().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$2(newProps, x0$2)))).keySet();
        return new Tuple2((Object)changeMap, (Object)deletedKeySet);
    }

    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        propsOverride.foreachEntry((Function2 & Serializable)(k, v) -> {
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms((String)k, false).foreach((Function1 & Serializable)key -> props.remove(key));
            return props.put(k, v);
        });
    }

    /*
     * WARNING - void declaration
     */
    private void updateCurrentConfig(boolean doLog) {
        void var5_5;
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        KafkaConfig oldConfig = this.currentConfig();
        Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false, doLog);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig newConfig = (KafkaConfig)tuple2._1();
        List brokerReconfigurablesToUpdate = (List)tuple2._2();
        if (var5_5 != this.currentConfig()) {
            void var6_6;
            this.currentConfig_$eq((KafkaConfig)var5_5);
            this.kafkaConfig().updateCurrentConfig((KafkaConfig)var5_5);
            var6_6.foreach(arg_0 -> DynamicBrokerConfig.$anonfun$updateCurrentConfig$1$adapted(oldConfig, (KafkaConfig)var5_5, arg_0));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly, boolean doLog) {
        void var7_7;
        void var6_6;
        KafkaConfig newConfig = new KafkaConfig(CollectionConverters$.MODULE$.MapHasAsJava(newProps).asJava(), doLog);
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeySet = (Set)tuple2._2();
        if (var6_6.nonEmpty() || var7_7.nonEmpty()) {
            try {
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                newConfig.valuesFromThisConfig().keySet().forEach(k -> customConfigs.remove(k));
                this.reconfigurables().forEach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$2(this, newConfig, customConfigs, validateOnly, (scala.collection.mutable.Map)var6_6, (Set)var7_7, arg_0));
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().forEach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$3(this, (scala.collection.mutable.Map)var6_6, (Set)var7_7, newConfig, validateOnly, brokerReconfigurablesToUpdate, arg_0));
                return new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to update broker configuration with configs : " + ConfigUtils.configMapToRedactedString(newConfig.originalsFromThisConfig(), (ConfigDef)KafkaConfig$.MODULE$.configDef()), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        }
        return new Tuple2((Object)this.currentConfig(), (Object)package$.MODULE$.List().empty());
    }

    private boolean processReconfiguration$default$3() {
        return false;
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys, Set<String> deletedKeys) {
        return CollectionConverters$.MODULE$.SetHasAsScala(reconfigurableConfigs).asScala().intersect(updatedKeys).nonEmpty() || CollectionConverters$.MODULE$.SetHasAsScala(reconfigurableConfigs).asScala().intersect(deletedKeys).nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private void processListenerReconfigurable(ListenerReconfigurable listenerReconfigurable, KafkaConfig newConfig, java.util.Map<String, Object> customConfigs, boolean validateOnly, boolean reloadOnly) {
        void var11_11;
        void var10_10;
        ListenerName listenerName = listenerReconfigurable.listenerName();
        java.util.Map<String, Object> oldValues = this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
        java.util.Map<String, Object> newValues = newConfig.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newValues, oldValues);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeys = (Set)tuple2._2();
        Set updatedKeys = var10_10.keySet();
        boolean configsChanged = this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys, (Set<String>)var11_11);
        if (reloadOnly != configsChanged) {
            this.processReconfigurable((Reconfigurable)listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs, validateOnly);
            return;
        }
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        allNewConfigs.forEach((k, v) -> newConfigs.put((String)k, v));
        newConfigs.putAll(newCustomConfigs);
        try {
            reconfigurable.validateReconfiguration(newConfigs);
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            throw new ConfigException("Validation of dynamic config update of " + updatedConfigNames + " failed with class " + reconfigurable.getClass());
        }
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Reconfiguring " + reconfigurable + ", updated configs: " + updatedConfigNames + " custom configs: " + ConfigUtils.configMapToRedactedString((java.util.Map)newCustomConfigs, (ConfigDef)KafkaConfig$.MODULE$.configDef()));
            reconfigurable.reconfigure(newConfigs);
            return;
        }
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicBrokerConfigs$1(DynamicBrokerConfig $this) {
        return (scala.collection.mutable.Map)$this.dynamicBrokerConfigs().clone();
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicDefaultConfigs$1(DynamicBrokerConfig $this) {
        return (scala.collection.mutable.Map)$this.dynamicDefaultConfigs().clone();
    }

    public static final /* synthetic */ void $anonfun$updateBrokerConfig$1(DynamicBrokerConfig $this, Properties persistentProps$1, boolean doLog$1, int brokerId$1) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$1, true);
            $this.dynamicBrokerConfigs().clear();
            $this.dynamicBrokerConfigs().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala());
            $this.updateCurrentConfig(doLog$1);
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> "Per-broker configs of " + brokerId$1 + " could not be applied: " + persistentProps$1.keys(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateDefaultConfig$1(DynamicBrokerConfig $this, Properties persistentProps$2, boolean doLog$2) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$2, false);
            $this.dynamicDefaultConfigs().clear();
            $this.dynamicDefaultConfigs().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala());
            $this.updateCurrentConfig(doLog$2);
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> "Cluster default configs could not be applied: " + persistentProps$2.keys(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$1(DynamicBrokerConfig $this, Properties newProps$1) {
        $this.reconfigurables().forEach(r -> {
            if (DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs().exists(arg_0 -> DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(r.reconfigurableConfigs(), arg_0))) {
                if (r instanceof ListenerReconfigurable) {
                    ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)r;
                    Map<String, String> kafkaProps = $this.validatedKafkaProps(newProps$1, true);
                    KafkaConfig newConfig = new KafkaConfig(CollectionConverters$.MODULE$.MapHasAsJava(kafkaProps).asJava(), false);
                    $this.processListenerReconfigurable(listenerReconfigurable, newConfig, Collections.emptyMap(), false, true);
                    return;
                }
                $this.trace((Function0<String>)(Function0 & Serializable)() -> "Files will not be reloaded without config change for " + r);
                return;
            }
        });
    }

    private final void encodePassword$1(String configName, String value, boolean perBrokerConfig$1, Properties props$3) {
        if (value != null) {
            if (!perBrokerConfig$1) {
                throw new ConfigException("Password config can be defined only at broker level");
            }
            props$3.setProperty(configName, this.passwordEncoder().encode(new Password(value)));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$toPersistentProps$1(DynamicBrokerConfig $this, boolean perBrokerConfig$1, Properties props$3, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.encodePassword$1(name, value, perBrokerConfig$1, props$3);
            return;
        }
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$4) {
        if (invalidPropNames.nonEmpty()) {
            invalidPropNames.foreach((Function1 & Serializable)x$1 -> props$4.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable)() -> errorMessage + ": " + invalidPropNames);
            return;
        }
    }

    private final void decodePassword$1(String configName, String value, Properties props$4) {
        if (value != null) {
            try {
                props$4.setProperty(configName, this.passwordEncoder().decode(value).value());
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Dynamic password config " + configName + " could not be decoded, ignoring.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                props$4.remove(configName);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$fromPersistentProps$5(DynamicBrokerConfig $this, Properties props$4, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.decodePassword$1(name, value, props$4);
            return;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$validate$1(DynamicBrokerConfig $this, Properties props$5, boolean perBrokerConfig$2) {
        Map<String, String> newProps = $this.validatedKafkaProps(props$5, perBrokerConfig$2);
        return $this.processReconfiguration(newProps, true, false);
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props1);
                return false;
            }
            catch (Exception exception) {
                return true;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            return !BoxesRunTime.equals((Object)x0$1._2(), currentProps$1.get(k));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$2(java.util.Map newProps$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            String k = (String)x0$2._1();
            return !newProps$2.containsKey(k);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$2(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig$3, customConfigs$1, validateOnly$1, false);
            return;
        }
        if ($this.needsReconfiguration(x0$1.reconfigurableConfigs(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            $this.processReconfigurable(x0$1, (Set<String>)changeMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$3(DynamicBrokerConfig $this, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, KafkaConfig newConfig$3, boolean validateOnly$1, Buffer brokerReconfigurablesToUpdate$1, BrokerReconfigurable reconfigurable) {
        if ($this.needsReconfiguration(CollectionConverters$.MODULE$.SetHasAsJava(reconfigurable.reconfigurableConfigs()).asJava(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            reconfigurable.validateReconfiguration(newConfig$3);
            if (!validateOnly$1) {
                brokerReconfigurablesToUpdate$1.$plus$eq((Object)reconfigurable);
                return;
            }
            return;
        }
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
        this.staticBrokerConfigs = CollectionConverters$.MODULE$.MapHasAsScala(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = CollectionConverters$.MODULE$.MapHasAsScala(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(KafkaConfig$.MODULE$.defaultValues()).asJava())).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = new CopyOnWriteArrayList();
        this.brokerReconfigurables = new CopyOnWriteArrayList();
        this.lock = new ReentrantReadWriteLock();
        this.dynamicConfigPasswordEncoder = new Some((Object)PasswordEncoder.NOOP);
    }

    public static final /* synthetic */ Object $anonfun$updateCurrentConfig$1$adapted(KafkaConfig oldConfig$2, KafkaConfig newConfig$2, BrokerReconfigurable x$5) {
        x$5.reconfigure(oldConfig$2, newConfig$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(java.util.Set eta$0$1$1, Object x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains(x$1));
    }
}

