/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.server.common.AdminOperationException;

public class AdminUtils {
    static final Random RAND = new Random();
    public static final String ADMIN_CLIENT_ID = "__admin_client";

    public static Map<Integer, List<Integer>> assignReplicasToBrokers(Collection<BrokerMetadata> brokerMetadatas, int nPartitions, int replicationFactor) {
        return AdminUtils.assignReplicasToBrokers(brokerMetadatas, nPartitions, replicationFactor, -1, -1);
    }

    public static Map<Integer, List<Integer>> assignReplicasToBrokers(Collection<BrokerMetadata> brokerMetadatas, int nPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        if (nPartitions <= 0) {
            throw new InvalidPartitionsException("Number of partitions must be larger than 0.");
        }
        if (replicationFactor <= 0) {
            throw new InvalidReplicationFactorException("Replication factor must be larger than 0.");
        }
        if (replicationFactor > brokerMetadatas.size()) {
            throw new InvalidReplicationFactorException("Replication factor: " + replicationFactor + " larger than available brokers: " + brokerMetadatas.size() + ".");
        }
        if (brokerMetadatas.stream().noneMatch(b -> b.rack.isPresent())) {
            return AdminUtils.assignReplicasToBrokersRackUnaware(nPartitions, replicationFactor, brokerMetadatas.stream().map(b -> b.id).collect(Collectors.toList()), fixedStartIndex, startPartitionId);
        }
        return AdminUtils.assignReplicasToBrokersRackAware(nPartitions, replicationFactor, brokerMetadatas, fixedStartIndex, startPartitionId);
    }

    private static Map<Integer, List<Integer>> assignReplicasToBrokersRackUnaware(int nPartitions, int replicationFactor, List<Integer> brokerList, int fixedStartIndex, int startPartitionId) {
        HashMap<Integer, List<Integer>> ret = new HashMap<Integer, List<Integer>>();
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : RAND.nextInt(brokerList.size());
        int currentPartitionId = Math.max(0, startPartitionId);
        int nextReplicaShift = fixedStartIndex >= 0 ? fixedStartIndex : RAND.nextInt(brokerList.size());
        for (int i = 0; i < nPartitions; ++i) {
            if (currentPartitionId > 0 && currentPartitionId % brokerList.size() == 0) {
                ++nextReplicaShift;
            }
            int firstReplicaIndex = (currentPartitionId + startIndex) % brokerList.size();
            ArrayList<Integer> replicaBuffer = new ArrayList<Integer>();
            replicaBuffer.add(brokerList.get(firstReplicaIndex));
            for (int j = 0; j < replicationFactor - 1; ++j) {
                replicaBuffer.add(brokerList.get(AdminUtils.replicaIndex(firstReplicaIndex, nextReplicaShift, j, brokerList.size())));
            }
            ret.put(currentPartitionId, replicaBuffer);
            ++currentPartitionId;
        }
        return ret;
    }

    private static Map<Integer, List<Integer>> assignReplicasToBrokersRackAware(int nPartitions, int replicationFactor, Collection<BrokerMetadata> brokerMetadatas, int fixedStartIndex, int startPartitionId) {
        HashMap<Integer, String> brokerRackMap = new HashMap<Integer, String>();
        brokerMetadatas.forEach(m -> brokerRackMap.put(m.id, m.rack.orElseThrow(() -> new AdminOperationException("Not all brokers have rack information for replica rack aware assignment."))));
        int numRacks = new HashSet(brokerRackMap.values()).size();
        List<Integer> arrangedBrokerList = AdminUtils.getRackAlternatedBrokerList(brokerRackMap);
        int numBrokers = arrangedBrokerList.size();
        HashMap<Integer, List<Integer>> ret = new HashMap<Integer, List<Integer>>();
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : RAND.nextInt(arrangedBrokerList.size());
        int currentPartitionId = Math.max(0, startPartitionId);
        int nextReplicaShift = fixedStartIndex >= 0 ? fixedStartIndex : RAND.nextInt(arrangedBrokerList.size());
        for (int i = 0; i < nPartitions; ++i) {
            if (currentPartitionId > 0 && currentPartitionId % arrangedBrokerList.size() == 0) {
                ++nextReplicaShift;
            }
            int firstReplicaIndex = (currentPartitionId + startIndex) % arrangedBrokerList.size();
            int leader = arrangedBrokerList.get(firstReplicaIndex);
            ArrayList<Integer> replicaBuffer = new ArrayList<Integer>();
            replicaBuffer.add(leader);
            HashSet<String> racksWithReplicas = new HashSet<String>();
            racksWithReplicas.add((String)brokerRackMap.get(leader));
            HashSet<Integer> brokersWithReplicas = new HashSet<Integer>();
            brokersWithReplicas.add(leader);
            int k = 0;
            for (int j = 0; j < replicationFactor - 1; ++j) {
                boolean done = false;
                while (!done) {
                    Integer broker = arrangedBrokerList.get(AdminUtils.replicaIndex(firstReplicaIndex, nextReplicaShift * numRacks, k, arrangedBrokerList.size()));
                    String rack = (String)brokerRackMap.get(broker);
                    if (!(racksWithReplicas.contains(rack) && racksWithReplicas.size() != numRacks || brokersWithReplicas.contains(broker) && brokersWithReplicas.size() != numBrokers)) {
                        replicaBuffer.add(broker);
                        racksWithReplicas.add(rack);
                        brokersWithReplicas.add(broker);
                        done = true;
                    }
                    ++k;
                }
            }
            ret.put(currentPartitionId, replicaBuffer);
            ++currentPartitionId;
        }
        return ret;
    }

    public static List<Integer> getRackAlternatedBrokerList(Map<Integer, String> brokerRackMap) {
        HashMap brokersIteratorByRack = new HashMap();
        AdminUtils.getInverseMap(brokerRackMap).forEach((rack, brokers) -> brokersIteratorByRack.put(rack, brokers.iterator()));
        Object[] racks = brokersIteratorByRack.keySet().toArray(new String[0]);
        Arrays.sort(racks);
        ArrayList<Integer> result = new ArrayList<Integer>();
        int rackIndex = 0;
        while (result.size() < brokerRackMap.size()) {
            Iterator rackIterator = (Iterator)brokersIteratorByRack.get(racks[rackIndex]);
            if (rackIterator.hasNext()) {
                result.add((Integer)rackIterator.next());
            }
            rackIndex = (rackIndex + 1) % racks.length;
        }
        return result;
    }

    static Map<String, List<Integer>> getInverseMap(Map<Integer, String> brokerRackMap) {
        HashMap<String, List<Integer>> results = new HashMap<String, List<Integer>>();
        brokerRackMap.forEach((id, rack) -> results.computeIfAbsent((String)rack, key -> new ArrayList()).add(id));
        results.forEach((rack, rackAndIdList) -> rackAndIdList.sort(Integer::compareTo));
        return results;
    }

    static int replicaIndex(int firstReplicaIndex, int secondReplicaShift, int replicaIndex, int nBrokers) {
        long shift = 1 + (secondReplicaShift + replicaIndex) % (nBrokers - 1);
        return (int)(((long)firstReplicaIndex + shift) % (long)nBrokers);
    }
}

