/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CompletedTxn;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.TxnMetadata;
import org.apache.kafka.storage.internals.log.VerificationStateEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerAppendInfo {
    private static final Logger log = LoggerFactory.getLogger(ProducerAppendInfo.class);
    private final TopicPartition topicPartition;
    private final long producerId;
    private final ProducerStateEntry currentEntry;
    private final AppendOrigin origin;
    private final VerificationStateEntry verificationStateEntry;
    private final List<TxnMetadata> transactions = new ArrayList<TxnMetadata>();
    private final ProducerStateEntry updatedEntry;

    public ProducerAppendInfo(TopicPartition topicPartition, long producerId, ProducerStateEntry currentEntry, AppendOrigin origin, VerificationStateEntry verificationStateEntry) {
        this.topicPartition = topicPartition;
        this.producerId = producerId;
        this.currentEntry = currentEntry;
        this.origin = origin;
        this.verificationStateEntry = verificationStateEntry;
        this.updatedEntry = currentEntry.withProducerIdAndBatchMetadata(producerId, Optional.empty());
    }

    public long producerId() {
        return this.producerId;
    }

    private void maybeValidateDataBatch(short producerEpoch, int firstSeq, long offset) {
        this.checkProducerEpoch(producerEpoch, offset);
        if (this.origin == AppendOrigin.CLIENT) {
            this.checkSequence(producerEpoch, firstSeq, offset);
        }
    }

    private void checkProducerEpoch(short producerEpoch, long offset) {
        if (producerEpoch < this.updatedEntry.producerEpoch()) {
            String message = "Epoch of producer " + this.producerId + " at offset " + offset + " in " + String.valueOf(this.topicPartition) + " is " + producerEpoch + ", which is smaller than the last seen epoch " + this.updatedEntry.producerEpoch();
            if (this.origin == AppendOrigin.REPLICATION) {
                log.warn(message);
            } else {
                throw new InvalidProducerEpochException(message);
            }
        }
    }

    private void checkSequence(short producerEpoch, int appendFirstSeq, long offset) {
        if (this.verificationStateEntry != null && appendFirstSeq > this.verificationStateEntry.lowestSequence()) {
            throw new OutOfOrderSequenceException("Out of order sequence number for producer " + this.producerId + " at offset " + offset + " in partition " + String.valueOf(this.topicPartition) + ": " + appendFirstSeq + " (incoming seq. number), " + this.verificationStateEntry.lowestSequence() + " (earliest seen sequence)");
        }
        if (producerEpoch != this.updatedEntry.producerEpoch()) {
            if (appendFirstSeq != 0 && this.updatedEntry.producerEpoch() != -1) {
                throw new OutOfOrderSequenceException("Invalid sequence number for new epoch of producer " + this.producerId + "at offset " + offset + " in partition " + String.valueOf(this.topicPartition) + ": " + producerEpoch + " (request epoch), " + appendFirstSeq + " (seq. number), " + this.updatedEntry.producerEpoch() + " (current producer epoch)");
            }
        } else {
            int currentLastSeq = !this.updatedEntry.isEmpty() ? this.updatedEntry.lastSeq() : (producerEpoch == this.currentEntry.producerEpoch() ? this.currentEntry.lastSeq() : -1);
            if (this.currentEntry.producerEpoch() != -1 && !this.inSequence(currentLastSeq, appendFirstSeq)) {
                throw new OutOfOrderSequenceException("Out of order sequence number for producer " + this.producerId + " at offset " + offset + " in partition " + String.valueOf(this.topicPartition) + ": " + appendFirstSeq + " (incoming seq. number), " + currentLastSeq + " (current end sequence number)");
            }
        }
    }

    private boolean inSequence(int lastSeq, int nextSeq) {
        return (long)nextSeq == (long)lastSeq + 1L || nextSeq == 0 && lastSeq == Integer.MAX_VALUE;
    }

    public Optional<CompletedTxn> append(RecordBatch batch, Optional<LogOffsetMetadata> firstOffsetMetadataOpt) {
        if (batch.isControlBatch()) {
            Iterator recordIterator = batch.iterator();
            if (recordIterator.hasNext()) {
                Record record = (Record)recordIterator.next();
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record);
                return this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record.timestamp());
            }
            return Optional.empty();
        }
        LogOffsetMetadata firstOffsetMetadata = firstOffsetMetadataOpt.orElse(new LogOffsetMetadata(batch.baseOffset()));
        this.appendDataBatch(batch.producerEpoch(), batch.baseSequence(), batch.lastSequence(), batch.maxTimestamp(), firstOffsetMetadata, batch.lastOffset(), batch.isTransactional());
        return Optional.empty();
    }

    public void appendDataBatch(short epoch, int firstSeq, int lastSeq, long lastTimestamp, LogOffsetMetadata firstOffsetMetadata, long lastOffset, boolean isTransactional) {
        long firstOffset = firstOffsetMetadata.messageOffset;
        this.maybeValidateDataBatch(epoch, firstSeq, firstOffset);
        this.updatedEntry.addBatch(epoch, lastSeq, lastOffset, (int)(lastOffset - firstOffset), lastTimestamp);
        OptionalLong currentTxnFirstOffset = this.updatedEntry.currentTxnFirstOffset();
        if (currentTxnFirstOffset.isPresent() && !isTransactional) {
            throw new InvalidTxnStateException("Expected transactional write from producer " + this.producerId + " at offset " + String.valueOf(firstOffsetMetadata) + " in partition " + String.valueOf(this.topicPartition));
        }
        if (!currentTxnFirstOffset.isPresent() && isTransactional) {
            this.updatedEntry.setCurrentTxnFirstOffset(firstOffset);
            this.transactions.add(new TxnMetadata(this.producerId, firstOffsetMetadata));
        }
    }

    private void checkCoordinatorEpoch(EndTransactionMarker endTxnMarker, long offset) {
        if (this.updatedEntry.coordinatorEpoch() > endTxnMarker.coordinatorEpoch()) {
            if (this.origin == AppendOrigin.REPLICATION) {
                log.info("Detected invalid coordinator epoch for producerId {} at offset {} in partition {}: {} is older than previously known coordinator epoch {}", new Object[]{this.producerId, offset, this.topicPartition, endTxnMarker.coordinatorEpoch(), this.updatedEntry.coordinatorEpoch()});
            } else {
                throw new TransactionCoordinatorFencedException("Invalid coordinator epoch for producerId " + this.producerId + " at offset " + offset + " in partition " + String.valueOf(this.topicPartition) + ": " + endTxnMarker.coordinatorEpoch() + " (zombie), " + this.updatedEntry.coordinatorEpoch() + " (current)");
            }
        }
    }

    public Optional<CompletedTxn> appendEndTxnMarker(EndTransactionMarker endTxnMarker, short producerEpoch, long offset, long timestamp) {
        this.checkProducerEpoch(producerEpoch, offset);
        this.checkCoordinatorEpoch(endTxnMarker, offset);
        Optional<CompletedTxn> completedTxn = this.updatedEntry.currentTxnFirstOffset().isPresent() ? Optional.of(new CompletedTxn(this.producerId, this.updatedEntry.currentTxnFirstOffset().getAsLong(), offset, endTxnMarker.controlType() == ControlRecordType.ABORT)) : Optional.empty();
        this.updatedEntry.update(producerEpoch, endTxnMarker.coordinatorEpoch(), timestamp);
        return completedTxn;
    }

    public ProducerStateEntry toEntry() {
        return this.updatedEntry;
    }

    public List<TxnMetadata> startedTransactions() {
        return Collections.unmodifiableList(this.transactions);
    }

    public String toString() {
        return "ProducerAppendInfo(producerId=" + this.producerId + ", producerEpoch=" + this.updatedEntry.producerEpoch() + ", firstSequence=" + this.updatedEntry.firstSeq() + ", lastSequence=" + this.updatedEntry.lastSeq() + ", currentTxnFirstOffset=" + String.valueOf(this.updatedEntry.currentTxnFirstOffset()) + ", coordinatorEpoch=" + this.updatedEntry.coordinatorEpoch() + ", lastTimestamp=" + this.updatedEntry.lastTimestamp() + ", startedTransactions=" + String.valueOf(this.transactions) + ")";
    }
}

