/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collections;
import java.util.Set;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableMaterializedValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.KeyValueStoreWrapper;

class KTableMapValues<KIn, VIn, VOut>
implements KTableProcessorSupplier<KIn, VIn, KIn, VOut> {
    private final KTableImpl<KIn, ?, VIn> parent;
    private final ValueMapperWithKey<? super KIn, ? super VIn, ? extends VOut> mapper;
    private final String queryableName;
    private boolean sendOldValues = false;
    private final StoreFactory storeFactory;

    KTableMapValues(KTableImpl<KIn, ?, VIn> parent, ValueMapperWithKey<? super KIn, ? super VIn, ? extends VOut> mapper, String queryableName, StoreFactory storeFactory) {
        this.parent = parent;
        this.mapper = mapper;
        this.queryableName = queryableName;
        this.storeFactory = storeFactory;
    }

    @Override
    public Processor<KIn, Change<VIn>, KIn, Change<VOut>> get() {
        return new KTableMapValuesProcessor();
    }

    @Override
    public Set<StoreBuilder<?>> stores() {
        if (this.storeFactory == null) {
            return null;
        }
        return Collections.singleton(new StoreFactory.FactoryWrappingStoreBuilder(this.storeFactory));
    }

    @Override
    public KTableValueGetterSupplier<KIn, VOut> view() {
        if (this.queryableName != null) {
            return new KTableMaterializedValueGetterSupplier(this.queryableName);
        }
        return new KTableValueGetterSupplier<KIn, VOut>(){
            final KTableValueGetterSupplier<KIn, VIn> parentValueGetterSupplier;
            {
                this.parentValueGetterSupplier = KTableMapValues.this.parent.valueGetterSupplier();
            }

            @Override
            public KTableValueGetter<KIn, VOut> get() {
                return new KTableMapValuesValueGetter(this.parentValueGetterSupplier.get());
            }

            @Override
            public String[] storeNames() {
                return this.parentValueGetterSupplier.storeNames();
            }
        };
    }

    @Override
    public boolean enableSendingOldValues(boolean forceMaterialization) {
        if (this.queryableName != null) {
            this.sendOldValues = true;
            return true;
        }
        if (this.parent.enableSendingOldValues(forceMaterialization)) {
            this.sendOldValues = true;
        }
        return this.sendOldValues;
    }

    private VOut computeValue(KIn key, VIn value) {
        VOut newValue = null;
        if (value != null) {
            newValue = this.mapper.apply(key, value);
        }
        return newValue;
    }

    private ValueAndTimestamp<VOut> computeValueAndTimestamp(KIn key, ValueAndTimestamp<VIn> valueAndTimestamp) {
        Object newValue = null;
        long timestamp = 0L;
        if (valueAndTimestamp != null) {
            newValue = this.mapper.apply(key, valueAndTimestamp.value());
            timestamp = valueAndTimestamp.timestamp();
        }
        return ValueAndTimestamp.make(newValue, timestamp);
    }

    private class KTableMapValuesProcessor
    implements Processor<KIn, Change<VIn>, KIn, Change<VOut>> {
        private ProcessorContext<KIn, Change<VOut>> context;
        private KeyValueStoreWrapper<KIn, VOut> store;
        private TimestampedTupleForwarder<KIn, VOut> tupleForwarder;

        private KTableMapValuesProcessor() {
        }

        @Override
        public void init(ProcessorContext<KIn, Change<VOut>> context) {
            this.context = context;
            if (KTableMapValues.this.queryableName != null) {
                this.store = new KeyValueStoreWrapper(context, KTableMapValues.this.queryableName);
                this.tupleForwarder = new TimestampedTupleForwarder(this.store.store(), context, new TimestampedCacheFlushListener(context), KTableMapValues.this.sendOldValues);
            }
        }

        @Override
        public void process(Record<KIn, Change<VIn>> record) {
            Object newValue = KTableMapValues.this.computeValue(record.key(), record.value().newValue);
            Object oldValue = this.computeOldValue(record.key(), record.value());
            if (KTableMapValues.this.queryableName != null) {
                long putReturnCode = this.store.put(record.key(), newValue, record.timestamp());
                if (putReturnCode != Long.MIN_VALUE) {
                    this.tupleForwarder.maybeForward(record.withValue(new Change(newValue, oldValue, putReturnCode == -1L)));
                }
            } else {
                this.context.forward(record.withValue(new Change(newValue, oldValue, record.value().isLatest)));
            }
        }

        private VOut computeOldValue(KIn key, Change<VIn> change) {
            if (!KTableMapValues.this.sendOldValues) {
                return null;
            }
            return KTableMapValues.this.queryableName != null ? ValueAndTimestamp.getValueOrNull(this.store.get(key)) : KTableMapValues.this.computeValue(key, change.oldValue);
        }
    }

    private class KTableMapValuesValueGetter
    implements KTableValueGetter<KIn, VOut> {
        private final KTableValueGetter<KIn, VIn> parentGetter;

        KTableMapValuesValueGetter(KTableValueGetter<KIn, VIn> parentGetter) {
            this.parentGetter = parentGetter;
        }

        @Override
        public void init(ProcessorContext<?, ?> context) {
            this.parentGetter.init(context);
        }

        @Override
        public ValueAndTimestamp<VOut> get(KIn key) {
            return KTableMapValues.this.computeValueAndTimestamp(key, this.parentGetter.get(key));
        }

        @Override
        public ValueAndTimestamp<VOut> get(KIn key, long asOfTimestamp) {
            return KTableMapValues.this.computeValueAndTimestamp(key, this.parentGetter.get(key, asOfTimestamp));
        }

        @Override
        public boolean isVersioned() {
            return this.parentGetter.isVersioned();
        }

        @Override
        public void close() {
            this.parentGetter.close();
        }
    }
}

