
#ifndef KDECORATIONS3_EXPORT_H
#define KDECORATIONS3_EXPORT_H

#ifdef KDECORATIONS3_STATIC_DEFINE
#  define KDECORATIONS3_EXPORT
#  define KDECORATIONS3_NO_EXPORT
#else
#  ifndef KDECORATIONS3_EXPORT
#    ifdef kdecorations3_EXPORTS
        /* We are building this library */
#      define KDECORATIONS3_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KDECORATIONS3_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KDECORATIONS3_NO_EXPORT
#    define KDECORATIONS3_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KDECORATIONS3_DECL_DEPRECATED
#  define KDECORATIONS3_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KDECORATIONS3_DECL_DEPRECATED_EXPORT
#  define KDECORATIONS3_DECL_DEPRECATED_EXPORT KDECORATIONS3_EXPORT KDECORATIONS3_DECL_DEPRECATED
#endif

#ifndef KDECORATIONS3_DECL_DEPRECATED_NO_EXPORT
#  define KDECORATIONS3_DECL_DEPRECATED_NO_EXPORT KDECORATIONS3_NO_EXPORT KDECORATIONS3_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KDECORATIONS3_NO_DEPRECATED
#    define KDECORATIONS3_NO_DEPRECATED
#  endif
#endif

#define KDECORATIONS3_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(KDECORATIONS3_NO_DEPRECATED)
#  undef KDECORATIONS3_DEPRECATED
#  define KDECORATIONS3_DEPRECATED_EXPORT KDECORATIONS3_EXPORT
#  define KDECORATIONS3_DEPRECATED_NO_EXPORT KDECORATIONS3_NO_EXPORT
#elif defined(KDECORATIONS3_NO_DEPRECATED_WARNINGS)
#  define KDECORATIONS3_DEPRECATED
#  define KDECORATIONS3_DEPRECATED_EXPORT KDECORATIONS3_EXPORT
#  define KDECORATIONS3_DEPRECATED_NO_EXPORT KDECORATIONS3_NO_EXPORT
#else
#  define KDECORATIONS3_DEPRECATED KDECORATIONS3_DECL_DEPRECATED
#  define KDECORATIONS3_DEPRECATED_EXPORT KDECORATIONS3_DECL_DEPRECATED_EXPORT
#  define KDECORATIONS3_DEPRECATED_NO_EXPORT KDECORATIONS3_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KDECORATIONS3_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KDECORATIONS3_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KDECORATIONS3_NO_DEPRECATED
#  define KDECORATIONS3_DISABLE_DEPRECATED_BEFORE_AND_AT 0x60400
#endif
#ifdef KDECORATIONS3_NO_DEPRECATED_WARNINGS
#  define KDECORATIONS3_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KDECORATIONS3_DEPRECATED_WARNINGS_SINCE
#  ifdef KDECORATIONS3_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KDECORATIONS3_DEPRECATED_WARNINGS_SINCE KDECORATIONS3_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KDECORATIONS3_DEPRECATED_WARNINGS_SINCE 0x60400
#  endif
#endif

#ifndef KDECORATIONS3_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KDECORATIONS3_DISABLE_DEPRECATED_BEFORE_AND_AT 0x60000
#endif

#ifdef KDECORATIONS3_DEPRECATED
#  define KDECORATIONS3_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KDECORATIONS3_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KDECORATIONS3_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KDECORATIONS3_DEPRECATED_WARNINGS_SINCE >= 0x51500
#  define KDECORATIONS3_DEPRECATED_VERSION_5_21(text) KDECORATIONS3_DECL_DEPRECATED_TEXT(text)
#else
#  define KDECORATIONS3_DEPRECATED_VERSION_5_21(text)
#endif
#define KDECORATIONS3_DEPRECATED_VERSION_5(minor, text)      KDECORATIONS3_DEPRECATED_VERSION_5_##minor(text)
#define KDECORATIONS3_DEPRECATED_VERSION(major, minor, text) KDECORATIONS3_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KDECORATIONS3_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDECORATIONS3_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KDECORATIONS3_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KDECORATIONS3_DEPRECATED_VERSION(major, minor, text)
#  define KDECORATIONS3_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDECORATIONS3_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KDECORATIONS3_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KDECORATIONS3_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KDECORATIONS3_EXPORT_H */
