#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 kmonad
version:              0.4.3
visibility:           public
id:                   kmonad-0.4.3-KMN6kot2p6H6zB7U3CqW54
key:                  kmonad-0.4.3-KMN6kot2p6H6zB7U3CqW54
license:              MIT
maintainer:           janssen.dhj@gmail.com
author:               David Janssen
synopsis:             Advanced keyboard remapping utility
description:
    KMonad is a cross-platform command-line utility that runs as a daemon. It
    captures keyboard input (exactly how depends on the OS) and remaps it. The
    mapping is highly configurable, and provides options like (transparent) layer
    overlays, tap-mod buttons, multi-tap buttons, leader-key style buttons, and
    keyboard macros. Functionality heavily inspired by the QMK-firmware.

category:             Application
abi:                  80888f4a6ffd6fb2735b2d5f5ca5bfc3
exposed:              True
exposed-modules:
    KMonad.App KMonad.App.Main KMonad.App.Types KMonad.Args
    KMonad.Args.Cmd KMonad.Args.Joiner KMonad.Args.Parser
    KMonad.Args.TH KMonad.Args.Types KMonad.Gesture KMonad.Keyboard
    KMonad.Keyboard.ComposeSeq KMonad.Keyboard.IO
    KMonad.Keyboard.IO.Linux.DeviceSource
    KMonad.Keyboard.IO.Linux.Types KMonad.Keyboard.IO.Linux.UinputSink
    KMonad.Keyboard.Keycode KMonad.Keyboard.Ops KMonad.Keyboard.Types
    KMonad.Model KMonad.Model.Action KMonad.Model.BEnv
    KMonad.Model.Button KMonad.Model.Dispatch KMonad.Model.Hooks
    KMonad.Model.Keymap KMonad.Model.Sluice KMonad.Parsing
    KMonad.Prelude KMonad.Prelude.Definitions KMonad.Prelude.Imports
    KMonad.Util KMonad.Util.LayerStack KMonad.Util.MultiMap
    Paths_kmonad

import-dirs:          /usr/lib/ghc-9.4.8/site-local/kmonad-0.4.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/kmonad-0.4.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/kmonad-0.4.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/kmonad
hs-libraries:         HSkmonad-0.4.3-KMN6kot2p6H6zB7U3CqW54
depends:
    base-4.17.2.1 cereal-0.5.8.3-H9MXf6i1TMkEAfnsx4oYbT
    lens-5.2.3-ECHdyiBhGt3AEK5VHs81a3
    megaparsec-9.6.1-iLYYaEwT1u7mxYx9b63Ap mtl-2.2.2
    optparse-applicative-0.17.1.0-3m15PZJ9R8tLZfnW85Yn0z
    resourcet-1.2.6-F9Fn1s8Ehj0BYy7paIyOT3
    rio-0.1.22.0-1juuKEAULP64bFli0bvHY template-haskell-2.19.0.0
    time-1.12.2 unix-2.7.3 unliftio-0.2.25.1-KoAUwIIyk4m4OHQUsvge0I

haddock-interfaces:   /usr/share/doc/kmonad/html/kmonad.haddock
haddock-html:         /usr/share/doc/kmonad/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

