/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.SwingErrorDialog;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lmediathek/gui/actions/ShowOnlineFaqAction;", "Ljavax/swing/AbstractAction;", "ui", "Lmediathek/mainwindow/MediathekGui;", "<init>", "(Lmediathek/mainwindow/MediathekGui;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "MediathekView"})
public final class ShowOnlineFaqAction
extends AbstractAction {
    @NotNull
    private final MediathekGui ui;

    public ShowOnlineFaqAction(@NotNull MediathekGui ui) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        this.ui = ui;
        this.putValue("Name", "Frequently Asked Questions (FAQs) anzeigen...");
        this.putValue("SmallIcon", SVGIconUtilities.createSVGIcon("icons/fontawesome/circle-question.svg"));
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (Desktop.isDesktopSupported()) {
            Desktop d = Desktop.getDesktop();
            if (d.isSupported(Desktop.Action.BROWSE)) {
                try {
                    d.browse(new URI("https://mediathekview.de/faq/"));
                }
                catch (IOException ex) {
                    SwingErrorDialog.showExceptionMessage(this.ui, "Es trat ein Fehler beim \u00d6ffnen der Online-Hilfe auf.\nSollte dies h\u00e4ufiger auftreten kontaktieren Sie bitte das Entwicklerteam.", ex);
                }
                catch (URISyntaxException ex) {
                    SwingErrorDialog.showExceptionMessage(this.ui, "Es trat ein Fehler beim \u00d6ffnen der Online-Hilfe auf.\nSollte dies h\u00e4ufiger auftreten kontaktieren Sie bitte das Entwicklerteam.", ex);
                }
            } else {
                JOptionPane.showMessageDialog(this.ui, "<html>Ihr Betriebssystem unterst\u00fctzt das \u00d6ffnen des Browsers nicht.<br>Bitte \u00f6ffnen Sie <b>https://mediathekview.de/faq/</b> selbst in Ihrem Browser.</html>", "MediathekView", 0);
            }
        }
    }
}

