/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions.export;

import java.io.File;
import java.nio.file.FileStore;
import java.nio.file.Files;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lmediathek/gui/actions/export/DiskSpaceUtil;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "enoughDiskSpace", "", "selectedFile", "Ljava/io/File;", "MediathekView"})
public final class DiskSpaceUtil {
    @NotNull
    public static final DiskSpaceUtil INSTANCE = new DiskSpaceUtil();
    private static final Logger logger = LogManager.getLogger();

    private DiskSpaceUtil() {
    }

    public final boolean enoughDiskSpace(@NotNull File selectedFile) {
        Intrinsics.checkNotNullParameter((Object)selectedFile, (String)"selectedFile");
        try {
            boolean tempFileCreated = false;
            if (!selectedFile.exists()) {
                selectedFile.createNewFile();
                tempFileCreated = true;
            }
            FileStore store = Files.getFileStore(selectedFile.toPath());
            long availFreeSpace = store.getUsableSpace() / (long)0x100000;
            if (tempFileCreated) {
                selectedFile.delete();
            }
            return availFreeSpace >= 1024L;
        }
        catch (Exception e) {
            logger.error("enoughDiskSpace failed!", (Throwable)e);
            return true;
        }
    }
}

