/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import mediathek.config.Daten;
import mediathek.config.MVColor;
import mediathek.daten.abo.AboTags;
import mediathek.daten.abo.DatenAbo;
import mediathek.daten.abo.FilmLengthState;
import mediathek.gui.dialog.DialogAboNoSet;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.FilenameUtils;
import mediathek.tool.GetFile;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.SenderListComboBoxModel;
import org.jetbrains.annotations.NotNull;

public class DialogEditAbo
extends JDialog {
    private final DatenAbo aktAbo;
    private final EnumMap<AboTags, JTextField> textFieldMap = new EnumMap(AboTags.class);
    private final JComboBox<String> comboboxPSet = new JComboBox();
    private final JComboBox<String> comboboxSender = new JComboBox();
    private final JComboBox<String> comboboxPfad = new JComboBox();
    private final JCheckBox checkBoxEingeschaltet = new JCheckBox();
    private final JRadioButton rbMin = new JRadioButton("Mindestdauer");
    private final JRadioButton rbMax = new JRadioButton("Maximaldauer");
    private final JSlider sliderDauer = new JSlider(0, 100, 0);
    private final JLabel labelDauer = new JLabel("0");
    private final boolean isMultiEditMode;
    private static final String TEXTFIELD_BACKGROUND = "TextField.background";
    public final boolean[] multiEditCbIndices = new boolean[AboTags.getEntries().size()];
    private boolean ok;
    private final EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
    private JButton jButtonAbbrechen;
    private JButton jButtonBeenden;
    private JButton jButtonHelp;
    private JPanel jPanelExtra;
    private JScrollPane jScrollPane1;

    public DialogEditAbo(JFrame parent, DatenAbo aktA, boolean isMultiEditMode) {
        super((Frame)parent, true);
        this.initComponents();
        Daten daten = Daten.getInstance();
        this.isMultiEditMode = isMultiEditMode;
        this.aktAbo = aktA;
        ButtonGroup gr = new ButtonGroup();
        gr.add(this.rbMin);
        gr.add(this.rbMax);
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(16);
        this.comboboxPSet.setModel(new DefaultComboBoxModel<String>(Daten.listePset.getListeAbo().getObjectDataCombo()));
        this.comboboxSender.setModel((ComboBoxModel<String>)((Object)new SenderListComboBoxModel()));
        ArrayList<String> pfade = daten.getListeAbo().getPfade();
        if (!pfade.contains(this.aktAbo.getZielpfad())) {
            pfade.addFirst(this.aktAbo.getZielpfad());
        }
        this.comboboxPfad.setModel(new DefaultComboBoxModel<String>(pfade.toArray(new String[0])));
        this.comboboxPfad.setEditable(true);
        this.checkPfad();
        JTextComponent editorComp = (JTextComponent)this.comboboxPfad.getEditor().getEditorComponent();
        editorComp.setOpaque(true);
        editorComp.getDocument().addDocumentListener(new CheckPathDocListener());
        this.jButtonBeenden.addActionListener(actionEvent -> {
            if (this.check()) {
                this.dispose();
            } else {
                MVMessageDialog.showMessageDialog(parent, "Filter angeben!", "Leeres Abo", 0);
            }
        });
        this.jButtonAbbrechen.addActionListener(actionEvent -> this.dispose());
        this.getRootPane().setDefaultButton(this.jButtonBeenden);
        EscapeKeyHandler.installHandler(this, this::dispose);
        this.jButtonHelp.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/circle-question.svg"));
        this.jButtonHelp.addActionListener(actionEvent -> {
            new GetFile();
            new DialogHilfe(parent, true, GetFile.getHilfeSuchen("hilfetext_dialog_add_abo.txt")).setVisible(true);
        });
        if (this.comboboxPSet.getModel().getSize() == 0) {
            new DialogAboNoSet(parent).setVisible(true);
        } else {
            this.setExtra();
            this.pack();
        }
        GuiFunktionen.centerOnScreen(this, false);
    }

    public boolean successful() {
        return this.ok;
    }

    @Override
    public void setVisible(boolean vis) {
        if (this.comboboxPSet.getModel().getSize() == 0) {
            this.dispose();
        } else {
            super.setVisible(vis);
        }
    }

    private void checkPfad() {
        String s = ((JTextComponent)this.comboboxPfad.getEditor().getEditorComponent()).getText();
        Component editor = this.comboboxPfad.getEditor().getEditorComponent();
        if (!s.equals(FilenameUtils.checkDateiname(s, false))) {
            editor.setBackground(MVColor.DOWNLOAD_FEHLER.color);
        } else {
            editor.setBackground(UIManager.getColor(TEXTFIELD_BACKGROUND));
        }
    }

    private void setExtra() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 10, 10, 5);
        this.jPanelExtra.setLayout(gridbag);
        int zeile = 1;
        if (this.isMultiEditMode) {
            c.gridx = 2;
            c.weightx = 1.0;
            JLabel label = new JLabel("<html><style type=\"text/css\"> p { text-align: center; }</style><p>bei allen<br />\u00e4ndern</p></html>");
            CompoundBorder border = new CompoundBorder(BorderFactory.createLineBorder(new Color(204, 204, 255), 4, true), this.emptyBorder);
            label.setBorder(border);
            gridbag.setConstraints(label, c);
            this.jPanelExtra.add(label);
            c.gridy = 1;
        } else {
            zeile = 0;
            c.gridy = 0;
        }
        for (AboTags tag : AboTags.getEntries()) {
            c.fill = 2;
            c.anchor = 17;
            this.addExtraFeld(tag, gridbag, c, this.jPanelExtra);
            c.gridy = ++zeile;
        }
    }

    private JTextField createTextField(@NotNull String displayText, GridBagLayout gridbag, GridBagConstraints c) {
        JTextField tf = new JTextField();
        tf.setText(displayText);
        gridbag.setConstraints(tf, c);
        return tf;
    }

    private JLabel createLabel(@NotNull AboTags tag, GridBagLayout gridbag, GridBagConstraints c) {
        JLabel label;
        switch (tag) {
            case SENDER: 
            case THEMA: 
            case TITEL: 
            case THEMA_TITEL: 
            case IRGENDWO: {
                label = new JLabel(DatenAbo.COLUMN_NAMES[tag.getIndex()] + ":");
                label.setForeground(MVColor.getBlueColor());
                break;
            }
            case MINDESTDAUER: {
                label = new JLabel("Dauer [min]: ");
                break;
            }
            default: {
                label = new JLabel(DatenAbo.COLUMN_NAMES[tag.getIndex()] + ":");
            }
        }
        gridbag.setConstraints(label, c);
        return label;
    }

    private void addExtraFeld(AboTags index, GridBagLayout gridbag, GridBagConstraints c, JPanel panel) {
        c.gridx = 0;
        c.weightx = 0.0;
        panel.add(this.createLabel(index, gridbag, c));
        c.gridx = 1;
        c.weightx = 10.0;
        switch (index) {
            case NR: {
                JLabel lbl = new JLabel();
                int nr = this.aktAbo.getNr();
                if (nr > 0) {
                    lbl.setText(Integer.toString(this.aktAbo.getNr()));
                } else {
                    lbl.setText("noch nicht vergeben");
                }
                gridbag.setConstraints(lbl, c);
                panel.add(lbl);
                break;
            }
            case EINGESCHALTET: {
                this.checkBoxEingeschaltet.setSelected(this.aktAbo.isActive());
                gridbag.setConstraints(this.checkBoxEingeschaltet, c);
                panel.add(this.checkBoxEingeschaltet);
                break;
            }
            case NAME: {
                JTextField tf = this.createTextField(this.aktAbo.getName(), gridbag, c);
                tf.getDocument().addDocumentListener(new EmptyTextDocListener(tf));
                this.textFieldMap.put(index, tf);
                panel.add(tf);
                break;
            }
            case SENDER: {
                this.comboboxSender.setSelectedItem(this.aktAbo.getSender());
                gridbag.setConstraints(this.comboboxSender, c);
                panel.add(this.comboboxSender);
                break;
            }
            case THEMA: {
                JTextField tf = this.createTextField(this.aktAbo.getThema(), gridbag, c);
                this.textFieldMap.put(index, tf);
                panel.add(tf);
                break;
            }
            case TITEL: {
                JTextField tf = this.createTextField(this.aktAbo.getTitle(), gridbag, c);
                this.textFieldMap.put(index, tf);
                panel.add(tf);
                break;
            }
            case THEMA_TITEL: {
                JTextField tf = this.createTextField(this.aktAbo.getThemaTitel(), gridbag, c);
                this.textFieldMap.put(index, tf);
                panel.add(tf);
                break;
            }
            case IRGENDWO: {
                JTextField tf = this.createTextField(this.aktAbo.getIrgendwo(), gridbag, c);
                this.textFieldMap.put(index, tf);
                panel.add(tf);
                break;
            }
            case MINDESTDAUER: {
                int minDauer = this.aktAbo.getMindestDauerMinuten();
                this.sliderDauer.setValue(minDauer);
                this.labelDauer.setText(String.valueOf(minDauer == 0 ? " alles " : Integer.valueOf(minDauer)));
                this.sliderDauer.addChangeListener(changeEvent -> this.labelDauer.setText("  " + (this.sliderDauer.getValue() == 0 ? "alles" : Integer.toString(this.sliderDauer.getValue()))));
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)this.sliderDauer, "Center");
                p.add((Component)this.labelDauer, "East");
                gridbag.setConstraints(p, c);
                panel.add(p);
                break;
            }
            case MIN: {
                boolean isMin = this.aktAbo.getFilmLengthState() == FilmLengthState.MINIMUM;
                this.rbMin.setSelected(isMin);
                this.rbMax.setSelected(!isMin);
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)this.rbMin, "North");
                p.add((Component)this.rbMax, "Center");
                gridbag.setConstraints(p, c);
                panel.add(p);
                break;
            }
            case ZIELPFAD: {
                this.comboboxPfad.setSelectedItem(this.aktAbo.getZielpfad());
                gridbag.setConstraints(this.comboboxPfad, c);
                panel.add(this.comboboxPfad);
                break;
            }
            case DOWN_DATUM: {
                JLabel p = new JLabel(this.aktAbo.getDownDatum());
                gridbag.setConstraints(p, c);
                panel.add(p);
                break;
            }
            case PSET: {
                this.comboboxPSet.setSelectedItem(this.aktAbo.getPsetName());
                this.aktAbo.setPsetName(Objects.requireNonNull(this.comboboxPSet.getSelectedItem()).toString());
                gridbag.setConstraints(this.comboboxPSet, c);
                panel.add(this.comboboxPSet);
            }
        }
        if (this.isMultiEditMode) {
            c.gridx = 2;
            c.weightx = 0.0;
            switch (index) {
                case MINDESTDAUER: 
                case EINGESCHALTET: 
                case MIN: 
                case ZIELPFAD: 
                case PSET: {
                    c.fill = 0;
                    c.anchor = 10;
                    JCheckBox jcb = new JCheckBox();
                    jcb.setBorder(this.emptyBorder);
                    jcb.setHorizontalTextPosition(0);
                    jcb.addActionListener(actionEvent -> {
                        this.multiEditCbIndices[index.getIndex()] = jcb.isSelected();
                    });
                    gridbag.setConstraints(jcb, c);
                    panel.add(jcb);
                }
            }
        }
    }

    private boolean check() {
        DatenAbo test = this.aktAbo.getCopy();
        this.get(test);
        if (test.isInvalid()) {
            this.ok = false;
        } else {
            this.get(this.aktAbo);
            this.ok = true;
        }
        return this.ok;
    }

    private void get(DatenAbo abo) {
        abo.setActive(this.checkBoxEingeschaltet.isSelected());
        abo.setName(this.textFieldMap.get((Object)AboTags.NAME).getText().trim());
        abo.setSender(Objects.requireNonNull(this.comboboxSender.getSelectedItem()).toString());
        abo.setThema(this.textFieldMap.get((Object)AboTags.THEMA).getText().trim());
        abo.setTitle(this.textFieldMap.get((Object)AboTags.TITEL).getText().trim());
        abo.setThemaTitel(this.textFieldMap.get((Object)AboTags.THEMA_TITEL).getText().trim());
        abo.setIrgendwo(this.textFieldMap.get((Object)AboTags.IRGENDWO).getText().trim());
        abo.setMindestDauerMinuten(this.sliderDauer.getValue());
        if (this.rbMin.isSelected()) {
            abo.setFilmLengthState(FilmLengthState.MINIMUM);
        } else {
            abo.setFilmLengthState(FilmLengthState.MAXIMUM);
        }
        abo.setZielpfad(Objects.requireNonNull(this.comboboxPfad.getSelectedItem()).toString());
        abo.setPsetName(Objects.requireNonNull(this.comboboxPSet.getSelectedItem()).toString());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanelExtra = new JPanel();
        this.jButtonAbbrechen = new JButton();
        this.jButtonBeenden = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Neues Abo anlegen");
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.jPanelExtra);
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jButtonBeenden.setText("Ok");
        this.jButtonHelp.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHelp.setToolTipText("Hilfe anzeigen");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonBeenden, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAbbrechen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp))).addContainerGap()));
        layout.linkSize(0, this.jButtonAbbrechen, this.jButtonBeenden);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonBeenden).addComponent(this.jButtonAbbrechen).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private class CheckPathDocListener
    implements DocumentListener {
        private CheckPathDocListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DialogEditAbo.this.checkPfad();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DialogEditAbo.this.checkPfad();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DialogEditAbo.this.checkPfad();
        }
    }

    private class EmptyTextDocListener
    implements DocumentListener {
        private final JTextField tf;

        public EmptyTextDocListener(JTextField tf) {
            this.tf = tf;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            boolean isEmpty = this.tf.getText().isBlank();
            this.tf.setBackground(isEmpty ? Color.red : UIManager.getColor(DialogEditAbo.TEXTFIELD_BACKGROUND));
            DialogEditAbo.this.jButtonBeenden.setEnabled(!isEmpty);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            boolean isEmpty = this.tf.getText().isBlank();
            this.tf.setBackground(isEmpty ? Color.red : UIManager.getColor(DialogEditAbo.TEXTFIELD_BACKGROUND));
            DialogEditAbo.this.jButtonBeenden.setEnabled(!isEmpty);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            boolean isEmpty = this.tf.getText().isBlank();
            this.tf.setBackground(isEmpty ? Color.red : UIManager.getColor(DialogEditAbo.TEXTFIELD_BACKGROUND));
            DialogEditAbo.this.jButtonBeenden.setEnabled(!isEmpty);
        }
    }
}

