/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.bookmark;

import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.swing.SwingUtilities;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import mediathek.config.Daten;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.gui.dialog.DialogAddDownload;
import mediathek.gui.messages.BookmarkDeleteRepaintEvent;
import mediathek.javafx.bookmark.BookmarkData;
import mediathek.javafx.bookmark.BookmarkDateComparator;
import mediathek.javafx.bookmark.BookmarkNoteDialogController;
import mediathek.javafx.bookmark.FilterState;
import mediathek.javafx.bookmark.TableViewColumnContextMenuHelper;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import mediathek.tool.timer.TimerPool;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BookmarkWindowController
implements Initializable {
    private static final Logger logger = LogManager.getLogger();
    private FilterState filterState = FilterState.UNDEFINED;
    private Stage stage;
    private FilteredList<BookmarkData> filteredBookmarkList;
    private MenuItem playitem;
    private MenuItem loaditem;
    private MenuItem deleteitem;
    private MenuItem viewitem;
    private MenuItem webitem;
    private MenuItem edititem;
    private ContextMenu cellContextMenu;
    private double divposition;
    private boolean listUpdated = false;
    private ScheduledFuture<?> SaveBookmarkTask;
    @FXML
    private Button btnSaveList;
    @FXML
    private Button btnDeleteEntry;
    @FXML
    private Button btnMarkViewed;
    @FXML
    private ToggleButton btnShowDetails;
    @FXML
    private Button btnFilter;
    @FXML
    private Button btnEditNote;
    @FXML
    private TableView<BookmarkData> tbBookmarks;
    @FXML
    private TableColumn<BookmarkData, String> colSender;
    @FXML
    private TableColumn<BookmarkData, String> colTheme;
    @FXML
    private TableColumn<BookmarkData, String> colTitle;
    @FXML
    private TableColumn<BookmarkData, String> colDuration;
    @FXML
    private TableColumn<BookmarkData, String> colRunDate;
    @FXML
    private TableColumn<BookmarkData, String> colBtnPlay;
    @FXML
    private TableColumn<BookmarkData, String> colBtnDownload;
    @FXML
    private TableColumn<BookmarkData, String> colNote;
    @FXML
    private Label lblCount;
    @FXML
    private Label lblFilter;
    @FXML
    private TextArea taDescription;
    @FXML
    private SplitPane spSplitPane;
    @FXML
    private Hyperlink hyperLink;

    public BookmarkWindowController() {
        Font.loadFont((InputStream)BookmarkWindowController.class.getResourceAsStream("/mediathek/res/programm/fxml/fontawesome-webfont.ttf"), (double)16.0);
    }

    private void setStageSize() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            this.stage.setWidth((double)config.getInt("application.ui.bookmarklist.width", 640));
            this.stage.setHeight((double)config.getInt("application.ui.bookmarklist.heigth", 480));
            this.stage.setX((double)config.getInt("application.ui.bookmarklist.location.x", 0));
            this.stage.setY((double)config.getInt("application.ui.bookmarklist.location.y", 0));
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    @FXML
    private void btnMarkEntryAsViewed(Event e) {
        ObservableList selections = this.tbBookmarks.getSelectionModel().getSelectedItems();
        if (!selections.isEmpty()) {
            boolean hasUnSeen = this.isUnSeenSelected();
            ArrayList filmlist = new ArrayList();
            selections.forEach(data -> {
                data.setSeen(hasUnSeen);
                DatenFilm film = data.getDatenFilm();
                if (film != null) {
                    filmlist.add(film);
                }
            });
            try (SeenHistoryController history = new SeenHistoryController();){
                if (hasUnSeen) {
                    history.markSeen(filmlist);
                } else {
                    history.markUnseen(filmlist);
                }
            }
            this.setSeenButtonState(hasUnSeen, (ObservableList<BookmarkData>)selections);
            this.tbBookmarks.getSelectionModel().clearSelection();
            selections.forEach(data -> this.tbBookmarks.getSelectionModel().select(data));
        }
    }

    @FXML
    private void btnSaveBookMarkList(Event e) {
        this.cancelBookmarkSave();
        this.saveBookMarkList();
    }

    @FXML
    private void btnDeleteEntry(Event e) {
        TableView.TableViewSelectionModel selModel = this.tbBookmarks.getSelectionModel();
        ObservableList items = selModel.getSelectedItems();
        if (!items.isEmpty()) {
            Daten.getInstance().getListeBookmarkList().deleteEntries((List<BookmarkData>)items);
            this.updateDisplay();
            selModel.clearSelection();
            MessageBus.getMessageBus().publishAsync((Object)new BookmarkDeleteRepaintEvent());
        }
    }

    @FXML
    private void btnEditNote(Event e) {
        try {
            BookmarkNoteDialogController noteDialogController = new BookmarkNoteDialogController();
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/mediathek/res/programm/fxml/bookmarkNoteDialog.fxml"));
            fxmlLoader.setController((Object)noteDialogController);
            Stage noteDialog = new Stage();
            noteDialog.initModality(Modality.WINDOW_MODAL);
            noteDialog.initOwner((Window)this.stage);
            noteDialog.getIcons().add((Object)new Image("/mediathek/res/MediathekView.png"));
            noteDialog.setScene(new Scene((Parent)fxmlLoader.load()));
            if (noteDialogController.setAndShow(noteDialog, (BookmarkData)this.tbBookmarks.getSelectionModel().getSelectedItem())) {
                this.listUpdated = true;
                this.refresh();
            }
        }
        catch (IOException ex) {
            logger.error("Can't find/load the FXML description!", (Throwable)ex);
        }
    }

    private void hyperLinkSelected(Event e) {
        String url = ((BookmarkData)this.tbBookmarks.getSelectionModel().getSelectedItem()).getWebUrl();
        if (url != null) {
            try {
                UrlHyperlinkAction.openURL(url);
            }
            catch (URISyntaxException ex) {
                logger.error("Hyperlink Syntax exception", (Throwable)ex);
            }
        }
    }

    private void setupTableColumns() {
        this.colSender.setCellValueFactory(param -> {
            DatenFilm film = ((BookmarkData)param.getValue()).getDatenFilm();
            if (film != null) {
                return new SimpleStringProperty(film.getSender());
            }
            return null;
        });
        this.colTheme.setCellValueFactory(param -> {
            DatenFilm film = ((BookmarkData)param.getValue()).getDatenFilm();
            if (film != null) {
                return new SimpleStringProperty(film.getThema());
            }
            return null;
        });
        this.colTitle.setCellValueFactory(param -> {
            DatenFilm film = ((BookmarkData)param.getValue()).getDatenFilm();
            if (film != null) {
                return new SimpleStringProperty(film.getTitle());
            }
            return new SimpleStringProperty("Kein Film gefunden!");
        });
        this.colDuration.setCellValueFactory(param -> {
            DatenFilm film = ((BookmarkData)param.getValue()).getDatenFilm();
            if (film != null) {
                return new SimpleStringProperty(film.getFilmLengthAsString());
            }
            return null;
        });
        this.colRunDate.setCellValueFactory(param -> {
            DatenFilm film = ((BookmarkData)param.getValue()).getDatenFilm();
            if (film != null) {
                return new SimpleStringProperty(film.getSendeDatum());
            }
            return null;
        });
        this.colRunDate.setComparator((Comparator)new BookmarkDateComparator());
        this.colNote.setCellValueFactory((Callback)new PropertyValueFactory("note"));
        this.colBtnPlay.setCellFactory(tableColumn -> new TableCell<BookmarkData, String>(){

            public void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || ((BookmarkData)this.getTableView().getItems().get(this.getIndex())).isNotInFilmList()) {
                    this.setGraphic(null);
                } else {
                    this.setGraphic((Node)new IconNode((IconCode)FontAwesome.PLAY));
                    this.setOnMouseClicked(mouseEvent -> BookmarkWindowController.this.playAction((BookmarkData)this.getTableView().getItems().get(this.getIndex())));
                }
            }
        });
        this.colBtnDownload.setCellFactory(tableColumn -> new TableCell<BookmarkData, String>(){

            public void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || ((BookmarkData)this.getTableView().getItems().get(this.getIndex())).isNotInFilmList()) {
                    this.setGraphic(null);
                } else {
                    this.setGraphic((Node)new IconNode((IconCode)FontAwesome.DOWNLOAD));
                    this.setOnMouseClicked(mouseEvent -> BookmarkWindowController.this.loadAction((BookmarkData)this.getTableView().getItems().get(this.getIndex())));
                }
            }
        });
    }

    private void setupTableView() {
        ObservableList<BookmarkData> observableList = Daten.getInstance().getListeBookmarkList().getObervableList();
        this.filteredBookmarkList = new FilteredList(observableList, null);
        SortedList sortedBookmarkList = new SortedList(this.filteredBookmarkList);
        sortedBookmarkList.comparatorProperty().bind((ObservableValue)this.tbBookmarks.comparatorProperty());
        observableList.addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded() && !c.wasRemoved() && !c.wasUpdated()) continue;
                this.listUpdated = true;
                break;
            }
            this.tbBookmarks.refresh();
            this.updateDisplay();
        });
        this.tbBookmarks.setItems((ObservableList)sortedBookmarkList);
        this.tbBookmarks.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tbBookmarks.getSelectionModel().selectedIndexProperty().addListener((observableValue, number, newSelection) -> {
            boolean disable = newSelection == null || newSelection.intValue() == -1;
            TableView.TableViewSelectionModel selModel = this.tbBookmarks.getSelectionModel();
            ObservableList items = selModel.getSelectedItems();
            boolean multipleSelected = items.size() > 1;
            this.btnDeleteEntry.setDisable(disable);
            this.btnMarkViewed.setDisable(disable || this.onlyLifeStreamSelected());
            disable = disable || multipleSelected;
            this.btnEditNote.setDisable(disable);
            this.playitem.setDisable(disable);
            this.edititem.setDisable(disable);
            this.loaditem.setDisable(disable);
            this.viewitem.setDisable(this.onlyLifeStreamSelected());
            this.webitem.setDisable(disable || ((BookmarkData)selModel.getSelectedItem()).getWebUrl() == null);
            boolean setViewed = this.isUnSeenSelected();
            this.setSeenButtonState(setViewed, (ObservableList<BookmarkData>)items);
            this.deleteitem.setText(String.format("Film%s aus der Merkliste entfernen", multipleSelected ? "e" : ""));
            this.updateDescriptionArea();
        });
        this.tbBookmarks.getSortOrder().addListener(change -> this.tbBookmarks.getSelectionModel().clearSelection());
    }

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.restoreTableStateAndContextMenu();
        this.setupTableColumns();
        this.setupTableView();
        this.tbBookmarks.setOnContextMenuRequested(this::tbviewOnContextRequested);
        this.tbBookmarks.setOnMouseClicked(this::tbviewMouseClick);
        this.hyperLink.setOnAction(this::hyperLinkSelected);
        this.btnFilterAction(null);
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.btnShowDetails.setSelected(config.getBoolean("application.ui.bookmarklist.details", true));
        this.divposition = config.getDouble("application.ui.bookmarklist.divider", this.spSplitPane.getDividerPositions()[0]);
        this.btnShowDetailsAction(null);
        this.updateDescriptionArea();
        this.setupColumnContextMenu();
        this.setupButtons();
    }

    private void setupButtons() {
        try {
            this.btnDeleteEntry.setOnAction(this::btnDeleteEntry);
            this.btnDeleteEntry.setGraphic((Node)new IconNode((IconCode)FontAwesome.TRASH));
            this.btnMarkViewed.setOnAction(this::btnMarkEntryAsViewed);
            this.btnMarkViewed.setGraphic((Node)new IconNode((IconCode)FontAwesome.EYE));
            this.btnEditNote.setOnAction(this::btnEditNote);
            this.btnEditNote.setGraphic((Node)new IconNode((IconCode)FontAwesome.PENCIL));
            this.btnSaveList.setOnAction(this::btnSaveBookMarkList);
            this.btnSaveList.setGraphic((Node)new IconNode((IconCode)FontAwesome.FLOPPY_O));
            this.btnShowDetails.setOnAction(this::btnShowDetailsAction);
            this.btnShowDetails.setGraphic((Node)new IconNode((IconCode)FontAwesome.INFO_CIRCLE));
            this.btnFilter.setOnAction(this::btnFilterAction);
            this.btnFilter.setGraphic((Node)new IconNode((IconCode)FontAwesome.FILTER));
        }
        catch (Exception e) {
            logger.error("Could not load fontawesome font", (Throwable)e);
        }
    }

    private void setupColumnContextMenu() {
        this.tbBookmarks.setTableMenuButtonVisible(true);
        new TableViewColumnContextMenuHelper(this, this.tbBookmarks){

            @Override
            protected CustomMenuItem createColumnCustomMenuItem(ContextMenu contextMenu, TableColumn<?, ?> column) {
                CheckBox checkBox;
                String columnText = column.getText();
                if (!columnText.isEmpty()) {
                    checkBox = new CheckBox(columnText);
                } else {
                    checkBox = new CheckBox(" ");
                    IconNode icon = switch (column.getId()) {
                        case "colBtnPlay" -> new IconNode((IconCode)FontAwesome.PLAY);
                        case "colBtnDownload" -> new IconNode((IconCode)FontAwesome.DOWNLOAD);
                        default -> throw new IllegalStateException("unknown id");
                    };
                    checkBox.setGraphic((Node)icon);
                }
                checkBox.selectedProperty().bindBidirectional((Property)column.visibleProperty());
                CustomMenuItem customMenuItem = new CustomMenuItem((Node)checkBox);
                customMenuItem.setOnAction(event -> {
                    checkBox.setSelected(!checkBox.isSelected());
                    event.consume();
                });
                customMenuItem.setHideOnClick(false);
                return customMenuItem;
            }
        };
    }

    private void updateDescriptionArea() {
        String url;
        boolean showurl = false;
        TableView.TableViewSelectionModel model = this.tbBookmarks.getSelectionModel();
        this.taDescription.setText(model.getSelectedItems().size() == 1 ? ((BookmarkData)model.getSelectedItem()).getExtendedDescription() : "");
        if (model.getSelectedItems().size() == 1 && (url = ((BookmarkData)model.getSelectedItem()).getWebUrl()) != null && !url.isEmpty()) {
            this.hyperLink.setTooltip(new Tooltip(url));
            this.hyperLink.setVisited(false);
            showurl = true;
        }
        this.hyperLink.setVisible(showurl);
    }

    private void setSeenButtonState(boolean setViewed, @NotNull ObservableList<BookmarkData> items) {
        boolean multipleSelected = items.size() > 1;
        this.btnMarkViewed.setGraphic((Node)new IconNode((IconCode)(setViewed ? FontAwesome.EYE : FontAwesome.EYE_SLASH)));
        String text = String.format("Film%s als %sgesehen markieren", multipleSelected ? "e" : "", setViewed ? "" : "un");
        this.btnMarkViewed.setTooltip(new Tooltip(text));
        this.viewitem.setText(text);
        this.viewitem.setGraphic((Node)new IconNode((IconCode)(setViewed ? FontAwesome.EYE : FontAwesome.EYE_SLASH)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreTableStateAndContextMenu() {
        this.cellContextMenu = new ContextMenu();
        this.playitem = new MenuItem("Film abspielen");
        this.playitem.setOnAction(actionEvent -> this.playAction((BookmarkData)this.tbBookmarks.getSelectionModel().getSelectedItem()));
        this.playitem.setGraphic((Node)new IconNode((IconCode)FontAwesome.PLAY));
        this.loaditem = new MenuItem("Film aufzeichnen");
        this.loaditem.setOnAction(actionEvent -> this.loadAction((BookmarkData)this.tbBookmarks.getSelectionModel().getSelectedItem()));
        this.loaditem.setGraphic((Node)new IconNode((IconCode)FontAwesome.DOWNLOAD));
        this.viewitem = new MenuItem();
        this.viewitem.setOnAction(this::btnMarkEntryAsViewed);
        this.edititem = new MenuItem("Anmerkungen bearbeiten");
        this.edititem.setOnAction(this::btnEditNote);
        this.edititem.setGraphic((Node)new IconNode((IconCode)FontAwesome.PENCIL));
        this.deleteitem = new MenuItem();
        this.deleteitem.setOnAction(this::btnDeleteEntry);
        this.deleteitem.setGraphic((Node)new IconNode((IconCode)FontAwesome.MINUS));
        this.webitem = new MenuItem("Film Webseite \u00f6ffnen");
        this.webitem.setOnAction(this::hyperLinkSelected);
        this.cellContextMenu.getItems().addAll((Object[])new MenuItem[]{this.playitem, this.loaditem, this.viewitem, new SeparatorMenuItem(), this.edititem, this.deleteitem, new SeparatorMenuItem(), this.webitem});
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            String colbase = "application.ui.bookmarklist.columns.";
            int entries = config.getInt(colbase + "no", 0);
            if (entries > 0) {
                ArrayList collist = new ArrayList(this.tbBookmarks.getColumns());
                this.tbBookmarks.getColumns().clear();
                block3: for (int i = 1; i <= entries; ++i) {
                    String colref = colbase + "col" + i;
                    String colid = config.getString(colref + ".id");
                    int colsize = config.getInt(colref + ".size", 20);
                    boolean colvisible = config.getBoolean(colref + ".visible", true);
                    for (TableColumn column : collist) {
                        if (!column.getId().equals(colid)) continue;
                        column.setPrefWidth((double)colsize);
                        column.setVisible(colvisible);
                        this.tbBookmarks.getColumns().add((Object)column);
                        continue block3;
                    }
                }
            }
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    @FXML
    private void btnShowDetailsAction(ActionEvent event) {
        double newposition;
        if (this.btnShowDetails.isSelected()) {
            newposition = this.divposition;
        } else {
            this.divposition = this.spSplitPane.getDividerPositions()[0];
            newposition = 1.0;
        }
        this.spSplitPane.setDividerPositions(new double[]{newposition});
    }

    private void updateFilterState() {
        this.filterState = this.filterState.next();
        switch (this.filterState) {
            case ALL: {
                this.filteredBookmarkList.setPredicate(null);
                break;
            }
            case UNSEEN: {
                this.filteredBookmarkList.setPredicate(BookmarkData::getNotSeen);
                break;
            }
            case SEEN: {
                this.filteredBookmarkList.setPredicate(BookmarkData::getSeen);
            }
        }
    }

    @FXML
    private void btnFilterAction(ActionEvent e) {
        this.updateFilterState();
        this.btnFilter.setTooltip(new Tooltip(this.filterState.tooltipText()));
        this.lblFilter.setText(this.filterState.messageText());
        this.refresh();
    }

    private void tbviewOnContextRequested(ContextMenuEvent event) {
        if (!this.tbBookmarks.getSelectionModel().getSelectedItems().isEmpty()) {
            this.cellContextMenu.show(this.tbBookmarks, event.getScreenX(), event.getScreenY());
        }
    }

    private void tbviewMouseClick(MouseEvent e) {
        if (e.getButton() == MouseButton.PRIMARY) {
            if (this.cellContextMenu.isShowing()) {
                this.cellContextMenu.hide();
            }
            if (e.getClickCount() > 1 && this.tbBookmarks.getSelectionModel().getSelectedItems().size() == 1) {
                this.btnEditNote(null);
            }
        }
    }

    private Stage createStage() {
        Stage stage = new Stage();
        stage.setTitle("Merkliste verwalten");
        stage.getIcons().add((Object)new Image("/mediathek/res/MediathekView.png"));
        stage.setOnHiding(windowEvent -> {
            this.cancelBookmarkSave();
            this.saveBookMarkList();
        });
        return stage;
    }

    public void show() {
        Platform.runLater(() -> {
            if (this.stage == null) {
                this.stage = this.createStage();
                this.setStageSize();
                try {
                    FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/mediathek/res/programm/fxml/bookmarkWindow.fxml"));
                    fxmlLoader.setController((Object)this);
                    Scene scene = new Scene((Parent)fxmlLoader.load());
                    this.stage.setScene(scene);
                    scene.getStylesheets().add((Object)Objects.requireNonNull(this.getClass().getResource("/mediathek/res/css/bookmarkWindow.css")).toExternalForm());
                }
                catch (IOException e) {
                    logger.error("Can't find/load the FXML description!", (Throwable)e);
                    this.stage = null;
                }
            } else {
                this.tbBookmarks.getSelectionModel().clearSelection();
                if (this.stage.isIconified()) {
                    this.stage.setIconified(false);
                }
                this.stage.toFront();
                this.stage.requestFocus();
            }
            if (this.stage != null) {
                this.stage.show();
                this.refresh();
            }
        });
    }

    private void refresh() {
        if (this.stage.isShowing()) {
            this.tbBookmarks.refresh();
            this.updateDisplay();
        }
    }

    private void scheduleBookmarkSave() {
        this.cancelBookmarkSave();
        this.SaveBookmarkTask = TimerPool.getTimerPool().schedule(() -> {
            this.saveBookMarkList();
            this.SaveBookmarkTask = null;
        }, 5L, TimeUnit.SECONDS);
    }

    private void updateDisplay() {
        this.lblCount.setText(String.format("Eintr\u00e4ge: %d / %d", this.filteredBookmarkList.size(), Daten.getInstance().getListeBookmarkList().getObervableList().size()));
        this.btnSaveList.setDisable(!this.listUpdated);
        if (this.listUpdated) {
            this.scheduleBookmarkSave();
        }
    }

    private void saveBookMarkList() {
        if (this.listUpdated) {
            Daten.getInstance().getListeBookmarkList().saveToFile();
            this.btnSaveList.setDisable(true);
        }
        this.listUpdated = false;
    }

    private void playAction(BookmarkData data) {
        data.getDatenFilmOptional().ifPresent(film -> {
            Daten.getInstance().getStarterClass().urlMitProgrammStarten(Daten.listePset.getPsetAbspielen(), (DatenFilm)film, "");
            this.tbBookmarks.getSelectionModel().clearSelection();
            this.tbBookmarks.getSelectionModel().select((Object)data);
        });
    }

    private void loadAction(@NotNull BookmarkData data) {
        Optional<DatenFilm> datenFilm = Optional.ofNullable(data.getDatenFilm());
        Daten daten = Daten.getInstance();
        this.refresh();
        datenFilm.ifPresent(film -> {
            DatenDownload previouslyCreatedDownload = daten.getListeDownloads().getDownloadUrlFilm(film.getUrlNormalQuality());
            if (previouslyCreatedDownload == null) {
                this.createDownload((DatenFilm)film);
            } else {
                ButtonType yes = new ButtonType("Ja", ButtonBar.ButtonData.OK_DONE);
                ButtonType no = new ButtonType("Nein", ButtonBar.ButtonData.CANCEL_CLOSE);
                Alert alert = new Alert(Alert.AlertType.WARNING, "Ein Download f\u00fcr den Film existiert bereits.\nNochmal anlegen?", new ButtonType[]{yes, no});
                alert.initOwner((Window)this.stage);
                alert.setTitle("Merkliste");
                alert.showAndWait().filter(response -> response == ButtonType.OK).ifPresent(buttonType -> this.createDownload((DatenFilm)film));
            }
        });
    }

    private void createDownload(DatenFilm film) {
        this.stage.hide();
        SwingUtilities.invokeLater(() -> {
            DatenPset pSet = (DatenPset)Daten.listePset.getListeSpeichern().getFirst();
            DialogAddDownload dlg = new DialogAddDownload((Frame)MediathekGui.ui(), film, pSet, Optional.empty());
            dlg.setVisible(true);
            this.showStage();
        });
    }

    private void showStage() {
        Platform.runLater(() -> {
            this.stage.show();
            this.stage.toFront();
            this.stage.requestFocus();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.WRITE);
            config.setProperty("application.ui.bookmarklist.width", (Object)((int)this.stage.getWidth()));
            config.setProperty("application.ui.bookmarklist.heigth", (Object)((int)this.stage.getHeight()));
            config.setProperty("application.ui.bookmarklist.location.x", (Object)((int)this.stage.getX()));
            config.setProperty("application.ui.bookmarklist.location.y", (Object)((int)this.stage.getY()));
            String colbase = "application.ui.bookmarklist.columns";
            config.setProperty(colbase + ".no", (Object)this.tbBookmarks.getColumns().size());
            int k = 0;
            for (TableColumn column : this.tbBookmarks.getColumns()) {
                String colref = colbase + ".col" + ++k;
                config.setProperty(colref + ".id", (Object)column.getId());
                config.setProperty(colref + ".size", (Object)((int)column.getWidth()));
                config.setProperty(colref + ".visible", (Object)column.isVisible());
            }
            config.setProperty("application.ui.bookmarklist.details", (Object)this.btnShowDetails.isSelected());
            config.setProperty("application.ui.bookmarklist.divider", (Object)(this.btnShowDetails.isSelected() ? this.spSplitPane.getDividerPositions()[0] : this.divposition));
        }
        catch (Exception e) {
            logger.error("Save Config exception: ", (Throwable)e);
        }
        finally {
            config.unlock(LockMode.WRITE);
        }
    }

    private boolean isUnSeenSelected() {
        boolean unSeen = false;
        for (BookmarkData data : this.tbBookmarks.getSelectionModel().getSelectedItems()) {
            if (data.getSeen() || data.isLiveStream()) continue;
            unSeen = true;
            break;
        }
        return unSeen;
    }

    private boolean onlyLifeStreamSelected() {
        boolean lifestream = true;
        for (BookmarkData data : this.tbBookmarks.getSelectionModel().getSelectedItems()) {
            if (data.isLiveStream()) continue;
            lifestream = false;
            break;
        }
        return lifestream;
    }

    private void cancelBookmarkSave() {
        if (this.SaveBookmarkTask != null) {
            this.SaveBookmarkTask.cancel(false);
            this.SaveBookmarkTask = null;
        }
    }
}

