/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import org.opensearch.action.admin.cluster.storedscripts.GetStoredScriptRequest;
import org.opensearch.action.admin.cluster.storedscripts.GetStoredScriptResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportGetStoredScriptAction
extends TransportClusterManagerNodeReadAction<GetStoredScriptRequest, GetStoredScriptResponse> {
    private final ScriptService scriptService;

    @Inject
    public TransportGetStoredScriptAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ScriptService scriptService) {
        super("cluster:admin/script/get", transportService, clusterService, threadPool, actionFilters, GetStoredScriptRequest::new, indexNameExpressionResolver, true);
        this.scriptService = scriptService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected GetStoredScriptResponse read(StreamInput in) throws IOException {
        return new GetStoredScriptResponse(in);
    }

    @Override
    protected void clusterManagerOperation(GetStoredScriptRequest request, ClusterState state, ActionListener<GetStoredScriptResponse> listener) throws Exception {
        listener.onResponse((Object)new GetStoredScriptResponse(request.id(), this.scriptService.getStoredScript(state, request)));
    }

    @Override
    protected ClusterBlockException checkBlock(GetStoredScriptRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

