/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.node;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.common.Booleans;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.index.translog.BufferedChecksumStreamOutput;

@PublicApi(since="1.0.0")
public class DiscoveryNodes
extends AbstractDiffable<DiscoveryNodes>
implements Iterable<DiscoveryNode> {
    public static final DiscoveryNodes EMPTY_NODES = DiscoveryNodes.builder().build();
    private final Map<String, DiscoveryNode> nodes;
    private final Map<String, DiscoveryNode> dataNodes;
    private final Map<String, DiscoveryNode> clusterManagerNodes;
    private final Map<String, DiscoveryNode> ingestNodes;
    private final String clusterManagerNodeId;
    private final String localNodeId;
    private final Version minNonClientNodeVersion;
    private final Version maxNonClientNodeVersion;
    private final Version maxNodeVersion;
    private final Version minNodeVersion;

    private DiscoveryNodes(Map<String, DiscoveryNode> nodes, Map<String, DiscoveryNode> dataNodes, Map<String, DiscoveryNode> clusterManagerNodes, Map<String, DiscoveryNode> ingestNodes, String clusterManagerNodeId, String localNodeId, Version minNonClientNodeVersion, Version maxNonClientNodeVersion, Version maxNodeVersion, Version minNodeVersion) {
        this.nodes = Collections.unmodifiableMap(nodes);
        this.dataNodes = Collections.unmodifiableMap(dataNodes);
        this.clusterManagerNodes = Collections.unmodifiableMap(clusterManagerNodes);
        this.ingestNodes = Collections.unmodifiableMap(ingestNodes);
        this.clusterManagerNodeId = clusterManagerNodeId;
        this.localNodeId = localNodeId;
        this.minNonClientNodeVersion = minNonClientNodeVersion;
        this.maxNonClientNodeVersion = maxNonClientNodeVersion;
        this.minNodeVersion = minNodeVersion;
        this.maxNodeVersion = maxNodeVersion;
    }

    @Override
    public Iterator<DiscoveryNode> iterator() {
        return this.nodes.values().iterator();
    }

    public boolean isLocalNodeElectedClusterManager() {
        if (this.localNodeId == null) {
            return false;
        }
        return this.localNodeId.equals(this.clusterManagerNodeId);
    }

    @Deprecated
    public boolean isLocalNodeElectedMaster() {
        return this.isLocalNodeElectedClusterManager();
    }

    public int getSize() {
        return this.nodes.size();
    }

    public Map<String, DiscoveryNode> getNodes() {
        return this.nodes;
    }

    public Map<String, DiscoveryNode> getDataNodes() {
        return this.dataNodes;
    }

    public Map<String, DiscoveryNode> getClusterManagerNodes() {
        return this.clusterManagerNodes;
    }

    @Deprecated
    public Map<String, DiscoveryNode> getMasterNodes() {
        return this.getClusterManagerNodes();
    }

    public Map<String, DiscoveryNode> getIngestNodes() {
        return this.ingestNodes;
    }

    public Map<String, DiscoveryNode> getClusterManagerAndDataNodes() {
        HashMap<String, DiscoveryNode> nodes = new HashMap<String, DiscoveryNode>(this.dataNodes);
        nodes.putAll(this.clusterManagerNodes);
        return Collections.unmodifiableMap(nodes);
    }

    @Deprecated
    public Map<String, DiscoveryNode> getMasterAndDataNodes() {
        return this.getClusterManagerAndDataNodes();
    }

    public Map<String, DiscoveryNode> getCoordinatingOnlyNodes() {
        HashMap<String, DiscoveryNode> nodes = new HashMap<String, DiscoveryNode>(this.nodes);
        nodes.keySet().removeAll(this.clusterManagerNodes.keySet());
        nodes.keySet().removeAll(this.dataNodes.keySet());
        nodes.keySet().removeAll(this.ingestNodes.keySet());
        return Collections.unmodifiableMap(nodes);
    }

    public Stream<DiscoveryNode> clusterManagersFirstStream() {
        return Stream.concat(StreamSupport.stream(Spliterators.spliterator(this.clusterManagerNodes.entrySet(), 0), false).map(cur -> (DiscoveryNode)cur.getValue()), StreamSupport.stream(this.spliterator(), false).filter(n -> !n.isClusterManagerNode()));
    }

    @Deprecated
    public Stream<DiscoveryNode> mastersFirstStream() {
        return this.clusterManagersFirstStream();
    }

    public DiscoveryNode get(String nodeId) {
        return this.nodes.get(nodeId);
    }

    public boolean nodeExists(String nodeId) {
        return this.nodes.containsKey(nodeId);
    }

    public boolean nodeExists(DiscoveryNode node) {
        DiscoveryNode existing = this.nodes.get(node.getId());
        return existing != null && existing.equals(node);
    }

    public boolean nodeExistsWithSameRoles(DiscoveryNode discoveryNode) {
        DiscoveryNode existing = this.nodes.get(discoveryNode.getId());
        return existing != null && existing.equals(discoveryNode) && existing.getRoles().equals(discoveryNode.getRoles());
    }

    public boolean nodeExistsWithBWCVersion(DiscoveryNode discoveryNode) {
        DiscoveryNode existing = this.nodes.get(discoveryNode.getId());
        return existing != null && existing.equals(discoveryNode) && existing.getVersion().equals((Object)LegacyESVersion.V_7_10_2) && discoveryNode.getVersion().onOrAfter(Version.V_1_0_0);
    }

    public String getClusterManagerNodeId() {
        return this.clusterManagerNodeId;
    }

    @Deprecated
    public String getMasterNodeId() {
        return this.getClusterManagerNodeId();
    }

    public String getLocalNodeId() {
        return this.localNodeId;
    }

    public DiscoveryNode getLocalNode() {
        return this.nodes.get(this.localNodeId);
    }

    @Nullable
    public DiscoveryNode getClusterManagerNode() {
        if (this.clusterManagerNodeId != null) {
            return this.nodes.get(this.clusterManagerNodeId);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public DiscoveryNode getMasterNode() {
        return this.getClusterManagerNode();
    }

    public DiscoveryNode findByAddress(TransportAddress address) {
        for (DiscoveryNode node : this.nodes.values()) {
            if (!node.getAddress().equals((Object)address)) continue;
            return node;
        }
        return null;
    }

    public Version getSmallestNonClientNodeVersion() {
        return this.minNonClientNodeVersion;
    }

    public Version getLargestNonClientNodeVersion() {
        return this.maxNonClientNodeVersion;
    }

    public Version getMinNodeVersion() {
        return this.minNodeVersion;
    }

    public Version getMaxNodeVersion() {
        return this.maxNodeVersion;
    }

    public DiscoveryNode resolveNode(String node) {
        String[] resolvedNodeIds = this.resolveNodes(node);
        if (resolvedNodeIds.length > 1) {
            throw new IllegalArgumentException("resolved [" + node + "] into [" + resolvedNodeIds.length + "] nodes, where expected to be resolved to a single node");
        }
        if (resolvedNodeIds.length == 0) {
            throw new IllegalArgumentException("failed to resolve [" + node + "], no matching nodes");
        }
        return this.nodes.get(resolvedNodeIds[0]);
    }

    public String[] resolveNodes(String ... nodes) {
        if (nodes == null || nodes.length == 0) {
            return (String[])StreamSupport.stream(this.spliterator(), false).map(DiscoveryNode::getId).toArray(String[]::new);
        }
        HashSet<String> resolvedNodesIds = new HashSet<String>(nodes.length);
        for (String nodeId : nodes) {
            if (nodeId == null) {
                assert (nodeId != null) : "nodeId should not be null";
                continue;
            }
            if (nodeId.equals("_local")) {
                String localNodeId = this.getLocalNodeId();
                if (localNodeId == null) continue;
                resolvedNodesIds.add(localNodeId);
                continue;
            }
            if (nodeId.equals("_master") || nodeId.equals("_cluster_manager")) {
                String clusterManagerNodeId = this.getClusterManagerNodeId();
                if (clusterManagerNodeId == null) continue;
                resolvedNodesIds.add(clusterManagerNodeId);
                continue;
            }
            if (this.nodeExists(nodeId)) {
                resolvedNodesIds.add(nodeId);
                continue;
            }
            for (DiscoveryNode node : this) {
                if (!"_all".equals(nodeId) && !Regex.simpleMatch(nodeId, node.getName()) && !Regex.simpleMatch(nodeId, node.getHostAddress()) && !Regex.simpleMatch(nodeId, node.getHostName())) continue;
                resolvedNodesIds.add(node.getId());
            }
            int index = nodeId.indexOf(58);
            if (index == -1) continue;
            String matchAttrName = nodeId.substring(0, index);
            String matchAttrValue = nodeId.substring(index + 1);
            if (DiscoveryNodeRole.DATA_ROLE.roleName().equals(matchAttrName)) {
                if (Booleans.parseBoolean((String)matchAttrValue, (boolean)true)) {
                    resolvedNodesIds.addAll(this.dataNodes.keySet());
                    continue;
                }
                resolvedNodesIds.removeAll(this.dataNodes.keySet());
                continue;
            }
            if (this.roleNameIsClusterManager(matchAttrName)) {
                if (Booleans.parseBoolean((String)matchAttrValue, (boolean)true)) {
                    resolvedNodesIds.addAll(this.clusterManagerNodes.keySet());
                    continue;
                }
                resolvedNodesIds.removeAll(this.clusterManagerNodes.keySet());
                continue;
            }
            if (DiscoveryNodeRole.INGEST_ROLE.roleName().equals(matchAttrName)) {
                if (Booleans.parseBoolean((String)matchAttrValue, (boolean)true)) {
                    resolvedNodesIds.addAll(this.ingestNodes.keySet());
                    continue;
                }
                resolvedNodesIds.removeAll(this.ingestNodes.keySet());
                continue;
            }
            if ("coordinating_only".equals(matchAttrName)) {
                if (Booleans.parseBoolean((String)matchAttrValue, (boolean)true)) {
                    resolvedNodesIds.addAll(this.getCoordinatingOnlyNodes().keySet());
                    continue;
                }
                resolvedNodesIds.removeAll(this.getCoordinatingOnlyNodes().keySet());
                continue;
            }
            for (DiscoveryNode node : this) {
                for (DiscoveryNodeRole discoveryNodeRole : Sets.difference(node.getRoles(), DiscoveryNodeRole.BUILT_IN_ROLES)) {
                    if (!discoveryNodeRole.roleName().equals(matchAttrName)) continue;
                    if (Booleans.parseBoolean((String)matchAttrValue, (boolean)true)) {
                        resolvedNodesIds.add(node.getId());
                        continue;
                    }
                    resolvedNodesIds.remove(node.getId());
                }
            }
            for (DiscoveryNode node : this) {
                for (Map.Entry entry : node.getAttributes().entrySet()) {
                    String attrName = (String)entry.getKey();
                    String attrValue = (String)entry.getValue();
                    if (!Regex.simpleMatch(matchAttrName, attrName) || !Regex.simpleMatch(matchAttrValue, attrValue)) continue;
                    resolvedNodesIds.add(node.getId());
                }
            }
        }
        return resolvedNodesIds.toArray(new String[0]);
    }

    public DiscoveryNodes newNode(DiscoveryNode node) {
        return new Builder(this).add(node).build();
    }

    public Delta delta(DiscoveryNodes other) {
        ArrayList<DiscoveryNode> removed = new ArrayList<DiscoveryNode>();
        ArrayList<DiscoveryNode> added = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : other) {
            if (this.nodeExists(node)) continue;
            removed.add(node);
        }
        for (DiscoveryNode node : this) {
            if (other.nodeExists(node)) continue;
            added.add(node);
        }
        return new Delta(other.getClusterManagerNode(), this.getClusterManagerNode(), this.localNodeId, Collections.unmodifiableList(removed), Collections.unmodifiableList(added));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes: \n");
        for (DiscoveryNode node : this) {
            sb.append("   ").append(node);
            if (node == this.getLocalNode()) {
                sb.append(", local");
            }
            if (node == this.getClusterManagerNode()) {
                sb.append(", cluster-manager");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.writeToUtil((Writeable.Writer<DiscoveryNode>)((Writeable.Writer)(output, value) -> value.writeTo(output)), out);
    }

    public void writeToWithAttribute(StreamOutput out) throws IOException {
        this.writeToUtil((Writeable.Writer<DiscoveryNode>)((Writeable.Writer)(output, value) -> value.writeToWithAttribute(output)), out);
    }

    private void writeToUtil(Writeable.Writer<DiscoveryNode> writer, StreamOutput out) throws IOException {
        this.writeClusterManager(out);
        out.writeVInt(this.nodes.size());
        for (DiscoveryNode node : this) {
            writer.write(out, (Object)node);
        }
    }

    public void writeVerifiableTo(BufferedChecksumStreamOutput out) throws IOException {
        this.writeClusterManager(out);
        out.writeMapValues(this.nodes, (stream, val) -> val.writeVerifiableTo((BufferedChecksumStreamOutput)stream));
    }

    private void writeClusterManager(StreamOutput out) throws IOException {
        if (this.clusterManagerNodeId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(this.clusterManagerNodeId);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryNodes that = (DiscoveryNodes)o;
        return Objects.equals(this.nodes, that.nodes) && Objects.equals(this.dataNodes, that.dataNodes) && Objects.equals(this.clusterManagerNodes, that.clusterManagerNodes) && Objects.equals(this.ingestNodes, that.ingestNodes) && Objects.equals(this.clusterManagerNodeId, that.clusterManagerNodeId) && Objects.equals(this.localNodeId, that.localNodeId) && Objects.equals(this.minNonClientNodeVersion, that.minNonClientNodeVersion) && Objects.equals(this.maxNonClientNodeVersion, that.maxNonClientNodeVersion) && Objects.equals(this.maxNodeVersion, that.maxNodeVersion) && Objects.equals(this.minNodeVersion, that.minNodeVersion);
    }

    public int hashCode() {
        return Objects.hash(this.nodes, this.dataNodes, this.clusterManagerNodes, this.ingestNodes, this.clusterManagerNodeId, this.localNodeId, this.minNonClientNodeVersion, this.maxNonClientNodeVersion, this.maxNodeVersion, this.minNodeVersion);
    }

    public static DiscoveryNodes readFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        Builder builder = new Builder();
        if (in.readBoolean()) {
            builder.clusterManagerNodeId(in.readString());
        }
        if (localNode != null) {
            builder.localNodeId(localNode.getId());
        }
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            DiscoveryNode node = new DiscoveryNode(in);
            if (localNode != null && node.getId().equals(localNode.getId())) {
                node = localNode;
            }
            assert (builder.validateAdd(node) == null) : "building disco nodes from network doesn't pass preflight: " + builder.validateAdd(node);
            builder.putUnsafe(node);
        }
        return builder.build();
    }

    public static Diff<DiscoveryNodes> readDiffFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        return AbstractDiffable.readDiffFrom(in1 -> DiscoveryNodes.readFrom(in1, localNode), in);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiscoveryNodes nodes) {
        return new Builder(nodes);
    }

    @Deprecated
    private boolean roleNameIsClusterManager(String matchAttrName) {
        return DiscoveryNodeRole.MASTER_ROLE.roleName().equals(matchAttrName) || DiscoveryNodeRole.CLUSTER_MANAGER_ROLE.roleName().equals(matchAttrName);
    }

    @PublicApi(since="1.0.0")
    public static class Builder {
        private final Map<String, DiscoveryNode> nodes;
        private String clusterManagerNodeId;
        private String localNodeId;

        public Builder() {
            this.nodes = new HashMap<String, DiscoveryNode>();
        }

        public Builder(DiscoveryNodes nodes) {
            this.clusterManagerNodeId = nodes.getClusterManagerNodeId();
            this.localNodeId = nodes.getLocalNodeId();
            this.nodes = new HashMap<String, DiscoveryNode>(nodes.getNodes());
        }

        public Builder add(DiscoveryNode node) {
            String preflight = this.validateAdd(node);
            if (preflight != null) {
                throw new IllegalArgumentException(preflight);
            }
            this.putUnsafe(node);
            return this;
        }

        @Nullable
        public DiscoveryNode get(String nodeId) {
            return this.nodes.get(nodeId);
        }

        private void putUnsafe(DiscoveryNode node) {
            this.nodes.put(node.getId(), node);
        }

        public Builder remove(String nodeId) {
            this.nodes.remove(nodeId);
            return this;
        }

        public Builder remove(DiscoveryNode node) {
            if (node.equals(this.nodes.get(node.getId()))) {
                this.nodes.remove(node.getId());
            }
            return this;
        }

        public Builder clusterManagerNodeId(String clusterManagerNodeId) {
            this.clusterManagerNodeId = clusterManagerNodeId;
            return this;
        }

        @Deprecated
        public Builder masterNodeId(String clusterManagerNodeId) {
            return this.clusterManagerNodeId(clusterManagerNodeId);
        }

        public Builder localNodeId(String localNodeId) {
            this.localNodeId = localNodeId;
            return this;
        }

        private String validateAdd(DiscoveryNode node) {
            for (DiscoveryNode existingNode : this.nodes.values()) {
                if (node.getAddress().equals((Object)existingNode.getAddress()) && !node.getId().equals(existingNode.getId())) {
                    return "can't add node " + String.valueOf(node) + ", found existing node " + String.valueOf(existingNode) + " with same address";
                }
                if (!node.getId().equals(existingNode.getId()) || node.equals(existingNode)) continue;
                return "can't add node " + String.valueOf(node) + ", found existing node " + String.valueOf(existingNode) + " with the same id but is a different node instance";
            }
            return null;
        }

        public DiscoveryNodes build() {
            HashMap<String, DiscoveryNode> dataNodesBuilder = new HashMap<String, DiscoveryNode>();
            HashMap<String, DiscoveryNode> clusterManagerNodesBuilder = new HashMap<String, DiscoveryNode>();
            HashMap<String, DiscoveryNode> ingestNodesBuilder = new HashMap<String, DiscoveryNode>();
            Version minNodeVersion = null;
            Version maxNodeVersion = null;
            Version minNonClientNodeVersion = null;
            Version maxNonClientNodeVersion = null;
            for (Map.Entry<String, DiscoveryNode> nodeEntry : this.nodes.entrySet()) {
                if (nodeEntry.getValue().isDataNode()) {
                    dataNodesBuilder.put(nodeEntry.getKey(), nodeEntry.getValue());
                }
                if (nodeEntry.getValue().isClusterManagerNode()) {
                    clusterManagerNodesBuilder.put(nodeEntry.getKey(), nodeEntry.getValue());
                }
                Version version = nodeEntry.getValue().getVersion();
                if (nodeEntry.getValue().isDataNode() || nodeEntry.getValue().isClusterManagerNode()) {
                    if (minNonClientNodeVersion == null) {
                        minNonClientNodeVersion = version;
                        maxNonClientNodeVersion = version;
                    } else {
                        minNonClientNodeVersion = Version.min((Version)minNonClientNodeVersion, (Version)version);
                        maxNonClientNodeVersion = Version.max((Version)maxNonClientNodeVersion, (Version)version);
                    }
                }
                if (nodeEntry.getValue().isIngestNode()) {
                    ingestNodesBuilder.put(nodeEntry.getKey(), nodeEntry.getValue());
                }
                minNodeVersion = minNodeVersion == null ? version : Version.min((Version)minNodeVersion, (Version)version);
                maxNodeVersion = maxNodeVersion == null ? version : Version.max((Version)maxNodeVersion, (Version)version);
            }
            return new DiscoveryNodes(this.nodes, dataNodesBuilder, clusterManagerNodesBuilder, ingestNodesBuilder, this.clusterManagerNodeId, this.localNodeId, minNonClientNodeVersion == null ? Version.CURRENT : minNonClientNodeVersion, maxNonClientNodeVersion == null ? Version.CURRENT : maxNonClientNodeVersion, maxNodeVersion == null ? Version.CURRENT : maxNodeVersion, minNodeVersion == null ? Version.CURRENT : minNodeVersion);
        }

        public boolean isLocalNodeElectedClusterManager() {
            return this.clusterManagerNodeId != null && this.clusterManagerNodeId.equals(this.localNodeId);
        }

        @Deprecated
        public boolean isLocalNodeElectedMaster() {
            return this.isLocalNodeElectedClusterManager();
        }
    }

    @PublicApi(since="1.0.0")
    public static class Delta {
        private final String localNodeId;
        @Nullable
        private final DiscoveryNode previousClusterManagerNode;
        @Nullable
        private final DiscoveryNode newClusterManagerNode;
        private final List<DiscoveryNode> removed;
        private final List<DiscoveryNode> added;

        private Delta(@Nullable DiscoveryNode previousClusterManagerNode, @Nullable DiscoveryNode newClusterManagerNode, String localNodeId, List<DiscoveryNode> removed, List<DiscoveryNode> added) {
            this.previousClusterManagerNode = previousClusterManagerNode;
            this.newClusterManagerNode = newClusterManagerNode;
            this.localNodeId = localNodeId;
            this.removed = removed;
            this.added = added;
        }

        public boolean hasChanges() {
            return this.clusterManagerNodeChanged() || !this.removed.isEmpty() || !this.added.isEmpty();
        }

        public boolean clusterManagerNodeChanged() {
            return !Objects.equals(this.newClusterManagerNode, this.previousClusterManagerNode);
        }

        @Deprecated
        public boolean masterNodeChanged() {
            return this.clusterManagerNodeChanged();
        }

        @Nullable
        public DiscoveryNode previousClusterManagerNode() {
            return this.previousClusterManagerNode;
        }

        @Deprecated
        @Nullable
        public DiscoveryNode previousMasterNode() {
            return this.previousClusterManagerNode();
        }

        @Nullable
        public DiscoveryNode newClusterManagerNode() {
            return this.newClusterManagerNode;
        }

        @Deprecated
        @Nullable
        public DiscoveryNode newMasterNode() {
            return this.newClusterManagerNode();
        }

        public boolean removed() {
            return !this.removed.isEmpty();
        }

        public List<DiscoveryNode> removedNodes() {
            return this.removed;
        }

        public boolean added() {
            return !this.added.isEmpty();
        }

        public List<DiscoveryNode> addedNodes() {
            return this.added;
        }

        public String shortSummary() {
            String addedNodesExceptLocalNode;
            StringBuilder summary = new StringBuilder();
            if (this.clusterManagerNodeChanged()) {
                summary.append("cluster-manager node changed {previous [");
                if (this.previousClusterManagerNode() != null) {
                    summary.append(this.previousClusterManagerNode());
                }
                summary.append("], current [");
                if (this.newClusterManagerNode() != null) {
                    summary.append(this.newClusterManagerNode());
                }
                summary.append("]}");
            }
            if (this.removed()) {
                if (summary.length() > 0) {
                    summary.append(", ");
                }
                summary.append("removed {").append(Strings.collectionToCommaDelimitedString(this.removedNodes())).append('}');
            }
            if (this.added() && (addedNodesExceptLocalNode = this.addedNodes().stream().filter(node -> !node.getId().equals(this.localNodeId)).map(DiscoveryNode::toString).collect(Collectors.joining(","))).length() > 0) {
                if (summary.length() > 0) {
                    summary.append(", ");
                }
                summary.append("added {").append(addedNodesExceptLocalNode).append('}');
            }
            return summary.toString();
        }
    }
}

