/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.allocator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntroSorter;
import org.opensearch.action.admin.indices.tiering.TieringUtils;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.RoutingNodes;
import org.opensearch.cluster.routing.RoutingPool;
import org.opensearch.cluster.routing.ShardMovementStrategy;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardRoutingState;
import org.opensearch.cluster.routing.UnassignedInfo;
import org.opensearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.opensearch.cluster.routing.allocation.AllocationDecision;
import org.opensearch.cluster.routing.allocation.MoveDecision;
import org.opensearch.cluster.routing.allocation.NodeAllocationResult;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.opensearch.cluster.routing.allocation.allocator.ShardsBalancer;
import org.opensearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.gateway.PriorityComparator;

public class LocalShardsBalancer
extends ShardsBalancer {
    private final Logger logger;
    private final Map<String, BalancedShardsAllocator.ModelNode> nodes;
    private final RoutingAllocation allocation;
    private final RoutingNodes routingNodes;
    private final ShardMovementStrategy shardMovementStrategy;
    private final boolean preferPrimaryBalance;
    private final boolean preferPrimaryRebalance;
    private final boolean ignoreThrottleInRestore;
    private final BalancedShardsAllocator.WeightFunction weight;
    private final float threshold;
    private final Metadata metadata;
    private final float avgPrimaryShardsPerNode;
    private final BalancedShardsAllocator.NodeSorter sorter;
    private final Set<RoutingNode> inEligibleTargetNode;
    private final Supplier<Boolean> timedOutFunc;
    private int totalShardCount = 0;
    private static final Comparator<ShardRouting> BY_DESCENDING_SHARD_ID = Comparator.comparing(ShardRouting::shardId).reversed();
    private static final Comparator<ShardRouting> PRIMARY_FIRST = Comparator.comparing(ShardRouting::primary).reversed();

    public LocalShardsBalancer(Logger logger, RoutingAllocation allocation, ShardMovementStrategy shardMovementStrategy, BalancedShardsAllocator.WeightFunction weight, float threshold, boolean preferPrimaryBalance, boolean preferPrimaryRebalance, boolean ignoreThrottleInRestore, Supplier<Boolean> timedOutFunc) {
        this.logger = logger;
        this.allocation = allocation;
        this.weight = weight;
        this.threshold = threshold;
        this.routingNodes = allocation.routingNodes();
        this.metadata = allocation.metadata();
        this.avgPrimaryShardsPerNode = (float)StreamSupport.stream(this.metadata.spliterator(), false).mapToInt(IndexMetadata::getNumberOfShards).sum() / (float)this.routingNodes.size();
        this.nodes = Collections.unmodifiableMap(this.buildModelFromAssigned());
        this.sorter = this.newNodeSorter();
        this.inEligibleTargetNode = new HashSet<RoutingNode>();
        this.preferPrimaryBalance = preferPrimaryBalance;
        this.preferPrimaryRebalance = preferPrimaryRebalance;
        this.shardMovementStrategy = shardMovementStrategy;
        this.ignoreThrottleInRestore = ignoreThrottleInRestore;
        this.timedOutFunc = timedOutFunc;
    }

    private BalancedShardsAllocator.ModelNode[] nodesArray() {
        return this.nodes.values().toArray(new BalancedShardsAllocator.ModelNode[0]);
    }

    @Override
    public float avgShardsPerNode(String index) {
        return (float)this.metadata.index(index).getTotalNumberOfShards() / (float)this.nodes.size();
    }

    @Override
    public float avgPrimaryShardsPerNode(String index) {
        return (float)this.metadata.index(index).getNumberOfShards() / (float)this.nodes.size();
    }

    @Override
    public float avgPrimaryShardsPerNode() {
        return this.avgPrimaryShardsPerNode;
    }

    @Override
    public float avgShardsPerNode() {
        return this.totalShardCount / this.nodes.size();
    }

    private BalancedShardsAllocator.NodeSorter newNodeSorter() {
        return new BalancedShardsAllocator.NodeSorter(this.nodesArray(), this.weight, this);
    }

    private static float absDelta(float lower, float higher) {
        assert (higher >= lower) : higher + " lt " + lower + " but was expected to be gte";
        return Math.abs(higher - lower);
    }

    private static boolean lessThan(float delta, float threshold) {
        return delta <= threshold + 0.001f;
    }

    @Override
    void balance() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Start balancing cluster");
        }
        if (this.allocation.hasPendingAsyncFetch()) {
            this.logger.debug("skipping rebalance due to in-flight shard/store fetches");
            return;
        }
        if (this.allocation.deciders().canRebalance(this.allocation).type() != Decision.Type.YES) {
            this.logger.trace("skipping rebalance as it is disabled");
            return;
        }
        if (this.nodes.size() < 2) {
            this.logger.trace("skipping rebalance as single node only");
            return;
        }
        this.balanceByWeights();
    }

    @Override
    MoveDecision decideRebalance(ShardRouting shard) {
        if (RoutingPool.REMOTE_CAPABLE.equals((Object)RoutingPool.getShardPool(shard, this.allocation))) {
            return MoveDecision.NOT_TAKEN;
        }
        if (!shard.started()) {
            return MoveDecision.NOT_TAKEN;
        }
        Decision canRebalance = this.allocation.deciders().canRebalance(shard, this.allocation);
        this.sorter.reset(shard.getIndexName());
        BalancedShardsAllocator.ModelNode[] modelNodes = this.sorter.modelNodes;
        String currentNodeId = shard.currentNodeId();
        BalancedShardsAllocator.ModelNode currentNode = null;
        for (BalancedShardsAllocator.ModelNode node : modelNodes) {
            if (!node.getNodeId().equals(currentNodeId)) continue;
            currentNode = node;
            break;
        }
        assert (currentNode != null) : "currently assigned node could not be found";
        String idxName = shard.getIndexName();
        float currentWeight = this.weight.weight(this, currentNode, idxName);
        AllocationDeciders deciders = this.allocation.deciders();
        Decision.Type rebalanceDecisionType = Decision.Type.NO;
        BalancedShardsAllocator.ModelNode assignedNode = null;
        ArrayList<Tuple> betterBalanceNodes = new ArrayList<Tuple>();
        ArrayList<Tuple> sameBalanceNodes = new ArrayList<Tuple>();
        ArrayList<Tuple> worseBalanceNodes = new ArrayList<Tuple>();
        for (BalancedShardsAllocator.ModelNode modelNode : modelNodes) {
            if (modelNode == currentNode) continue;
            Decision canAllocate = deciders.canAllocate(shard, modelNode.getRoutingNode(), this.allocation);
            float nodeWeight = this.weight.weightWithRebalanceConstraints(this, modelNode, idxName);
            boolean betterWeightThanCurrent = nodeWeight <= currentWeight;
            boolean rebalanceConditionsMet = false;
            if (betterWeightThanCurrent) {
                float currentDelta = LocalShardsBalancer.absDelta(nodeWeight, currentWeight);
                boolean deltaAboveThreshold = !LocalShardsBalancer.lessThan(currentDelta, this.threshold);
                float proposedDelta = 2.0f + nodeWeight - currentWeight;
                boolean betterWeightWithShardAdded = proposedDelta < currentDelta;
                boolean bl = rebalanceConditionsMet = deltaAboveThreshold && betterWeightWithShardAdded;
                if (rebalanceConditionsMet && canAllocate.type().higherThan(rebalanceDecisionType)) {
                    rebalanceDecisionType = canAllocate.type();
                    assignedNode = modelNode;
                }
            }
            Tuple nodeResult = Tuple.tuple((Object)modelNode, (Object)canAllocate);
            if (rebalanceConditionsMet) {
                betterBalanceNodes.add(nodeResult);
                continue;
            }
            if (betterWeightThanCurrent) {
                sameBalanceNodes.add(nodeResult);
                continue;
            }
            worseBalanceNodes.add(nodeResult);
        }
        int weightRanking = 0;
        ArrayList<NodeAllocationResult> nodeDecisions = new ArrayList<NodeAllocationResult>(modelNodes.length - 1);
        for (Tuple tuple : betterBalanceNodes) {
            nodeDecisions.add(new NodeAllocationResult(((BalancedShardsAllocator.ModelNode)tuple.v1()).getRoutingNode().node(), AllocationDecision.fromDecisionType(((Decision)tuple.v2()).type()), (Decision)tuple.v2(), ++weightRanking));
        }
        int currentNodeWeightRanking = ++weightRanking;
        for (Tuple result : sameBalanceNodes) {
            AllocationDecision nodeDecision = ((Decision)result.v2()).type() == Decision.Type.NO ? AllocationDecision.NO : AllocationDecision.WORSE_BALANCE;
            nodeDecisions.add(new NodeAllocationResult(((BalancedShardsAllocator.ModelNode)result.v1()).getRoutingNode().node(), nodeDecision, (Decision)result.v2(), currentNodeWeightRanking));
        }
        for (Tuple result : worseBalanceNodes) {
            AllocationDecision nodeDecision = ((Decision)result.v2()).type() == Decision.Type.NO ? AllocationDecision.NO : AllocationDecision.WORSE_BALANCE;
            nodeDecisions.add(new NodeAllocationResult(((BalancedShardsAllocator.ModelNode)result.v1()).getRoutingNode().node(), nodeDecision, (Decision)result.v2(), ++weightRanking));
        }
        if (canRebalance.type() != Decision.Type.YES || this.allocation.hasPendingAsyncFetch()) {
            AllocationDecision allocationDecision = this.allocation.hasPendingAsyncFetch() ? AllocationDecision.AWAITING_INFO : AllocationDecision.fromDecisionType(canRebalance.type());
            return MoveDecision.cannotRebalance(canRebalance, allocationDecision, currentNodeWeightRanking, nodeDecisions);
        }
        return MoveDecision.rebalance(canRebalance, AllocationDecision.fromDecisionType(rebalanceDecisionType), assignedNode != null ? assignedNode.getRoutingNode().node() : null, currentNodeWeightRanking, nodeDecisions);
    }

    private void balanceByWeights() {
        AllocationDeciders deciders = this.allocation.deciders();
        BalancedShardsAllocator.ModelNode[] modelNodes = this.sorter.modelNodes;
        float[] weights = this.sorter.weights;
        block0: for (String index : this.buildWeightOrderedIndices()) {
            if (this.timedOutFunc != null && this.timedOutFunc.get().booleanValue()) {
                this.logger.info("Cannot balance any shard in the cluster as time allocated to balanced shards allocator has elapsed. Skipping indices iteration");
                return;
            }
            IndexMetadata indexMetadata = this.metadata.index(index);
            int relevantNodes = 0;
            for (int i = 0; i < modelNodes.length; ++i) {
                BalancedShardsAllocator.ModelNode modelNode = modelNodes[i];
                if (modelNode.getIndex(index) == null && deciders.canAllocate(indexMetadata, modelNode.getRoutingNode(), this.allocation).type() == Decision.Type.NO) continue;
                modelNodes[i] = modelNodes[relevantNodes];
                modelNodes[relevantNodes] = modelNode;
                ++relevantNodes;
            }
            if (relevantNodes < 2) continue;
            this.sorter.reset(index, 0, relevantNodes);
            int lowIdx = 0;
            int highIdx = relevantNodes - 1;
            while (true) {
                if (this.timedOutFunc != null && this.timedOutFunc.get().booleanValue()) {
                    this.logger.info("Cannot balance any shard in the cluster as time allocated to balanced shards allocator has elapsed. Skipping relevant nodes iteration");
                    return;
                }
                BalancedShardsAllocator.ModelNode minNode = modelNodes[lowIdx];
                BalancedShardsAllocator.ModelNode maxNode = modelNodes[highIdx];
                if (maxNode.numShards(index) > 0) {
                    float delta = LocalShardsBalancer.absDelta(weights[lowIdx], weights[highIdx]);
                    if (LocalShardsBalancer.lessThan(delta, this.threshold)) {
                        if (lowIdx <= 0 || highIdx - 1 <= 0 || !(LocalShardsBalancer.absDelta(weights[0], weights[highIdx - 1]) > this.threshold)) {
                            if (!this.logger.isTraceEnabled()) continue block0;
                            this.logger.trace("Stop balancing index [{}]  min_node [{}] weight: [{}]  max_node [{}] weight: [{}]  delta: [{}]", (Object)index, (Object)maxNode.getNodeId(), (Object)Float.valueOf(weights[highIdx]), (Object)minNode.getNodeId(), (Object)Float.valueOf(weights[lowIdx]), (Object)Float.valueOf(delta));
                            continue block0;
                        }
                    } else {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("Balancing from node [{}] weight: [{}] to node [{}] weight: [{}]  delta: [{}]", (Object)maxNode.getNodeId(), (Object)Float.valueOf(weights[highIdx]), (Object)minNode.getNodeId(), (Object)Float.valueOf(weights[lowIdx]), (Object)Float.valueOf(delta));
                        }
                        if (delta <= 1.0f) {
                            this.logger.trace("Couldn't find shard to relocate from node [{}] to node [{}]", (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
                        } else if (this.tryRelocateShard(minNode, maxNode, index)) {
                            weights[lowIdx] = this.sorter.weight(modelNodes[lowIdx]);
                            weights[highIdx] = this.sorter.weight(modelNodes[highIdx]);
                            this.sorter.sort(0, relevantNodes);
                            lowIdx = 0;
                            highIdx = relevantNodes - 1;
                            continue;
                        }
                    }
                }
                if (lowIdx < highIdx - 1) {
                    ++lowIdx;
                    continue;
                }
                if (lowIdx <= 0) continue block0;
                lowIdx = 0;
                --highIdx;
            }
        }
    }

    private String[] buildWeightOrderedIndices() {
        ArrayList<String> localIndices = new ArrayList<String>();
        for (String index : this.allocation.routingTable().indicesRouting().keySet().toArray(new String[0])) {
            if (!RoutingPool.LOCAL_ONLY.equals((Object)RoutingPool.getIndexPool(this.metadata.index(index)))) continue;
            localIndices.add(index);
        }
        final String[] indices = localIndices.toArray(new String[0]);
        final float[] deltas = new float[indices.length];
        for (int i = 0; i < deltas.length; ++i) {
            this.sorter.reset(indices[i]);
            deltas[i] = this.sorter.delta();
        }
        new IntroSorter(){
            float pivotWeight;

            protected void swap(int i, int j) {
                String tmpIdx = indices[i];
                indices[i] = indices[j];
                indices[j] = tmpIdx;
                float tmpDelta = deltas[i];
                deltas[i] = deltas[j];
                deltas[j] = tmpDelta;
            }

            protected int compare(int i, int j) {
                return Float.compare(deltas[j], deltas[i]);
            }

            protected void setPivot(int i) {
                this.pivotWeight = deltas[i];
            }

            protected int comparePivot(int j) {
                return Float.compare(deltas[j], this.pivotWeight);
            }
        }.sort(0, deltas.length);
        return indices;
    }

    private void checkAndAddInEligibleTargetNode(RoutingNode targetNode) {
        Decision nodeLevelAllocationDecision = this.allocation.deciders().canAllocateAnyShardToNode(targetNode, this.allocation);
        if (nodeLevelAllocationDecision.type() != Decision.Type.YES) {
            this.inEligibleTargetNode.add(targetNode);
        }
    }

    private boolean canShardBeSkipped(ShardRouting shardRouting) {
        return RoutingPool.REMOTE_CAPABLE.equals((Object)RoutingPool.getShardPool(shardRouting, this.allocation)) && (!FeatureFlags.isEnabled("opensearch.experimental.feature.tiered_remote_index.enabled") || !TieringUtils.isPartialShard(shardRouting, this.allocation));
    }

    @Override
    void moveShards() {
        for (BalancedShardsAllocator.ModelNode currentNode : this.sorter.modelNodes) {
            this.checkAndAddInEligibleTargetNode(currentNode.getRoutingNode());
        }
        boolean primariesThrottled = false;
        Iterator<ShardRouting> it = this.allocation.routingNodes().nodeInterleavedShardIterator(this.shardMovementStrategy);
        while (it.hasNext()) {
            if (this.allocation.deciders().canMoveAnyShard(this.allocation).type() != Decision.Type.YES) {
                this.logger.info("Cannot move any shard in the cluster due to cluster concurrent recoveries getting breached. Skipping shard iteration");
                return;
            }
            if (this.sorter.modelNodes.length == this.inEligibleTargetNode.size()) {
                this.logger.info("Cannot move any shard in the cluster as there is no node on which shards can be allocated. Skipping shard iteration");
                return;
            }
            if (this.timedOutFunc != null && this.timedOutFunc.get().booleanValue()) {
                this.logger.info("Cannot move any shard in the cluster as time allocated to balanced shards allocator has elapsed. Skipping shard iteration");
                return;
            }
            ShardRouting shardRouting = it.next();
            if (this.canShardBeSkipped(shardRouting)) continue;
            if (this.shardMovementStrategy == ShardMovementStrategy.PRIMARY_FIRST && primariesThrottled && !shardRouting.primary()) {
                this.logger.info("Cannot move any replica shard in the cluster as movePrimaryFirst is enabled and primary shardsare being throttled. Skipping shard iteration");
                return;
            }
            Decision canMoveAwayDecision = this.allocation.deciders().canMoveAway(shardRouting, this.allocation);
            if (canMoveAwayDecision.type() != Decision.Type.YES) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Cannot move away shard [{}] Skipping this shard", (Object)shardRouting);
                }
                if (!shardRouting.primary() || canMoveAwayDecision.type() != Decision.Type.THROTTLE) continue;
                primariesThrottled = true;
                continue;
            }
            MoveDecision moveDecision = this.decideMove(shardRouting);
            if (moveDecision.isDecisionTaken() && moveDecision.forceMove()) {
                BalancedShardsAllocator.ModelNode sourceNode = this.nodes.get(shardRouting.currentNodeId());
                BalancedShardsAllocator.ModelNode targetNode = this.nodes.get(moveDecision.getTargetNode().getId());
                sourceNode.removeShard(shardRouting);
                --this.totalShardCount;
                Tuple<ShardRouting, ShardRouting> relocatingShards = this.routingNodes.relocateShard(shardRouting, targetNode.getNodeId(), this.allocation.clusterInfo().getShardSize(shardRouting, -1L), this.allocation.changes());
                targetNode.addShard((ShardRouting)relocatingShards.v2());
                ++this.totalShardCount;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Moved shard [{}] to node [{}]", (Object)shardRouting, (Object)targetNode.getRoutingNode());
                }
                if (targetNode == null) continue;
                this.checkAndAddInEligibleTargetNode(targetNode.getRoutingNode());
                continue;
            }
            if (!moveDecision.isDecisionTaken() || moveDecision.canRemain()) continue;
            this.logger.trace("[{}][{}] can't move", (Object)shardRouting.index(), (Object)shardRouting.id());
        }
    }

    @Override
    MoveDecision decideMove(ShardRouting shardRouting) {
        if (this.canShardBeSkipped(shardRouting)) {
            return MoveDecision.NOT_TAKEN;
        }
        if (!shardRouting.started()) {
            return MoveDecision.NOT_TAKEN;
        }
        boolean explain = this.allocation.debugDecision();
        BalancedShardsAllocator.ModelNode sourceNode = this.nodes.get(shardRouting.currentNodeId());
        assert (sourceNode != null && sourceNode.containsShard(shardRouting));
        RoutingNode routingNode = sourceNode.getRoutingNode();
        Decision canRemain = this.allocation.deciders().canRemain(shardRouting, routingNode, this.allocation);
        if (canRemain.type() != Decision.Type.NO) {
            return MoveDecision.stay(canRemain);
        }
        this.sorter.reset(shardRouting.getIndexName());
        Decision.Type bestDecision = Decision.Type.NO;
        RoutingNode targetNode = null;
        ArrayList<NodeAllocationResult> nodeExplanationMap = explain ? new ArrayList<NodeAllocationResult>() : null;
        int weightRanking = 0;
        for (BalancedShardsAllocator.ModelNode currentNode : this.sorter.modelNodes) {
            Decision nodeLevelAllocationDecision;
            if (currentNode == sourceNode) continue;
            RoutingNode target = currentNode.getRoutingNode();
            if (!explain && this.inEligibleTargetNode.contains(target)) continue;
            if (!explain && (nodeLevelAllocationDecision = this.allocation.deciders().canAllocateAnyShardToNode(target, this.allocation)).type() != Decision.Type.YES) {
                this.inEligibleTargetNode.add(currentNode.getRoutingNode());
                continue;
            }
            Decision allocationDecision = this.allocation.deciders().canAllocate(shardRouting, target, this.allocation);
            if (explain) {
                nodeExplanationMap.add(new NodeAllocationResult(currentNode.getRoutingNode().node(), allocationDecision, ++weightRanking));
            }
            if (!allocationDecision.type().higherThan(bestDecision) || (bestDecision = allocationDecision.type()) != Decision.Type.YES) continue;
            targetNode = target;
            if (!explain) break;
        }
        return MoveDecision.cannotRemain(canRemain, AllocationDecision.fromDecisionType(bestDecision), targetNode != null ? targetNode.node() : null, nodeExplanationMap);
    }

    private Map<String, BalancedShardsAllocator.ModelNode> buildModelFromAssigned() {
        HashMap<String, BalancedShardsAllocator.ModelNode> nodes = new HashMap<String, BalancedShardsAllocator.ModelNode>();
        for (RoutingNode rn : this.routingNodes) {
            BalancedShardsAllocator.ModelNode node = new BalancedShardsAllocator.ModelNode(rn);
            nodes.put(rn.nodeId(), node);
            for (ShardRouting shard : rn) {
                assert (rn.nodeId().equals(shard.currentNodeId()));
                if (!RoutingPool.LOCAL_ONLY.equals((Object)RoutingPool.getShardPool(shard, this.allocation)) && (!FeatureFlags.isEnabled("opensearch.experimental.feature.tiered_remote_index.enabled") || !TieringUtils.isPartialShard(shard, this.allocation)) || shard.state() == ShardRoutingState.RELOCATING) continue;
                node.addShard(shard);
                ++this.totalShardCount;
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("Assigned shard [{}] to node [{}]", (Object)shard, (Object)node.getNodeId());
            }
        }
        return nodes;
    }

    @Override
    void allocateUnassigned() {
        RoutingNodes.UnassignedShards unassigned = this.routingNodes.unassigned();
        assert (!this.nodes.isEmpty());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Start allocating unassigned shards");
        }
        if (unassigned.isEmpty()) {
            return;
        }
        PriorityComparator secondaryComparator = PriorityComparator.getAllocationComparator(this.allocation);
        Comparator comparator = (o1, o2) -> {
            if (o1.primary() ^ o2.primary()) {
                return o1.primary() ? -1 : 1;
            }
            int indexCmp = o1.getIndexName().compareTo(o2.getIndexName());
            if (indexCmp == 0) {
                return o1.getId() - o2.getId();
            }
            int secondary = secondaryComparator.compare((ShardRouting)o1, (ShardRouting)o2);
            return secondary == 0 ? indexCmp : secondary;
        };
        ArrayList<ShardRouting> primaryList = new ArrayList<ShardRouting>();
        for (ShardRouting shard : unassigned.drain()) {
            if (RoutingPool.LOCAL_ONLY.equals((Object)RoutingPool.getShardPool(shard, this.allocation))) {
                primaryList.add(shard);
                continue;
            }
            this.routingNodes.unassigned().add(shard);
        }
        Object[] primary = primaryList.toArray(new ShardRouting[0]);
        Object[] secondary = new ShardRouting[primary.length];
        int secondaryLength = 0;
        int primaryLength = primary.length;
        ArrayUtil.timSort((Object[])primary, (Comparator)comparator);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Staring allocation of [{}] unassigned shards", (Object)primaryLength);
        }
        do {
            for (int i = 0; i < primaryLength; ++i) {
                long shardSize;
                BalancedShardsAllocator.ModelNode minNode;
                if (this.timedOutFunc != null && this.timedOutFunc.get().booleanValue()) {
                    this.logger.info("Ignoring [{}] unassigned shards for allocation as time allocated to balanced shards allocator has elapsed", (Object)(primaryLength - i));
                    while (i < primaryLength) {
                        unassigned.ignoreShard((ShardRouting)primary[i], UnassignedInfo.AllocationStatus.NO_ATTEMPT, this.allocation.changes());
                        ++i;
                    }
                    return;
                }
                Object shard = primary[i];
                AllocateUnassignedDecision allocationDecision = this.decideAllocateUnassigned((ShardRouting)shard);
                String assignedNodeId = allocationDecision.getTargetNode() != null ? allocationDecision.getTargetNode().getId() : null;
                BalancedShardsAllocator.ModelNode modelNode = minNode = assignedNodeId != null ? this.nodes.get(assignedNodeId) : null;
                if (allocationDecision.getAllocationDecision() == AllocationDecision.YES) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Assigned shard [{}] to [{}]", shard, (Object)minNode.getNodeId());
                    }
                    shardSize = DiskThresholdDecider.getExpectedShardSize((ShardRouting)shard, -1L, this.allocation.clusterInfo(), this.allocation.snapshotShardSizeInfo(), this.allocation.metadata(), this.allocation.routingTable());
                    shard = this.routingNodes.initializeShard((ShardRouting)shard, minNode.getNodeId(), null, shardSize, this.allocation.changes());
                    minNode.addShard((ShardRouting)shard);
                    ++this.totalShardCount;
                    if (((ShardRouting)shard).primary()) continue;
                    while (i < primaryLength - 1 && comparator.compare(primary[i], primary[i + 1]) == 0) {
                        secondary[secondaryLength++] = primary[++i];
                    }
                    continue;
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("No eligible node found to assign shard [{}] allocation_status [{}]", shard, (Object)allocationDecision.getAllocationStatus());
                }
                if (minNode != null) {
                    assert (allocationDecision.getAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED);
                    shardSize = DiskThresholdDecider.getExpectedShardSize((ShardRouting)shard, -1L, this.allocation.clusterInfo(), this.allocation.snapshotShardSizeInfo(), this.allocation.metadata(), this.allocation.routingTable());
                    minNode.addShard(((ShardRouting)shard).initialize(minNode.getNodeId(), null, shardSize));
                    ++this.totalShardCount;
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.trace("No Node found to assign shard [{}]", shard);
                }
                unassigned.ignoreShard((ShardRouting)shard, allocationDecision.getAllocationStatus(), this.allocation.changes());
                if (((ShardRouting)shard).primary()) continue;
                while (i < primaryLength - 1 && comparator.compare(primary[i], primary[i + 1]) == 0) {
                    unassigned.ignoreShard((ShardRouting)primary[++i], allocationDecision.getAllocationStatus(), this.allocation.changes());
                }
            }
            primaryLength = secondaryLength;
            Object[] tmp = primary;
            primary = secondary;
            secondary = tmp;
            secondaryLength = 0;
        } while (primaryLength > 0);
    }

    @Override
    AllocateUnassignedDecision decideAllocateUnassigned(ShardRouting shard) {
        if (shard.assignedToNode()) {
            return AllocateUnassignedDecision.NOT_TAKEN;
        }
        boolean explain = this.allocation.debugDecision();
        Decision shardLevelDecision = this.allocation.deciders().canAllocate(shard, this.allocation);
        if (shardLevelDecision.type() == Decision.Type.NO && !explain) {
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.DECIDERS_NO, null);
        }
        float minWeight = Float.POSITIVE_INFINITY;
        BalancedShardsAllocator.ModelNode minNode = null;
        Decision decision = null;
        HashMap<String, NodeAllocationResult> nodeExplanationMap = explain ? new HashMap<String, NodeAllocationResult>() : null;
        ArrayList<Tuple> nodeWeights = explain ? new ArrayList<Tuple>() : null;
        for (BalancedShardsAllocator.ModelNode node : this.nodes.values()) {
            boolean updateMinNode;
            boolean considerThrottleAsNo;
            float currentWeight;
            if (node.containsShard(shard) && !explain || (currentWeight = this.weight.weightWithAllocationConstraints(this, node, shard.getIndexName())) > minWeight && !explain) continue;
            Decision currentDecision = this.allocation.deciders().canAllocate(shard, node.getRoutingNode(), this.allocation);
            if (explain) {
                nodeExplanationMap.put(node.getNodeId(), new NodeAllocationResult(node.getRoutingNode().node(), currentDecision, 0));
                nodeWeights.add(Tuple.tuple((Object)node.getNodeId(), (Object)Float.valueOf(currentWeight)));
            }
            boolean bl = considerThrottleAsNo = this.ignoreThrottleInRestore && shard.recoverySource().getType() == RecoverySource.Type.REMOTE_STORE && shard.primary();
            if (currentDecision.type() != Decision.Type.YES && (currentDecision.type() != Decision.Type.THROTTLE || considerThrottleAsNo)) continue;
            if (currentWeight == minWeight) {
                if (currentDecision.type() == decision.type()) {
                    int repId = shard.id();
                    int nodeHigh = node.highestPrimary(shard.index().getName());
                    int minNodeHigh = minNode.highestPrimary(shard.getIndexName());
                    updateMinNode = (nodeHigh > repId && minNodeHigh > repId || nodeHigh < repId && minNodeHigh < repId) && nodeHigh < minNodeHigh || nodeHigh > repId && minNodeHigh < repId;
                } else {
                    updateMinNode = currentDecision.type() == Decision.Type.YES;
                }
            } else {
                boolean bl2 = updateMinNode = currentWeight < minWeight;
            }
            if (!updateMinNode) continue;
            minNode = node;
            minWeight = currentWeight;
            decision = currentDecision;
        }
        if (decision == null) {
            decision = Decision.NO;
        }
        ArrayList<NodeAllocationResult> nodeDecisions = null;
        if (explain) {
            nodeDecisions = new ArrayList<NodeAllocationResult>();
            nodeWeights.sort((nodeWeight1, nodeWeight2) -> Float.compare(((Float)nodeWeight1.v2()).floatValue(), ((Float)nodeWeight2.v2()).floatValue()));
            int weightRanking = 0;
            for (Tuple nodeWeight : nodeWeights) {
                NodeAllocationResult current = (NodeAllocationResult)nodeExplanationMap.get(nodeWeight.v1());
                nodeDecisions.add(new NodeAllocationResult(current.getNode(), current.getCanAllocateDecision(), ++weightRanking));
            }
        }
        return AllocateUnassignedDecision.fromDecision(decision, minNode != null ? minNode.getRoutingNode().node() : null, nodeDecisions);
    }

    private boolean tryRelocateShard(BalancedShardsAllocator.ModelNode minNode, BalancedShardsAllocator.ModelNode maxNode, String idx) {
        BalancedShardsAllocator.ModelIndex index = maxNode.getIndex(idx);
        if (index != null) {
            this.logger.trace("Try relocating shard of [{}] from [{}] to [{}]", (Object)idx, (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
            Stream<ShardRouting> routingStream = StreamSupport.stream(index.spliterator(), false).filter(ShardRouting::started).filter(maxNode::containsShard).sorted(BY_DESCENDING_SHARD_ID);
            if (this.preferPrimaryBalance) {
                routingStream = routingStream.sorted(PRIMARY_FIRST);
            }
            Iterable shardRoutings = routingStream::iterator;
            AllocationDeciders deciders = this.allocation.deciders();
            for (ShardRouting shard : shardRoutings) {
                Decision allocationDecision;
                Decision rebalanceDecision = deciders.canRebalance(shard, this.allocation);
                if (rebalanceDecision.type() == Decision.Type.NO || (allocationDecision = deciders.canAllocate(shard, minNode.getRoutingNode(), this.allocation)).type() == Decision.Type.NO || this.preferPrimaryBalance && !this.preferPrimaryRebalance && shard.primary() && maxNode.numPrimaryShards(shard.getIndexName()) - minNode.numPrimaryShards(shard.getIndexName()) < 2 || this.preferPrimaryRebalance && shard.primary() && maxNode.numPrimaryShards() - minNode.numPrimaryShards() < 2) continue;
                Decision.Multi decision = new Decision.Multi().add(allocationDecision).add(rebalanceDecision);
                maxNode.removeShard(shard);
                --this.totalShardCount;
                long shardSize = this.allocation.clusterInfo().getShardSize(shard, -1L);
                if (((Decision)decision).type() == Decision.Type.YES) {
                    this.logger.debug("Relocate [{}] from [{}] to [{}]", (Object)shard, (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
                    minNode.addShard((ShardRouting)this.routingNodes.relocateShard(shard, minNode.getNodeId(), shardSize, this.allocation.changes()).v1());
                    ++this.totalShardCount;
                    return true;
                }
                this.logger.debug("Simulate relocation of [{}] from [{}] to [{}]", (Object)shard, (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
                assert (((Decision)decision).type() == Decision.Type.THROTTLE);
                minNode.addShard(shard.relocate(minNode.getNodeId(), shardSize));
                ++this.totalShardCount;
                return false;
            }
        }
        this.logger.trace("No shards of [{}] can relocate from [{}] to [{}]", (Object)idx, (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
        return false;
    }
}

