/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.lucene.index.DocValuesType;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.compositeindex.datacube.Dimension;

@ExperimentalApi
public class NumericDimension
implements Dimension {
    public static final String NUMERIC = "numeric";
    private final String field;

    public NumericDimension(String field) {
        this.field = field;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public int getNumSubDimensions() {
        return 1;
    }

    @Override
    public void setDimensionValues(Long val, Consumer<Long> dimSetter) {
        dimSetter.accept(val);
    }

    @Override
    public List<String> getSubDimensionNames() {
        return List.of(this.field);
    }

    @Override
    public DocValuesType getDocValuesType() {
        return DocValuesType.SORTED_NUMERIC;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.field);
        builder.field("type", NUMERIC);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericDimension dimension = (NumericDimension)o;
        return Objects.equals(this.field, dimension.getField());
    }

    public int hashCode() {
        return Objects.hash(this.field);
    }
}

