/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.NonCollectingAggregator;
import org.opensearch.search.aggregations.bucket.sampler.DiversifiedAggregationBuilder;
import org.opensearch.search.aggregations.bucket.sampler.DiversifiedNumericSamplerAggregator;
import org.opensearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.opensearch.search.aggregations.bucket.sampler.UnmappedSampler;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.internal.SearchContext;

public class DiversifiedAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final int shardSize;
    private final int maxDocsPerValue;
    private final String executionHint;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(DiversifiedAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), (name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue, executionHint) -> new DiversifiedNumericSamplerAggregator(name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue), true);
        builder.register(DiversifiedAggregationBuilder.REGISTRY_KEY, CoreValuesSourceType.BYTES, (name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue, executionHint) -> {
            SamplerAggregator.ExecutionMode execution = null;
            if (executionHint != null) {
                execution = SamplerAggregator.ExecutionMode.fromString(executionHint);
            }
            if (execution == null) {
                execution = SamplerAggregator.ExecutionMode.GLOBAL_ORDINALS;
            }
            if (execution.needsGlobalOrdinals() && !valuesSourceConfig.hasGlobalOrdinals()) {
                execution = SamplerAggregator.ExecutionMode.MAP;
            }
            return execution.create(name, factories, shardSize, maxDocsPerValue, valuesSourceConfig, context, parent, metadata);
        }, true);
    }

    DiversifiedAggregatorFactory(String name, ValuesSourceConfig config, int shardSize, int maxDocsPerValue, String executionHint, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.shardSize = shardSize;
        this.maxDocsPerValue = maxDocsPerValue;
        this.executionHint = executionHint;
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.queryShardContext.getValuesSourceRegistry().getAggregator(DiversifiedAggregationBuilder.REGISTRY_KEY, this.config).build(this.name, this.shardSize, this.factories, searchContext, parent, metadata, this.config, this.maxDocsPerValue, this.executionHint);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        final UnmappedSampler aggregation = new UnmappedSampler(this.name, metadata);
        return new NonCollectingAggregator(this.name, searchContext, parent, this.factories, metadata){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    @Override
    protected boolean supportsConcurrentSegmentSearch() {
        return false;
    }
}

