/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.lucene.spatial3d.geom.GeoBasePolygon;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.lucene.spatial3d.geom.Membership;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.SerializableObject;
import org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.lucene.spatial3d.geom.Vector;

class GeoS2Shape
extends GeoBasePolygon {
    protected final GeoPoint point1;
    protected final GeoPoint point2;
    protected final GeoPoint point3;
    protected final GeoPoint point4;
    protected final SidedPlane plane1;
    protected final SidedPlane plane2;
    protected final SidedPlane plane3;
    protected final SidedPlane plane4;
    protected final GeoPoint[] plane1Points;
    protected final GeoPoint[] plane2Points;
    protected final GeoPoint[] plane3Points;
    protected final GeoPoint[] plane4Points;
    protected final GeoPoint[] edgePoints;

    public GeoS2Shape(PlanetModel planetModel, GeoPoint point1, GeoPoint point2, GeoPoint point3, GeoPoint point4) {
        super(planetModel);
        this.point1 = point1;
        this.point2 = point2;
        this.point3 = point3;
        this.point4 = point4;
        this.plane1 = new SidedPlane((Vector)point4, (Vector)point1, point2);
        this.plane2 = new SidedPlane((Vector)point1, (Vector)point2, point3);
        this.plane3 = new SidedPlane((Vector)point2, (Vector)point3, point4);
        this.plane4 = new SidedPlane((Vector)point3, (Vector)point4, point1);
        this.plane1Points = new GeoPoint[]{point1, point2};
        this.plane2Points = new GeoPoint[]{point2, point3};
        this.plane3Points = new GeoPoint[]{point3, point4};
        this.plane4Points = new GeoPoint[]{point4, point1};
        this.edgePoints = new GeoPoint[]{point1};
    }

    public GeoS2Shape(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, (GeoPoint)SerializableObject.readObject(inputStream), (GeoPoint)SerializableObject.readObject(inputStream), (GeoPoint)SerializableObject.readObject(inputStream), (GeoPoint)SerializableObject.readObject(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeObject(outputStream, this.point1);
        SerializableObject.writeObject(outputStream, this.point2);
        SerializableObject.writeObject(outputStream, this.point3);
        SerializableObject.writeObject(outputStream, this.point4);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.plane1.isWithin(x, y, z) && this.plane2.isWithin(x, y, z) && this.plane3.isWithin(x, y, z) && this.plane4.isWithin(x, y, z);
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.plane1, notablePoints, this.plane1Points, bounds, this.plane2, this.plane4) || p.intersects(this.planetModel, this.plane2, notablePoints, this.plane2Points, bounds, this.plane3, this.plane1) || p.intersects(this.planetModel, this.plane3, notablePoints, this.plane3Points, bounds, this.plane4, this.plane2) || p.intersects(this.planetModel, this.plane4, notablePoints, this.plane4Points, bounds, this.plane1, this.plane3);
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        return geoShape.intersects(this.plane1, this.plane1Points, this.plane2, this.plane4) || geoShape.intersects(this.plane2, this.plane2Points, this.plane3, this.plane1) || geoShape.intersects(this.plane3, this.plane3Points, this.plane4, this.plane2) || geoShape.intersects(this.plane4, this.plane4Points, this.plane1, this.plane3);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.addPlane(this.planetModel, this.plane1, this.plane2, this.plane4).addPlane(this.planetModel, this.plane2, this.plane3, this.plane1).addPlane(this.planetModel, this.plane3, this.plane4, this.plane2).addPlane(this.planetModel, this.plane4, this.plane1, this.plane3).addPoint(this.point1).addPoint(this.point2).addPoint(this.point3).addPoint(this.point4);
    }

    @Override
    public double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double planeDistance1 = distanceStyle.computeDistance(this.planetModel, (Plane)this.plane1, x, y, z, this.plane2, this.plane4);
        double planeDistance2 = distanceStyle.computeDistance(this.planetModel, (Plane)this.plane2, x, y, z, this.plane3, this.plane1);
        double planeDistance3 = distanceStyle.computeDistance(this.planetModel, (Plane)this.plane3, x, y, z, this.plane4, this.plane2);
        double planeDistance4 = distanceStyle.computeDistance(this.planetModel, (Plane)this.plane4, x, y, z, this.plane1, this.plane3);
        double pointDistance1 = distanceStyle.computeDistance(this.point1, x, y, z);
        double pointDistance2 = distanceStyle.computeDistance(this.point2, x, y, z);
        double pointDistance3 = distanceStyle.computeDistance(this.point3, x, y, z);
        double pointDistance4 = distanceStyle.computeDistance(this.point4, x, y, z);
        return Math.min(Math.min(Math.min(planeDistance1, planeDistance2), Math.min(planeDistance3, planeDistance4)), Math.min(Math.min(pointDistance1, pointDistance2), Math.min(pointDistance3, pointDistance4)));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoS2Shape)) {
            return false;
        }
        GeoS2Shape other = (GeoS2Shape)o;
        return super.equals(other) && other.point1.equals(this.point1) && other.point2.equals(this.point2) && other.point3.equals(this.point3) && other.point4.equals(this.point4);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.point1.hashCode();
        result = 31 * result + this.point2.hashCode();
        result = 31 * result + this.point3.hashCode();
        result = 31 * result + this.point4.hashCode();
        return result;
    }

    public String toString() {
        return "GeoS2Shape: {planetmodel=" + this.planetModel + ", point1=" + this.point1 + ", point2=" + this.point2 + ", point3=" + this.point3 + ", point4=" + this.point4 + "}";
    }
}

