/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.streamingingestion.resume;

import java.io.IOException;
import java.util.Arrays;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.AcknowledgedRequest;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.util.CollectionUtils;

@ExperimentalApi
public class ResumeIngestionRequest
extends AcknowledgedRequest<ResumeIngestionRequest>
implements IndicesRequest.Replaceable {
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();
    private final ResetSettings[] resetSettingsList;

    public ResumeIngestionRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.resetSettingsList = (ResetSettings[])in.readArray(ResetSettings::new, ResetSettings[]::new);
    }

    public ResumeIngestionRequest(String[] indices) {
        this(indices, new ResetSettings[0]);
    }

    public ResumeIngestionRequest(String[] indices, ResetSettings[] resetSettingsList) {
        this.indices = indices;
        this.resetSettingsList = resetSettingsList;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (CollectionUtils.isEmpty((Object[])this.indices)) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        if (this.resetSettingsList.length > 0) {
            boolean invalidResetSettingsFound = Arrays.stream(this.resetSettingsList).anyMatch(resetSettings -> resetSettings.getShard() < 0 || resetSettings.getMode() == null || resetSettings.getValue() == null);
            if (invalidResetSettingsFound) {
                validationException = ValidateActions.addValidationError("ResetSettings is missing either shard, mode or value", validationException);
            }
            validationException = ValidateActions.addValidationError("reset settings is currently not supported", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public ResumeIngestionRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public ResumeIngestionRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeArray((Writeable[])this.resetSettingsList);
    }

    @ExperimentalApi
    public static class ResetSettings
    implements Writeable {
        private final int shard;
        private final String mode;
        private final String value;

        public ResetSettings(int shard, String mode, String value) {
            this.shard = shard;
            this.mode = mode;
            this.value = value;
        }

        public ResetSettings(StreamInput in) throws IOException {
            this.shard = in.readVInt();
            this.mode = in.readString();
            this.value = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.shard);
            out.writeString(this.mode);
            out.writeString(this.value);
        }

        public int getShard() {
            return this.shard;
        }

        public String getMode() {
            return this.mode;
        }

        public String getValue() {
            return this.value;
        }
    }
}

