/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.streamingingestion.state;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.lucene.store.AlreadyClosedException;
import org.opensearch.action.admin.indices.streamingingestion.state.ShardIngestionState;
import org.opensearch.action.admin.indices.streamingingestion.state.UpdateIngestionStateRequest;
import org.opensearch.action.admin.indices.streamingingestion.state.UpdateIngestionStateResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.IngestionStatus;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardNotFoundException;
import org.opensearch.indices.IndicesService;
import org.opensearch.transport.TransportService;

public class TransportUpdateIngestionStateAction
extends TransportBroadcastByNodeAction<UpdateIngestionStateRequest, UpdateIngestionStateResponse, ShardIngestionState> {
    private final IndicesService indicesService;

    @Inject
    public TransportUpdateIngestionStateAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/ingestion/updateState", clusterService, transportService, actionFilters, indexNameExpressionResolver, UpdateIngestionStateRequest::new, "management");
        this.indicesService = indicesService;
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, UpdateIngestionStateRequest request, String[] concreteIndices) {
        Set shardSet = Arrays.stream(request.getShards()).boxed().collect(Collectors.toSet());
        Predicate<ShardRouting> shardFilter = ShardRouting::primary;
        if (!shardSet.isEmpty()) {
            shardFilter = shardFilter.and(shardRouting -> shardSet.contains(shardRouting.shardId().getId()));
        }
        return clusterState.routingTable().allShardsSatisfyingPredicate(request.getIndex(), shardFilter);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, UpdateIngestionStateRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, UpdateIngestionStateRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, request.indices());
    }

    @Override
    protected ShardIngestionState readShardResult(StreamInput in) throws IOException {
        return new ShardIngestionState(in);
    }

    @Override
    protected UpdateIngestionStateResponse newResponse(UpdateIngestionStateRequest request, int totalShards, int successfulShards, int failedShards, List<ShardIngestionState> responses, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new UpdateIngestionStateResponse(true, totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected UpdateIngestionStateRequest readRequestFrom(StreamInput in) throws IOException {
        return new UpdateIngestionStateRequest(in);
    }

    @Override
    protected ShardIngestionState shardOperation(UpdateIngestionStateRequest request, ShardRouting shardRouting) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
        if (indexShard.routingEntry() == null) {
            throw new ShardNotFoundException(indexShard.shardId());
        }
        try {
            if (request.getIngestionPaused() != null) {
                indexShard.updateShardIngestionState(new IngestionStatus(request.getIngestionPaused()));
            }
            return indexShard.getIngestionState();
        }
        catch (AlreadyClosedException e) {
            throw new ShardNotFoundException(indexShard.shardId());
        }
    }
}

