/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.RoutingPool;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.decider.AllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.Decision;

public class TargetPoolAllocationDecider
extends AllocationDecider {
    private static final Logger logger = LogManager.getLogger(TargetPoolAllocationDecider.class);
    public static final String NAME = "target_pool";

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        RoutingPool shardPool = RoutingPool.getShardPool(shardRouting, allocation);
        RoutingPool targetNodePool = RoutingPool.getNodePool(node);
        if (RoutingPool.REMOTE_CAPABLE.equals((Object)shardPool) && RoutingPool.LOCAL_ONLY.equals((Object)targetNodePool)) {
            logger.debug("Shard: [{}] has target pool: [{}]. Cannot allocate on node: [{}] with target pool: [{}]", (Object)shardRouting, (Object)shardPool, (Object)node.node(), (Object)targetNodePool);
            return allocation.decision(Decision.NO, NAME, "Routing pools are incompatible. Shard pool: [%s], node pool: [%s]", new Object[]{shardPool, targetNodePool});
        }
        if (RoutingPool.LOCAL_ONLY.equals((Object)shardPool) && RoutingPool.REMOTE_CAPABLE.equals((Object)targetNodePool) && !node.node().getRoles().contains(DiscoveryNodeRole.DATA_ROLE)) {
            logger.debug("Shard: [{}] has target pool: [{}]. Cannot allocate on node: [{}] without the [{}] node role", (Object)shardRouting, (Object)shardPool, (Object)node.node(), (Object)DiscoveryNodeRole.DATA_ROLE.roleName());
            return allocation.decision(Decision.NO, NAME, "Routing pools are incompatible. Shard pool: [%s], node pool: [%s] without [%s] role", new Object[]{shardPool, targetNodePool, DiscoveryNodeRole.DATA_ROLE.roleName()});
        }
        return allocation.decision(Decision.YES, NAME, "Routing pools are compatible. Shard pool: [%s], node pool: [%s]", new Object[]{shardPool, targetNodePool});
    }

    @Override
    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocateInTargetPool(indexMetadata, node.node(), allocation);
    }

    @Override
    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        logger.debug("Evaluating force allocation for primary shard.");
        return this.canAllocate(shardRouting, node, allocation);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        RoutingPool targetPool = RoutingPool.getShardPool(shardRouting, allocation);
        RoutingPool currentNodePool = RoutingPool.getNodePool(allocation.routingNodes().node(shardRouting.currentNodeId()));
        if (RoutingPool.REMOTE_CAPABLE.equals((Object)targetPool) && targetPool != currentNodePool) {
            logger.debug("Shard: [{}] has current pool: [{}], target pool: [{}]. Cannot remain on node: [{}]", (Object)shardRouting.shortSummary(), (Object)currentNodePool.name(), (Object)RoutingPool.REMOTE_CAPABLE.name(), (Object)node.node());
            return allocation.decision(Decision.NO, NAME, "Shard %s is allocated on a different pool %s than the target pool %s", new Object[]{shardRouting.shortSummary(), currentNodePool, targetPool});
        }
        return allocation.decision(Decision.YES, NAME, "Routing pools are compatible. Shard pool: [%s], node pool: [%s]", new Object[]{currentNodePool, targetPool});
    }

    @Override
    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        logger.debug("Evaluating node: {} for autoExpandReplica eligibility of index: {}", (Object)node, (Object)indexMetadata.getIndex());
        return this.canAllocateInTargetPool(indexMetadata, node, allocation);
    }

    private Decision canAllocateInTargetPool(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        RoutingPool indexPool = RoutingPool.getIndexPool(indexMetadata);
        RoutingPool targetNodePool = RoutingPool.getNodePool(node);
        if (RoutingPool.REMOTE_CAPABLE.equals((Object)indexPool) && RoutingPool.LOCAL_ONLY.equals((Object)targetNodePool)) {
            logger.debug("Index: [{}] has target pool: [{}]. Cannot allocate on node: [{}] with target pool: [{}]", (Object)indexMetadata.getIndex().getName(), (Object)indexPool, (Object)node, (Object)targetNodePool);
            return allocation.decision(Decision.NO, NAME, "Routing pools are incompatible. Index pool: [%s], node pool: [%s]", new Object[]{indexPool, targetNodePool});
        }
        if (RoutingPool.LOCAL_ONLY.equals((Object)indexPool) && RoutingPool.REMOTE_CAPABLE.equals((Object)targetNodePool) && !node.getRoles().contains(DiscoveryNodeRole.DATA_ROLE)) {
            logger.debug("Index: [{}] has target pool: [{}]. Cannot allocate on node: [{}] without the [{}] node role", (Object)indexMetadata.getIndex().getName(), (Object)indexPool, (Object)node, (Object)DiscoveryNodeRole.DATA_ROLE.roleName());
            return allocation.decision(Decision.NO, NAME, "Routing pools are incompatible. Index pool: [%s], node pool: [%s] without [%s] role", new Object[]{indexPool, targetNodePool, DiscoveryNodeRole.DATA_ROLE.roleName()});
        }
        return allocation.decision(Decision.YES, NAME, "Routing pools are compatible. Index pool: [%s], node pool: [%s]", new Object[]{indexPool, targetNodePool});
    }
}

