/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.sandbox.search.MultiRangeQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.opensearch.Version;
import org.opensearch.common.Nullable;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.network.InetAddresses;
import org.opensearch.common.network.NetworkAddress;
import org.opensearch.index.compositeindex.datacube.DimensionType;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SimpleMappedFieldType;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.lookup.SearchLookup;

public class IpFieldMapper
extends ParametrizedFieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(IpFieldMapper.class);
    public static final String CONTENT_TYPE = "ip";
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings());
        return new Builder((String)n, ignoreMalformedByDefault, c.indexVersionCreated());
    });
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final boolean ignoreMalformed;
    private final InetAddress nullValue;
    private final String nullValueAsString;
    private final boolean ignoreMalformedByDefault;
    private final Version indexCreatedVersion;

    private static IpFieldMapper toType(FieldMapper in) {
        return (IpFieldMapper)in;
    }

    private IpFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.ignoreMalformedByDefault = builder.ignoreMalformedByDefault;
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.stored = builder.stored.getValue();
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.nullValue = builder.parseNullValue();
        this.nullValueAsString = builder.nullValue.getValue();
        this.indexCreatedVersion = builder.indexCreatedVersion;
    }

    boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Override
    public IpFieldType fieldType() {
        return (IpFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().typeName();
    }

    @Override
    protected IpFieldMapper clone() {
        return (IpFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        InetAddress address;
        Object addressAsObject = context.externalValueSet() ? context.externalValue() : context.parser().textOrNull();
        if (addressAsObject == null) {
            addressAsObject = this.nullValue;
        }
        if (addressAsObject == null) {
            return;
        }
        String addressAsString = addressAsObject.toString();
        if (addressAsObject instanceof InetAddress) {
            address = (InetAddress)addressAsObject;
        } else {
            try {
                address = InetAddresses.forString((String)addressAsString);
            }
            catch (IllegalArgumentException e) {
                if (this.ignoreMalformed) {
                    context.addIgnoredField(this.fieldType().name());
                    return;
                }
                throw e;
            }
        }
        if (this.indexed && this.hasDocValues) {
            context.doc().add((IndexableField)new InetAddressField(this.fieldType().name(), address));
        } else if (this.indexed) {
            context.doc().add((IndexableField)new InetAddressPoint(this.fieldType().name(), address));
        } else if (this.hasDocValues) {
            context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode((InetAddress)address))));
        }
        if ((this.stored || this.indexed) && !this.hasDocValues) {
            this.createFieldNamesField(context);
        }
        if (this.stored) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), new BytesRef(InetAddressPoint.encode((InetAddress)address))));
        }
    }

    public static InetAddressField buildInetAddressField(String name, InetAddress value) {
        return new InetAddressField(name, value);
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.ignoreMalformedByDefault, this.indexCreatedVersion).init(this);
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> indexed = ParametrizedFieldMapper.Parameter.indexParam(m -> IpFieldMapper.toType((FieldMapper)m).indexed, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> IpFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.storeParam(m -> IpFieldMapper.toType((FieldMapper)m).stored, false);
        private final ParametrizedFieldMapper.Parameter<Boolean> ignoreMalformed;
        private final ParametrizedFieldMapper.Parameter<String> nullValue = ParametrizedFieldMapper.Parameter.stringParam("null_value", false, m -> IpFieldMapper.toType((FieldMapper)m).nullValueAsString, null).acceptsNull();
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        private final boolean ignoreMalformedByDefault;
        private final Version indexCreatedVersion;

        public Builder(String name, boolean ignoreMalformedByDefault, Version indexCreatedVersion) {
            super(name);
            this.ignoreMalformedByDefault = ignoreMalformedByDefault;
            this.indexCreatedVersion = indexCreatedVersion;
            this.ignoreMalformed = ParametrizedFieldMapper.Parameter.boolParam("ignore_malformed", true, m -> IpFieldMapper.toType((FieldMapper)m).ignoreMalformed, ignoreMalformedByDefault);
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue(nullValue);
            return this;
        }

        private InetAddress parseNullValue() {
            String nullValueAsString = this.nullValue.getValue();
            if (nullValueAsString == null) {
                return null;
            }
            try {
                return InetAddresses.forString((String)nullValueAsString);
            }
            catch (Exception e) {
                DEPRECATION_LOGGER.deprecate("ip_mapper_null_field", "Error parsing [" + this.nullValue.getValue() + "] as IP in [null_value] on field [" + this.name() + "]); [null_value] will be ignored", new Object[0]);
                return null;
            }
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.nullValue, this.meta);
        }

        @Override
        public IpFieldMapper build(Mapper.BuilderContext context) {
            return new IpFieldMapper(this.name, new IpFieldType(this.buildFullName(context), (boolean)this.indexed.getValue(), (boolean)this.stored.getValue(), (boolean)this.hasDocValues.getValue(), this.parseNullValue(), this.meta.getValue()), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }

        @Override
        public Optional<DimensionType> getSupportedDataCubeDimensionType() {
            return Optional.of(DimensionType.IP);
        }
    }

    public static final class IpFieldType
    extends SimpleMappedFieldType {
        private final InetAddress nullValue;

        public IpFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, InetAddress nullValue, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.nullValue = nullValue;
        }

        public IpFieldType(String name) {
            this(name, true, false, true, (InetAddress)null, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return IpFieldMapper.CONTENT_TYPE;
        }

        private static InetAddress parse(Object value) {
            if (value instanceof InetAddress) {
                return (InetAddress)value;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return InetAddresses.forString((String)value.toString());
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this, this.name(), context, this.nullValue){

                @Override
                protected Object parseSourceValue(Object value) {
                    InetAddress address = value instanceof InetAddress ? (InetAddress)value : InetAddresses.forString((String)value.toString());
                    return InetAddresses.toAddrString((InetAddress)address);
                }
            };
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            PointRangeQuery pointQuery;
            this.failIfNotIndexedAndNoDocValues();
            if (value instanceof InetAddress) {
                pointQuery = (PointRangeQuery)InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)((InetAddress)value));
            } else {
                String term;
                if (value instanceof BytesRef) {
                    value = ((BytesRef)value).utf8ToString();
                }
                if ((term = value.toString()).contains("/")) {
                    Tuple cidr = InetAddresses.parseCidr((String)term);
                    pointQuery = (PointRangeQuery)InetAddressPoint.newPrefixQuery((String)this.name(), (InetAddress)((InetAddress)cidr.v1()), (int)((Integer)cidr.v2()));
                } else {
                    InetAddress address = InetAddresses.forString((String)term);
                    pointQuery = (PointRangeQuery)InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)address);
                }
            }
            Query dvQuery = null;
            if (this.hasDocValues()) {
                dvQuery = SortedSetDocValuesField.newSlowRangeQuery((String)this.name(), (BytesRef)new BytesRef(pointQuery.getLowerPoint()), (BytesRef)new BytesRef(pointQuery.getUpperPoint()), (boolean)true, (boolean)true);
            }
            if (this.isSearchable() && this.hasDocValues()) {
                return new IndexOrDocValuesQuery((Query)pointQuery, dvQuery);
            }
            return this.isSearchable() ? pointQuery : dvQuery;
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            Tuple<List<InetAddress>, List<String>> ipsMasks = IpFieldType.splitIpsAndMasks(values);
            ArrayList<Query> combiner = new ArrayList<Query>();
            this.convertIps((List)ipsMasks.v1(), combiner);
            this.convertMasks((List)ipsMasks.v2(), context, combiner);
            if (combiner.size() == 1) {
                return (Query)combiner.get(0);
            }
            return new ConstantScoreQuery(this.union(combiner));
        }

        private Query union(List<Query> combiner) {
            BooleanQuery.Builder bqb = new BooleanQuery.Builder();
            for (Query q : combiner) {
                bqb.add(q, BooleanClause.Occur.SHOULD);
            }
            return bqb.build();
        }

        private void convertIps(List<InetAddress> inetAddresses, List<Query> sink) {
            if (!inetAddresses.isEmpty() && (this.isSearchable() || this.hasDocValues())) {
                Query pointsQuery = null;
                if (this.isSearchable()) {
                    pointsQuery = inetAddresses.size() == 1 ? InetAddressPoint.newExactQuery((String)this.name(), (InetAddress)inetAddresses.iterator().next()) : InetAddressPoint.newSetQuery((String)this.name(), (InetAddress[])inetAddresses.toArray(new InetAddress[0]));
                }
                Query dvQuery = null;
                if (this.hasDocValues()) {
                    ArrayList<BytesRef> set = new ArrayList<BytesRef>(inetAddresses.size());
                    for (InetAddress address : inetAddresses) {
                        set.add(new BytesRef(InetAddressPoint.encode((InetAddress)address)));
                    }
                    dvQuery = set.size() == 1 ? SortedSetDocValuesField.newSlowExactQuery((String)this.name(), (BytesRef)((BytesRef)set.iterator().next())) : SortedSetDocValuesField.newSlowSetQuery((String)this.name(), set);
                }
                Object out = this.isSearchable() && this.hasDocValues() ? new IndexOrDocValuesQuery(pointsQuery, dvQuery) : (this.isSearchable() ? pointsQuery : dvQuery);
                sink.add((Query)out);
            }
        }

        private void convertMasks(List<String> masks, QueryShardContext context, List<Query> sink) {
            if (!masks.isEmpty() && (this.isSearchable() || this.hasDocValues())) {
                MultiIpRangeQueryBuilder multiRange = null;
                for (String mask : masks) {
                    Tuple cidr = InetAddresses.parseCidr((String)mask);
                    PointRangeQuery query = (PointRangeQuery)InetAddressPoint.newPrefixQuery((String)this.name(), (InetAddress)((InetAddress)cidr.v1()), (int)((Integer)cidr.v2()));
                    if (this.isSearchable()) {
                        if (multiRange == null) {
                            multiRange = new MultiIpRangeQueryBuilder(this.name());
                        }
                        multiRange.add(query.getLowerPoint(), query.getUpperPoint());
                        continue;
                    }
                    Query dvRange = SortedSetDocValuesField.newSlowRangeQuery((String)this.name(), (BytesRef)new BytesRef(query.getLowerPoint()), (BytesRef)new BytesRef(query.getUpperPoint()), (boolean)true, (boolean)true);
                    sink.add(dvRange);
                }
                if (multiRange != null) {
                    sink.add((Query)multiRange.build());
                }
            }
        }

        private static Tuple<List<InetAddress>, List<String>> splitIpsAndMasks(List<?> values) {
            ArrayList<InetAddress> concreteIPs = new ArrayList<InetAddress>();
            ArrayList<String> masks = new ArrayList<String>();
            for (Object value : values) {
                String strVal;
                if (value instanceof InetAddress) {
                    concreteIPs.add((InetAddress)value);
                    continue;
                }
                String string = strVal = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
                if (strVal.contains("/")) {
                    masks.add(strVal);
                    continue;
                }
                concreteIPs.add(InetAddresses.forString((String)strVal));
            }
            return Tuple.tuple(concreteIPs, masks);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            return IpFieldType.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (lower, upper) -> {
                PointRangeQuery pointQuery = (PointRangeQuery)InetAddressPoint.newRangeQuery((String)this.name(), (InetAddress)lower, (InetAddress)upper);
                Query dvQuery = null;
                if (this.hasDocValues()) {
                    dvQuery = SortedSetDocValuesField.newSlowRangeQuery((String)pointQuery.getField(), (BytesRef)new BytesRef(pointQuery.getLowerPoint()), (BytesRef)new BytesRef(pointQuery.getUpperPoint()), (boolean)true, (boolean)true);
                }
                if (this.isSearchable() && this.hasDocValues()) {
                    return new IndexOrDocValuesQuery((Query)pointQuery, dvQuery);
                }
                return this.isSearchable() ? pointQuery : dvQuery;
            });
        }

        public static Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<InetAddress, InetAddress, Query> builder) {
            InetAddress upper;
            InetAddress lower;
            if (lowerTerm == null) {
                lower = InetAddressPoint.MIN_VALUE;
            } else {
                lower = IpFieldType.parse(lowerTerm);
                if (!includeLower) {
                    if (lower.equals(InetAddressPoint.MAX_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    lower = InetAddressPoint.nextUp((InetAddress)lower);
                }
            }
            if (upperTerm == null) {
                upper = InetAddressPoint.MAX_VALUE;
            } else {
                upper = IpFieldType.parse(upperTerm);
                if (!includeUpper) {
                    if (upper.equals(InetAddressPoint.MIN_VALUE)) {
                        return new MatchNoDocsQuery();
                    }
                    upper = InetAddressPoint.nextDown((InetAddress)upper);
                }
            }
            return builder.apply(lower, upper);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), IpScriptDocValues::new, CoreValuesSourceType.IP);
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return DocValueFormat.IP.format((BytesRef)value);
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
            }
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            return DocValueFormat.IP;
        }

        public static final class IpScriptDocValues
        extends ScriptDocValues<String> {
            private final SortedSetDocValues in;
            private long[] ords = new long[0];
            private int count;

            public IpScriptDocValues(SortedSetDocValues in) {
                this.in = in;
            }

            @Override
            public void setNextDocId(int docId) throws IOException {
                this.count = 0;
                if (this.in.advanceExact(docId)) {
                    long ord = this.in.nextOrd();
                    while (ord != Integer.MAX_VALUE && this.count < this.in.docValueCount()) {
                        this.ords = ArrayUtil.grow((long[])this.ords, (int)(this.count + 1));
                        this.ords[this.count++] = ord;
                        ord = this.in.nextOrd();
                    }
                }
            }

            public String getValue() {
                if (this.count == 0) {
                    return null;
                }
                return this.get(0);
            }

            @Override
            public String get(int index) {
                try {
                    BytesRef encoded = this.in.lookupOrd(this.ords[index]);
                    InetAddress address = InetAddressPoint.decode((byte[])Arrays.copyOfRange(encoded.bytes, encoded.offset, encoded.offset + encoded.length));
                    return InetAddresses.toAddrString((InetAddress)address);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int size() {
                return this.count;
            }
        }
    }

    public static class InetAddressField
    extends Field {
        private static final FieldType FIELD_TYPE = new FieldType();

        public InetAddressField(String name, InetAddress value) {
            super(name, (IndexableFieldType)FIELD_TYPE);
            this.fieldsData = new BytesRef(InetAddressPoint.encode((InetAddress)value));
        }

        static {
            FIELD_TYPE.setDimensions(1, 16);
            FIELD_TYPE.setDocValuesType(DocValuesType.SORTED_SET);
            FIELD_TYPE.freeze();
        }
    }

    public static class MultiIpRangeQueryBuilder
    extends MultiRangeQuery.Builder {
        public MultiIpRangeQueryBuilder(String field) {
            super(field, 16, 1);
        }

        public MultiIpRangeQueryBuilder add(InetAddress lower, InetAddress upper) {
            this.add(new MultiRangeQuery.RangeClause(InetAddressPoint.encode((InetAddress)lower), InetAddressPoint.encode((InetAddress)upper)));
            return this;
        }

        public MultiRangeQuery build() {
            return new MultiRangeQuery(this, this.field, this.numDims, this.bytesPerDim, this.clauses){

                protected String toString(int dimension, byte[] value) {
                    return NetworkAddress.format((InetAddress)InetAddressPoint.decode((byte[])value));
                }
            };
        }
    }
}

