/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.pipeline.PipelinedRequest;
import org.opensearch.transport.client.Client;

@PublicApi(since="2.19.0")
public class QueryCoordinatorContext
implements QueryRewriteContext {
    private final QueryRewriteContext rewriteContext;
    private final PipelinedRequest searchRequest;

    public QueryCoordinatorContext(QueryRewriteContext rewriteContext, PipelinedRequest searchRequest) {
        this.rewriteContext = rewriteContext;
        this.searchRequest = searchRequest;
    }

    @Override
    public NamedXContentRegistry getXContentRegistry() {
        return this.rewriteContext.getXContentRegistry();
    }

    @Override
    public long nowInMillis() {
        return this.rewriteContext.nowInMillis();
    }

    @Override
    public NamedWriteableRegistry getWriteableRegistry() {
        return this.rewriteContext.getWriteableRegistry();
    }

    @Override
    public QueryShardContext convertToShardContext() {
        return this.rewriteContext.convertToShardContext();
    }

    @Override
    public void registerAsyncAction(BiConsumer<Client, ActionListener<?>> asyncAction) {
        this.rewriteContext.registerAsyncAction(asyncAction);
    }

    @Override
    public boolean hasAsyncActions() {
        return this.rewriteContext.hasAsyncActions();
    }

    @Override
    public void executeAsyncActions(ActionListener listener) {
        this.rewriteContext.executeAsyncActions(listener);
    }

    @Override
    public boolean validate() {
        return this.rewriteContext.validate();
    }

    @Override
    public QueryCoordinatorContext convertToCoordinatorContext() {
        return this;
    }

    public Map<String, Object> getContextVariables() {
        HashMap<String, Object> contextVariables = new HashMap<String, Object>(this.searchRequest.getPipelineProcessingContext().getAttributes());
        return contextVariables;
    }
}

