/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.pollingingest;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public class PollingIngestStats
implements Writeable,
ToXContentFragment {
    private final MessageProcessorStats messageProcessorStats;
    private final ConsumerStats consumerStats;

    public PollingIngestStats(MessageProcessorStats messageProcessorStats, ConsumerStats consumerStats) {
        this.messageProcessorStats = messageProcessorStats;
        this.consumerStats = consumerStats;
    }

    public PollingIngestStats(StreamInput in) throws IOException {
        long totalProcessedCount = in.readLong();
        long totalSkippedCount = in.readLong();
        this.messageProcessorStats = new MessageProcessorStats(totalProcessedCount, totalSkippedCount);
        long totalPolledCount = in.readLong();
        this.consumerStats = new ConsumerStats(totalPolledCount);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.messageProcessorStats.totalProcessedCount);
        out.writeLong(this.messageProcessorStats.totalSkippedCount);
        out.writeLong(this.consumerStats.totalPolledCount);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("polling_ingest_stats");
        builder.startObject("message_processor_stats");
        builder.field("total_processed_count", this.messageProcessorStats.totalProcessedCount);
        builder.field("total_skipped_count", this.messageProcessorStats.totalSkippedCount);
        builder.endObject();
        builder.startObject("consumer_stats");
        builder.field("total_polled_count", this.consumerStats.totalPolledCount);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public MessageProcessorStats getMessageProcessorStats() {
        return this.messageProcessorStats;
    }

    public ConsumerStats getConsumerStats() {
        return this.consumerStats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PollingIngestStats)) {
            return false;
        }
        PollingIngestStats that = (PollingIngestStats)o;
        return Objects.equals(this.messageProcessorStats, that.messageProcessorStats) && Objects.equals(this.consumerStats, that.consumerStats);
    }

    public int hashCode() {
        return Objects.hash(this.messageProcessorStats, this.consumerStats);
    }

    public static Builder builder() {
        return new Builder();
    }

    @ExperimentalApi
    public record MessageProcessorStats(long totalProcessedCount, long totalSkippedCount) {
    }

    @ExperimentalApi
    public record ConsumerStats(long totalPolledCount) {
    }

    @ExperimentalApi
    public static class Builder {
        private long totalProcessedCount;
        private long totalSkippedCount;
        private long totalPolledCount;

        public Builder setTotalProcessedCount(long totalProcessedCount) {
            this.totalProcessedCount = totalProcessedCount;
            return this;
        }

        public Builder setTotalPolledCount(long totalPolledCount) {
            this.totalPolledCount = totalPolledCount;
            return this;
        }

        public Builder setTotalSkippedCount(long totalSkippedCount) {
            this.totalSkippedCount = totalSkippedCount;
            return this;
        }

        public PollingIngestStats build() {
            MessageProcessorStats messageProcessorStats = new MessageProcessorStats(this.totalProcessedCount, this.totalSkippedCount);
            ConsumerStats consumerStats = new ConsumerStats(this.totalPolledCount);
            return new PollingIngestStats(messageProcessorStats, consumerStats);
        }
    }
}

