/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.PriorityQueue;
import org.opensearch.common.Numbers;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.LongArray;
import org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.SortedNumericStarTreeValuesIterator;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.InternalOrder;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.StarTreeBucketCollector;
import org.opensearch.search.aggregations.StarTreePreComputeCollector;
import org.opensearch.search.aggregations.bucket.LocalBucketCountThresholds;
import org.opensearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.opensearch.search.aggregations.bucket.terms.BucketSignificancePriorityQueue;
import org.opensearch.search.aggregations.bucket.terms.DoubleTerms;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.bucket.terms.InternalMappedTerms;
import org.opensearch.search.aggregations.bucket.terms.InternalTerms;
import org.opensearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.opensearch.search.aggregations.bucket.terms.LongTerms;
import org.opensearch.search.aggregations.bucket.terms.SignificanceLookup;
import org.opensearch.search.aggregations.bucket.terms.SignificantLongTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.UnsignedLongTerms;
import org.opensearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.internal.ContextIndexSearcher;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.StarTreeQueryHelper;
import org.opensearch.search.startree.StarTreeTraversalUtil;
import org.opensearch.search.startree.filter.DimensionFilter;

public class NumericTermsAggregator
extends TermsAggregator
implements StarTreePreComputeCollector {
    private final ResultStrategy<?, ?> resultStrategy;
    private final ValuesSource.Numeric valuesSource;
    private final LongKeyedBucketOrds bucketOrds;
    private final IncludeExclude.LongFilter longFilter;
    private final String fieldName;

    public NumericTermsAggregator(String name, AggregatorFactories factories, Function<NumericTermsAggregator, ResultStrategy<?, ?>> resultStrategy, ValuesSource.Numeric valuesSource, DocValueFormat format, BucketOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, SearchContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, IncludeExclude.LongFilter longFilter, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, bucketCountThresholds, order, format, subAggCollectMode, metadata);
        this.resultStrategy = resultStrategy.apply(this);
        this.valuesSource = valuesSource;
        this.longFilter = longFilter;
        this.bucketOrds = LongKeyedBucketOrds.build(this.context.bigArrays(), cardinality);
        this.fieldName = this.valuesSource instanceof ValuesSource.Numeric.FieldData ? ((ValuesSource.Numeric.FieldData)valuesSource).getIndexFieldName() : null;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final SortedNumericDocValues values = this.resultStrategy.getValues(ctx);
        return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    long previous = Long.MAX_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long val = values.nextValue();
                        if (previous == val && i != 0) continue;
                        if (NumericTermsAggregator.this.longFilter == null || NumericTermsAggregator.this.longFilter.accept(val)) {
                            long bucketOrdinal = NumericTermsAggregator.this.bucketOrds.add(owningBucketOrd, val);
                            if (bucketOrdinal < 0L) {
                                bucketOrdinal = -1L - bucketOrdinal;
                                NumericTermsAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                            } else {
                                NumericTermsAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                            }
                        }
                        previous = val;
                    }
                }
            }
        });
    }

    @Override
    protected boolean tryPrecomputeAggregationForLeaf(LeafReaderContext ctx) throws IOException {
        CompositeIndexFieldInfo supportedStarTree = StarTreeQueryHelper.getSupportedStarTree(this.context.getQueryShardContext());
        if (supportedStarTree != null) {
            StarTreeBucketCollector starTreeBucketCollector = this.getStarTreeBucketCollector(ctx, supportedStarTree, null);
            StarTreeQueryHelper.preComputeBucketsWithStarTree(starTreeBucketCollector);
            return true;
        }
        return false;
    }

    @Override
    public StarTreeBucketCollector getStarTreeBucketCollector(final LeafReaderContext ctx, final CompositeIndexFieldInfo starTree, StarTreeBucketCollector parent) throws IOException {
        assert (parent == null);
        StarTreeValues starTreeValues = StarTreeQueryHelper.getStarTreeValues(ctx, starTree);
        final SortedNumericStarTreeValuesIterator valuesIterator = (SortedNumericStarTreeValuesIterator)starTreeValues.getDimensionValuesIterator(this.fieldName);
        final SortedNumericStarTreeValuesIterator docCountsIterator = StarTreeQueryHelper.getDocCountsIterator(starTreeValues, starTree);
        return new StarTreeBucketCollector(starTreeValues, StarTreeTraversalUtil.getStarTreeResult(starTreeValues, StarTreeQueryHelper.mergeDimensionFilterIfNotExists(this.context.getQueryShardContext().getStarTreeQueryContext().getBaseQueryStarTreeFilter(), this.fieldName, List.of(DimensionFilter.MATCH_ALL_DEFAULT)), this.context)){

            @Override
            public void setSubCollectors() throws IOException {
                for (Aggregator aggregator : NumericTermsAggregator.this.subAggregators) {
                    this.subCollectors.add(((StarTreePreComputeCollector)((Object)aggregator)).getStarTreeBucketCollector(ctx, starTree, this));
                }
            }

            @Override
            public void collectStarTreeEntry(int starTreeEntry, long owningBucketOrd) throws IOException {
                if (!valuesIterator.advanceExact(starTreeEntry)) {
                    return;
                }
                long dimensionValue = valuesIterator.nextValue();
                if (NumericTermsAggregator.this.valuesSource.isFloatingPoint()) {
                    double doubleValue = ((NumberFieldMapper.NumberFieldType)NumericTermsAggregator.this.context.mapperService().fieldType(NumericTermsAggregator.this.fieldName)).toDoubleValue(dimensionValue);
                    dimensionValue = NumericUtils.doubleToSortableLong((double)doubleValue);
                }
                int count = valuesIterator.entryValueCount();
                for (int i = 0; i < count; ++i) {
                    if (!docCountsIterator.advanceExact(starTreeEntry)) continue;
                    long metricValue = docCountsIterator.nextValue();
                    long bucketOrd = NumericTermsAggregator.this.bucketOrds.add(owningBucketOrd, dimensionValue);
                    NumericTermsAggregator.this.collectStarTreeBucket(this, metricValue, bucketOrd, starTreeEntry);
                }
            }
        };
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.resultStrategy.buildAggregations(owningBucketOrds);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.resultStrategy.buildEmptyResult();
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{() -> super.doClose(), this.bucketOrds, this.resultStrategy});
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("result_strategy", this.resultStrategy.describe());
        add.accept("total_buckets", this.bucketOrds.size());
    }

    abstract class ResultStrategy<R extends InternalAggregation, B extends InternalMultiBucketAggregation.InternalBucket>
    implements Releasable {
        ResultStrategy() {
        }

        private InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
            LocalBucketCountThresholds localBucketCountThresholds = NumericTermsAggregator.this.context.asLocalBucketCountThresholds(NumericTermsAggregator.this.bucketCountThresholds);
            InternalMultiBucketAggregation.InternalBucket[][] topBucketsPerOrd = this.buildTopBucketsPerOrd(owningBucketOrds.length);
            long[] otherDocCounts = new long[owningBucketOrds.length];
            for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                this.collectZeroDocEntriesIfNeeded(owningBucketOrds[ordIdx]);
                long bucketsInOrd = NumericTermsAggregator.this.bucketOrds.bucketsInOrd(owningBucketOrds[ordIdx]);
                int size = (int)Math.min(bucketsInOrd, (long)localBucketCountThresholds.getRequiredSize());
                PriorityQueue<B> ordered = this.buildPriorityQueue(size);
                InternalMultiBucketAggregation.InternalBucket spare = null;
                LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = NumericTermsAggregator.this.bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
                Supplier<B> emptyBucketBuilder = this.emptyBucketBuilder(owningBucketOrds[ordIdx]);
                while (ordsEnum.next()) {
                    long docCount = NumericTermsAggregator.this.bucketDocCount(ordsEnum.ord());
                    int n = ordIdx;
                    otherDocCounts[n] = otherDocCounts[n] + docCount;
                    if (docCount < localBucketCountThresholds.getMinDocCount()) continue;
                    if (spare == null) {
                        spare = (InternalMultiBucketAggregation.InternalBucket)emptyBucketBuilder.get();
                    }
                    this.updateBucket(spare, ordsEnum, docCount);
                    spare = (InternalMultiBucketAggregation.InternalBucket)ordered.insertWithOverflow((Object)spare);
                }
                InternalMultiBucketAggregation.InternalBucket[] bucketsForOrd = this.buildBuckets(ordered.size());
                topBucketsPerOrd[ordIdx] = bucketsForOrd;
                if (InternalOrder.isKeyOrder(NumericTermsAggregator.this.order)) {
                    for (int b = ordered.size() - 1; b >= 0; --b) {
                        topBucketsPerOrd[ordIdx][b] = (InternalMultiBucketAggregation.InternalBucket)ordered.pop();
                        int n = ordIdx;
                        otherDocCounts[n] = otherDocCounts[n] - topBucketsPerOrd[ordIdx][b].getDocCount();
                    }
                    continue;
                }
                Iterator itr = ordered.iterator();
                for (int b = ordered.size() - 1; b >= 0; --b) {
                    topBucketsPerOrd[ordIdx][b] = (InternalMultiBucketAggregation.InternalBucket)itr.next();
                    int n = ordIdx;
                    otherDocCounts[n] = otherDocCounts[n] - topBucketsPerOrd[ordIdx][b].getDocCount();
                }
            }
            this.buildSubAggs(topBucketsPerOrd);
            InternalAggregation[] result = new InternalAggregation[owningBucketOrds.length];
            for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                result[ordIdx] = this.buildResult(owningBucketOrds[ordIdx], otherDocCounts[ordIdx], topBucketsPerOrd[ordIdx]);
            }
            return result;
        }

        abstract String describe();

        abstract SortedNumericDocValues getValues(LeafReaderContext var1) throws IOException;

        abstract LeafBucketCollector wrapCollector(LeafBucketCollector var1);

        abstract B[][] buildTopBucketsPerOrd(int var1);

        abstract B[] buildBuckets(int var1);

        abstract Supplier<B> emptyBucketBuilder(long var1);

        abstract void updateBucket(B var1, LongKeyedBucketOrds.BucketOrdsEnum var2, long var3) throws IOException;

        abstract PriorityQueue<B> buildPriorityQueue(int var1);

        abstract void buildSubAggs(B[][] var1) throws IOException;

        abstract void collectZeroDocEntriesIfNeeded(long var1) throws IOException;

        abstract R buildResult(long var1, long var3, B[] var5);

        abstract R buildEmptyResult();
    }

    class SignificantLongTermsResults
    extends ResultStrategy<SignificantLongTerms, SignificantLongTerms.Bucket> {
        private final SignificanceLookup.BackgroundFrequencyForLong backgroundFrequencies;
        private final long supersetSize;
        private final SignificanceHeuristic significanceHeuristic;
        private LongArray subsetSizes;

        SignificantLongTermsResults(SignificanceLookup significanceLookup, SignificanceHeuristic significanceHeuristic, CardinalityUpperBound cardinality) {
            this.backgroundFrequencies = significanceLookup.longLookup(NumericTermsAggregator.this.context.bigArrays(), cardinality);
            this.supersetSize = significanceLookup.supersetSize();
            this.significanceHeuristic = significanceHeuristic;
            this.subsetSizes = NumericTermsAggregator.this.context.bigArrays().newLongArray(1L, true);
        }

        @Override
        SortedNumericDocValues getValues(LeafReaderContext ctx) throws IOException {
            return NumericTermsAggregator.this.valuesSource.longValues(ctx);
        }

        @Override
        String describe() {
            return "significant_terms";
        }

        @Override
        LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return new LeafBucketCollectorBase(primary, null){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    super.collect(doc, owningBucketOrd);
                    SignificantLongTermsResults.this.subsetSizes = NumericTermsAggregator.this.context.bigArrays().grow(SignificantLongTermsResults.this.subsetSizes, owningBucketOrd + 1L);
                    SignificantLongTermsResults.this.subsetSizes.increment(owningBucketOrd, 1L);
                }
            };
        }

        SignificantLongTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new SignificantLongTerms.Bucket[size][];
        }

        SignificantLongTerms.Bucket[] buildBuckets(int size) {
            return new SignificantLongTerms.Bucket[size];
        }

        @Override
        Supplier<SignificantLongTerms.Bucket> emptyBucketBuilder(long owningBucketOrd) {
            long subsetSize = this.subsetSizes.get(owningBucketOrd);
            return () -> new SignificantLongTerms.Bucket(0L, subsetSize, 0L, this.supersetSize, 0L, null, NumericTermsAggregator.this.format, 0.0);
        }

        @Override
        void updateBucket(SignificantLongTerms.Bucket spare, LongKeyedBucketOrds.BucketOrdsEnum ordsEnum, long docCount) throws IOException {
            spare.term = ordsEnum.value();
            spare.subsetDf = docCount;
            spare.supersetDf = this.backgroundFrequencies.freq(spare.term);
            spare.bucketOrd = ordsEnum.ord();
            spare.updateScore(this.significanceHeuristic);
        }

        @Override
        PriorityQueue<SignificantLongTerms.Bucket> buildPriorityQueue(int size) {
            return new BucketSignificancePriorityQueue<SignificantLongTerms.Bucket>(size);
        }

        void buildSubAggs(SignificantLongTerms.Bucket[][] topBucketsPerOrd) throws IOException {
            NumericTermsAggregator.this.buildSubAggsForAllBuckets(topBucketsPerOrd, b -> b.bucketOrd, (b, aggs) -> {
                b.aggregations = aggs;
            });
        }

        @Override
        void collectZeroDocEntriesIfNeeded(long owningBucketOrd) throws IOException {
        }

        SignificantLongTerms buildResult(long owningBucketOrd, long otherDocCoun, SignificantLongTerms.Bucket[] topBuckets) {
            SignificantLongTerms significantLongTerms = new SignificantLongTerms(NumericTermsAggregator.this.name, NumericTermsAggregator.this.metadata(), NumericTermsAggregator.this.format, this.subsetSizes.get(owningBucketOrd), this.supersetSize, this.significanceHeuristic, List.of(topBuckets), NumericTermsAggregator.this.bucketCountThresholds);
            return significantLongTerms;
        }

        @Override
        SignificantLongTerms buildEmptyResult() {
            ContextIndexSearcher searcher = NumericTermsAggregator.this.context.searcher();
            IndexReader topReader = searcher.getIndexReader();
            int supersetSize = topReader.numDocs();
            return new SignificantLongTerms(NumericTermsAggregator.this.name, NumericTermsAggregator.this.metadata(), NumericTermsAggregator.this.format, 0L, (long)supersetSize, this.significanceHeuristic, Collections.emptyList(), NumericTermsAggregator.this.bucketCountThresholds);
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.backgroundFrequencies, this.subsetSizes});
        }
    }

    class UnsignedLongTermsResults
    extends StandardTermsResultStrategy<UnsignedLongTerms, UnsignedLongTerms.Bucket> {
        UnsignedLongTermsResults(boolean showTermDocCountError) {
            super(showTermDocCountError);
        }

        @Override
        String describe() {
            return "unsigned_long_terms";
        }

        @Override
        SortedNumericDocValues getValues(LeafReaderContext ctx) throws IOException {
            return NumericTermsAggregator.this.valuesSource.longValues(ctx);
        }

        UnsignedLongTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new UnsignedLongTerms.Bucket[size][];
        }

        UnsignedLongTerms.Bucket[] buildBuckets(int size) {
            return new UnsignedLongTerms.Bucket[size];
        }

        @Override
        UnsignedLongTerms.Bucket buildEmptyBucket() {
            return new UnsignedLongTerms.Bucket(BigInteger.ZERO, 0L, null, this.showTermDocCountError, 0L, NumericTermsAggregator.this.format);
        }

        @Override
        void updateBucket(UnsignedLongTerms.Bucket spare, LongKeyedBucketOrds.BucketOrdsEnum ordsEnum, long docCount) {
            spare.term = Numbers.toUnsignedBigInteger((long)ordsEnum.value());
            spare.docCount = docCount;
            spare.bucketOrd = ordsEnum.ord();
        }

        UnsignedLongTerms buildResult(long owningBucketOrd, long otherDocCount, UnsignedLongTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(NumericTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = NumericTermsAggregator.this.order;
            }
            return new UnsignedLongTerms(NumericTermsAggregator.this.name, reduceOrder, NumericTermsAggregator.this.order, NumericTermsAggregator.this.metadata(), NumericTermsAggregator.this.format, NumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, List.of(topBuckets), 0L, NumericTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        UnsignedLongTerms buildEmptyResult() {
            return new UnsignedLongTerms(NumericTermsAggregator.this.name, NumericTermsAggregator.this.order, NumericTermsAggregator.this.order, NumericTermsAggregator.this.metadata(), NumericTermsAggregator.this.format, NumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), 0L, NumericTermsAggregator.this.bucketCountThresholds);
        }
    }

    class DoubleTermsResults
    extends StandardTermsResultStrategy<DoubleTerms, DoubleTerms.Bucket> {
        DoubleTermsResults(boolean showTermDocCountError) {
            super(showTermDocCountError);
        }

        @Override
        String describe() {
            return "double_terms";
        }

        @Override
        SortedNumericDocValues getValues(LeafReaderContext ctx) throws IOException {
            return FieldData.toSortableLongBits(NumericTermsAggregator.this.valuesSource.doubleValues(ctx));
        }

        DoubleTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new DoubleTerms.Bucket[size][];
        }

        DoubleTerms.Bucket[] buildBuckets(int size) {
            return new DoubleTerms.Bucket[size];
        }

        @Override
        DoubleTerms.Bucket buildEmptyBucket() {
            return new DoubleTerms.Bucket(0.0, 0L, null, this.showTermDocCountError, 0L, NumericTermsAggregator.this.format);
        }

        @Override
        void updateBucket(DoubleTerms.Bucket spare, LongKeyedBucketOrds.BucketOrdsEnum ordsEnum, long docCount) {
            spare.term = NumericUtils.sortableLongToDouble((long)ordsEnum.value());
            spare.docCount = docCount;
            spare.bucketOrd = ordsEnum.ord();
        }

        DoubleTerms buildResult(long owningBucketOrd, long otherDocCount, DoubleTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(NumericTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = NumericTermsAggregator.this.order;
            }
            return new DoubleTerms(NumericTermsAggregator.this.name, reduceOrder, NumericTermsAggregator.this.order, NumericTermsAggregator.this.metadata(), NumericTermsAggregator.this.format, NumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, List.of(topBuckets), 0L, NumericTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        DoubleTerms buildEmptyResult() {
            return new DoubleTerms(NumericTermsAggregator.this.name, NumericTermsAggregator.this.order, NumericTermsAggregator.this.order, NumericTermsAggregator.this.metadata(), NumericTermsAggregator.this.format, NumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), 0L, NumericTermsAggregator.this.bucketCountThresholds);
        }
    }

    class LongTermsResults
    extends StandardTermsResultStrategy<LongTerms, LongTerms.Bucket> {
        LongTermsResults(boolean showTermDocCountError) {
            super(showTermDocCountError);
        }

        @Override
        String describe() {
            return "long_terms";
        }

        @Override
        SortedNumericDocValues getValues(LeafReaderContext ctx) throws IOException {
            return NumericTermsAggregator.this.valuesSource.longValues(ctx);
        }

        LongTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new LongTerms.Bucket[size][];
        }

        LongTerms.Bucket[] buildBuckets(int size) {
            return new LongTerms.Bucket[size];
        }

        @Override
        LongTerms.Bucket buildEmptyBucket() {
            return new LongTerms.Bucket(0L, 0L, null, this.showTermDocCountError, 0L, NumericTermsAggregator.this.format);
        }

        @Override
        void updateBucket(LongTerms.Bucket spare, LongKeyedBucketOrds.BucketOrdsEnum ordsEnum, long docCount) {
            spare.term = ordsEnum.value();
            spare.docCount = docCount;
            spare.bucketOrd = ordsEnum.ord();
        }

        LongTerms buildResult(long owningBucketOrd, long otherDocCount, LongTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(NumericTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = NumericTermsAggregator.this.order;
            }
            return new LongTerms(NumericTermsAggregator.this.name, reduceOrder, NumericTermsAggregator.this.order, NumericTermsAggregator.this.metadata(), NumericTermsAggregator.this.format, NumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, List.of(topBuckets), 0L, NumericTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        LongTerms buildEmptyResult() {
            return new LongTerms(NumericTermsAggregator.this.name, NumericTermsAggregator.this.order, NumericTermsAggregator.this.order, NumericTermsAggregator.this.metadata(), NumericTermsAggregator.this.format, NumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), 0L, NumericTermsAggregator.this.bucketCountThresholds);
        }
    }

    abstract class StandardTermsResultStrategy<R extends InternalMappedTerms<R, B>, B extends InternalTerms.Bucket<B>>
    extends ResultStrategy<R, B> {
        protected final boolean showTermDocCountError;

        StandardTermsResultStrategy(boolean showTermDocCountError) {
            this.showTermDocCountError = showTermDocCountError;
        }

        @Override
        final LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return primary;
        }

        @Override
        final PriorityQueue<B> buildPriorityQueue(int size) {
            return new BucketPriorityQueue(size, NumericTermsAggregator.this.partiallyBuiltBucketComparator);
        }

        @Override
        final void buildSubAggs(B[][] topBucketsPerOrd) throws IOException {
            NumericTermsAggregator.this.buildSubAggsForAllBuckets(topBucketsPerOrd, b -> b.bucketOrd, (b, aggs) -> {
                b.aggregations = aggs;
            });
        }

        @Override
        Supplier<B> emptyBucketBuilder(long owningBucketOrd) {
            return this::buildEmptyBucket;
        }

        abstract B buildEmptyBucket();

        @Override
        final void collectZeroDocEntriesIfNeeded(long owningBucketOrd) throws IOException {
            if (NumericTermsAggregator.this.bucketCountThresholds.getMinDocCount() != 0L) {
                return;
            }
            if (InternalOrder.isCountDesc(NumericTermsAggregator.this.order) && NumericTermsAggregator.this.bucketOrds.bucketsInOrd(owningBucketOrd) >= (long)NumericTermsAggregator.this.bucketCountThresholds.getRequiredSize()) {
                return;
            }
            for (LeafReaderContext ctx : NumericTermsAggregator.this.context.searcher().getTopReaderContext().leaves()) {
                SortedNumericDocValues values = this.getValues(ctx);
                for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                    if (!values.advanceExact(docId)) continue;
                    int valueCount = values.docValueCount();
                    for (int v = 0; v < valueCount; ++v) {
                        long value = values.nextValue();
                        if (NumericTermsAggregator.this.longFilter != null && !NumericTermsAggregator.this.longFilter.accept(value)) continue;
                        NumericTermsAggregator.this.bucketOrds.add(owningBucketOrd, value);
                    }
                }
            }
        }

        public final void close() {
        }
    }
}

